/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.customer;

import com.xdja.ca.utils.DnUtil;
import com.xdja.ca.vo.ManagerCertInfo;
import com.xdja.ca.vo.UserCertInfo;
import com.xdja.pki.ra.cache.CertTempCache;
import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.common.OperatorCertCache;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.constant.PathConstants;
import com.xdja.pki.ra.core.exception.DAOException;
import com.xdja.pki.ra.core.exception.ServiceException;
import com.xdja.pki.ra.core.util.cert.CertDnVerifyUtils;
import com.xdja.pki.ra.core.util.cert.CertUtils;
import com.xdja.pki.ra.core.util.cert.KeyStoreUtils;
import com.xdja.pki.ra.core.util.cert.KeyUtils;
import com.xdja.pki.ra.core.util.cert.RandomUtils;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.manager.dao.CaCertDao;
import com.xdja.pki.ra.manager.dao.CustomerCertDao;
import com.xdja.pki.ra.manager.dao.CustomerDao;
import com.xdja.pki.ra.manager.dao.CustomerTempDao;
import com.xdja.pki.ra.manager.dao.RaCertDao;
import com.xdja.pki.ra.manager.dao.model.CaCertDO;
import com.xdja.pki.ra.manager.dao.model.CertTempDO;
import com.xdja.pki.ra.manager.dao.model.CustomerSysCertDO;
import com.xdja.pki.ra.manager.dao.model.CustomerSysDO;
import com.xdja.pki.ra.manager.dao.model.CustomerSysTempDO;
import com.xdja.pki.ra.manager.dao.model.RaCertDO;
import com.xdja.pki.ra.manager.dto.CustomerCertDTO;
import com.xdja.pki.ra.manager.page.PageInfo;
import com.xdja.pki.ra.manager.sdk.cmp.CertLifeCycleManager;
import com.xdja.pki.ra.service.manager.certapply.CertApplyService;
import com.xdja.pki.ra.service.manager.customer.CustomerSysService;
import com.xdja.pki.ra.service.manager.customer.bean.CustomerCertIssueApplyVO;
import com.xdja.pki.ra.service.manager.customer.bean.CustomerSysCertVO;
import com.xdja.pki.ra.service.manager.customer.bean.CustomerSysResp;
import com.xdja.pki.ra.service.manager.customer.bean.CustomerSysVO;
import com.xdja.pki.ra.service.manager.customer.bean.CustomerTemplateRepVO;
import com.xdja.pki.ra.service.manager.customer.bean.CustomerTemplateSaveVO;
import com.xdja.pki.ra.service.manager.organuser.bean.OrganParamsCheck;
import com.xdja.pki.ra.service.manager.system.CaService;
import com.xdja.pki.ra.service.manager.system.RaServer;
import com.xdja.pki.ra.service.manager.utils.CertContentInfoUtil;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CustomerSysServiceImpl
implements CustomerSysService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CustomerDao customerDao;
    @Autowired
    private CustomerCertDao customerCertDao;
    @Autowired
    private CustomerTempDao customerTempDao;
    @Autowired
    private RaServer raServer;
    @Autowired
    private CaService caService;
    @Autowired
    private CertApplyService certApplyService;
    @Autowired
    private CaCertDao caCertDao;
    @Autowired
    RaCertDao raCertDao;
    @Autowired
    private CertLifeCycleManager certLifeCycleManager;
    @Autowired
    CertContentInfoUtil certContentInfoUtil;
    @Autowired
    CertTempCache certTempCache;

    public Result getCustomerCertInfo(String certSn) {
        Result result = new Result();
        CustomerSysCertDO customerCert = this.customerCertDao.getCustomerCert(certSn);
        if (customerCert == null) {
            this.logger.info("\u7b2c\u4e09\u65b9\u7cfb\u7edf\u8bc1\u4e66\u67e5\u8be2\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_OPERATOR_CERT_INFO_EMPTY);
            return result;
        }
        String certInfo = customerCert.getCertInfo();
        Map<String, Object> certContentInfo = null;
        try {
            X509Certificate certificate = CertUtils.getCertFromStr((String)certInfo);
            certContentInfo = this.certContentInfoUtil.getCertContentInfo(certificate);
        }
        catch (Exception e) {
            this.logger.error("\u8bc1\u4e66\u8be6\u60c5\u683c\u5f0f\u8bfb\u53d6\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CERT_DETAIL_FORMAT_ERROR);
            return result;
        }
        result.setInfo(certContentInfo);
        return result;
    }

    public Result registerCustomerInfo(CustomerSysVO customerSysVO) {
        boolean check;
        Result result = new Result();
        int count = this.customerDao.getSystemIdentifier(customerSysVO.getCustomerSysNumber());
        if (count >= 1) {
            result.setError(ErrorEnum.SYS_ID_HAS_EXISTED);
            return result;
        }
        if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{customerSysVO.getCustomerSysContact()}) && !(check = OrganParamsCheck.isCheck((String)"^(13|14|15|16|17|18|19)[0-9]{9}$", (String)customerSysVO.getCustomerSysContact()))) {
            this.logger.info("\u8054\u7cfb\u7535\u8bdd\u683c\u5f0f\u9519\u8bef");
            return Result.failure((ErrorEnum)ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
        }
        CustomerSysDO customerSysDO = new CustomerSysDO();
        BeanUtils.copyProperties((Object)customerSysVO, (Object)customerSysDO);
        Date date = new Date(System.currentTimeMillis());
        customerSysDO.setGmtCreate(date);
        customerSysDO.setGmtUpdate(date);
        this.customerDao.insertSystemInfo(customerSysDO);
        return Result.success();
    }

    public Result getCustomerInfo(Integer id) {
        Result result = new Result();
        CustomerSysDO systemInfo = this.customerDao.getSystemInfo(id);
        result.setInfo((Object)systemInfo);
        return result;
    }

    public Result updateCustomerInfo(Integer id, CustomerSysVO customerSysVO) {
        boolean check;
        Result result = new Result();
        CustomerSysDO customerSysDO = this.customerDao.getSystemInfo(id);
        if (!customerSysDO.getCustomerSysNumber().equals(customerSysVO.getCustomerSysNumber())) {
            return Result.failure((ErrorEnum)ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
        }
        if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{customerSysVO.getCustomerSysContact()}) && !(check = OrganParamsCheck.isCheck((String)"^(13|14|15|16|17|18|19)[0-9]{9}$", (String)customerSysVO.getCustomerSysContact()))) {
            this.logger.info("\u8054\u7cfb\u7535\u8bdd\u683c\u5f0f\u9519\u8bef");
            return Result.failure((ErrorEnum)ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
        }
        CustomerSysDO systemInfo = this.customerDao.getSystemInfo(id);
        BeanUtils.copyProperties((Object)customerSysVO, (Object)systemInfo);
        Date date = new Date(System.currentTimeMillis());
        systemInfo.setGmtUpdate(date);
        int i = this.customerDao.updateSystemInfo(systemInfo);
        if (i == 0) {
            result.setError(ErrorEnum.SYS_UPDATE_IS_ERROR);
            return result;
        }
        return Result.success();
    }

    public Result getCustomerInfoList(String systemNumber, String systemName, int pageSize, int pageNo) {
        CustomerSysResp customerSysResp = new CustomerSysResp();
        Result result = new Result();
        PageInfo systemInfoPageList = this.customerDao.getSystemInfoList(systemNumber, systemName, Integer.valueOf(pageSize), Integer.valueOf(pageNo));
        ArrayList<CustomerSysVO> customerSysVOList = new ArrayList<CustomerSysVO>();
        List customerPagelist = systemInfoPageList.getList();
        if (CollectionUtils.isEmpty((Collection)customerPagelist)) {
            customerSysResp.setRecordCount(0);
            customerSysResp.setPageCount(0);
            customerSysResp.setDatas(customerSysVOList);
            result.setInfo((Object)customerSysResp);
            return result;
        }
        for (CustomerSysDO customerSysDO : customerPagelist) {
            CustomerSysVO deviceUserVO = new CustomerSysVO();
            BeanUtils.copyProperties((Object)customerSysDO, (Object)deviceUserVO);
            Date gmtCreate = customerSysDO.getGmtCreate();
            deviceUserVO.setId(Integer.valueOf((int)customerSysDO.getId()));
            deviceUserVO.setGmtCreate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(gmtCreate));
            customerSysVOList.add(deviceUserVO);
        }
        customerSysResp.setDatas(customerSysVOList);
        customerSysResp.setPageCount(systemInfoPageList.getPageCount());
        customerSysResp.setRecordCount(systemInfoPageList.getRecordCount());
        result.setInfo((Object)customerSysResp);
        return result;
    }

    public Result getCustomerCertInfoList(String systemName, String certDn, String status, String order, int pageSize, int pageNo) {
        CustomerSysResp customerSysResp = new CustomerSysResp();
        Result result = new Result();
        PageInfo systemInfoPageList = this.customerCertDao.getSystemCertInfoList(systemName, certDn, status, order, Integer.valueOf(pageSize), Integer.valueOf(pageNo));
        ArrayList<CustomerSysCertVO> customerSysVOList = new ArrayList<CustomerSysCertVO>();
        List customerPagelist = systemInfoPageList.getList();
        if (CollectionUtils.isEmpty((Collection)customerPagelist)) {
            customerSysResp.setRecordCount(0);
            customerSysResp.setPageCount(0);
            customerSysResp.setDatas(customerSysVOList);
            result.setInfo((Object)customerSysResp);
            return result;
        }
        for (CustomerCertDTO customerSysCertDO : customerPagelist) {
            CustomerSysCertVO certVO = new CustomerSysCertVO();
            BeanUtils.copyProperties((Object)customerSysCertDO, (Object)certVO);
            if (null != customerSysCertDO.getTempId()) {
                CertTempDO certTempDO = this.certTempCache.getCertTempInfoByTempId((long)customerSysCertDO.getTempId().intValue());
                certVO.setCertPatterm(certTempDO.getCertPatterm());
            }
            long nowDateMillis = System.currentTimeMillis();
            long time = customerSysCertDO.getFailureTime().getTime();
            if (time < nowDateMillis) {
                certVO.setCertStatus(Integer.valueOf(2));
            }
            Calendar ca = Calendar.getInstance();
            long timeInMillis = ca.getTimeInMillis();
            ca.add(2, 1);
            if (time > timeInMillis && ca.getTimeInMillis() > time) {
                certVO.setOutStatus(true);
            } else {
                certVO.setOutStatus(false);
            }
            certVO.setEffectiveTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(customerSysCertDO.getEffectiveTime()));
            certVO.setFailureTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(customerSysCertDO.getFailureTime()));
            customerSysVOList.add(certVO);
        }
        customerSysResp.setDatas(customerSysVOList);
        customerSysResp.setPageCount(systemInfoPageList.getPageCount());
        customerSysResp.setRecordCount(systemInfoPageList.getRecordCount());
        result.setInfo((Object)customerSysResp);
        return result;
    }

    public Result getCustomerTemplateById(Long id) {
        ArrayList<CustomerTemplateRepVO> customerTemplateRepVOList = new ArrayList<CustomerTemplateRepVO>();
        List allNewCertTemplateList = null;
        List customerTempInfoById = null;
        try {
            allNewCertTemplateList = this.certTempCache.getAllNewCertTemplateList();
            customerTempInfoById = this.customerTempDao.getCustomerTempInfoById(id);
        }
        catch (DAOException e) {
            throw new ServiceException("\u67e5\u8be2\u7b2c\u4e09\u65b9\u6388\u6743\u6a21\u677f\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
        if (null != allNewCertTemplateList && !allNewCertTemplateList.isEmpty()) {
            for (CertTempDO certTempDO : allNewCertTemplateList) {
                CustomerTemplateRepVO customerTemplateRepVO = new CustomerTemplateRepVO();
                customerTemplateRepVO.setId(certTempDO.getId());
                customerTemplateRepVO.setTempNo(certTempDO.getTempNo());
                customerTemplateRepVO.setName(certTempDO.getTempName());
                customerTemplateRepVO.setStatus(certTempDO.getTempStatus());
                int status = certTempDO.getTempStatus();
                boolean isNotCancel = true;
                if (status == 3) {
                    isNotCancel = false;
                }
                if (null != customerTempInfoById && !customerTempInfoById.isEmpty()) {
                    for (CustomerSysTempDO customerTempInfo : customerTempInfoById) {
                        if (!customerTempInfo.getTempNo().equals(certTempDO.getTempNo())) continue;
                        customerTemplateRepVO.setBound(Boolean.valueOf(true));
                        isNotCancel = true;
                    }
                }
                if (!isNotCancel) continue;
                customerTemplateRepVOList.add(customerTemplateRepVO);
            }
        }
        return Result.success(customerTemplateRepVOList);
    }

    public Result saveCustomerTemplates(CustomerTemplateSaveVO customerTemplateSaveVO) {
        Result result = new Result();
        long customsysId = customerTemplateSaveVO.getCustomsysId();
        String templateNos = customerTemplateSaveVO.getTemplateNos();
        Object[] customerTemplateNos = null;
        String customerTemplateNoStr = "";
        try {
            if (!StringUtils.isEmpty((CharSequence)templateNos) && (customerTemplateNos = templateNos.split("#")).length > 0) {
                customerTemplateNoStr = Arrays.toString(customerTemplateNos);
                List allNewCertTemplateList = this.certTempCache.getAllNewCertTemplateList();
                for (Object customerTemplateNo2 : customerTemplateNos) {
                    boolean isCustomerTemplateExist = false;
                    if (null == allNewCertTemplateList || allNewCertTemplateList.isEmpty()) continue;
                    for (CertTempDO certTempDO : allNewCertTemplateList) {
                        if (!((String)customerTemplateNo2).equals(certTempDO.getTempNo())) continue;
                        isCustomerTemplateExist = true;
                        break;
                    }
                    if (isCustomerTemplateExist) continue;
                    return Result.failure((ErrorEnum)ErrorEnum.TEMPLATEID_NOT_EXIST);
                }
            }
            List customerSysTempDOStopeds = this.customerTempDao.getCustomerTemplateByStatus(Long.valueOf(customsysId), 3);
            for (CustomerSysTempDO customerSysTempDOStoped : customerSysTempDOStopeds) {
                String customerSysTempDOStopedTempNo = customerSysTempDOStoped.getTempNo();
                boolean ishasTemplateStop = customerTemplateNoStr.contains(customerSysTempDOStopedTempNo);
                if (ishasTemplateStop) continue;
                return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_STOPED_CANNOT_CANCEL);
            }
            this.customerTempDao.resetCustomerTemplate(Long.valueOf(customsysId));
            if (null != customerTemplateNos && customerTemplateNos.length > 0) {
                CustomerSysTempDO customerSysTempDO = new CustomerSysTempDO();
                customerSysTempDO.setCustomerSysId(Long.valueOf(customsysId));
                Arrays.asList(customerTemplateNos).forEach(customerTemplateNo -> {
                    customerSysTempDO.setTempNo(customerTemplateNo);
                    customerSysTempDO.setGmtCreate(new Date(System.currentTimeMillis()));
                    this.customerTempDao.saveCustomerTemplate(customerSysTempDO);
                });
            }
            CustomerSysDO systemInfo = this.customerDao.getSystemInfo(Integer.valueOf((int)customsysId));
            String customerSysNumber = systemInfo.getCustomerSysNumber();
            result.setLogContent("\uff0c\u7cfb\u7edf\u6807\u8bc6=" + customerSysNumber + "\uff0c\u6a21\u677f\u7f16\u53f7tempNos=" + templateNos);
        }
        catch (DAOException e) {
            throw new ServiceException("\u4fdd\u5b58\u7b2c\u4e09\u65b9\u6388\u6743\u6a21\u677f\u670d\u52a1\u5931\u8d25\uff0c", (Throwable)e);
        }
        return result;
    }

    public Result issCustomerCertByKeyStore(CustomerCertIssueApplyVO customerCertIssueApplyVO) {
        KeyPair encKeyPair;
        Result result = new Result();
        String raServiceDnName = this.raServer.getRAServiceDnName();
        if (StringUtils.isBlank((CharSequence)raServiceDnName)) {
            result.setError(ErrorEnum.GET_RA_SERVICE_DN_NAME_ERROR);
            return result;
        }
        String caServiceDnName = this.caService.getCAServiceDnName();
        if (StringUtils.isBlank((CharSequence)caServiceDnName)) {
            result.setError(ErrorEnum.GET_CA_SERVICE_DN_NAME_ERROR);
            return result;
        }
        int certValidity = customerCertIssueApplyVO.getCertValidity();
        String signAlg = customerCertIssueApplyVO.getSignAlg();
        String tempNo = customerCertIssueApplyVO.getTempNo();
        String customerCertDN = customerCertIssueApplyVO.getCertDn();
        KeyPair signKeyPair = null;
        String keyAlgName = null;
        int keyLength = 0;
        if ("SM3withSM2".equalsIgnoreCase(signAlg)) {
            keyAlgName = "SM2";
            keyLength = 256;
        } else if ("SHA256withECDSA".equalsIgnoreCase(signAlg)) {
            keyAlgName = "NISTP256";
            keyLength = 256;
        } else {
            keyAlgName = "RSA";
            keyLength = customerCertIssueApplyVO.getPrivateKeyLength();
        }
        this.logger.info("\u5bc6\u94a5\u7b97\u6cd5\uff1a{}, \u5bc6\u94a5\u957f\u5ea6\uff1a{}", (Object)keyAlgName, (Object)keyLength);
        String customerTransId = RandomUtils.getUUID();
        try {
            signKeyPair = KeyUtils.genKeyPair((String)keyAlgName, (int)keyLength);
            encKeyPair = KeyUtils.genKeyPair((String)keyAlgName, (int)keyLength);
        }
        catch (Exception e) {
            this.logger.info("\u751f\u6210\u7528\u6237\u7b7e\u540d\u516c\u79c1\u94a5\u5931\u8d25");
            result.setError(ErrorEnum.GEN_USER_CERT_SIGN_KEY_FAIL);
            return result;
        }
        Result issueResult = this.certLifeCycleManager.issueManageCert(false, null, signKeyPair.getPublic().getEncoded(), Base64.toBase64String((byte[])encKeyPair.getPublic().getEncoded()), raServiceDnName, caServiceDnName, customerTransId, tempNo, signAlg, certValidity, customerCertDN);
        if (!issueResult.isSuccess()) {
            this.logger.info("\u7b7e\u53d1\u7b2c\u4e09\u65b9\u7cfb\u7edf\u8bc1\u4e66\u5931\u8d25: code:{}, desc:{}", (Object)issueResult.getErrorBean().getErrCode(), (Object)issueResult.getErrorBean().getErrMsg());
            result.setErrorBean(issueResult.getErrorBean());
            return result;
        }
        ManagerCertInfo managerCertInfo = (ManagerCertInfo)issueResult.getInfo();
        UserCertInfo customerCertInfo = new UserCertInfo();
        customerCertInfo.setSignCert(managerCertInfo.getSignCert());
        try {
            String encCertB64String = CertUtils.getDataFromEnvelopDataByBc((byte[])encKeyPair.getPrivate().getEncoded(), (byte[])managerCertInfo.getEncEncCert().getBytes(), (String)CommonVariable.getKeyAlgName());
            customerCertInfo.setEncCert(encCertB64String);
        }
        catch (Exception e) {
            this.logger.info("\u89e3\u6790\u4fe1\u5c01\u5931\u8d25", (Throwable)e);
            result.setError(ErrorEnum.GET_RA_SERVER_ENC_CERT_ERROR);
            return result;
        }
        this.logger.info("\u7b2c\u4e09\u65b9\u7cfb\u7edf\u8bc1\u4e66\u5f00\u59cb\u5165\u5e93\uff1a{}", (Object)customerCertInfo);
        Result certInsertResult = this.insertCustomerCertInfo(customerCertIssueApplyVO, customerCertInfo);
        if (!certInsertResult.isSuccess()) {
            this.logger.info("\u5c06\u7528\u6237\u8bc1\u4e66\u63d2\u5165\u6570\u636e\u5e93\u5931\u8d25");
            result.setError(certInsertResult.getError());
            return result;
        }
        PrivateKey encPriKey = encKeyPair.getPrivate();
        try {
            int i;
            List trustCaCerts = CommonVariable.getTrustCaCerts();
            int length = trustCaCerts.size();
            X509Certificate[] caCerts = new X509Certificate[length];
            trustCaCerts.toArray(caCerts);
            for (int i2 = 0; i2 < caCerts.length; ++i2) {
                X509Certificate caCert = caCerts[i2];
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("caCert.length {}", (Object)caCerts.length);
                this.logger.debug("caCert issuer{}", (Object)CertUtils.getIssuerByX509Cert((X509Certificate)caCert));
                this.logger.debug("caCert subjcet:{}", (Object)CertUtils.getSubjectByX509Cert((X509Certificate)caCert));
            }
            X509Certificate[] signCert = new X509Certificate[caCerts.length + 1];
            X509Certificate customerSignCert = CertUtils.getCertFromStr((String)customerCertInfo.getSignCert());
            signCert[0] = CertUtils.getCertFromStr((String)customerCertInfo.getSignCert());
            for (i = 1; i < signCert.length; ++i) {
                signCert[i] = caCerts[i - 1];
            }
            for (i = 0; i < signCert.length; ++i) {
                X509Certificate x509Certificate = signCert[i];
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("signCert.length {}", (Object)signCert.length);
                this.logger.debug("signCert issuer{}", (Object)CertUtils.getIssuerByX509Cert((X509Certificate)x509Certificate));
                this.logger.debug("signCert subjcet:{}", (Object)CertUtils.getSubjectByX509Cert((X509Certificate)x509Certificate));
            }
            X509Certificate[] encCert = null;
            encCert = new X509Certificate[caCerts.length + 1];
            encCert[0] = CertUtils.getCertFromStr((String)customerCertInfo.getEncCert());
            for (int i3 = 1; i3 < encCert.length; ++i3) {
                encCert[i3] = caCerts[i3 - 1];
            }
            KeyStoreUtils.generateDoubleCertByKeyStore((boolean)true, (X509Certificate[])signCert, (X509Certificate[])encCert, (PrivateKey)signKeyPair.getPrivate(), (PrivateKey)encPriKey, (int)1, (String)customerSignCert.getSerialNumber().toString(16), (String)PathConstants.USER_CERT_KEYSTORE_FILE_PATH, (X509Certificate[])caCerts);
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("transId", customerTransId);
            resultMap.put("customerSystemFlag", customerCertIssueApplyVO.getCustomerSysNumber());
            resultMap.put("certSn", customerSignCert.getSerialNumber().toString(16));
            result.setInfo(resultMap);
            if (null != signCert[0]) {
                result.setLogContent("\uff0c\u7b7e\u540d\u8bc1\u4e66SN=" + signCert[0].getSerialNumber().toString(16).toLowerCase());
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u751f\u6210\u7528\u6237keyStore\u7c7b\u578b\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            result.setError(ErrorEnum.GEN_USER_CERT_KEY_STORE_FILE_FAIL);
            return result;
        }
    }

    public Result getSysCertBySysNumber(String sysNumber, String certSn) {
        PublicKey publicKey;
        Result result = new Result();
        CustomerSysCertDO customerSysCert = null;
        try {
            customerSysCert = this.customerDao.getSysCertBySysNumber(sysNumber, certSn);
            if (customerSysCert.getCertStatus() != 1) {
                this.logger.info("\u7cfb\u7edf\u8bc1\u4e66\u72b6\u6001\u4e0d\u6b63\u5e38");
                result.setError(ErrorEnum.CUSTOMER_SYS_CERT_IS_NOT_NORMAL);
                return result;
            }
            X509Certificate normalCert = CertUtils.getCertFromStr((String)customerSysCert.getCertInfo());
            publicKey = normalCert.getPublicKey();
        }
        catch (DataAccessException e) {
            this.logger.info("\u67e5\u8be2\u8bc1\u4e66\u4fe1\u606f\u7ed3\u679c\u4e0d\u4e3a1", (Object)((Object)((Object)e) + "certSn : " + certSn));
            result.setError(ErrorEnum.GET_CERT_INFO_BY_SYSNUMBER_IS_EMPTY);
            return result;
        }
        catch (Exception e) {
            this.logger.info("\u83b7\u53d6\u8bc1\u4e66\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.GET_CERT_INFO_BY_SYSNUMBER_ERROR);
            return result;
        }
        result.setInfo((Object)publicKey);
        return result;
    }

    public Result genCertConfirm(String transId, String signSn) {
        Result result = new Result();
        String raServiceDnName = this.getRAServiceDnName();
        if (StringUtils.isBlank((CharSequence)raServiceDnName)) {
            result.setError(ErrorEnum.GET_RA_SERVICE_DN_NAME_ERROR);
            return result;
        }
        String caServiceDnName = this.getCAServiceDnName();
        if (StringUtils.isBlank((CharSequence)caServiceDnName)) {
            result.setError(ErrorEnum.GET_CA_SERVICE_DN_NAME_ERROR);
            return result;
        }
        Result certRespResult = this.certLifeCycleManager.issueCertResp(raServiceDnName, caServiceDnName, 2, transId);
        if (!certRespResult.isSuccess()) {
            this.logger.error("\u7b2c\u4e09\u65b9\u7cfb\u7edf\u8bc1\u4e66\u7b7e\u53d1\uff0c\u786e\u8ba4\u5931\u8d25:{}", (Object)JsonUtils.object2Json((Object)certRespResult));
            result.setErrorBean(certRespResult.getErrorBean());
            return result;
        }
        try {
            this.customerCertDao.updateCustomerCertStatus(1, signSn);
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u7b2c\u4e09\u65b9\u7cfb\u7edf\u8bc1\u4e66\u72b6\u6001\u5f02\u5e38 ", (Throwable)e);
            result.setError(ErrorEnum.UPDATE_USER_CERT_STATUS_EXCEPTION);
            return result;
        }
        return result;
    }

    public Result genErrorMsgContent(String transId, int errorCode, String errorMsg) {
        Result result = new Result();
        String raServiceDnName = this.getRAServiceDnName();
        if (StringUtils.isBlank((CharSequence)raServiceDnName)) {
            result.setError(ErrorEnum.GET_RA_SERVICE_DN_NAME_ERROR);
            return result;
        }
        String caServiceDnName = this.getCAServiceDnName();
        if (StringUtils.isBlank((CharSequence)caServiceDnName)) {
            result.setError(ErrorEnum.GET_CA_SERVICE_DN_NAME_ERROR);
            return result;
        }
        Map map = OperatorCertCache.getMap();
        map.remove(transId);
        Result errResult = this.certLifeCycleManager.sendErrorCMPMessage(raServiceDnName, caServiceDnName, 2, transId, errorCode, errorMsg);
        if (!errResult.isSuccess()) {
            this.logger.info("\u9519\u8bef\u786e\u8ba4\u6d88\u606f\u51fa\u9519\uff1a" + JsonUtils.object2Json((Object)errResult));
            result.setErrorBean(errResult.getErrorBean());
            return result;
        }
        return result;
    }

    public Result revokeCustomerCert(String signSn, String certDn, int revokeType, String revokeReason) {
        Result result = new Result();
        String raServiceDnName = this.getRAServiceDnName();
        if (StringUtils.isBlank((CharSequence)raServiceDnName)) {
            result.setError(ErrorEnum.GET_RA_SERVICE_DN_NAME_ERROR);
            return result;
        }
        String caServiceDnName = this.getCAServiceDnName();
        if (StringUtils.isBlank((CharSequence)caServiceDnName)) {
            result.setError(ErrorEnum.GET_CA_SERVICE_DN_NAME_ERROR);
            return result;
        }
        CustomerSysCertDO customerCert = this.customerCertDao.getCustomerCert(signSn);
        Long tempId = customerCert.getTempId();
        Result revokeResult = null == tempId ? this.certLifeCycleManager.revokeManageCert(raServiceDnName, caServiceDnName, signSn, certDn, revokeType, revokeReason) : this.certLifeCycleManager.revokeUserCert(null, raServiceDnName, caServiceDnName, signSn, certDn, revokeType, revokeReason);
        if (!revokeResult.isSuccess()) {
            this.logger.info("CA\u8fd4\u56de\u64a4\u9500\u8bc1\u4e66\u9519\u8bef\u6d88\u606f:{}", (Object)JsonUtils.object2Json((Object)revokeResult));
            result.setErrorBean(revokeResult.getErrorBean());
            return result;
        }
        try {
            this.customerCertDao.updateCustomerCertStatus(3, signSn);
        }
        catch (Exception e) {
            this.logger.error("\u4fee\u6539\u7b2c\u4e09\u65b9\u7cfb\u7edf\u8bc1\u4e66\u72b6\u6001\u5f02\u5e38{}", (Throwable)e);
            result.setError(ErrorEnum.UPDATE_OPERATOR_CERT_STATUS_EXCEPTION);
            return result;
        }
        return result;
    }

    public Result getCertMaxValidity(String tempNo) {
        Result result = new Result();
        CertTempDO certTempInfoByTempNo = this.certTempCache.getCertTempInfoByTempNo(tempNo);
        if (certTempInfoByTempNo == null) {
            result.setError(ErrorEnum.GET_CERT_TEMP_INFO_IS_EMPTY);
            return result;
        }
        int tempMaxValidity = certTempInfoByTempNo.getMaxValidity();
        CaCertDO newCaCertInfo = this.caCertDao.getNewCaCertInfo();
        if (newCaCertInfo == null) {
            result.setError(ErrorEnum.GET_CA_CERT_INFO_IS_EMPTY);
            return result;
        }
        Timestamp failureTime = newCaCertInfo.getFailureTime();
        long failTime = failureTime.getTime();
        long nowTime = System.currentTimeMillis();
        int caValidity = (int)((failTime - nowTime) / 86400000L);
        this.logger.info("\u7528\u6237\u6a21\u677f\u7f16\u53f7:{},\u7ba1\u7406CA\u6700\u5927\u6709\u6548\u671f:{},\u6a21\u677f\u6700\u5927\u6709\u6548\u671f:{}", new Object[]{tempNo, caValidity, tempMaxValidity});
        int min = Math.min(tempMaxValidity, caValidity);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("maxValidity", min);
        result.setInfo(map);
        return result;
    }

    public Result getCustomerTemplateSelectList(Long customerId) {
        Result result = new Result();
        try {
            List customerTemplateSelectList = this.customerTempDao.getCustomerTemplateSelectList(customerId);
            result.setInfo((Object)customerTemplateSelectList);
        }
        catch (DAOException e) {
            throw new ServiceException("\u67e5\u8be2\u7b2c\u4e09\u65b9\u7cfb\u7edf\u6a21\u677f\u4e0b\u62c9\u9009\u62e9\u5217\u8868\u5f02\u5e38", (Throwable)e);
        }
        return result;
    }

    public Result verifyClientCertDn(String systemFlag, String certDn) {
        Result result = new Result();
        X500Name x500Name = null;
        try {
            x500Name = DnUtil.getRFC4519X500Name((String)certDn);
        }
        catch (Exception e) {
            this.logger.info("certDn\u4e0d\u6b63\u786e{}", (Object)e.getMessage());
            result.setError(ErrorEnum.CERT_APPLY_DN_IS_ERROR);
            return result;
        }
        String certDnFormat = x500Name.toString();
        this.logger.info("\u683c\u5f0f\u5316\u4e4b\u540e\u7684\u64cd\u4f5c\u5458\u8bc1\u4e66DN\uff1a" + certDnFormat);
        Result checkResult = CertDnVerifyUtils.checkDn((X500Name)x500Name);
        if (!checkResult.isSuccess()) {
            result.setError(checkResult.getError());
            return result;
        }
        checkResult = CertDnVerifyUtils.checkCertDnSort((X500Name)x500Name);
        if (!checkResult.isSuccess()) {
            this.logger.info("\u8bc1\u4e66\u7684DN\u7684\u7c7b\u578b\u5148\u540e\u987a\u5e8f\u6709\u8bef");
            result.setError(checkResult.getError());
            return result;
        }
        List customerSysCertDOS = this.customerCertDao.queryClientCertByCertDn(systemFlag, certDn);
        if (!CollectionUtils.isEmpty((Collection)customerSysCertDOS)) {
            this.logger.info("\u6709\u591a\u4e2a\u7684\u8bc1\u4e66\u7684DN\u4fe1\u606f\u540c\u3010" + certDn + "\u3011\u4e00\u81f4");
            result.setError(ErrorEnum.CLIENT_CERT_DN_HAVE_SAME_IN_CREATED);
            return result;
        }
        return result;
    }

    public Result verifyCustomerSysName(Boolean isUpdate, Integer id, String systemName) {
        Result result = new Result();
        int count = this.customerDao.getSystemIdentifier(isUpdate, id, systemName);
        if (count >= 1) {
            result.setError(ErrorEnum.SYS_NAME_HAS_EXISTED);
            return result;
        }
        return result;
    }

    public Result verifyCustomerSysNumber(String systemNumber) {
        Result result = new Result();
        int count = this.customerDao.getSystemIdentifier(systemNumber);
        if (count >= 1) {
            result.setError(ErrorEnum.SYS_ID_HAS_EXISTED);
            return result;
        }
        return result;
    }

    public Result verifyUserSystemFlag(String systemNumber) {
        int count = this.customerDao.getSystemIdentifier(systemNumber = systemNumber == null ? "RA" : systemNumber);
        if (1 != count) {
            return Result.failure((ErrorEnum)ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
        }
        return Result.success();
    }

    private Result checkCertDnCnValue(String certDn) {
        Result result = new Result();
        Result raBaseDNResult = this.certApplyService.getRaBaseDn();
        if (!raBaseDNResult.isSuccess()) {
            return raBaseDNResult;
        }
        String raBaseDN = (String)raBaseDNResult.getInfo();
        if (certDn.length() <= 3 || certDn.length() <= 3 + raBaseDN.length()) {
            result.setError(ErrorEnum.OPERATOR_CERT_DN_LENGTH_IS_ERROR);
            return result;
        }
        String dnValue = certDn.substring(3, certDn.length() - raBaseDN.length() - 1);
        this.logger.info("\u7b2c\u4e09\u65b9\u7cfb\u7edf\u7684DN\u503c\u4e3a ========== " + dnValue);
        if (dnValue.contains("=")) {
            this.logger.info("\u7b2c\u4e09\u65b9\u7cfb\u7edf\u7684DN\u4e2d\u542b\u6709\u7279\u6b8a\u7b26\u53f7");
            result.setError(ErrorEnum.OPERATOR_CERT_DN_VALUE_HAVE_ERROR_SYMBOL);
            return result;
        }
        return result;
    }

    private String getRAServiceDnName() {
        RaCertDO newRaCertInfo = null;
        try {
            newRaCertInfo = this.raCertDao.getNewRaCertInfo();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6RA\u670d\u52a1\u5668\u8bc1\u4e66\u5f02\u5e38{}", (Throwable)e);
            return null;
        }
        if (newRaCertInfo == null) {
            return null;
        }
        String certInfo = newRaCertInfo.getCertInfo();
        X509Certificate certFromStr = CertUtils.getCertFromStr((String)certInfo);
        String raServiceDnName = CertUtils.getSubjectByX509Cert((X509Certificate)certFromStr);
        return raServiceDnName;
    }

    private String getCAServiceDnName() {
        CaCertDO newCaCertInfo = null;
        try {
            newCaCertInfo = this.caCertDao.getNewCaCertInfo();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6CA\u670d\u52a1\u5668\u8bc1\u4e66\u5f02\u5e38{}", (Throwable)e);
            return null;
        }
        if (newCaCertInfo == null) {
            return null;
        }
        String certInfo = newCaCertInfo.getCertInfo();
        X509Certificate certFromStr = CertUtils.getCertFromStr((String)certInfo);
        String caServiceDnName = CertUtils.getSubjectByX509Cert((X509Certificate)certFromStr);
        return caServiceDnName;
    }

    private Result insertCustomerCertInfo(CustomerCertIssueApplyVO customerCertIssueApplyVO, UserCertInfo customerCertInfo) {
        Result result = new Result();
        String signCert = customerCertInfo.getSignCert();
        if (StringUtils.isBlank((CharSequence)signCert)) {
            this.logger.info("CA\u8fd4\u56de\u7684\u7528\u6237\u8bc1\u4e66\u4fe1\u606f\u4e2d\uff0c\u7b7e\u540d\u8bc1\u4e66\u4e3a\u7a7a");
            result.setError(ErrorEnum.CA_RESPONSE_USER_SIGN_CERT_INFO_IS_EMPTY);
            return result;
        }
        long pairCertIndex = System.nanoTime();
        CustomerSysCertDO signCertDO = new CustomerSysCertDO();
        this.handleCustomerSysCertDO(pairCertIndex, customerCertIssueApplyVO, signCertDO);
        if (StringUtils.isBlank((CharSequence)customerCertInfo.getEncCert())) {
            signCertDO.setCertType(Integer.valueOf(1));
        } else {
            signCertDO.setCertType(Integer.valueOf(2));
        }
        CaCertDO newCaCertInfo = this.caCertDao.getNewCaCertInfo();
        if (newCaCertInfo == null) {
            this.logger.info("\u83b7\u53d6CA\u8bc1\u4e66\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_CA_CERT_INFO_IS_EMPTY);
            return result;
        }
        signCertDO.setCaCertId(newCaCertInfo.getId());
        X509Certificate signCertStr = CertUtils.getCertFromStr((String)signCert);
        if (signCertStr == null) {
            this.logger.info("CA\u8fd4\u56de\u7684\u7528\u6237\u8bc1\u4e66\u4fe1\u606f\u4e2d\uff0c\u7b7e\u540d\u8bc1\u4e66\u9519\u8bef");
            result.setError(ErrorEnum.CA_RESPONSE_USER_SIGN_CERT_ERROR);
            return result;
        }
        signCertDO.setCertInfo(signCert);
        signCertDO.setCertSn(signCertStr.getSerialNumber().toString(16).toLowerCase());
        signCertDO.setCertDn(CertUtils.getSubjectByX509Cert((X509Certificate)signCertStr));
        Date startDate = signCertStr.getNotBefore();
        Date endDate = signCertStr.getNotAfter();
        signCertDO.setEffectiveTime((Date)new Timestamp(startDate.getTime()));
        signCertDO.setFailureTime((Date)new Timestamp(endDate.getTime()));
        int certDays = (int)((endDate.getTime() - startDate.getTime()) / 86400000L);
        signCertDO.setCertValidity(Integer.valueOf(certDays));
        int priKeyDays = (int)((newCaCertInfo.getFailureTime().getTime() - startDate.getTime()) / 86400000L);
        signCertDO.setEncKeyValidity(Integer.valueOf(priKeyDays));
        Date date = new Date();
        signCertDO.setGmtCreate((Date)new Timestamp(date.getTime()));
        signCertDO.setGmtUpdate((Date)new Timestamp(date.getTime()));
        CustomerSysCertDO customerSignCertDO = this.customerCertDao.insertCustomerCertInfo(signCertDO);
        String encCert = customerCertInfo.getEncCert();
        if (StringUtils.isNotBlank((CharSequence)encCert)) {
            CustomerSysCertDO encCertDO = new CustomerSysCertDO();
            this.handleCustomerSysCertDO(pairCertIndex, customerCertIssueApplyVO, encCertDO);
            encCertDO.setCertType(Integer.valueOf(3));
            encCertDO.setCertStatus(Integer.valueOf(0));
            encCertDO.setCaCertId(newCaCertInfo.getId());
            encCertDO.setEffectiveTime((Date)new Timestamp(startDate.getTime()));
            encCertDO.setFailureTime((Date)new Timestamp(endDate.getTime()));
            encCertDO.setCertValidity(Integer.valueOf(certDays));
            encCertDO.setEncKeyValidity(Integer.valueOf(priKeyDays));
            X509Certificate encCertStr = CertUtils.getCertFromStr((String)encCert);
            if (encCertStr == null) {
                this.logger.info("CA\u8fd4\u56de\u7684\u7528\u6237\u8bc1\u4e66\u4fe1\u606f\u4e2d\uff0c\u52a0\u5bc6\u8bc1\u4e66\u9519\u8bef");
                result.setError(ErrorEnum.CA_RESPONSE_USER_ENC_CERT_ERROR);
                return result;
            }
            encCertDO.setCertInfo(encCert);
            encCertDO.setGmtCreate((Date)new Timestamp(date.getTime()));
            encCertDO.setGmtUpdate((Date)new Timestamp(date.getTime()));
            encCertDO.setCertDn(CertUtils.getSubjectByX509Cert((X509Certificate)encCertStr));
            encCertDO.setCertSn(encCertStr.getSerialNumber().toString(16).toLowerCase());
            encCertDO.setSignCertSn(customerSignCertDO.getCertSn());
            try {
                this.customerCertDao.insertCustomerCertInfo(encCertDO);
            }
            catch (Exception e) {
                this.logger.info("\u63d2\u5165\u7b2c\u4e09\u65b9\u7cfb\u7edf\u8bc1\u4e66\u4fe1\u606f\u5f02\u5e38");
                this.customerCertDao.deleteCustomerCert(customerSignCertDO.getId().longValue());
            }
        }
        return result;
    }

    private void handleCustomerSysCertDO(long pairCertIndex, CustomerCertIssueApplyVO customerCertIssueApplyVO, CustomerSysCertDO customerSysCertDO) {
        customerSysCertDO.setPairCertIndex(Long.valueOf(pairCertIndex));
        customerSysCertDO.setCertStatus(Integer.valueOf(0));
        customerSysCertDO.setCustomerSysId(customerCertIssueApplyVO.getCustomerSysId());
        customerSysCertDO.setCustomerSysNumber(customerCertIssueApplyVO.getCustomerSysNumber());
        customerSysCertDO.setTempId(customerCertIssueApplyVO.getTempId());
        customerSysCertDO.setTempNo(customerCertIssueApplyVO.getTempNo());
        customerSysCertDO.setSignAlg(customerCertIssueApplyVO.getSignAlg());
        customerSysCertDO.setPrivateKeyLength(customerCertIssueApplyVO.getPrivateKeyLength());
    }
}

