/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.init;

import com.xdja.pki.apache.client.utils.ApacheClientHttpUtils;
import com.xdja.pki.cache.RedisClient;
import com.xdja.pki.core.exception.ServiceException;
import com.xdja.pki.gmssl.core.utils.GMSSLRandomUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLKeKUtils;
import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.config.Config;
import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.core.constant.PathConstants;
import com.xdja.pki.ra.core.util.cert.HsmUtils;
import com.xdja.pki.ra.core.util.file.FileUtils;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.manager.dao.AdminCertDao;
import com.xdja.pki.ra.manager.dao.InitDao;
import com.xdja.pki.ra.manager.dao.model.AdminCertDO;
import com.xdja.pki.ra.manager.sdk.business.CaBusinessManager;
import com.xdja.pki.ra.service.manager.init.InitService;
import com.xdja.pki.ra.service.manager.system.SystemService;
import com.xdja.pki.security.service.SecurityService;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class InitServiceImpl
implements InitService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    InitDao initDao;
    @Autowired
    SecurityService securityService;
    @Autowired
    CaBusinessManager caBusinessManager;
    @Autowired
    AdminCertDao adminCertDao;
    @Autowired
    SystemService systemService;
    private String tomcatPath = System.getProperty("catalina.home");
    @Value(value="${ra.system.https.port}")
    private String httpsPort;
    @Value(value="${ra.system.http.port}")
    private String httpPort;
    @Autowired
    private RedisClient redisClient;

    public Result isInitialized() {
        int isInit;
        Result result = new Result();
        try {
            Config config = this.systemService.getConfigFile("config.json");
            if (null == config) {
                result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
                return result;
            }
            isInit = config.getIsInit();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u662f\u5426\u521d\u59cb\u5316\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
        result.setInfo((Object)isInit);
        return result;
    }

    public Result updateDeviceInitStatus(Integer status) {
        Result result = new Result();
        try {
            Config config = Config.getConfig((String)PathConstants.GLOBAL_CONF_FILE_PATH);
            if (null == config) {
                result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
                return result;
            }
            config.setIsInit(status.intValue());
            Config.saveConfig((Config)config, (String)PathConstants.GLOBAL_CONF_FILE_PATH);
        }
        catch (Exception e) {
            this.logger.error("\u4fee\u6539\u521d\u59cb\u5316\u72b6\u6001\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
        return result;
    }

    public Result updateInitStep(int step) {
        Result result = new Result();
        try {
            Config config = this.systemService.getConfigFile("config.json");
            if (null == config) {
                result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
                return result;
            }
            config.setInitStep(step);
            this.systemService.updateConfigFile(config);
        }
        catch (Exception e) {
            this.logger.error("\u8bb0\u5f55\u6b65\u9aa4\u6570\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
        return result;
    }

    public Result getOperateStep() {
        int initStepId;
        Result result = new Result();
        try {
            Config config = this.systemService.getConfigFile("config.json");
            if (null == config) {
                result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
                return result;
            }
            initStepId = config.getInitStep();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u6b65\u9aa4\u6570\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
        result.setInfo((Object)initStepId);
        return result;
    }

    public Result initDeviceRecover() {
        Result result = new Result();
        try {
            Config config = this.systemService.getConfigFile("config.json");
            if (null == config) {
                result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
                return result;
            }
            int init = config.getIsInit();
            if (1 == init) {
                this.logger.info("\u7cfb\u7edf\u5df2\u7ecf\u521d\u59cb\u5316");
                result.setError(ErrorEnum.SYSTEM_IS_INIT_TRUE);
                return result;
            }
            config.setIsInit(0);
            config.setInitStep(0);
            config.setIsReboot(0);
            this.systemService.updateConfigFile(config);
        }
        catch (Exception e) {
            this.logger.error("\u91cd\u65b0\u5f00\u59cb\u521d\u59cb\u5316\u91cd\u7f6e\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
        try {
            this.initDao.deleteRaCert();
        }
        catch (Exception e) {
            this.logger.error("\u91cd\u65b0\u5f00\u59cb\u521d\u59cb\u5316\u6e05\u7a7ara_cert\u8868\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.RECOVER_INIT_DB_OPERATION_ERROR);
            return result;
        }
        try {
            this.initDao.deleteCACert();
        }
        catch (Exception e) {
            this.logger.error("\u91cd\u65b0\u5f00\u59cb\u521d\u59cb\u5316\u6e05\u7a7aca_cert\u8868\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.RECOVER_INIT_DB_OPERATION_ERROR);
            return result;
        }
        try {
            this.initDao.deleteAdminCert();
        }
        catch (Exception e) {
            this.logger.error("\u91cd\u65b0\u5f00\u59cb\u521d\u59cb\u5316\u6e05\u7a7aadmin_cert\u8868\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.RECOVER_INIT_DB_OPERATION_ERROR);
            return result;
        }
        try {
            this.initDao.deleteAdminRole();
        }
        catch (Exception e) {
            this.logger.error("\u91cd\u65b0\u5f00\u59cb\u521d\u59cb\u5316\u6e05\u7a7aadmin_role\u8868\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.RECOVER_INIT_DB_OPERATION_ERROR);
            return result;
        }
        try {
            this.systemService.updateConfigFile(Config.getConfigInit());
        }
        catch (Exception e) {
            result.setError(ErrorEnum.DECRYPT_ENCRYPT_INFO_ERROR);
            return result;
        }
        CommonVariable.clear();
        ApacheClientHttpUtils.client = null;
        FileUtils.deleteFile((File)new File(PathConstants.SOFT_ALG_FOLDER_PATH));
        FileUtils.deleteFile((File)new File(PathConstants.SUPER_CA_CERTS_FILE_PATH));
        this.redisClient.flushAll();
        return result;
    }

    public Result authorizeAdmin(String signSn, String cardNo, int adminType) {
        Result result = new Result();
        AdminCertDO adminCertInfo = null;
        Result stepResult = this.getOperateStep();
        this.logger.info("\u5f53\u524d\u521d\u59cb\u5316\u6b65\u9aa4\u4e3a========" + stepResult.getInfo());
        if (1 == adminType && !stepResult.getInfo().equals(4)) {
            this.logger.info("\u521d\u59cb\u5316\u6b65\u9aa4\u6570\u9519\u8bef");
            result.setError(ErrorEnum.INIT_STEP_ERROR);
            return result;
        }
        if (2 == adminType && !stepResult.getInfo().equals(5)) {
            this.logger.info("\u521d\u59cb\u5316\u6b65\u9aa4\u6570\u9519\u8bef");
            result.setError(ErrorEnum.INIT_STEP_ERROR);
            return result;
        }
        try {
            adminCertInfo = this.adminCertDao.getAdminCertInfo(signSn, 2);
        }
        catch (Exception e) {
            this.logger.info("\u8be5sn\u3010{}\u3011\u672a\u8fdb\u884c\u8fc7\u6388\u6743\uff0c\u5c06\u8fdb\u884c\u6388\u6743\u64cd\u4f5c\uff01", (Object)signSn);
        }
        if (adminCertInfo != null) {
            result.setError(ErrorEnum.THIS_ADMIN_SIGN_SN_HAD_AUTHORIZE);
            return result;
        }
        Result authenResult = this.caBusinessManager.raAdminLoginAuthen(signSn);
        if (!authenResult.isSuccess()) {
            return authenResult;
        }
        Map caAuthenMap = (Map)authenResult.getInfo();
        this.logger.info("CA\u8fd4\u56de\u7684\u8ba4\u8bc1\u4fe1\u606f ============ " + JsonUtils.object2Json((Object)caAuthenMap));
        if (CollectionUtils.isEmpty((Map)caAuthenMap)) {
            result.setError(ErrorEnum.CA_RETURN_ADMIN_AUTHEN_INFO_IS_EMPTY);
            return result;
        }
        int caAdminType = (Integer)caAuthenMap.get("adminType");
        if (caAdminType != adminType) {
            result.setError(ErrorEnum.AUTHEN_ADMIN_ROLE_IS_ERROR);
            return result;
        }
        int signCertStatus = (Integer)caAuthenMap.get("signCertStatus");
        if (1 != signCertStatus) {
            result.setError(ErrorEnum.ADMIN_CERT_STATUS_IS_NOT_NORMAL);
            return result;
        }
        String signCertData = (String)caAuthenMap.get("signCertData");
        String encCertData = (String)caAuthenMap.get("encCertData");
        Result authorResult = null;
        try {
            authorResult = (Result)this.securityService.authorizationAdminInfo(cardNo, signCertData, encCertData, adminType, signCertStatus);
        }
        catch (NamingException e) {
            this.logger.error("\u6388\u6743\u7ba1\u7406\u5458\u5f02\u5e38 ", (Throwable)e);
        }
        if (!authorResult.isSuccess()) {
            result.setError(authorResult.getError());
            return result;
        }
        result = 1 == adminType ? this.updateInitStep(5) : this.updateInitStep(6);
        return result;
    }

    public Result initRaSystem() {
        Result result = new Result();
        try {
            Config config = this.systemService.getConfigFile("config.json");
            if (null == config) {
                result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
                return result;
            }
            config.setIsReboot(1);
            config.setIsInit(1);
            config.setInitStep(7);
            this.systemService.updateConfigFile(config);
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u91cd\u542f\u4fee\u6539\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
        this.logger.info("HTTPs\u7aef\u53e3\uff1a" + this.httpsPort + " \u8bf7\u8df3\u8f6c");
        result.setInfo((Object)this.httpsPort);
        return result;
    }

    public Result restartTomcat() {
        Result result = new Result();
        this.logger.info("================tomcatPath " + this.tomcatPath);
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(900L);
                        Runtime.getRuntime().exec(InitServiceImpl.this.tomcatPath + "/bin/restart.sh");
                    }
                    catch (InterruptedException e) {
                        InitServiceImpl.this.logger.error("\u91cd\u542f\u7cfb\u7edf\u5f02\u5e38 ", (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                    catch (IOException e) {
                        InitServiceImpl.this.logger.error("\u91cd\u542f\u7cfb\u7edf\u5f02\u5e38 ", (Throwable)e);
                    }
                }
            }).start();
        }
        catch (Exception e) {
            this.logger.error("\u91cd\u542ftomcat\u5931\u8d25");
            result.setError(ErrorEnum.RESTART_TOMCAT_ERROR);
            return result;
        }
        return Result.success();
    }

    public Result getSystemKeyAlgName() {
        String keyAlgName = CommonVariable.getKeyAlgName();
        if (StringUtils.isBlank((CharSequence)keyAlgName)) {
            this.logger.error("\u83b7\u53d6\u7cfb\u7edf\u7b97\u6cd5\u5931\u8d25");
            return Result.failure((ErrorEnum)ErrorEnum.GET_CERT_ALG_NAME_LENGTH_EXCEPTION);
        }
        int keyAlg = "SM2".equalsIgnoreCase(CommonVariable.getKeyAlgName()) ? 1 : ("RSA".equalsIgnoreCase(CommonVariable.getKeyAlgName()) ? 2 : 3);
        return Result.success((Object)keyAlg);
    }

    public Result genLocalEncryptKey() {
        try {
            byte[] random = GMSSLRandomUtils.generateRandom((int)16);
            return Result.success();
        }
        catch (Exception e) {
            this.logger.error("\u751f\u6210\u52a0\u5bc6\u5bf9\u79f0\u5bc6\u94a5\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u751f\u6210\u52a0\u5bc6\u5bf9\u79f0\u5bc6\u94a5\u5931\u8d25", (Throwable)e);
        }
    }

    public Result genEncryptKey(Integer keyIndex) {
        try {
            byte[] key;
            Result result = this.getOperateStep();
            if (!result.getInfo().equals(3)) {
                this.logger.info("\u521d\u59cb\u5316\u6b65\u9aa4\u6570\u9519\u8bef");
                result.setError(ErrorEnum.INIT_STEP_ERROR);
                return result;
            }
            Config config = this.systemService.getConfigFile("config.json");
            if (null == config) {
                result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
                return result;
            }
            CommonVariable.setIsEncrypt((Integer)Constants.DATA_IS_ENCRYPTION_1);
            config.setInitStep(4);
            if (1 == CommonVariable.getIsHsm()) {
                config.setEncryptKeyIndex(keyIndex.intValue());
                CommonVariable.setEncryptKeyIndex((int)keyIndex);
                key = GMSSLKeKUtils.generateKeyWithKeKBySM4ECB((int)keyIndex);
            } else {
                key = GMSSLRandomUtils.generateRandom((int)16);
            }
            CommonVariable.setEncryptKey((String)Base64.toBase64String((byte[])key));
            String encrypt = HsmUtils.getEncryptKey((String)Base64.toBase64String((byte[])key));
            config.setEncryptKey(encrypt);
            config = HsmUtils.cryptConfigRaPwd((boolean)true, (Config)config);
            this.systemService.updateConfigFile(config);
        }
        catch (Exception e) {
            this.logger.error("\u751f\u6210\u52a0\u5bc6\u5bf9\u79f0\u5bc6\u94a5\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u751f\u6210\u52a0\u5bc6\u5bf9\u79f0\u5bc6\u94a5\u5931\u8d25", (Throwable)e);
        }
        return Result.success();
    }
}

