/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.login;

import com.xdja.pki.auth.service.AuditLogService;
import com.xdja.pki.auth.service.bean.AuditSignBean;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRandomUtils;
import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.manager.dao.AdminCertDao;
import com.xdja.pki.ra.manager.dao.AdminRoleDao;
import com.xdja.pki.ra.manager.dao.FunctionDao;
import com.xdja.pki.ra.manager.dao.model.AdminCertDO;
import com.xdja.pki.ra.manager.dao.model.FunctionDO;
import com.xdja.pki.ra.manager.dao.model.RoleDO;
import com.xdja.pki.ra.manager.sdk.business.CaBusinessManager;
import com.xdja.pki.ra.service.manager.login.AdminLoginService;
import com.xdja.pki.ra.service.manager.login.bean.CurrentAdminInfo;
import com.xdja.pki.security.bean.AdminCertCardNoToken;
import com.xdja.pki.security.bean.Menu;
import com.xdja.pki.security.bean.Operator;
import com.xdja.pki.security.service.SecurityService;
import com.xdja.pki.security.util.OperatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdminLoginServiceImpl
implements AdminLoginService {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    AdminCertDao adminCertDao;
    @Autowired
    FunctionDao functionDao;
    @Autowired
    AdminRoleDao adminRoleDao;
    @Autowired
    SecurityService securityService;
    @Autowired
    CaBusinessManager caBusinessManager;
    @Autowired
    AuditLogService auditLogService;

    public Result managerLogin(String cardNo, String signSn, String signData, String clientIpAddress, AuditSignBean bean) {
        Result result = new Result();
        try {
            AdminCertCardNoToken token = new AdminCertCardNoToken(signSn, "111111");
            token.setCardNo(cardNo);
            token.setSignSn(signSn);
            token.setSignData(signData);
            SecurityUtils.getSubject().login((AuthenticationToken)token);
        }
        catch (AuthenticationException e) {
            String errorInfo;
            switch (errorInfo = e.getMessage()) {
                case "20001": {
                    result.setError(ErrorEnum.ADMIN_LOGIN_AUTHEN_EXCEPTION);
                    break;
                }
                case "20002": {
                    result.setError(ErrorEnum.ADMIN_CERT_NOT_EXIST);
                    break;
                }
                case "20003": {
                    result.setError(ErrorEnum.ADMIN_CERT_STATUS_IS_NOT_NORMAL);
                    break;
                }
                case "20004": {
                    result.setError(ErrorEnum.ADMIN_ROLE_TYPE_IS_ERROR);
                    break;
                }
                case "20006": {
                    result.setError(ErrorEnum.CA_OPEN_API_SERVICE_EXCEPTION);
                    break;
                }
                case "20007": {
                    result.setError(ErrorEnum.CHALLENGE_CODE_IS_EMPTY);
                    break;
                }
                case "20008": {
                    result.setError(ErrorEnum.CHALLENGE_CODE_VERIFY_IS_ERROR);
                    break;
                }
                case "20317": {
                    result.setError(ErrorEnum.GET_CA_CERT_INFO_IS_EMPTY);
                    break;
                }
                case "20505": {
                    Result.failure((ErrorEnum)ErrorEnum.CA_RESPONSE_USER_SIGN_CERT_ERROR);
                    break;
                }
                case "20506": {
                    result.setError(ErrorEnum.CA_RESPONSE_USER_ENC_CERT_ERROR);
                    break;
                }
                case "20510": {
                    result.setError(ErrorEnum.CA_SERVICE_RETURN_LOGIN_AUTHEN_ERROR);
                    break;
                }
                case "20713": {
                    result.setError(ErrorEnum.CA_RETURN_ADMIN_AUTHEN_INFO_IS_EMPTY);
                    break;
                }
                default: {
                    this.logger.info("========== authentication_exception_errorInfo ========= " + errorInfo);
                    result.setError(ErrorEnum.AUTHENTICATION_EXCEPTION);
                }
            }
            return result;
        }
        AdminCertDO adminCertInfo = this.adminCertDao.getAdminCertInfo(signSn, 2);
        if (null == adminCertInfo) {
            result.setError(ErrorEnum.ADMIN_CERT_NOT_EXIST);
            return result;
        }
        ArrayList<Integer> roleList = new ArrayList<Integer>();
        boolean isAuditor = false;
        List roleDOS = this.adminRoleDao.getRoleListByAdminCertId(adminCertInfo.getId().longValue());
        for (RoleDO roleDO : roleDOS) {
            roleList.add(roleDO.getType());
            if (2 != roleDO.getType()) continue;
            isAuditor = true;
        }
        boolean allowLogin = this.auditLogService.isAllowLogin();
        if (!allowLogin && !isAuditor) {
            result.setError(ErrorEnum.MAX_AUDIT_LOG_STORAGE);
            return result;
        }
        String adminDnName = 3 == adminCertInfo.getAdminType() ? "\u4e1a\u52a1\u64cd\u4f5c\u5458" : adminCertInfo.getRoleInfo();
        Integer isHsm = CommonVariable.getIsHsm();
        Map<String, Menu> menuMap = this.queryFunctions(signSn, isHsm);
        this.logger.info("\u3010{}\u3011\u7ba1\u7406\u5458\u62e5\u6709\u7684\u3010\u6743\u9650\u3011\u83dc\u5355 : " + JsonUtils.object2Json(menuMap), (Object)adminDnName);
        menuMap = this.removeUserManagerMenu(menuMap);
        List<Menu> menus = this.sortMenuList(menuMap.values());
        this.logger.info("\u3010{}\u3011\u7ba1\u7406\u5458\u62e5\u6709\u7684\u3010\u8bbf\u95ee\u3011\u83dc\u5355 :" + JsonUtils.object2Json(menus), (Object)adminDnName);
        CurrentAdminInfo currentAdminInfo = new CurrentAdminInfo();
        BeanUtils.copyProperties((Object)adminCertInfo, (Object)currentAdminInfo);
        currentAdminInfo.setRoleList(roleList);
        currentAdminInfo.setClientIpAddress(clientIpAddress);
        OperatorUtil.setOperator((Operator)new Operator(signSn, menuMap, (Object)currentAdminInfo));
        Session session = SecurityUtils.getSubject().getSession();
        session.setAttribute((Object)"sessionId", (Object)session.getId().toString());
        HashMap<String, Object> userInfoMap = new HashMap<String, Object>();
        userInfoMap.put("name", adminDnName);
        userInfoMap.put("role", roleList);
        userInfoMap.put("sn", signSn);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("menus", menus);
        map.put("userInfo", userInfoMap);
        result.setInfo(map);
        this.logger.info("AdminLoginServiceImpl.managerLogin>>>>>>result:" + JsonUtils.object2Json((Object)result));
        return result;
    }

    public Result generateChallenge(String signSn) {
        String challengeCode;
        Result result = new Result();
        if (0 != CommonVariable.getIsHsm()) {
            try {
                challengeCode = GMSSLRandomUtils.generateRandomByYunhsm((int)20);
            }
            catch (Exception e) {
                this.logger.error("\u5bc6\u7801\u673a\u56fd\u5bc6\u7b97\u6cd5\u5de5\u5177\u7c7b-\u83b7\u53d6\u968f\u673a\u6570-\u5f02\u5e38,{}", (Throwable)e);
                result.setError(ErrorEnum.GMSSL_HSM_UTILS_IS_EXCEPTION);
                return result;
            }
        } else {
            challengeCode = UUID.randomUUID().toString().replace("-", "");
        }
        this.logger.info("LoginManagerImpl.generateChallenge>>>>>>signSn:" + signSn + " challengeCode:" + challengeCode);
        result.setInfo((Object)challengeCode);
        return result;
    }

    public Map<String, Menu> queryFunctions(String signSn, Integer isHsm) {
        List functions = new ArrayList();
        functions = signSn == null ? this.functionDao.queryAllFunctions() : this.functionDao.queryFunctionsByAdminCertSn(signSn, isHsm);
        return this.queryMapFunctions(functions);
    }

    private Map<String, Menu> queryMapFunctions(List<FunctionDO> functionList) {
        LinkedHashMap<String, Menu> functions = new LinkedHashMap<String, Menu>();
        LinkedHashMap<Long, Menu> tempFunctions = new LinkedHashMap<Long, Menu>();
        Menu menu = null;
        for (FunctionDO function : functionList) {
            menu = this.function2Menu(function);
            if (function.getParentId() == 0L) {
                tempFunctions.put(function.getId(), menu);
                functions.put(String.valueOf(function.getId()), menu);
                continue;
            }
            Menu parentFunc = (Menu)tempFunctions.get(function.getParentId());
            if (parentFunc != null) {
                parentFunc.addChild(menu);
            }
            tempFunctions.put(function.getId(), menu);
        }
        return functions;
    }

    private Menu function2Menu(FunctionDO function) {
        Menu menu = new Menu();
        menu.setId(String.valueOf(function.getId()));
        menu.setName(function.getName());
        menu.setPermissionKey(function.getPermissionKey());
        menu.setPermission(function.getPermission());
        menu.setIcon(function.getIcon());
        menu.setLink(function.getLink());
        menu.setObjName(function.getObjName());
        menu.setOrder(function.getOrderNum().intValue());
        menu.setShow(function.getIsShow() == 1);
        return menu;
    }

    private List<Menu> sortMenuList(Collection<Menu> menuCollection) {
        ArrayList<Menu> menuList = new ArrayList<Menu>();
        menuList.addAll(menuCollection);
        Collections.sort(menuList, new MenuComparator());
        return menuList;
    }

    private Map<String, Menu> removeUserManagerMenu(Map<String, Menu> menuMap) {
        Iterator<Map.Entry<String, Menu>> iterator = menuMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Menu> next = iterator.next();
            Collection children = next.getValue().getChildren();
            if (CollectionUtils.isNotEmpty((Collection)children)) {
                Iterator childIterator = children.iterator();
                while (childIterator.hasNext()) {
                    Menu childNext = (Menu)childIterator.next();
                    Collection children1 = childNext.getChildren();
                    if (CollectionUtils.isNotEmpty((Collection)children1)) {
                        Iterator iterator1 = children1.iterator();
                        while (iterator1.hasNext()) {
                            Menu next1 = (Menu)iterator1.next();
                            if (next1.isShow()) continue;
                            iterator1.remove();
                        }
                    }
                    if (childNext.isShow()) continue;
                    childIterator.remove();
                }
            }
            if (next.getValue().isShow()) continue;
            iterator.remove();
        }
        return menuMap;
    }

    private class MenuComparator
    implements Comparator<Object> {
        private MenuComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            int orderNum2;
            int orderNum1 = ((Menu)o1).getOrder();
            if (orderNum1 > (orderNum2 = ((Menu)o2).getOrder())) {
                return 1;
            }
            if (orderNum1 < orderNum2) {
                return -1;
            }
            return 0;
        }
    }
}

