/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.operator;

import com.xdja.ca.utils.DnUtil;
import com.xdja.ca.utils.SdkCertUtils;
import com.xdja.ca.utils.SdkP10Utils;
import com.xdja.ca.vo.ManagerCertInfo;
import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.common.OperatorCertCache;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.pkcs7.SignedDataUtils;
import com.xdja.pki.ra.core.util.cert.CertDnVerifyUtils;
import com.xdja.pki.ra.core.util.cert.CertUtils;
import com.xdja.pki.ra.core.util.cert.RandomUtils;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.manager.dao.AdminCertDao;
import com.xdja.pki.ra.manager.dao.AdminRoleDao;
import com.xdja.pki.ra.manager.dao.CaCertDao;
import com.xdja.pki.ra.manager.dao.RaCertDao;
import com.xdja.pki.ra.manager.dao.model.AdminCertDO;
import com.xdja.pki.ra.manager.dao.model.AdminRoleDO;
import com.xdja.pki.ra.manager.dao.model.CaCertDO;
import com.xdja.pki.ra.manager.dao.model.RaCertDO;
import com.xdja.pki.ra.manager.dto.AdminCertDTO;
import com.xdja.pki.ra.manager.page.PageInfo;
import com.xdja.pki.ra.manager.sdk.business.CaBusinessManager;
import com.xdja.pki.ra.manager.sdk.cmp.CertLifeCycleManager;
import com.xdja.pki.ra.service.manager.certapply.CertApplyService;
import com.xdja.pki.ra.service.manager.operator.OperatorCertService;
import com.xdja.pki.ra.service.manager.operator.bean.ManagerCertVO;
import com.xdja.pki.ra.service.manager.operator.bean.OperatorCertResp;
import com.xdja.pki.ra.service.manager.operator.bean.OperatorCertVO;
import com.xdja.pki.ra.service.manager.utils.CertContentInfoUtil;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.spec.RSAPublicKeySpec;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class OperatorCertServiceImpl
implements OperatorCertService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    AdminCertDao adminCertDao;
    @Autowired
    CertContentInfoUtil certContentInfoUtil;
    @Autowired
    CertLifeCycleManager certLifeCycleManager;
    @Autowired
    CaBusinessManager caBusinessManager;
    @Autowired
    CaCertDao caCertDao;
    @Autowired
    RaCertDao raCertDao;
    @Autowired
    AdminRoleDao adminRoleDao;
    @Autowired
    private CertApplyService certApplyService;

    public Result queryOperatorCertList(String certDN, int pageNo, int pageSize) {
        OperatorCertResp operatorCertResp = new OperatorCertResp();
        Result result = new Result();
        PageInfo adminCertDTOPageInfo = this.adminCertDao.listPageAdminCert(certDN, pageNo, pageSize);
        if (adminCertDTOPageInfo == null) {
            result.setError(ErrorEnum.QUERY_OPERATOR_CERT_LIST_ERROR);
            return result;
        }
        ArrayList<OperatorCertVO> operatorCertVOList = new ArrayList<OperatorCertVO>();
        List list = adminCertDTOPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            operatorCertResp.setRecordCount(0);
            operatorCertResp.setPageCount(0);
            operatorCertResp.setDatas(operatorCertVOList);
            result.setInfo((Object)operatorCertResp);
            return result;
        }
        for (AdminCertDTO adminCertDTO : list) {
            OperatorCertVO operatorCertVO = new OperatorCertVO();
            BeanUtils.copyProperties((Object)adminCertDTO, (Object)operatorCertVO);
            Timestamp effectiveTime = adminCertDTO.getEffectiveTime();
            Timestamp failureTime = adminCertDTO.getFailureTime();
            operatorCertVO.setEffectiveTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(effectiveTime));
            operatorCertVO.setFailureTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(failureTime));
            if (System.currentTimeMillis() > failureTime.getTime()) {
                operatorCertVO.setCertStatus(Integer.valueOf(2));
            }
            operatorCertVOList.add(operatorCertVO);
        }
        operatorCertResp.setDatas(operatorCertVOList);
        operatorCertResp.setPageCount(adminCertDTOPageInfo.getPageCount());
        operatorCertResp.setRecordCount(adminCertDTOPageInfo.getRecordCount());
        result.setInfo((Object)operatorCertResp);
        return result;
    }

    public Result getOperatorCertDetail(String certSn, int certType) {
        Result result = new Result();
        AdminCertDO adminCertInfo = this.adminCertDao.getAdminCertInfo(certSn, certType);
        if (adminCertInfo == null) {
            result.setError(ErrorEnum.GET_OPERATOR_CERT_INFO_EMPTY);
            return result;
        }
        String certInfo = adminCertInfo.getCertInfo();
        Map<String, Object> certContentInfo = null;
        try {
            X509Certificate certificate = CertUtils.getCertFromStr((String)certInfo);
            certContentInfo = this.certContentInfoUtil.getCertContentInfo(certificate);
        }
        catch (Exception e) {
            this.logger.error("\u8bc1\u4e66\u8be6\u60c5\u683c\u5f0f\u8bfb\u53d6\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CERT_DETAIL_FORMAT_ERROR);
            return result;
        }
        result.setInfo(certContentInfo);
        return result;
    }

    public Result getOperatorCertInfo(String signSn) {
        Result result = new Result();
        AdminCertDO adminCertInfo = this.adminCertDao.getAdminCertInfo(signSn, 2);
        if (adminCertInfo == null) {
            result.setError(ErrorEnum.GET_OPERATOR_CERT_INFO_EMPTY);
            return result;
        }
        OperatorCertVO operatorCertVO = new OperatorCertVO();
        BeanUtils.copyProperties((Object)adminCertInfo, (Object)operatorCertVO);
        int leftValidity = (int)((adminCertInfo.getFailureTime().getTime() - System.currentTimeMillis()) / 86400000L);
        operatorCertVO.setCertValidity(Integer.valueOf(leftValidity));
        operatorCertVO.setEffectiveTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(adminCertInfo.getEffectiveTime()));
        operatorCertVO.setFailureTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(adminCertInfo.getFailureTime()));
        result.setInfo((Object)operatorCertVO);
        return result;
    }

    public Result getOperatorCertBase64Info(String signSn) {
        Result result = new Result();
        Map adminCertBase64Info = new HashMap();
        try {
            adminCertBase64Info = this.adminCertDao.getAdminCertBase64Info(signSn);
        }
        catch (Exception e) {
            result.setError(ErrorEnum.GET_OPERATOR_CERT_BASE64_INFO_EMPTY);
            return result;
        }
        if (adminCertBase64Info == null) {
            result.setError(ErrorEnum.GET_OPERATOR_CERT_BASE64_INFO_EMPTY);
            return result;
        }
        String signCertStr = (String)adminCertBase64Info.get("signCert");
        String encCertStr = (String)adminCertBase64Info.get("encCert");
        ArrayList list = new ArrayList();
        X509Certificate signCert = CertUtils.getCertFromStr((String)signCertStr);
        String signTrustCert = null;
        String encTrustCert = null;
        try {
            List caTrustCert = CommonVariable.getTrustCaCerts();
            ArrayList<X509Certificate> caTrust = new ArrayList<X509Certificate>(caTrustCert);
            caTrust.add(signCert);
            signTrustCert = SignedDataUtils.createCertChainByCerts(caTrust);
            if (!"NISTP256".equalsIgnoreCase(CommonVariable.getKeyAlgName())) {
                X509Certificate encCert = CertUtils.getCertFromStr((String)encCertStr);
                caTrust.remove(signCert);
                caTrust.add(encCert);
                encTrustCert = SignedDataUtils.createCertChainByCerts(caTrust);
            }
        }
        catch (Exception e) {
            this.logger.error("sdk\u63a5\u53e3-\u5c01\u88c5\u8bc1\u4e66\u94fe\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.BUILD_TRAIN_CERT_P7b_IS_ERROR);
            return result;
        }
        result.setLogContent("\uff0c\u8bc1\u4e66\u4e3b\u4f53=" + CertUtils.getSubjectByX509Cert((X509Certificate)signCert));
        HashMap<String, Object> signMap = new HashMap<String, Object>();
        signMap.put("name", "SignCert");
        signMap.put("suffix", "p7b");
        byte[] signByte = signTrustCert.getBytes();
        signMap.put("buffer", signByte);
        list.add(signMap);
        if (null != encTrustCert) {
            HashMap<String, Object> encMap = new HashMap<String, Object>();
            encMap.put("name", "EncCert");
            encMap.put("suffix", "p7b");
            byte[] encByte = encTrustCert.getBytes();
            encMap.put("buffer", encByte);
            list.add(encMap);
        }
        result.setInfo(list);
        return result;
    }

    public Result getRaOperatorCertTemp() {
        Result result = new Result();
        Result raOperatorCertTemp = this.caBusinessManager.getRaOperatorCertTemp();
        if (!raOperatorCertTemp.isSuccess()) {
            return raOperatorCertTemp;
        }
        Map map = (Map)raOperatorCertTemp.getInfo();
        result.setInfo((Object)map);
        return result;
    }

    public Result getOperatorCertMaxValidity(int updateKey, String signSn) {
        Result result = new Result();
        Result raOperatorCertTemp = this.caBusinessManager.getRaOperatorCertTemp();
        if (!raOperatorCertTemp.isSuccess()) {
            return raOperatorCertTemp;
        }
        Map map = (Map)raOperatorCertTemp.getInfo();
        int tempMaxValidity = (Integer)map.get("maxDate");
        CaCertDO newCaCertInfo = this.caCertDao.getNewCaCertInfo();
        if (newCaCertInfo == null) {
            result.setError(ErrorEnum.GET_CA_CERT_INFO_IS_EMPTY);
            return result;
        }
        Timestamp failureTime = newCaCertInfo.getFailureTime();
        long failTime = failureTime.getTime();
        long nowTime = System.currentTimeMillis();
        int caValidity = (int)((failTime - nowTime) / 86400000L);
        int min = Math.min(tempMaxValidity, caValidity);
        this.logger.info("\u64cd\u4f5c\u5458\u53ef\u9009\u8bc1\u4e66\u6709\u6548\u671f\u4e2d\uff0c\u7ba1\u7406CA\u6700\u5927\u6709\u6548\u671f:{}\uff0c\u6a21\u677f\u6700\u5927\u6709\u6548\u671f:{}", (Object)caValidity, (Object)tempMaxValidity);
        result.setInfo((Object)min);
        return result;
    }

    @Transactional
    public Result insertOperatorCert(AdminCertDTO adminCertDTO) {
        byte[] signPublicKey;
        Result result = new Result();
        String raServiceDnName = this.getRAServiceDnName();
        if (StringUtils.isBlank((CharSequence)raServiceDnName)) {
            result.setError(ErrorEnum.GET_RA_SERVICE_DN_NAME_ERROR);
            return result;
        }
        CaCertDO newCaCertInfo = this.caCertDao.getNewCaCertInfo();
        if (newCaCertInfo == null) {
            this.logger.info("\u83b7\u53d6CA\u8bc1\u4e66\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_CA_CERT_INFO_IS_EMPTY);
            return result;
        }
        String caServiceDnName = newCaCertInfo.getCertDn();
        String transId = RandomUtils.getUUID();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("************************ gen TransID:[{}]", (Object)transId);
        }
        try {
            signPublicKey = SdkP10Utils.p10ToPublicKey((String)adminCertDTO.getSignP10()).getEncoded();
        }
        catch (Exception e) {
            this.logger.info("sdk\u63a5\u53e3-\u4eceP10\u4e2d\u83b7\u53d6\u516c\u94a5\u4fe1\u606f\u5f02\u5e38\uff1a{}", (Throwable)e);
            result.setError(ErrorEnum.GET_PUBLIC_KEY_FROM_P10_EXCEPTION);
            return result;
        }
        Result issueResult = this.certLifeCycleManager.issueManageCert(true, adminCertDTO.getCardNo(), signPublicKey, adminCertDTO.getEncPubKey(), raServiceDnName, caServiceDnName, transId, adminCertDTO.getManagerTempNo(), adminCertDTO.getSignAlg(), adminCertDTO.getCertValidity(), adminCertDTO.getCertDn());
        if (!issueResult.isSuccess()) {
            this.logger.error("\u7b7e\u53d1\u8bc1\u4e66\u9519\u8bef\u6d88\u606f ==== ", (Object)issueResult.getErrorBean().getErrMsg());
            result.setErrorBean(issueResult.getErrorBean());
            return result;
        }
        ManagerCertInfo managerCertInfo = (ManagerCertInfo)issueResult.getInfo();
        long pairCertIndex = System.nanoTime();
        List roles = adminCertDTO.getRoles();
        StringBuffer sb = new StringBuffer();
        Iterator iterator = roles.iterator();
        while (iterator.hasNext()) {
            int role = (Integer)iterator.next();
            if (role == 3) {
                sb.append("\u5f55\u5165\u5458\u3001");
                continue;
            }
            if (role == 4) {
                sb.append("\u5ba1\u6838\u5458\u3001");
                continue;
            }
            if (role == 5) {
                sb.append("\u5236\u8bc1\u5458\u3001");
                continue;
            }
            this.logger.info("\u64cd\u4f5c\u5458\u89d2\u8272\u7c7b\u578b\u9519\u8bef");
            result.setError(ErrorEnum.OPERATOR_ROLE_IS_ERROR);
            return result;
        }
        String roleInfo = sb.substring(0, sb.length() - 1);
        AdminCertDO adminCertSignCertDO = new AdminCertDO();
        BeanUtils.copyProperties((Object)adminCertDTO, (Object)adminCertSignCertDO);
        adminCertSignCertDO.setAdminType(Integer.valueOf(3));
        adminCertSignCertDO.setCaCertId(newCaCertInfo.getId());
        adminCertSignCertDO.setCertInfo(managerCertInfo.getSignCert());
        adminCertSignCertDO.setPairCertIndex(Long.valueOf(pairCertIndex));
        adminCertSignCertDO.setCertType(Integer.valueOf(2));
        adminCertSignCertDO.setRoleInfo(roleInfo);
        X509Certificate signCertStr = CertUtils.getCertFromStr((String)managerCertInfo.getSignCert());
        if (signCertStr == null) {
            this.logger.info("CA\u8fd4\u56de\u7684\u7ba1\u7406\u5458\u8bc1\u4e66\u4fe1\u606f\u4e2d\uff0c\u7b7e\u540d\u8bc1\u4e66\u9519\u8bef");
            result.setError(ErrorEnum.CA_RESPONSE_USER_SIGN_CERT_ERROR);
            return result;
        }
        adminCertSignCertDO.setCertSn(signCertStr.getSerialNumber().toString(16).toLowerCase());
        adminCertSignCertDO.setCertDn(CertUtils.getSubjectByX509Cert((X509Certificate)signCertStr));
        this.logger.info("============== CA\u8fd4\u56de\u7b7e\u53d1\u7b7e\u540d\u8bc1\u4e66sn:" + adminCertSignCertDO.getCertSn());
        adminCertSignCertDO.setEncPubKey(null);
        int publicKeyLength = 0;
        try {
            publicKeyLength = CertUtils.getPublicKeyLength((X509Certificate)signCertStr);
            adminCertSignCertDO.setPrivateKeyLength(Integer.valueOf(publicKeyLength));
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u8bc1\u4e66\u516c\u94a5\u957f\u5ea6\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.GET_CERT_PUBLIC_KEY_LENGTH_EXCEPTION);
            return result;
        }
        String publicKeyAlg = null;
        try {
            publicKeyAlg = CertUtils.getKeyAlg((X509Certificate)signCertStr);
            adminCertSignCertDO.setPublicKeyAlg(publicKeyAlg);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u8bc1\u4e66\u5bc6\u94a5\u7b97\u6cd5\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.GET_CERT_ALG_NAME_LENGTH_EXCEPTION);
            return result;
        }
        Date startDate = signCertStr.getNotBefore();
        Date endDate = signCertStr.getNotAfter();
        adminCertSignCertDO.setEffectiveTime(new Timestamp(startDate.getTime()));
        adminCertSignCertDO.setFailureTime(new Timestamp(endDate.getTime()));
        adminCertSignCertDO.setGmtCreate(new Timestamp(System.currentTimeMillis()));
        adminCertSignCertDO.setGmtUpdate(new Timestamp(System.currentTimeMillis()));
        AdminCertDO operatorSignCertDO = this.adminCertDao.insertAdminCert(adminCertSignCertDO);
        AdminCertDO adminCertEncCertDO = new AdminCertDO();
        BeanUtils.copyProperties((Object)adminCertDTO, (Object)adminCertEncCertDO);
        adminCertEncCertDO.setAdminType(Integer.valueOf(3));
        adminCertEncCertDO.setCaCertId(newCaCertInfo.getId());
        adminCertEncCertDO.setCertInfo(managerCertInfo.getEncEncCert());
        adminCertEncCertDO.setPairCertIndex(Long.valueOf(pairCertIndex));
        adminCertEncCertDO.setCertType(Integer.valueOf(3));
        adminCertEncCertDO.setRoleInfo(roleInfo);
        adminCertEncCertDO.setCertDn(CertUtils.getSubjectByX509Cert((X509Certificate)signCertStr));
        adminCertEncCertDO.setEncPubKey(adminCertDTO.getEncPubKey());
        adminCertEncCertDO.setPrivateKeyLength(Integer.valueOf(publicKeyLength));
        adminCertEncCertDO.setPublicKeyAlg(publicKeyAlg);
        adminCertEncCertDO.setEffectiveTime(new Timestamp(startDate.getTime()));
        adminCertEncCertDO.setFailureTime(new Timestamp(endDate.getTime()));
        adminCertEncCertDO.setGmtCreate(new Timestamp(System.currentTimeMillis()));
        adminCertEncCertDO.setGmtUpdate(new Timestamp(System.currentTimeMillis()));
        this.adminCertDao.insertAdminCert(adminCertEncCertDO);
        Iterator iterator2 = roles.iterator();
        while (iterator2.hasNext()) {
            int role = (Integer)iterator2.next();
            AdminRoleDO adminRoleDO = new AdminRoleDO(operatorSignCertDO.getId(), Long.valueOf(role), new Timestamp(System.currentTimeMillis()), new Timestamp(System.currentTimeMillis()));
            this.adminRoleDao.insertAdminRole(adminRoleDO);
        }
        ManagerCertVO managerCertVO = new ManagerCertVO(managerCertInfo.getSignCert(), managerCertInfo.getEncEncCert(), transId);
        result.setInfo((Object)managerCertVO);
        return result;
    }

    @Transactional
    public Result updateOperatorCert(AdminCertDTO adminCertDTO) {
        Result result = new Result();
        String raServiceDnName = this.getRAServiceDnName();
        if (StringUtils.isBlank((CharSequence)raServiceDnName)) {
            result.setError(ErrorEnum.GET_RA_SERVICE_DN_NAME_ERROR);
            return result;
        }
        CaCertDO newCaCertInfo = this.caCertDao.getNewCaCertInfo();
        if (newCaCertInfo == null) {
            this.logger.info("\u83b7\u53d6CA\u8bc1\u4e66\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_CA_CERT_INFO_IS_EMPTY);
            return result;
        }
        String caServiceDnName = newCaCertInfo.getCertDn();
        String transId = RandomUtils.getUUID();
        Map map = OperatorCertCache.getMap();
        map.put(transId, adminCertDTO.getSignCertSn());
        this.logger.info("\u7f13\u5b58\u7684\u64cd\u4f5c\u5458sn\u4fe1\u606f ===== " + JsonUtils.object2Json((Object)map));
        Result updateResult = this.certLifeCycleManager.updateManageCert(adminCertDTO.getCardNo(), adminCertDTO.getSignP10(), adminCertDTO.getEncPubKey(), raServiceDnName, caServiceDnName, transId, adminCertDTO.getManagerTempNo(), adminCertDTO.getSignAlg(), adminCertDTO.getCertValidity(), adminCertDTO.getCertDn(), adminCertDTO.getSignCertSn(), adminCertDTO.isUpdateKey());
        if (!updateResult.isSuccess()) {
            this.logger.info("CA\u8fd4\u56de\u66f4\u65b0\u8bc1\u4e66\u9519\u8bef\u6d88\u606f ==== " + JsonUtils.object2Json((Object)updateResult));
            result.setErrorBean(updateResult.getErrorBean());
            return result;
        }
        ManagerCertInfo managerCertInfo = (ManagerCertInfo)updateResult.getInfo();
        AdminCertDO adminCertDO = this.adminCertDao.getAdminCertInfo(adminCertDTO.getSignCertSn(), 2);
        if (adminCertDO == null) {
            result.setError(ErrorEnum.GET_OPERATOR_CERT_INFO_EMPTY);
            return result;
        }
        long pairCertIndex = System.nanoTime();
        AdminCertDO adminCertSignCertDO = new AdminCertDO();
        BeanUtils.copyProperties((Object)adminCertDTO, (Object)adminCertSignCertDO);
        adminCertSignCertDO.setAdminType(Integer.valueOf(3));
        adminCertSignCertDO.setCaCertId(newCaCertInfo.getId());
        adminCertSignCertDO.setCertInfo(managerCertInfo.getSignCert());
        adminCertSignCertDO.setPairCertIndex(Long.valueOf(pairCertIndex));
        adminCertSignCertDO.setCertType(Integer.valueOf(2));
        adminCertSignCertDO.setRoleInfo(adminCertDO.getRoleInfo());
        X509Certificate signCertStr = CertUtils.getCertFromStr((String)managerCertInfo.getSignCert());
        if (signCertStr == null) {
            this.logger.info("CA\u8fd4\u56de\u7684\u7ba1\u7406\u5458\u8bc1\u4e66\u4fe1\u606f\u4e2d\uff0c\u7b7e\u540d\u8bc1\u4e66\u9519\u8bef");
            result.setError(ErrorEnum.CA_RESPONSE_USER_SIGN_CERT_ERROR);
            return result;
        }
        adminCertSignCertDO.setCertSn(signCertStr.getSerialNumber().toString(16).toLowerCase());
        adminCertSignCertDO.setCertDn(CertUtils.getSubjectByX509Cert((X509Certificate)signCertStr));
        adminCertSignCertDO.setEncPubKey(null);
        int publicKeyLength = 0;
        try {
            publicKeyLength = CertUtils.getPublicKeyLength((X509Certificate)signCertStr);
            adminCertSignCertDO.setPrivateKeyLength(Integer.valueOf(publicKeyLength));
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u8bc1\u4e66\u516c\u94a5\u957f\u5ea6\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.GET_CERT_PUBLIC_KEY_LENGTH_EXCEPTION);
            return result;
        }
        String publicKeyAlg = null;
        try {
            publicKeyAlg = CertUtils.getKeyAlg((X509Certificate)signCertStr);
            adminCertSignCertDO.setPublicKeyAlg(publicKeyAlg);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u8bc1\u4e66\u5bc6\u94a5\u7b97\u6cd5\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.GET_CERT_ALG_NAME_LENGTH_EXCEPTION);
            return result;
        }
        Date startDate = signCertStr.getNotBefore();
        Date endDate = signCertStr.getNotAfter();
        adminCertSignCertDO.setEffectiveTime(new Timestamp(startDate.getTime()));
        adminCertSignCertDO.setFailureTime(new Timestamp(endDate.getTime()));
        adminCertSignCertDO.setGmtCreate(new Timestamp(System.currentTimeMillis()));
        adminCertSignCertDO.setGmtUpdate(new Timestamp(System.currentTimeMillis()));
        AdminCertDO operatorSignCertDO = this.adminCertDao.insertAdminCert(adminCertSignCertDO);
        AdminCertDO adminCertEncCertDO = new AdminCertDO();
        BeanUtils.copyProperties((Object)adminCertDTO, (Object)adminCertEncCertDO);
        adminCertEncCertDO.setAdminType(Integer.valueOf(3));
        adminCertEncCertDO.setCaCertId(newCaCertInfo.getId());
        adminCertEncCertDO.setCertInfo(managerCertInfo.getEncEncCert());
        adminCertEncCertDO.setPairCertIndex(Long.valueOf(pairCertIndex));
        adminCertEncCertDO.setCertType(Integer.valueOf(3));
        adminCertEncCertDO.setRoleInfo(adminCertDO.getRoleInfo());
        adminCertEncCertDO.setCertDn(CertUtils.getSubjectByX509Cert((X509Certificate)signCertStr));
        adminCertEncCertDO.setEncPubKey(adminCertDTO.getEncPubKey());
        adminCertEncCertDO.setPrivateKeyLength(Integer.valueOf(publicKeyLength));
        adminCertEncCertDO.setPublicKeyAlg(publicKeyAlg);
        adminCertEncCertDO.setEffectiveTime(new Timestamp(startDate.getTime()));
        adminCertEncCertDO.setFailureTime(new Timestamp(endDate.getTime()));
        adminCertEncCertDO.setGmtCreate(new Timestamp(System.currentTimeMillis()));
        adminCertEncCertDO.setGmtUpdate(new Timestamp(System.currentTimeMillis()));
        this.adminCertDao.insertAdminCert(adminCertEncCertDO);
        List adminRoleDOList = this.adminRoleDao.queryAdminRoleList(adminCertDO.getId().longValue());
        if (CollectionUtils.isEmpty((Collection)adminRoleDOList)) {
            result.setError(ErrorEnum.QUERY_ADMIN_ROLE_IS_EMPTY);
            return result;
        }
        for (AdminRoleDO adminRoleDO : adminRoleDOList) {
            adminRoleDO.setAdminId(operatorSignCertDO.getId());
            adminRoleDO.setRoleId(adminRoleDO.getRoleId());
            adminRoleDO.setGmtCreate(new Timestamp(System.currentTimeMillis()));
            adminRoleDO.setGmtUpdate(new Timestamp(System.currentTimeMillis()));
            this.adminRoleDao.insertAdminRole(adminRoleDO);
        }
        ManagerCertVO managerCertVO = new ManagerCertVO(managerCertInfo.getSignCert(), managerCertInfo.getEncEncCert(), transId);
        result.setInfo((Object)managerCertVO);
        return result;
    }

    public Result revokeOperatorCert(String signSn, String certDn, int revokeType, String revokeReason) {
        Result result = new Result();
        String raServiceDnName = this.getRAServiceDnName();
        if (StringUtils.isBlank((CharSequence)raServiceDnName)) {
            result.setError(ErrorEnum.GET_RA_SERVICE_DN_NAME_ERROR);
            return result;
        }
        String caServiceDnName = this.getCAServiceDnName();
        if (StringUtils.isBlank((CharSequence)caServiceDnName)) {
            result.setError(ErrorEnum.GET_CA_SERVICE_DN_NAME_ERROR);
            return result;
        }
        Result revokeResult = this.certLifeCycleManager.revokeManageCert(raServiceDnName, caServiceDnName, signSn, certDn, revokeType, revokeReason);
        if (!revokeResult.isSuccess()) {
            this.logger.info("CA\u8fd4\u56de\u64a4\u9500\u8bc1\u4e66\u9519\u8bef\u6d88\u606f ==== " + JsonUtils.object2Json((Object)revokeResult));
            result.setErrorBean(revokeResult.getErrorBean());
            return result;
        }
        try {
            this.adminCertDao.updateAdminSignCertStatus(3, signSn);
            this.adminCertDao.updateAdminEncCertStatus(3, signSn);
        }
        catch (Exception e) {
            this.logger.error("\u4fee\u6539\u64cd\u4f5c\u5458\u8bc1\u4e66\u72b6\u6001\u5f02\u5e38{}", (Throwable)e);
            result.setError(ErrorEnum.UPDATE_OPERATOR_CERT_STATUS_EXCEPTION);
            return result;
        }
        return result;
    }

    public Result updateOperatorCertStatus(int certStatus, String certSn) {
        Result result = new Result();
        try {
            this.adminCertDao.updateAdminSignCertStatus(certStatus, certSn);
            this.adminCertDao.updateAdminEncCertStatus(certStatus, certSn);
        }
        catch (Exception e) {
            result.setError(ErrorEnum.UPDATE_OPERATOR_CERT_STATUS_EXCEPTION);
            return result;
        }
        return result;
    }

    @Transactional
    public Result genCertConfirm(String transId, String signSn, String encSn, String encCert) {
        Result result = new Result();
        String raServiceDnName = this.getRAServiceDnName();
        if (StringUtils.isBlank((CharSequence)raServiceDnName)) {
            result.setError(ErrorEnum.GET_RA_SERVICE_DN_NAME_ERROR);
            return result;
        }
        String caServiceDnName = this.getCAServiceDnName();
        if (StringUtils.isBlank((CharSequence)caServiceDnName)) {
            result.setError(ErrorEnum.GET_CA_SERVICE_DN_NAME_ERROR);
            return result;
        }
        String publicKeyStr = null;
        String encPubKey = this.adminCertDao.getEncPubKeyBySignSn(signSn);
        if (StringUtils.isNotBlank((CharSequence)encPubKey)) {
            PublicKey publicKey = null;
            try {
                if ("SM2".equalsIgnoreCase(CommonVariable.getKeyAlgName())) {
                    publicKey = SdkCertUtils.convertSM2PublicKey((String)encPubKey);
                } else if ("NISTP256".equalsIgnoreCase(CommonVariable.getKeyAlgName())) {
                    publicKey = SdkCertUtils.convertECPublicKey((String)encPubKey, (String)NISTNamedCurves.getName((ASN1ObjectIdentifier)SECObjectIdentifiers.secp256r1));
                } else {
                    KeyFactory kf = KeyFactory.getInstance("RSA", (Provider)new BouncyCastleProvider());
                    RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(BigIntegers.fromUnsignedByteArray((byte[])Base64.decode((String)encPubKey)), BigInteger.valueOf(65537L));
                    publicKey = kf.generatePublic(rsaPublicKeySpec);
                }
            }
            catch (Exception e) {
                this.logger.error("\u83b7\u53d6\u8bc1\u4e66\u8bf7\u6c42\u65f6\u7684\u516c\u94a5\u4fe1\u606f\u5f02\u5e38{}", (Throwable)e);
                result.setError(ErrorEnum.GET_CERT_PUBLIC_KEY_EXCEPTION);
                return result;
            }
            publicKeyStr = Base64.toBase64String((byte[])publicKey.getEncoded());
            this.logger.info("\u8bc1\u4e66\u8bf7\u6c42\u65f6\u7684\u516c\u94a5\u4fe1\u606f ==== " + publicKeyStr);
            if (!"NISTP256".equalsIgnoreCase(CommonVariable.getKeyAlgName())) {
                this.logger.info("\u52a0\u5bc6\u8bc1\u4e66\u660e\u6587\uff1a" + encCert);
                X509Certificate certificate = CertUtils.getCertFromStr((String)encCert);
                String encCertPubKey = Base64.toBase64String((byte[])certificate.getPublicKey().getEncoded());
                this.logger.info("\u52a0\u5bc6\u8bc1\u4e66\u4e2d\u7684\u516c\u94a5\u4fe1\u606f ==== " + encCertPubKey);
                if (!publicKeyStr.equalsIgnoreCase(encCertPubKey)) {
                    this.logger.info("\u8bc1\u4e66\u54cd\u5e94\u4e2d\u7684\u52a0\u5bc6\u8bc1\u4e66\u516c\u94a5\u548c\u7533\u8bf7\u65f6\u7684\u4e0d\u4e00\u81f4");
                    result.setError(ErrorEnum.CERT_CONFIRM_PUB_KEY_NOT_SAME_REQ);
                    return result;
                }
            }
        }
        Map map = OperatorCertCache.getMap();
        String oldSignSn = (String)map.get(transId);
        Result certRespResult = this.certLifeCycleManager.issueCertResp(raServiceDnName, caServiceDnName, 2, transId);
        if (!certRespResult.isSuccess()) {
            map.remove(transId);
            this.logger.info("\u7b7e\u53d1\u7ba1\u7406\u5458\u8bc1\u4e66\u54cd\u5e94");
            result.setErrorBean(certRespResult.getErrorBean());
            return result;
        }
        try {
            this.adminCertDao.updateAdminSignCertStatus(3, oldSignSn);
            this.adminCertDao.updateAdminEncCertStatus(3, oldSignSn);
        }
        catch (Exception e) {
            this.logger.error("\u4fee\u6539\u64cd\u4f5c\u5458\u8bc1\u4e66\u72b6\u6001\u5f02\u5e38{}", (Throwable)e);
            result.setError(ErrorEnum.UPDATE_OPERATOR_CERT_STATUS_EXCEPTION);
            return result;
        }
        map.remove(transId);
        try {
            this.adminCertDao.updateAdminSignCertStatus(1, signSn);
            this.adminCertDao.updateAdminEncCertStatus(1, signSn);
        }
        catch (Exception e) {
            this.logger.error("\u4fee\u6539\u64cd\u4f5c\u5458\u8bc1\u4e66\u72b6\u6001\u5f02\u5e38{}", (Throwable)e);
            result.setError(ErrorEnum.UPDATE_OPERATOR_CERT_STATUS_EXCEPTION);
            return result;
        }
        if (!"NISTP256".equalsIgnoreCase(CommonVariable.getKeyAlgName())) {
            try {
                this.adminCertDao.updateAdminEncCertInfoBySignSn(signSn, encSn, encCert);
            }
            catch (Exception e) {
                this.logger.error("\u4fee\u6539\u64cd\u4f5c\u5458\u52a0\u5bc6\u8bc1\u4e66\u5f02\u5e38{}", (Throwable)e);
                throw new RuntimeException();
            }
        }
        return result;
    }

    public Result verifyOperatorCertApplyDn(String certDn) {
        Result result = new Result();
        X500Name x500Name = null;
        try {
            x500Name = DnUtil.getRFC4519X500Name((String)certDn);
            String certDnFormat = x500Name.toString();
            this.logger.info("\u683c\u5f0f\u5316\u4e4b\u540e\u7684\u64cd\u4f5c\u5458\u8bc1\u4e66DN\uff1a" + certDnFormat);
            Result checkResult = this.checkCertDnCnValue(certDnFormat);
            if (!checkResult.isSuccess()) {
                this.logger.info("\u8bc1\u4e66\u7684DN\u7684\u7279\u6b8a\u7b26\u53f7\u6821\u9a8c\u6709\u8bef");
                result.setError(checkResult.getError());
                return result;
            }
            checkResult = CertDnVerifyUtils.checkDn((X500Name)x500Name);
            if (!checkResult.isSuccess()) {
                result.setError(checkResult.getError());
                return result;
            }
            checkResult = CertDnVerifyUtils.checkCertDnSort((X500Name)x500Name);
            if (!checkResult.isSuccess()) {
                this.logger.info("\u8bc1\u4e66\u7684DN\u7684\u7c7b\u578b\u5148\u540e\u987a\u5e8f\u6709\u8bef");
                result.setError(checkResult.getError());
                return result;
            }
        }
        catch (Exception e) {
            this.logger.info("certDn\u4e0d\u6b63\u786e{}", (Object)e.getMessage());
            result.setError(ErrorEnum.CERT_APPLY_DN_IS_ERROR);
            return result;
        }
        return result;
    }

    public Result genErrorMsgContent(String transId, int errorCode, String errorMsg) {
        Result result = new Result();
        String raServiceDnName = this.getRAServiceDnName();
        if (StringUtils.isBlank((CharSequence)raServiceDnName)) {
            result.setError(ErrorEnum.GET_RA_SERVICE_DN_NAME_ERROR);
            return result;
        }
        String caServiceDnName = this.getCAServiceDnName();
        if (StringUtils.isBlank((CharSequence)caServiceDnName)) {
            result.setError(ErrorEnum.GET_CA_SERVICE_DN_NAME_ERROR);
            return result;
        }
        Map map = OperatorCertCache.getMap();
        map.remove(transId);
        Result errResult = this.certLifeCycleManager.sendErrorCMPMessage(raServiceDnName, caServiceDnName, 2, transId, errorCode, errorMsg);
        if (!errResult.isSuccess()) {
            this.logger.info("\u9519\u8bef\u786e\u8ba4\u6d88\u606f\u51fa\u9519\uff1a" + JsonUtils.object2Json((Object)errResult));
            result.setErrorBean(errResult.getErrorBean());
            return result;
        }
        return result;
    }

    private Result checkCertDnCnValue(String certDn) {
        Result result = new Result();
        Result raBaseDNResult = this.certApplyService.getRaBaseDn();
        if (!raBaseDNResult.isSuccess()) {
            return raBaseDNResult;
        }
        String raBaseDN = (String)raBaseDNResult.getInfo();
        if (certDn.length() <= 3 || certDn.length() <= 3 + raBaseDN.length()) {
            result.setError(ErrorEnum.OPERATOR_CERT_DN_LENGTH_IS_ERROR);
            return result;
        }
        return result;
    }

    private String getRAServiceDnName() {
        String raServiceDnName;
        RaCertDO newRaCertInfo = null;
        try {
            newRaCertInfo = this.raCertDao.getNewRaCertInfo();
            if (newRaCertInfo == null) {
                return null;
            }
            String certInfo = newRaCertInfo.getCertInfo();
            X509Certificate certFromStr = CertUtils.getCertFromStr((String)certInfo);
            raServiceDnName = CertUtils.getSubjectByX509Cert((X509Certificate)certFromStr);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6RA\u670d\u52a1\u5668\u8bc1\u4e66\u5f02\u5e38{}", (Throwable)e);
            return null;
        }
        return raServiceDnName;
    }

    private String getCAServiceDnName() {
        CaCertDO newCaCertInfo = null;
        try {
            newCaCertInfo = this.caCertDao.getNewCaCertInfo();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6CA\u670d\u52a1\u5668\u8bc1\u4e66\u5f02\u5e38{}", (Throwable)e);
            return null;
        }
        if (newCaCertInfo == null) {
            return null;
        }
        String certInfo = newCaCertInfo.getCertInfo();
        X509Certificate certFromStr = CertUtils.getCertFromStr((String)certInfo);
        String caServiceDnName = CertUtils.getSubjectByX509Cert((X509Certificate)certFromStr);
        return caServiceDnName;
    }
}

