/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.scep;

import com.alibaba.fastjson.TypeReference;
import com.xdja.ca.utils.SdkP10Utils;
import com.xdja.pki.ra.cache.CertTempCache;
import com.xdja.pki.ra.cache.RaSdkCache;
import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.config.Config;
import com.xdja.pki.ra.core.util.cert.CertUtils;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.manager.dao.BaseUserDao;
import com.xdja.pki.ra.manager.dao.CertApplyDao;
import com.xdja.pki.ra.manager.dao.IssueApplyDao;
import com.xdja.pki.ra.manager.dao.RaCertDao;
import com.xdja.pki.ra.manager.dao.ScepDeviceDAO;
import com.xdja.pki.ra.manager.dao.UserCertDao;
import com.xdja.pki.ra.manager.dao.model.BaseUserDO;
import com.xdja.pki.ra.manager.dao.model.CertApplyDO;
import com.xdja.pki.ra.manager.dao.model.CertTempDO;
import com.xdja.pki.ra.manager.dao.model.ScepDeviceDO;
import com.xdja.pki.ra.manager.dto.IssueApplyDTO;
import com.xdja.pki.ra.manager.dto.RaServerCertDTO;
import com.xdja.pki.ra.manager.sdk.business.CaBusinessManager;
import com.xdja.pki.ra.service.manager.certapply.CertApplyService;
import com.xdja.pki.ra.service.manager.certapply.IssueApplyService;
import com.xdja.pki.ra.service.manager.certapply.bean.ExtensionAttr;
import com.xdja.pki.ra.service.manager.scep.ScepCertService;
import com.xdja.pki.ra.service.manager.system.SystemService;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScepCertServiceImpl
implements ScepCertService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ScepDeviceDAO scepDeviceDAO;
    @Autowired
    private CertApplyService certApplyService;
    @Autowired
    private IssueApplyService issueApplyService;
    @Autowired
    CertApplyDao certApplyDao;
    @Autowired
    CaBusinessManager caBusinessManager;
    @Autowired
    RaCertDao raCertDao;
    @Autowired
    UserCertDao userCertDao;
    @Autowired
    BaseUserDao baseUserDao;
    @Autowired
    IssueApplyDao issueApplyDao;
    @Autowired
    private SystemService systemService;
    @Autowired
    RaSdkCache raSdkCache;
    @Autowired
    CertTempCache certTempCache;
    private static final DERObjectIdentifier challengePasswordId = new DERObjectIdentifier("1.2.840.113549.1.9.7");
    private static final ASN1ObjectIdentifier extReq = new ASN1ObjectIdentifier("1.2.840.113549.1.9.14");

    public Result issueScepCert(PKCS10CertificationRequest pkcs10CertificationRequest, String transactionId) throws Exception {
        Result issueApplyResult;
        this.logger.info("scep\u6ce8\u518c\u8bc1\u4e66 transactionId:{}", (Object)transactionId);
        Result result = new Result();
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
        PublicKey publicKey = converter.getPublicKey(pkcs10CertificationRequest.getSubjectPublicKeyInfo());
        String certDn = SdkP10Utils.p10ToCertDn((String)Base64.toBase64String((byte[])pkcs10CertificationRequest.getEncoded()));
        String challengePassword = null;
        Attribute[] pwdAttributes = pkcs10CertificationRequest.getAttributes((ASN1ObjectIdentifier)challengePasswordId);
        if (pwdAttributes != null && pwdAttributes.length == 1) {
            Attribute attribute = pwdAttributes[0];
            ASN1Encodable asn1Encodable1 = attribute.getAttributeValues()[0];
            DEROctetString asn1Encodable = (DEROctetString)asn1Encodable1;
            challengePassword = new String(asn1Encodable.getOctets());
        }
        this.logger.info("\u4eceP10\u4e2d\u89e3\u6790\u83b7\u53d6\u6311\u6218\u503c\u4e3a:{}", challengePassword);
        ScepDeviceDO scepByChallenge = new ScepDeviceDO();
        if (StringUtils.isNotBlank(challengePassword) && null == (scepByChallenge = this.scepDeviceDAO.getScepByChallenge(challengePassword))) {
            this.logger.info("\u4e0d\u5b58\u5728\u7684\u6311\u6218\u503c\uff01");
            return Result.failure((ErrorEnum)ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
        }
        String tempNo = null;
        String scepTempNo = scepByChallenge.getTempNo();
        if (StringUtils.isNotBlank((CharSequence)scepTempNo)) {
            tempNo = scepTempNo;
        } else {
            Config config = this.systemService.getConfigFile("config.json");
            tempNo = config.getScepTempNo();
            if (StringUtils.isBlank((CharSequence)tempNo)) {
                this.logger.info("\u65e0\u53ef\u7528\u7684\u9ed8\u8ba4\u6a21\u677f\uff01");
                return Result.failure((ErrorEnum)ErrorEnum.MISSING_REQUIRED_PARAMETERS);
            }
        }
        CertTempDO certTempInfo = this.certTempCache.getCertTempInfoByTempNo(tempNo);
        if (null == certTempInfo) {
            this.logger.info("\u8be5\u6a21\u677f\u5df2\u505c\u7528\u6216\u8005\u5df2\u89e3\u7ed1\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002 \u539ftempNo\uff1a{}", (Object)tempNo);
            result.setError(ErrorEnum.OLD_TEMPLATE_IS_STOP_OR_UNBOUND);
            return result;
        }
        if (certTempInfo.getTempStatus() != 2 || certTempInfo.getTempBound() != 1) {
            this.logger.info("\u672c\u6b21\u4f7f\u7528\u7684\u6a21\u677f\u72b6\u6001\u4e0d\u53ef\u7528:{}", (Object)JsonUtils.object2Json((Object)certTempInfo));
            result.setError(ErrorEnum.CERT_TEMP_STATUS_IS_NOT_NORMAL);
            return result;
        }
        Boolean aBoolean = CertUtils.checkPublicKey((PublicKey)publicKey, (String)certTempInfo.getPublicKeyAlg(), (Integer)certTempInfo.getPrivateKeyLength());
        if (!aBoolean.booleanValue()) {
            result.setError(ErrorEnum.MISSING_REQUIRED_PARAMETERS);
            return result;
        }
        String tempParas = certTempInfo.getTempParas();
        List atrList = (List)JsonUtils.json2Object((String)tempParas, (TypeReference)new TypeReference<List<ExtensionAttr>>(){});
        Attribute[] extAttributes = pkcs10CertificationRequest.getAttributes(extReq);
        if (extAttributes.length != 0) {
            Attribute attribute = extAttributes[0];
            HashMap<String, String> params = new HashMap<String, String>();
            DERSet attrValues = (DERSet)attribute.getAttrValues();
            DERSet attrValue = (DERSet)attrValues.getObjectAt(0);
            for (ASN1Encodable asn1Encodable : attrValue) {
                DERSequence value = (DERSequence)asn1Encodable;
                String id = ((ASN1ObjectIdentifier)value.getObjectAt(0)).getId();
                String extValue = new String(((DEROctetString)((DERSet)value.getObjectAt(1)).getObjectAt(0)).getOctets());
                params.put(id, extValue);
            }
            for (ExtensionAttr extensionAttr : atrList) {
                if (!params.containsKey(extensionAttr.getAttrOid()) && extensionAttr.getAttrRequired() == 1) {
                    this.logger.info("\u7f3a\u5c11\u5fc5\u8981\u7684\u6a21\u677f\u6269\u5c55\u5c5e\u6027\u4fe1\u606f\uff1a{}", (Object)extensionAttr.getAttrOid());
                    result.setError(ErrorEnum.MISSING_REQUIRED_PARAMETERS);
                    return result;
                }
                extensionAttr.setAttrValue((String)params.get(extensionAttr.getAttrOid()));
            }
        }
        String extParams = JsonUtils.object2Json((Object)atrList);
        this.logger.info("================P10\u4e2d\u6269\u5c55\u9879\u503c=================:{}", (Object)JsonUtils.object2Json((Object)extParams));
        Long userId = this.baseUserDao.getUserId(3, "SCEP", Integer.valueOf(4), "scep");
        if (null == userId) {
            this.logger.info("\u67e5\u8be2scep\u9ed8\u8ba4\u7528\u6237id\u4e0d\u5b58\u5728\uff01");
            return Result.failure((ErrorEnum)ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
        }
        String baseDn = certTempInfo.getBaseDn();
        this.logger.info("\u6a21\u677f\u83b7\u53d6baseDn\u4e3a:{}", (Object)baseDn);
        if (null != baseDn && certDn.endsWith(baseDn)) {
            result = this.certApplyService.verifyUserCertApplyDn(certDn, userId.longValue(), null);
        } else {
            if (!certDn.endsWith(CommonVariable.getRaBaseDn())) {
                this.logger.info("\u6ce8\u518c\u7b7e\u53d1\u7533\u8bf7DN\u540e\u7f00\u9519\u8bef\uff0cDN[{}]", (Object)certDn);
                return Result.failure((ErrorEnum)ErrorEnum.CERT_APPLY_DN_IS_ERROR);
            }
            result = this.certApplyService.verifyUserCertApplyDn(certDn, userId.longValue(), null);
        }
        if (!result.isSuccess()) {
            this.logger.info("\u6ce8\u518c\u7b7e\u53d1\u7533\u8bf7DN\u683c\u5f0f\u9519\u8bef\uff0cDN[{}]", (Object)certDn);
            return result;
        }
        int applyStatus = 1;
        if (StringUtils.isNotBlank((CharSequence)challengePassword)) {
            applyStatus = 3;
        }
        IssueApplyDTO issueApplyDTO = new IssueApplyDTO();
        issueApplyDTO.setUserId(userId);
        issueApplyDTO.setTempNo(tempNo);
        issueApplyDTO.setCertDn(certDn);
        issueApplyDTO.setSignAlg(certTempInfo.getSignAlg());
        issueApplyDTO.setPrivateKeyLength(certTempInfo.getPrivateKeyLength());
        issueApplyDTO.setCertValidity(certTempInfo.getMaxValidity());
        issueApplyDTO.setApplyReason("SCEP\u8bbe\u5907\u5728\u7ebf\u53d1\u8d77\u6ce8\u518c\u7b7e\u53d1\u8bc1\u4e66\u7533\u8bf7");
        issueApplyDTO.setTempId(certTempInfo.getId());
        issueApplyDTO.setCertPatterm(certTempInfo.getCertPatterm());
        issueApplyDTO.setTempParas(extParams);
        String applyNo = this.raSdkCache.getIncApplyNo();
        issueApplyDTO.setApplyNo(applyNo);
        String adminCertDn = "scep\u9ed8\u8ba4\u8bbe\u5907";
        if (StringUtils.isNotBlank((CharSequence)challengePassword)) {
            adminCertDn = scepByChallenge.getScepName();
        }
        if (!(issueApplyResult = this.issueApplyService.insertCertIssueApply(Integer.valueOf(applyStatus), adminCertDn, issueApplyDTO, certTempInfo)).isSuccess()) {
            result.setError(issueApplyResult.getError());
            return result;
        }
        issueApplyDTO.setApplyId((Long)issueApplyResult.getInfo());
        this.certApplyService.insertCertApplyRecordScep(1, 1, applyNo, adminCertDn, 1, issueApplyDTO.getApplyReason(), 1, false, true);
        this.raSdkCache.cacheScepTransId(transactionId, applyNo);
        if (StringUtils.isNotBlank((CharSequence)challengePassword)) {
            this.certApplyService.insertCertApplyRecordScep(1, 3, applyNo, adminCertDn, 3, "\u81ea\u52a8\u5ba1\u6838\u7c7b\u6a21\u677f-\u5ba1\u6838\u6210\u529f", 4, true, true);
            Result issueResult = this.certApplyService.issueCert("SCEP", issueApplyDTO, publicKey.getEncoded(), adminCertDn);
            if (!issueResult.isSuccess()) {
                this.logger.info("scep\u7b7e\u53d1\u7533\u8bf7\u5904\u7406\u8bf7\u6c42\u9519\u8bef\u9519\u8bef\u539f\u56e0:{}", (Object)issueResult.getErrorBean().getErrMsg());
                return issueResult;
            }
            Result ackResult = this.certApplyService.issueUserCertRespScep(applyNo, adminCertDn);
            if (!ackResult.isSuccess()) {
                this.logger.info("scep\u7b7e\u53d1\u7533\u8bf7\u5904\u7406\u8bf7\u6c42\u9519\u8bef\u9519\u8bef\u539f\u56e0:{}", (Object)ackResult.getErrorBean().getErrMsg());
                return ackResult;
            }
            this.raSdkCache.removeScepTransId(transactionId);
            return issueResult;
        }
        String publicKeyString = Base64.toBase64String((byte[])publicKey.getEncoded());
        this.raSdkCache.cacheScepPublicKey(applyNo, publicKeyString);
        this.logger.info("==========\u8bf7\u7b49\u5f85\u7ba1\u7406\u5e73\u53f0\u5ba1\u6838\u5e76\u8fdb\u884c\u8f6e\u5faa\u67e5\u8be2==========");
        return Result.success();
    }

    public Result getRaCert(int type) {
        RaServerCertDTO raCertInfo;
        this.logger.info("scep\u67e5\u8be2RA\u670d\u52a1\u5668signCert.p7b");
        try {
            raCertInfo = this.raCertDao.getNewRaCertInfo(type);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6RA\u670d\u52a1\u5668\u8bc1\u4e66\u4e3a\u7a7a", (Throwable)e);
            return Result.failure((ErrorEnum)ErrorEnum.GET_RA_SERVER_CERT_INFO_EMPTY);
        }
        if (type == 3) {
            String encCert = raCertInfo.getCertInfo();
            this.logger.info("\u67e5\u8be2RA\u52a0\u5bc6\u8bc1\u4e66\u6210\u529f:{}", (Object)encCert);
            return Result.success((Object)encCert);
        }
        String certP7b = raCertInfo.getCertP7b();
        this.logger.info("\u67e5\u8be2RA\u7b7e\u540d\u8bc1\u4e66\u6210\u529f:{}", (Object)Base64.decode((String)certP7b));
        return Result.success((Object)new String(Base64.decode((String)certP7b)));
    }

    public Result getScepCert(String sn, String issuerDn) {
        this.logger.info("scep\u67e5\u8be2\u8bc1\u4e66 sn:{}, issuerDn:{}", (Object)sn, (Object)issuerDn);
        Long id = this.userCertDao.getUserId(sn);
        if (null == id) {
            this.logger.error("sn\u4e0d\u5b58\u5728\uff01");
            return Result.failure((ErrorEnum)ErrorEnum.SCEP_CERT_SN_NOT_EXIST);
        }
        BaseUserDO baseUserInfo = this.baseUserDao.getBaseUserInfo(id.longValue(), "SCEP");
        if (null == baseUserInfo) {
            this.logger.error("sn\u5bf9\u5e94\u8bc1\u4e66\u975eSCEP\u8bbe\u5907\uff01");
            return Result.failure((ErrorEnum)ErrorEnum.SCEP_CERT_SN_NOT_EXIST);
        }
        Result result = this.caBusinessManager.downloadCertDataInfo(sn, true);
        this.logger.info("\u67e5\u8be2\u6ce8\u518c\u8bc1\u4e66\u6210\u529f\uff1a{}", result.getInfo());
        return result;
    }

    public Result pollScepCert(String transactionId, String subjectDn, String issuerDn) {
        PublicKey publicKey;
        this.logger.info("scep\u8f6e\u5faa\u67e5\u8be2\u8bc1\u4e66 subjectDn:[{}], issuerDn:[{}] transactionId:[{}]", new Object[]{subjectDn, issuerDn, transactionId});
        String applyNo = this.raSdkCache.getScepTransId(transactionId);
        if (null == applyNo) {
            this.logger.error("\u6839\u636etransactionId\u627e\u4e0d\u5230applyNo\uff01");
            return Result.failure((ErrorEnum)ErrorEnum.SCEP_TRANSACTION_ID_ERROR);
        }
        String publicKeyString = this.raSdkCache.getScepPublicKey(applyNo);
        try {
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)Base64.decode((String)publicKeyString));
            publicKey = converter.getPublicKey(subjectPublicKeyInfo);
        }
        catch (Exception e) {
            this.logger.error("\u8f6c\u6362\u516c\u94a5\u4fe1\u606f\u5931\u8d25\uff01", (Throwable)e);
            return Result.failure((ErrorEnum)ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
        }
        if (null == publicKey) {
            this.logger.error("\u7f13\u5b58\u516c\u94a5\u4fe1\u606f\u4e22\u5931\uff01");
            return Result.failure((ErrorEnum)ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
        }
        boolean isIssuer = false;
        X509Certificate[] caCert = CommonVariable.getSuperCaCerts();
        for (int i = 0; i < caCert.length; ++i) {
            X509Certificate x509Certificate = caCert[i];
            String caIssuerDN = CertUtils.getSubjectByX509Cert((X509Certificate)x509Certificate);
            if (!issuerDn.equalsIgnoreCase(caIssuerDN)) continue;
            isIssuer = true;
        }
        if (!isIssuer) {
            this.logger.error("issuerDn\u4e0d\u5b58\u5728\uff01");
            return Result.failure((ErrorEnum)ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
        }
        CertApplyDO certApplyDO = this.certApplyDao.getCertApplyInfo(applyNo);
        Integer applyStatus = certApplyDO.getApplyStatus();
        IssueApplyDTO issueApplyDTO = this.issueApplyDao.getIssueApplyInfoByApplyNo(applyNo);
        issueApplyDTO.setApplyNo(applyNo);
        if (3 == applyStatus) {
            Result issueResult = this.certApplyService.issueCert("SCEP", issueApplyDTO, publicKey.getEncoded(), certApplyDO.getAdminCertDn());
            if (!issueResult.isSuccess()) {
                this.logger.error("scep\u7b7e\u53d1\u5236\u8bc1\u5931\u8d25:{}", (Object)issueResult.getErrorBean().getErrMsg());
                return issueResult;
            }
            Result ackResult = this.certApplyService.issueUserCertRespScep(applyNo, certApplyDO.getAdminCertDn());
            if (!ackResult.isSuccess()) {
                this.logger.error("scep\u7b7e\u53d1\u786e\u8ba4\u5931\u8d25:{}", (Object)ackResult.getErrorBean().getErrMsg());
                return ackResult;
            }
            this.raSdkCache.removeScepTransId(transactionId);
            this.raSdkCache.removeScepPublicKey(applyNo);
            return issueResult;
        }
        if (1 == applyStatus) {
            return Result.success();
        }
        return Result.failure((ErrorEnum)ErrorEnum.SCEP_ISSUE_CERT_END);
    }
}

