/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.scep;

import com.xdja.pki.ra.cache.CertTempCache;
import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.config.Config;
import com.xdja.pki.ra.core.exception.DAOException;
import com.xdja.pki.ra.core.exception.ServiceException;
import com.xdja.pki.ra.core.util.file.HexUtils;
import com.xdja.pki.ra.manager.dao.ScepDeviceDAO;
import com.xdja.pki.ra.manager.dao.model.CertTempDO;
import com.xdja.pki.ra.manager.dao.model.ScepDeviceDO;
import com.xdja.pki.ra.manager.page.PageInfo;
import com.xdja.pki.ra.service.manager.scep.ScepDeviceService;
import com.xdja.pki.ra.service.manager.scep.bean.ScepDeviceResp;
import com.xdja.pki.ra.service.manager.scep.bean.ScepDeviceVO;
import com.xdja.pki.ra.service.manager.scep.bean.ScepTemplateVO;
import com.xdja.pki.ra.service.manager.system.SystemService;
import com.xdja.pki.ra.service.manager.utils.ParmsCommonVerifyUtil;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ScepDeviceServiceImpl
implements ScepDeviceService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ScepDeviceDAO scepDeviceDAO;
    @Autowired
    CertTempCache certTempCache;
    @Autowired
    SystemService systemService;

    public Result registerScepInfo(ScepDeviceVO scepDeviceVO) {
        boolean isMobile;
        boolean isIpv4;
        String scepIp = scepDeviceVO.getScepIp();
        if (StringUtils.isNotBlank((CharSequence)scepIp) && !(isIpv4 = ParmsCommonVerifyUtil.isIpv4(scepIp))) {
            this.logger.error("IP\u5730\u5740\u683c\u5f0f\u9519\u8bef\uff01");
            return Result.failure((ErrorEnum)ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
        }
        String scepContact = scepDeviceVO.getScepContact();
        if (StringUtils.isNotBlank((CharSequence)scepContact) && !(isMobile = ParmsCommonVerifyUtil.isMobile(scepContact))) {
            this.logger.error("\u8054\u7cfb\u65b9\u5f0f\u683c\u5f0f\u9519\u8bef\uff01");
            return Result.failure((ErrorEnum)ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
        }
        int i = this.scepDeviceDAO.verifyScepName(scepDeviceVO.getScepName());
        if (i != 0) {
            return Result.failure((ErrorEnum)ErrorEnum.SCEP_DEVICE_NAME_HAS_EXISTED);
        }
        ScepDeviceDO scepDeviceDO = new ScepDeviceDO();
        BeanUtils.copyProperties((Object)scepDeviceVO, (Object)scepDeviceDO);
        Date date = new Date(System.currentTimeMillis());
        scepDeviceDO.setGmtCreate(date);
        scepDeviceDO.setGmtUpdate(date);
        byte[] challenge = new byte[4];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(challenge);
        String scepChallenge = HexUtils.bytesToHexFun1((byte[])challenge);
        scepDeviceDO.setScepChallenge(scepChallenge);
        this.scepDeviceDAO.insertScepDevice(scepDeviceDO);
        return Result.success();
    }

    public Result getScepInfo(Long id) {
        ScepDeviceDO scepDeviceById = this.scepDeviceDAO.getScepDeviceById(id);
        return Result.success((Object)scepDeviceById);
    }

    public Result verifyScepDeviceName(String systemName) {
        int i = this.scepDeviceDAO.verifyScepName(systemName);
        if (i != 0) {
            return Result.failure((ErrorEnum)ErrorEnum.SCEP_DEVICE_NAME_HAS_EXISTED);
        }
        return Result.success();
    }

    public Result getScepDeviceList(String scepName, String scepChallenge, Integer pageSize, Integer pageNo) {
        Result result = new Result();
        ScepDeviceResp scepDeviceResp = new ScepDeviceResp();
        ArrayList<ScepDeviceVO> scepDeviceVOS = new ArrayList<ScepDeviceVO>();
        PageInfo scepDeviceList = this.scepDeviceDAO.getScepDeviceList(scepName, scepChallenge, pageSize, pageNo);
        List scepDeviceDOS = scepDeviceList.getList();
        if (CollectionUtils.isEmpty((Collection)scepDeviceDOS)) {
            scepDeviceResp.setRecordCount(0);
            scepDeviceResp.setPageCount(0);
            scepDeviceResp.setDatas(scepDeviceDOS);
            result.setInfo((Object)scepDeviceResp);
            return result;
        }
        for (ScepDeviceDO scepDeviceDO : scepDeviceDOS) {
            ScepDeviceVO scepDeviceVO = new ScepDeviceVO();
            BeanUtils.copyProperties((Object)scepDeviceDO, (Object)scepDeviceVO);
            Date gmtCreate = scepDeviceDO.getGmtCreate();
            scepDeviceVO.setId(Integer.valueOf((int)scepDeviceDO.getId()));
            scepDeviceVO.setGmtCreate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(gmtCreate));
            scepDeviceVOS.add(scepDeviceVO);
        }
        scepDeviceResp.setDatas(scepDeviceVOS);
        scepDeviceResp.setPageCount(scepDeviceList.getPageCount());
        scepDeviceResp.setRecordCount(scepDeviceList.getRecordCount());
        result.setInfo((Object)scepDeviceResp);
        return result;
    }

    public Result getScepTemplateById(Long id) {
        ScepDeviceDO scepDeviceDO = this.scepDeviceDAO.getScepDeviceById(id);
        return this.getScepTemplateByTemp(scepDeviceDO.getTempNo());
    }

    public Result getScepTemplateInner() {
        Config config = null;
        try {
            config = this.systemService.getConfigFile("config.json");
        }
        catch (Exception e) {
            throw new ServiceException("\u67e5\u8be2\u9ed8\u8ba4\u6a21\u677f\u7f16\u53f7\u83b7\u53d6\u5f02\u5e38", (Throwable)e);
        }
        String scepTempNo = config.getScepTempNo();
        return this.getScepTemplateByTemp(scepTempNo);
    }

    public Result getScepTemplateByTemp(String tempNo) {
        ArrayList<ScepTemplateVO> ScepTemplateVOList = new ArrayList<ScepTemplateVO>();
        List allNewCertTemplateList = null;
        try {
            allNewCertTemplateList = this.certTempCache.getAllNewCertTemplateList();
        }
        catch (DAOException e) {
            throw new ServiceException("\u67e5\u8be2\u7cfb\u7edf\u6388\u6743\u6a21\u677f\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
        if (null != allNewCertTemplateList && !allNewCertTemplateList.isEmpty()) {
            for (CertTempDO certTempDO : allNewCertTemplateList) {
                ScepTemplateVO scepTemplateVO = new ScepTemplateVO();
                scepTemplateVO.setId(certTempDO.getId());
                scepTemplateVO.setTempNo(certTempDO.getTempNo());
                scepTemplateVO.setName(certTempDO.getTempName());
                scepTemplateVO.setStatus(certTempDO.getTempStatus());
                int status = certTempDO.getTempStatus();
                boolean isNotCancel = true;
                if (status == 3) {
                    isNotCancel = false;
                }
                if (null != tempNo && tempNo.equals(certTempDO.getTempNo())) {
                    scepTemplateVO.setBound(Boolean.valueOf(true));
                    isNotCancel = true;
                }
                if (!isNotCancel) continue;
                ScepTemplateVOList.add(scepTemplateVO);
            }
        }
        return Result.success(ScepTemplateVOList);
    }

    public Result saveScepTemplate(Long id, String tempNo) {
        ScepDeviceDO scepDeviceById;
        Result result = new Result();
        try {
            scepDeviceById = this.scepDeviceDAO.getScepDeviceById(id);
            Date date = new Date(System.currentTimeMillis());
            this.scepDeviceDAO.updateScepTempById(id, tempNo, date);
        }
        catch (DAOException e) {
            throw new ServiceException("\u4fdd\u5b58SCEP\u6388\u6743\u6a21\u677f\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
        result.setLogContent("\uff0c\u7cfb\u7edf\u540d\u79f0=" + scepDeviceById.getScepName() + "\uff0c\u6a21\u677f\u7f16\u53f7=" + tempNo);
        return result;
    }

    public Result saveScepInnerTemplate(String tempNo) {
        try {
            Config config = this.systemService.getConfigFile("config.json");
            config.setScepTempNo(tempNo);
            this.systemService.updateConfigFile(config);
            CommonVariable.setConfig((Config)config);
        }
        catch (Exception e) {
            throw new ServiceException("\u4fdd\u5b58\u9ed8\u8ba4\u6a21\u677f\u7f16\u53f7\u5230\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
        return Result.success();
    }

    public Result updateScepDeviceTempNo(HashSet tempNoHashSet) {
        try {
            Config config = this.systemService.getConfigFile("config.json");
            String tempNo = config.getScepTempNo();
            if (tempNoHashSet.contains(tempNo)) {
                config.setScepTempNo(null);
                this.systemService.updateConfigFile(config);
                CommonVariable.setConfig((Config)config);
            }
            List scepDeviceDOS = this.scepDeviceDAO.listScepDevices();
            for (ScepDeviceDO scepDeviceDO : scepDeviceDOS) {
                if (!tempNoHashSet.contains(tempNo)) continue;
                Date date = new Date(System.currentTimeMillis());
                this.scepDeviceDAO.updateScepTempById(Long.valueOf(scepDeviceDO.getId()), null, date);
            }
        }
        catch (Exception e) {
            throw new ServiceException("\u66f4\u65b0SCEP\u6a21\u677f\u7f16\u53f7\u4e3a\u7a7a\u5230\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
        return Result.success();
    }
}

