/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.statistics;

import com.xdja.pki.ra.manager.dao.CertTempDao;
import com.xdja.pki.ra.manager.dao.StatisticsDao;
import com.xdja.pki.ra.manager.dao.model.CertTempDO;
import com.xdja.pki.ra.manager.dto.StatisticsCertDTO;
import com.xdja.pki.ra.manager.dto.StatisticsCustomerDTO;
import com.xdja.pki.ra.manager.dto.StatisticsUserDTO;
import com.xdja.pki.ra.service.manager.statistics.StatisticsService;
import com.xdja.pki.ra.service.manager.statistics.bean.CertTemplateVO;
import com.xdja.pki.ra.service.manager.statistics.bean.StatisticsCertVO;
import com.xdja.pki.ra.service.manager.statistics.bean.StatisticsCustomerVO;
import com.xdja.pki.ra.service.manager.statistics.bean.StatisticsUserVO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StatisticsServiceImpl
implements StatisticsService {
    @Autowired
    StatisticsDao certCountDao;
    @Autowired
    CertTempDao certTempDao;

    public List<StatisticsCustomerVO> getCustomerCertStatistics(String customerSysName, String startTime, String endTime) {
        List customerCertCountList = this.certCountDao.getCustomerCertCount(customerSysName, startTime, endTime);
        ArrayList<StatisticsCustomerVO> voList = new ArrayList<StatisticsCustomerVO>();
        for (StatisticsCustomerDTO statisticsCustomerDTO : customerCertCountList) {
            StatisticsCustomerVO vo = new StatisticsCustomerVO();
            vo.setCustomerSysName(statisticsCustomerDTO.getCustomerSysName());
            if (!"SCEP".equals(statisticsCustomerDTO.getCustomerSysName())) {
                vo.setCustomerSysNumber(statisticsCustomerDTO.getCustomerSysNumber());
            }
            vo.setNormal(statisticsCustomerDTO.getNormal());
            vo.setExpire(statisticsCustomerDTO.getOutdate());
            vo.setRevoke(statisticsCustomerDTO.getRevoked());
            vo.setFreeze(statisticsCustomerDTO.getFreeze());
            vo.setTotal(statisticsCustomerDTO.getTotal());
            voList.add(vo);
        }
        return voList;
    }

    public List<StatisticsCertVO> getCertStatistics(String certTemplateName, String startTime, String endTime) {
        List dtoList = this.certCountDao.getCertCount(certTemplateName, startTime, endTime);
        ArrayList<StatisticsCertVO> voList = new ArrayList<StatisticsCertVO>();
        for (StatisticsCertDTO statisticsCertDTO : dtoList) {
            StatisticsCertVO vo = new StatisticsCertVO();
            vo.setCertTemplateName(statisticsCertDTO.getTempName());
            vo.setNormal(statisticsCertDTO.getNormal());
            vo.setExpire(statisticsCertDTO.getOutdate());
            vo.setFreeze(statisticsCertDTO.getFreeze());
            vo.setRevoke(statisticsCertDTO.getRevoked());
            vo.setTotal(statisticsCertDTO.getTotal());
            voList.add(vo);
        }
        return voList;
    }

    public List<StatisticsUserVO> getUserStatistics(String startTime, String endTime) {
        List dtoList = this.certCountDao.getUserCount(startTime, endTime);
        ArrayList<StatisticsUserVO> voList = new ArrayList<StatisticsUserVO>();
        int normalCount = 0;
        int disabledCount = 0;
        int totalCount = 0;
        for (int i = 0; i < dtoList.size(); ++i) {
            StatisticsUserVO userVO = new StatisticsUserVO();
            userVO.setType(((StatisticsUserDTO)dtoList.get(i)).getTypeString());
            userVO.setNormal(((StatisticsUserDTO)dtoList.get(i)).getNormal());
            userVO.setDisabled(((StatisticsUserDTO)dtoList.get(i)).getDisabled());
            userVO.setTotal(((StatisticsUserDTO)dtoList.get(i)).getTotal());
            normalCount += ((StatisticsUserDTO)dtoList.get(i)).getNormal();
            disabledCount += ((StatisticsUserDTO)dtoList.get(i)).getDisabled();
            totalCount += ((StatisticsUserDTO)dtoList.get(i)).getTotal();
            voList.add(userVO);
        }
        StatisticsUserVO userVO = new StatisticsUserVO();
        userVO.setType("\u5408\u8ba1");
        userVO.setNormal(normalCount);
        userVO.setDisabled(disabledCount);
        userVO.setTotal(totalCount);
        voList.add(userVO);
        return voList;
    }

    public List<CertTemplateVO> getCertTemplate() {
        List templateList = this.certCountDao.getTemplate();
        ArrayList<CertTemplateVO> list = new ArrayList<CertTemplateVO>();
        for (CertTempDO templateDO : templateList) {
            CertTemplateVO vo = new CertTemplateVO();
            vo.setTempNo(templateDO.getTempNo());
            vo.setTemplateName(templateDO.getTempName());
            list.add(vo);
        }
        return list;
    }
}

