/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.system;

import com.xdja.ca.asn1.NISTObjectIdentifiers;
import com.xdja.ca.asn1.RsaObjectIdentifiers;
import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.config.CaServerConf;
import com.xdja.pki.ra.core.config.Config;
import com.xdja.pki.ra.core.constant.PathConstants;
import com.xdja.pki.ra.core.pkcs7.SignedDataUtils;
import com.xdja.pki.ra.core.util.cert.CertUtils;
import com.xdja.pki.ra.core.util.cert.VerifyCert;
import com.xdja.pki.ra.core.util.file.FileUtils;
import com.xdja.pki.ra.manager.dao.CaCertDao;
import com.xdja.pki.ra.manager.dao.CaServerDao;
import com.xdja.pki.ra.manager.dao.InitDao;
import com.xdja.pki.ra.manager.dao.model.CaCertDO;
import com.xdja.pki.ra.manager.sdk.business.CaBusinessManager;
import com.xdja.pki.ra.service.manager.init.InitService;
import com.xdja.pki.ra.service.manager.system.CaService;
import com.xdja.pki.ra.service.manager.system.SystemService;
import com.xdja.pki.ra.service.manager.system.bean.CaCertInfo;
import com.xdja.pki.ra.service.manager.utils.ParmsCommonVerifyUtil;
import java.security.cert.X509Certificate;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CaServiceImpl
implements CaService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    CaServerDao caServerDao;
    @Autowired
    InitDao initDao;
    @Autowired
    InitService initService;
    @Autowired
    CaCertDao caCertDao;
    @Autowired
    SystemService systemService;
    @Autowired
    CaBusinessManager caBusinessManager;

    public Result configCaServer(MultipartFile file, String caServerIp, int caServerPort) {
        Result result = this.caBusinessManager.testCaServerConnect(file, caServerIp, caServerPort);
        if (!result.isSuccess()) {
            this.logger.error("\u6d4b\u8bd5CA\u8fde\u901a\u6027\u5931\u8d25");
            return result;
        }
        Result stepResult = this.initService.getOperateStep();
        this.logger.info("\u5f53\u524d\u521d\u59cb\u5316\u6b65\u9aa4\u4e3a========" + stepResult.getInfo());
        if (!stepResult.getInfo().equals(1)) {
            this.logger.info("\u521d\u59cb\u5316\u6b65\u9aa4\u6570\u9519\u8bef");
            result.setError(ErrorEnum.INIT_STEP_ERROR);
            return result;
        }
        Result updateCAResult = this.updateConfigCaInfo(file, caServerIp, caServerPort, false);
        if (!updateCAResult.isSuccess()) {
            return updateCAResult;
        }
        return this.initService.updateInitStep(2);
    }

    public Result updateLessCAServer(String caServerIp, int caServerPort) {
        Result result = new Result();
        boolean isIpv4 = ParmsCommonVerifyUtil.isIpv4(caServerIp);
        if (!isIpv4) {
            this.logger.error("IP\u5730\u5740\u683c\u5f0f\u9519\u8bef\uff01");
            return Result.failure((ErrorEnum)ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
        }
        try {
            Config config = this.systemService.getConfigFile("config.json");
            CaServerConf caServerConf = config.getCaServerConf();
            caServerConf.setCaServerIp(caServerIp);
            caServerConf.setCaServerPort(caServerPort);
            this.systemService.updateConfigFile(config);
        }
        catch (Exception e) {
            this.logger.error("\u914d\u7f6eCA\u670d\u52a1\u64cd\u4f5cconfig.json\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
        CommonVariable.setCaServiceIp((String)caServerIp);
        CommonVariable.setCaServicePort((int)caServerPort);
        return result;
    }

    public Result updateConfigCaServer(MultipartFile file, String caServerIp, int caServerPort) {
        Result result = this.caBusinessManager.testCaServerConnect(file, caServerIp, caServerPort);
        if (!result.isSuccess()) {
            this.logger.error("\u6d4b\u8bd5CA\u8fde\u901a\u6027\u5931\u8d25");
            return result;
        }
        return this.updateConfigCaInfo(file, caServerIp, caServerPort, true);
    }

    public Result updateConfigCaInfo(MultipartFile file, String caServerIp, int caServerPort, boolean isUpdate) {
        String keyAlg;
        Config config;
        Result result = new Result();
        boolean isIpv4 = ParmsCommonVerifyUtil.isIpv4(caServerIp);
        if (!isIpv4) {
            this.logger.error("IP\u5730\u5740\u683c\u5f0f\u9519\u8bef\uff01");
            return Result.failure((ErrorEnum)ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
        }
        String trustCertName = file.getOriginalFilename();
        String fileName = trustCertName.substring(trustCertName.lastIndexOf("\\") + 1);
        try {
            config = this.systemService.getConfigFile("config.json");
            CaServerConf caServerConf = config.getCaServerConf();
            if (null == caServerConf) {
                caServerConf = new CaServerConf();
            }
            caServerConf.setCaServerIp(caServerIp);
            caServerConf.setCaServerPort(caServerPort);
            caServerConf.setTrustCertName(fileName);
            config.setCaServerConf(caServerConf);
        }
        catch (Exception e) {
            this.logger.error("\u914d\u7f6eCA\u670d\u52a1\u64cd\u4f5cconfig.json\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
        byte[] fileBytes = new byte[]{};
        try {
            fileBytes = file.getBytes();
        }
        catch (Exception e) {
            this.logger.info("\u6587\u4ef6\u8f6c\u6362bytes\u5f02\u5e38");
            result.setError(ErrorEnum.FILE_TO_BYTES_ERROR);
            return result;
        }
        Result verifyResult = VerifyCert.verifyP7bCertList((byte[])fileBytes);
        if (!verifyResult.isSuccess()) {
            result.setError(verifyResult.getError());
            return result;
        }
        List certs = null;
        try {
            certs = SignedDataUtils.resolveCertChain((byte[])fileBytes);
        }
        catch (Exception e) {
            this.logger.error("\u914d\u7f6eCA\u670d\u52a1\u89e3\u6790\u8bc1\u4e66\u94fe\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CONVERT_CERT_ERROR);
            return result;
        }
        String p7bContent = null;
        try {
            p7bContent = new String(fileBytes);
        }
        catch (Exception e) {
            this.logger.error("\u914d\u7f6eCA\u670d\u52a1\u8bfb\u53d6\u8bc1\u4e66\u94febase64\u503c\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CERT_P7B_INFO_READ_ERROR);
            return result;
        }
        X509Certificate cert = (X509Certificate)certs.get(0);
        String certPem = null;
        try {
            certPem = CertUtils.writeObject((Object)cert);
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u53d6CA\u670d\u52a1\u8bc1\u4e66pem\u503c\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CERT_SERVER_INFO_READ_ERROR);
            return result;
        }
        try {
            keyAlg = CertUtils.getKeyAlg((X509Certificate)cert);
            if (2 == CommonVariable.getIsHsm() && "NISTP256".equalsIgnoreCase(keyAlg)) {
                this.logger.error("\u4e09\u672a\u4fe1\u5b89\u5bc6\u7801\u673a\u4e0d\u652f\u6301NIST256\u7b97\u6cd5");
                result.setError(ErrorEnum.SWXA_HSM_NOT_SUPPORT_NIST);
                return result;
            }
            this.logger.info("=============CommonVariable.getKeyAlgName()" + CommonVariable.getKeyAlgName());
            this.logger.info("=============certInfo.getKeyAlg()" + keyAlg);
            if (isUpdate && !CommonVariable.getKeyAlgName().equalsIgnoreCase(keyAlg)) {
                this.logger.info("\u5bfc\u5165CA\u8bc1\u4e66\u79d8\u94a5\u7b97\u6cd5\u548c\u539f\u7cfb\u7edf\u4e0d\u4e00\u81f4");
                result.setError(ErrorEnum.CA_ALGORITHM_IS_NOT_SAME_OLD);
                return result;
            }
            config.setKeyAlgName(keyAlg);
            this.systemService.updateConfigFile(config);
        }
        catch (Exception e) {
            this.logger.error("\u79d8\u94a5\u7b97\u6cd5\u5199\u5230\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
        try {
            FileUtils.saveFile((String)certPem, (String)PathConstants.CA_SERVICE_CERT_FILE_PATH);
        }
        catch (Exception e) {
            this.logger.info("\u8bc1\u4e66\u4fdd\u5b58\u5728\u6307\u5b9a\u8def\u5f84\u4e2d\u9519\u8bef", (Throwable)e);
            result.setInfo((Object)ErrorEnum.SAVE_CA_CERT_IS_ERROR);
            return result;
        }
        String date = new SimpleDateFormat("yyyyMMddHHmmss").format(Calendar.getInstance().getTime());
        try {
            String path = PathConstants.SUPER_CA_CERTS_FILE_PATH + "/caCert-" + date + ".cer";
            FileUtils.saveFile((String)certPem, (String)path);
        }
        catch (Exception e) {
            this.logger.info("\u8bc1\u4e66\u4fdd\u5b58\u5728\u6307\u5b9a\u8def\u5f84\u4e2d\u9519\u8bef", (Throwable)e);
            result.setInfo((Object)ErrorEnum.SAVE_CA_CERT_IS_ERROR);
            return result;
        }
        try {
            FileUtils.saveFile((String)p7bContent, (String)PathConstants.CA_TRUST_SERVICE_CERT_FILE_PATH);
        }
        catch (Exception e) {
            this.logger.info("\u8bc1\u4e66\u94fe\u4fdd\u5b58\u5728\u6307\u5b9a\u8def\u5f84\u4e2d\u9519\u8bef", (Throwable)e);
            result.setInfo((Object)ErrorEnum.SAVE_CA_CERT_IS_ERROR);
            return result;
        }
        CaCertDO caCertDO = new CaCertDO();
        caCertDO.setCertDn(CertUtils.getSubjectByX509Cert((X509Certificate)cert));
        caCertDO.setCertSn(cert.getSerialNumber().toString(16).toLowerCase());
        caCertDO.setPublicKeyAlg(keyAlg);
        int publicKeyLength = 0;
        try {
            publicKeyLength = CertUtils.getPublicKeyLength((X509Certificate)cert);
            caCertDO.setPrivateKeyLength(Integer.valueOf(publicKeyLength));
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u8bc1\u4e66\u516c\u94a5\u957f\u5ea6\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.GET_CERT_PUBLIC_KEY_LENGTH_EXCEPTION);
            return result;
        }
        caCertDO.setSignAlg(cert.getSigAlgName());
        caCertDO.setCertInfo(certPem);
        caCertDO.setCertP7b(p7bContent);
        caCertDO.setEffectiveTime(new Timestamp(cert.getNotBefore().getTime()));
        caCertDO.setFailureTime(new Timestamp(cert.getNotAfter().getTime()));
        caCertDO.setGmtCreate(new Timestamp(System.currentTimeMillis()));
        caCertDO.setGmtUpdate(new Timestamp(System.currentTimeMillis()));
        try {
            this.caServerDao.insertCaCertInfo(caCertDO);
        }
        catch (Exception e) {
            this.logger.error("CA\u57fa\u672c\u4fe1\u606f\u5b58ca_cert\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.INSERT_CA_CERT_INFO_ERROR);
            return result;
        }
        CommonVariable.setCaServiceIp((String)caServerIp);
        CommonVariable.setCaServicePort((int)caServerPort);
        CommonVariable.setCaServiceCert((X509Certificate)cert);
        CommonVariable.setKeyAlgName((String)keyAlg);
        CommonVariable.setTrustCaCerts(null);
        CommonVariable.setCaCerts(null);
        return result;
    }

    public Result getVerifyCaCertInfo(MultipartFile file, boolean isUpdate) {
        Result result = new Result();
        byte[] fileBytes = new byte[]{};
        try {
            fileBytes = file.getBytes();
        }
        catch (Exception e) {
            this.logger.info("\u6587\u4ef6\u8f6c\u6362bytes\u5f02\u5e38");
            result.setError(ErrorEnum.FILE_TO_BYTES_ERROR);
            return result;
        }
        Result verifyResult = VerifyCert.verifyP7bCertList((byte[])fileBytes);
        if (!verifyResult.isSuccess()) {
            result.setError(verifyResult.getError());
            return result;
        }
        List certs = null;
        try {
            certs = SignedDataUtils.resolveCertChain((byte[])fileBytes);
        }
        catch (Exception e) {
            this.logger.error("\u914d\u7f6eCA\u670d\u52a1\u89e3\u6790\u8bc1\u4e66\u94fe\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CONVERT_CERT_ERROR);
            return result;
        }
        X509Certificate cert = (X509Certificate)certs.get(0);
        try {
            String keyAlg = CertUtils.getKeyAlg((X509Certificate)cert);
            this.logger.info("=============CommonVariable.getKeyAlgName()" + CommonVariable.getKeyAlgName());
            this.logger.info("=============certInfo.getKeyAlg()" + keyAlg);
            if (isUpdate && !CommonVariable.getKeyAlgName().equalsIgnoreCase(keyAlg)) {
                this.logger.info("\u5bfc\u5165CA\u8bc1\u4e66\u79d8\u94a5\u7b97\u6cd5\u548c\u539f\u7cfb\u7edf\u4e0d\u4e00\u81f4");
                result.setError(ErrorEnum.CA_ALGORITHM_IS_NOT_SAME_OLD);
                return result;
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u8bc1\u4e66\u5bc6\u94a5\u7b97\u6cd5\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.GET_CERT_ALG_NAME_LENGTH_EXCEPTION);
            return result;
        }
        CaCertInfo caCertInfo = this.getCAInfo(cert);
        result.setInfo((Object)caCertInfo);
        return result;
    }

    public Result getCaConfigInfo() {
        Result result = new Result();
        Config config = null;
        try {
            config = this.systemService.getConfigFile("config.json");
        }
        catch (Exception e) {
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
        CaServerConf caServerConf = config.getCaServerConf();
        if (null == caServerConf) {
            this.logger.error("\u83b7\u53d6CA\u670d\u52a1\u8be6\u60c5\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_CA_SERVER_INFO_IS_EMPTY);
            return result;
        }
        X509Certificate caCert = CommonVariable.getCaServiceCert();
        CaCertInfo caCertInfo = this.getCAInfo(caCert);
        caCertInfo.setCaServerConf(caServerConf);
        result.setInfo((Object)caCertInfo);
        return result;
    }

    private CaCertInfo getCAInfo(X509Certificate caCert) {
        String SIGN_ALGO_SM3WITHSM2 = "SM3WithSM2";
        String SIGN_ALGO_SHA256WithECDSA = "sha256WithECDSA";
        String SIGN_ALGO_SHA256WithRSA = "sha256WithRSA";
        String SIGN_ALGO_SHA1WithRSA = "sha-1WithRSA";
        String certDn = CertUtils.getSubjectByX509Cert((X509Certificate)caCert);
        String sigAlgOID = caCert.getSigAlgOID();
        String sigAlgName = caCert.getSigAlgName();
        String sm3withsm2OID = GMObjectIdentifiers.sm2sign_with_sm3.getId();
        if (sigAlgOID.equals(sm3withsm2OID)) {
            sigAlgName = SIGN_ALGO_SM3WITHSM2;
        }
        if (sigAlgOID.equals(NISTObjectIdentifiers.nistSignAlgorithm.getId())) {
            sigAlgName = SIGN_ALGO_SHA256WithECDSA;
        }
        if (sigAlgOID.equals(RsaObjectIdentifiers.sha256WithRSA.getId())) {
            sigAlgName = SIGN_ALGO_SHA256WithRSA;
        }
        if (sigAlgOID.equals(RsaObjectIdentifiers.sha1WithRSA.getId())) {
            sigAlgName = SIGN_ALGO_SHA1WithRSA;
        }
        CaCertInfo caCertInfo = new CaCertInfo();
        caCertInfo.setCertDN(certDn);
        caCertInfo.setSignAlgName(sigAlgName);
        caCertInfo.setNotBefore(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(caCert.getNotBefore()));
        caCertInfo.setNotAfter(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(caCert.getNotAfter()));
        return caCertInfo;
    }

    public CaCertDO getCaConfigInfoByTime() {
        long id = this.caServerDao.getCaCertId();
        CaCertDO oldCaCertDO = this.caServerDao.getCaCert(id);
        return oldCaCertDO;
    }

    public Result getNewCaCertInfo() {
        Result result = new Result();
        CaCertDO newCaCertInfo = this.caCertDao.getNewCaCertInfo();
        if (newCaCertInfo == null) {
            result.setError(ErrorEnum.GET_CA_CERT_INFO_IS_EMPTY);
            return result;
        }
        result.setInfo((Object)newCaCertInfo);
        return result;
    }

    public String getCAServiceDnName() {
        CaCertDO newCaCertInfo = null;
        try {
            newCaCertInfo = this.caCertDao.getNewCaCertInfo();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6CA\u670d\u52a1\u5668\u8bc1\u4e66\u5f02\u5e38{}", (Throwable)e);
            return null;
        }
        if (newCaCertInfo == null) {
            return null;
        }
        String certInfo = newCaCertInfo.getCertInfo();
        X509Certificate certFromStr = CertUtils.getCertFromStr((String)certInfo);
        String caServiceDnName = CertUtils.getSubjectByX509Cert((X509Certificate)certFromStr);
        return caServiceDnName;
    }
}

