/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.system;

import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.sdf.yunhsm.utils.GMSSLSancHsmUtils;
import com.xdja.pki.gmssl.sdf.yunhsm.utils.GMSSLYunHsmUtils;
import com.xdja.pki.gmssl.x509.utils.bean.SancHsmInfoEntry;
import com.xdja.pki.gmssl.x509.utils.bean.YunHsmExceptionEnum;
import com.xdja.pki.gmssl.x509.utils.bean.YunHsmInfoEntry;
import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.config.Config;
import com.xdja.pki.ra.service.manager.init.InitService;
import com.xdja.pki.ra.service.manager.system.HsmServer;
import com.xdja.pki.ra.service.manager.system.SystemService;
import com.xdja.pki.ra.service.manager.system.bean.HsmInfoVO;
import com.xdja.pki.ra.service.manager.system.bean.SancHsmInfoEntryVO;
import java.io.FileInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class HsmServerImpl
implements HsmServer {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    InitService initService;
    @Autowired
    SystemService systemService;

    public Result initHsmServer(String hsmServerIp, int hsmServerPort, String signCertPwd, String encCertPwd, MultipartFile sign, MultipartFile enc, MultipartFile certChain) {
        Result result = new Result();
        FileInputStream inputSign = null;
        FileInputStream inputEnc = null;
        FileInputStream inputCertChain = null;
        try {
            if (sign != null) {
                inputSign = (FileInputStream)sign.getInputStream();
            }
            if (enc != null) {
                inputEnc = (FileInputStream)enc.getInputStream();
            }
            if (certChain != null) {
                inputCertChain = (FileInputStream)certChain.getInputStream();
            }
        }
        catch (Exception e) {
            this.logger.info("\u6587\u4ef6\u6d41\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.HSM_SDK_SERVICE_ERROR);
            return result;
        }
        try {
            YunHsmExceptionEnum yunHsmExceptionEnum = GMSSLYunHsmUtils.initYunHsmConfigAndTestConnect((String)hsmServerIp, (int)hsmServerPort, (String)signCertPwd, (String)encCertPwd, (FileInputStream)inputSign, (FileInputStream)inputEnc, (FileInputStream)inputCertChain);
            if (YunHsmExceptionEnum.NORMAL.id != yunHsmExceptionEnum.id) {
                switch (yunHsmExceptionEnum) {
                    case TELNET_PORT_FAILURE: {
                        result.setError(ErrorEnum.TELNET_IP_FAILURE);
                        break;
                    }
                    case OPEN_DEVICE_IS_FAILURE: {
                        result.setError(ErrorEnum.TELNET_IP_FAILURE);
                        break;
                    }
                    case SIGN_PASSWORD_IS_ERROR: {
                        result.setError(ErrorEnum.SIGN_PASSWORD_IS_ERROR);
                        break;
                    }
                    case ENC_PASSWORD_IS_ERROR: {
                        result.setError(ErrorEnum.ENC_PASSWORD_IS_ERROR);
                        break;
                    }
                    case SIGN_CERT_VERIFY_IS_ERROR: {
                        result.setError(ErrorEnum.SIGN_CERT_VERIFY_IS_ERROR);
                        break;
                    }
                    case ENC_CERT_VERIFY_IS_ERROR: {
                        result.setError(ErrorEnum.ENC_CERT_VERIFY_IS_ERROR);
                        break;
                    }
                    case OPEN_TRAIN_CERT_P7b_IS_ERROR: {
                        result.setError(ErrorEnum.OPEN_TRAIN_CERT_P7b_IS_ERROR);
                        break;
                    }
                    case SIGN_CERT_KEY_USAGE_IS_ERROR: {
                        result.setError(ErrorEnum.SIGN_CERT_KEY_USAGE_IS_ERROR);
                        break;
                    }
                    case ENC_CERT_KEY_USAGE_IS_ERROR: {
                        result.setError(ErrorEnum.ENC_CERT_KEY_USAGE_IS_ERROR);
                        break;
                    }
                    default: {
                        result.setError(ErrorEnum.HSM_SDK_SERVICE_ERROR);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.info("\u5bc6\u7801\u673a\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.HSM_SDK_SERVICE_ERROR);
            return result;
        }
        try {
            Config config = this.systemService.getConfigFile("config.json");
            config.setIsHsm(Integer.valueOf(1));
            config.setInitStep(1);
            this.systemService.updateConfigFile(config);
        }
        catch (Exception e) {
            this.logger.info("\u4fee\u6539\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
        CommonVariable.setIsHsm((Integer)1);
        GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
        return result;
    }

    public Result testHsmConnect(String hsmServerIp, int hsmServerPort, String signCertPwd, String encCertPwd, MultipartFile sign, MultipartFile enc, MultipartFile certChain) {
        Result result = new Result();
        FileInputStream inputSign = null;
        FileInputStream inputEnc = null;
        FileInputStream inputCertChain = null;
        try {
            if (sign != null) {
                inputSign = (FileInputStream)sign.getInputStream();
            }
            if (enc != null) {
                inputEnc = (FileInputStream)enc.getInputStream();
            }
            if (certChain != null) {
                inputCertChain = (FileInputStream)certChain.getInputStream();
            }
        }
        catch (Exception e) {
            this.logger.info("\u6587\u4ef6\u6d41\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.HSM_SDK_SERVICE_ERROR);
            return result;
        }
        try {
            YunHsmExceptionEnum yunHsmExceptionEnum = GMSSLYunHsmUtils.testConnect((String)hsmServerIp, (int)hsmServerPort, (String)signCertPwd, (String)encCertPwd, (FileInputStream)inputSign, (FileInputStream)inputEnc, (FileInputStream)inputCertChain);
            if (YunHsmExceptionEnum.NORMAL.id != yunHsmExceptionEnum.id) {
                this.logger.info("\u6d4b\u8bd5XDJA\u5bc6\u7801\u673a\u8fde\u901a\u6027\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + yunHsmExceptionEnum.value);
                switch (yunHsmExceptionEnum) {
                    case TELNET_PORT_FAILURE: {
                        result.setError(ErrorEnum.TELNET_IP_FAILURE);
                        break;
                    }
                    case OPEN_DEVICE_IS_FAILURE: {
                        result.setError(ErrorEnum.TELNET_IP_FAILURE);
                        break;
                    }
                    case SIGN_PASSWORD_IS_ERROR: {
                        result.setError(ErrorEnum.SIGN_PASSWORD_IS_ERROR);
                        break;
                    }
                    case ENC_PASSWORD_IS_ERROR: {
                        result.setError(ErrorEnum.ENC_PASSWORD_IS_ERROR);
                        break;
                    }
                    case SIGN_CERT_VERIFY_IS_ERROR: {
                        result.setError(ErrorEnum.SIGN_CERT_VERIFY_IS_ERROR);
                        break;
                    }
                    case ENC_CERT_VERIFY_IS_ERROR: {
                        result.setError(ErrorEnum.ENC_CERT_VERIFY_IS_ERROR);
                        break;
                    }
                    case OPEN_TRAIN_CERT_P7b_IS_ERROR: {
                        result.setError(ErrorEnum.OPEN_TRAIN_CERT_P7b_IS_ERROR);
                        break;
                    }
                    case SIGN_CERT_KEY_USAGE_IS_ERROR: {
                        result.setError(ErrorEnum.SIGN_CERT_KEY_USAGE_IS_ERROR);
                        break;
                    }
                    case ENC_CERT_KEY_USAGE_IS_ERROR: {
                        result.setError(ErrorEnum.ENC_CERT_KEY_USAGE_IS_ERROR);
                        break;
                    }
                    default: {
                        result.setError(ErrorEnum.HSM_SDK_SERVICE_ERROR);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.info("\u5bc6\u7801\u673a\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.HSM_SDK_SERVICE_ERROR);
        }
        return result;
    }

    public Result testHsmConnect() {
        Result result = Result.success();
        boolean status = GMSSLYunHsmUtils.testConnect();
        if (!status) {
            result.setError(ErrorEnum.HSM_SDK_SERVICE_ERROR);
        }
        return result;
    }

    public Result isHsm() {
        Result result = new Result();
        try {
            Config config = this.systemService.getConfigFile("config.json");
            if (null == config) {
                result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
                return result;
            }
            config.setIsHsm(Integer.valueOf(0));
            CommonVariable.setIsHsm((Integer)0);
            config.setInitStep(1);
            this.systemService.updateConfigFile(config);
        }
        catch (Exception e) {
            this.logger.info("\u4fee\u6539\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
        return null;
    }

    public Result saveSwxaHsm(String hsmServerIp, int hsmServerPort, String accessPassword, boolean isInit) {
        Result result = new Result();
        YunHsmExceptionEnum yunHsmExceptionEnum = GMSSLSancHsmUtils.initConfigAndTestConnect((String)hsmServerIp, (int)hsmServerPort, (String)accessPassword, (boolean)isInit);
        if (YunHsmExceptionEnum.NORMAL.id != yunHsmExceptionEnum.id) {
            this.logger.info("\u6d4b\u8bd5SWXA\u5bc6\u7801\u673a\u8fde\u901a\u6027\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + yunHsmExceptionEnum.value);
            switch (yunHsmExceptionEnum) {
                case TELNET_PORT_FAILURE: {
                    result.setError(ErrorEnum.TELNET_IP_FAILURE);
                    break;
                }
                case OPEN_DEVICE_IS_FAILURE: {
                    result.setError(ErrorEnum.HSM_SDK_SERVICE_ERROR);
                    break;
                }
                default: {
                    result.setError(ErrorEnum.HSM_SDK_SERVICE_ERROR);
                }
            }
            return result;
        }
        try {
            Config config = this.systemService.getConfigFile("config.json");
            if (null == config) {
                result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
                return result;
            }
            config.setIsHsm(Integer.valueOf(2));
            config.setInitStep(1);
            this.systemService.updateConfigFile(config);
        }
        catch (Exception e) {
            this.logger.info("\u4fee\u6539\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
        CommonVariable.setIsHsm((Integer)2);
        try {
            GMSSLPkiCryptoInit.getSancHsmInstance();
        }
        catch (Exception e) {
            this.logger.error("\u52a0\u8f7dGMSSL\u5f02\u5e38 ", (Throwable)e);
        }
        return result;
    }

    public Result testSwxaHsmConnect(String hsmServerIp, int hsmServerPort, String accessPassword, boolean isInit) {
        Result result = new Result();
        YunHsmExceptionEnum yunHsmExceptionEnum = GMSSLSancHsmUtils.testConnect((String)hsmServerIp, (int)hsmServerPort, (String)accessPassword, (boolean)isInit);
        if (YunHsmExceptionEnum.NORMAL.id != yunHsmExceptionEnum.id) {
            this.logger.info("\u6d4b\u8bd5SWXA\u5bc6\u7801\u673a\u8fde\u901a\u6027\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + yunHsmExceptionEnum.value);
            result.setError(ErrorEnum.HSM_SDK_SERVICE_ERROR);
            return result;
        }
        return result;
    }

    public Result getHsmInfo() {
        Result result = new Result();
        HsmInfoVO hsmInfoVO = new HsmInfoVO();
        try {
            if (1 == CommonVariable.getIsHsm()) {
                YunHsmInfoEntry hsmInfo = GMSSLYunHsmUtils.getYunHsmInfo();
                hsmInfoVO.setYunHsmInfoEntry(hsmInfo);
            } else if (2 == CommonVariable.getIsHsm()) {
                SancHsmInfoEntry sancHsmInfoEntry = GMSSLSancHsmUtils.getSancDeviceInfo();
                SancHsmInfoEntryVO sancHsmInfoEntryVO = new SancHsmInfoEntryVO();
                BeanUtils.copyProperties((Object)sancHsmInfoEntry, (Object)sancHsmInfoEntryVO);
                sancHsmInfoEntryVO.setSancHsmType("\u4e09\u672a\u4fe1\u5b89\u670d\u52a1\u5668\u5bc6\u7801\u673a");
                hsmInfoVO.setSancHsmInfoEntry(sancHsmInfoEntryVO);
            }
        }
        catch (Exception e) {
            this.logger.info("\u8bfb\u53d6\u5bc6\u7801\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.HSM_GET_DETAILS_ERROR);
        }
        result.setInfo((Object)hsmInfoVO);
        return result;
    }
}

