/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.system;

import com.xdja.ca.utils.DnUtil;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSHA1DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2KeyUtils;
import com.xdja.pki.gmssl.tomcat.utils.GMSSLTomcatUtils;
import com.xdja.pki.gmssl.x509.utils.GMSSLP10Utils;
import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.config.Config;
import com.xdja.pki.ra.core.config.RaServerConfig;
import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.core.constant.PathConstants;
import com.xdja.pki.ra.core.pkcs7.SignedDataUtils;
import com.xdja.pki.ra.core.util.cert.CertDnVerifyUtils;
import com.xdja.pki.ra.core.util.cert.CertUtils;
import com.xdja.pki.ra.core.util.cert.HsmUtils;
import com.xdja.pki.ra.core.util.cert.KeyStoreUtils;
import com.xdja.pki.ra.core.util.cert.KeyUtils;
import com.xdja.pki.ra.core.util.cert.P10Utils;
import com.xdja.pki.ra.core.util.cert.VerifyCert;
import com.xdja.pki.ra.core.util.file.FileUtils;
import com.xdja.pki.ra.core.util.file.HexUtils;
import com.xdja.pki.ra.core.util.file.ZipUtils;
import com.xdja.pki.ra.manager.dao.CaCertDao;
import com.xdja.pki.ra.manager.dao.RaCertDao;
import com.xdja.pki.ra.manager.dao.model.CaCertDO;
import com.xdja.pki.ra.manager.dao.model.RaCertDO;
import com.xdja.pki.ra.manager.dto.RaServerCertDTO;
import com.xdja.pki.ra.service.manager.init.InitService;
import com.xdja.pki.ra.service.manager.init.bean.HsmResp;
import com.xdja.pki.ra.service.manager.system.RaServer;
import com.xdja.pki.ra.service.manager.system.SystemService;
import com.xdja.pki.ra.service.manager.utils.CertContentInfoUtil;
import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class RaServerImpl
implements RaServer {
    @Autowired
    CaCertDao caCertDao;
    @Autowired
    RaCertDao raCertDao;
    @Autowired
    CertContentInfoUtil certContentInfoUtil;
    @Autowired
    InitService initService;
    @Autowired
    SystemService systemService;
    private String tomcatPath = System.getProperty("catalina.home");
    @Value(value="${ra.system.https.port}")
    private String httpsPort;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public Result updateRaServerConfig(Integer keyIndex, String priKeyPwd, MultipartFile certChain, MultipartFile enc) {
        Result result = Result.success();
        int keyDex = 0;
        String priPwd = null;
        if (1 == CommonVariable.getIsHsm() && "SM2".equalsIgnoreCase(CommonVariable.getKeyAlgName())) {
            block9: {
                try {
                    Config config = this.systemService.getConfigFile("config.json");
                    RaServerConfig raServerConfig = config.getRaServerConfig();
                    if (keyIndex != null && !StringUtils.isBlank((CharSequence)priKeyPwd)) {
                        keyDex = keyIndex;
                        priPwd = priKeyPwd;
                        break block9;
                    }
                    if (keyIndex == null && StringUtils.isBlank((CharSequence)priKeyPwd)) {
                        keyDex = raServerConfig.getKeyIndex();
                        priPwd = HsmUtils.getDecrypt((String)raServerConfig.getPriKeyPwd());
                        break block9;
                    }
                    result.setError(ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
                    return result;
                }
                catch (Exception e) {
                    this.logger.info("\u67e5\u8be2\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                    result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
                    return result;
                }
            }
            result = this.raServerSaveByHsm(keyDex, priPwd, certChain, enc, Constants.SYSTEM_UPDATE_RA_TYPE);
            result.setLogContent("\uff0c\u5bc6\u94a5\u7d22\u5f15=" + keyDex + "\uff0c\u5bc6\u94a5\u8bbf\u95ee\u63a7\u5236\u7801=" + priPwd);
        } else {
            byte[] signCertChainBytes = null;
            byte[] encEncCertBytes = null;
            try {
                signCertChainBytes = certChain.getBytes();
                encEncCertBytes = enc.getBytes();
            }
            catch (IOException e) {
                this.logger.error("\u83b7\u53d6\u8f93\u5165\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
                result.setError(ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
                return result;
            }
            if (signCertChainBytes == null || encEncCertBytes == null) {
                result.setError(ErrorEnum.MISSING_REQUIRED_PARAMETERS);
                return result;
            }
            CommonVariable.getRaEncPriKey();
            CommonVariable.getEncryptKey();
            result = this.raServerSaveByBC(certChain.getOriginalFilename(), signCertChainBytes, enc.getOriginalFilename(), encEncCertBytes, Constants.SYSTEM_UPDATE_RA_TYPE);
        }
        return result;
    }

    public Result initRaServerConfig(Integer keyIndex, String priKeyPwd, MultipartFile certChain, MultipartFile enc) {
        Result result = Result.success();
        Result stepResult = this.initService.getOperateStep();
        this.logger.info("\u5f53\u524d\u521d\u59cb\u5316\u6b65\u9aa4\u4e3a:{}", stepResult.getInfo());
        if (!stepResult.getInfo().equals(2)) {
            this.logger.info("\u521d\u59cb\u5316\u6b65\u9aa4\u6570\u9519\u8bef");
            result.setError(ErrorEnum.INIT_STEP_ERROR);
            return result;
        }
        if (1 == CommonVariable.getIsHsm() && "SM2".equalsIgnoreCase(CommonVariable.getKeyAlgName())) {
            result = this.raServerSaveByHsm(keyIndex, priKeyPwd, certChain, enc, Constants.INIT_UPDATE_RA_TYPE);
        } else {
            byte[] signCertChainBytes = null;
            byte[] encEncCertBytes = null;
            try {
                signCertChainBytes = certChain.getBytes();
                encEncCertBytes = enc.getBytes();
            }
            catch (IOException e) {
                this.logger.error("\u83b7\u53d6\u8f93\u5165\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
                result.setError(ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
                return result;
            }
            if (signCertChainBytes == null || encEncCertBytes == null) {
                result.setError(ErrorEnum.MISSING_REQUIRED_PARAMETERS);
                return result;
            }
            result = this.raServerSaveByBC(certChain.getOriginalFilename(), signCertChainBytes, enc.getOriginalFilename(), encEncCertBytes, true);
        }
        return result;
    }

    public Result getRaServerCertDetails(int type) {
        Map<String, Object> certContentInfo;
        Result result = Result.success();
        RaServerCertDTO raCertInfo = null;
        try {
            raCertInfo = this.raCertDao.getNewRaCertInfo(type);
        }
        catch (Exception e) {
            this.logger.info("\u83b7\u53d6RA\u670d\u52a1\u5668\u8bc1\u4e66\u4e3a\u7a7a", (Throwable)e);
            result.setError(ErrorEnum.GET_RA_SERVER_CERT_INFO_EMPTY);
            return result;
        }
        X509Certificate cert = CertUtils.getCertFromStr((String)raCertInfo.getCertInfo());
        try {
            certContentInfo = this.certContentInfoUtil.getCertContentInfo(cert);
            byte[] digest = GMSSLSHA1DigestUtils.digest((byte[])cert.getEncoded());
            String certFingerprint = HexUtils.bytesToHexString((byte[])digest);
            certContentInfo.put("certFingerprint", certFingerprint);
        }
        catch (Exception e) {
            this.logger.info("\u8bc1\u4e66\u8be6\u60c5\u683c\u5f0f\u8bfb\u53d6\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CERT_DETAIL_FORMAT_ERROR);
            return result;
        }
        result.setInfo(certContentInfo);
        return result;
    }

    public Result getRaServerCertInfo() {
        Result result = Result.success();
        RaCertDO newRaCertInfo = null;
        try {
            newRaCertInfo = this.raCertDao.getNewRaCertInfo();
            result.setInfo((Object)newRaCertInfo);
        }
        catch (Exception e) {
            this.logger.info("\u83b7\u53d6RA\u670d\u52a1\u5668\u6700\u65b0\u7b7e\u540d\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            result.setError(ErrorEnum.GET_RA_SERVER_CERT_INFO_EMPTY);
            return result;
        }
        return result;
    }

    public Result getRaServerConfigInfo() {
        Result result = Result.success();
        RaServerConfig raServerConfig = null;
        try {
            Config config = this.systemService.getConfigFile("config.json");
            raServerConfig = config.getRaServerConfig();
        }
        catch (Exception e) {
            this.logger.info("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u9519\u8bef", (Throwable)e);
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
        result.setInfo((Object)raServerConfig);
        return result;
    }

    private Result raServerSaveByHsm(Integer keyIndex, String priKeyPwd, MultipartFile certChain, MultipartFile enc, boolean initType) {
        this.logger.info("\u901a\u8fc7\u5bc6\u7801\u673a\u9a8c\u8bc1\u5e76\u4fdd\u5b58RA\u670d\u52a1\u5668\u4fe1\u606f keyIndex:{}, priKeyPwd:{} ", (Object)keyIndex, (Object)priKeyPwd);
        Result result = Result.success();
        boolean pwdBoolean = false;
        try {
            pwdBoolean = GMSSLSM2KeyUtils.getPrivateKeyAccessRightFromYunHsm((int)keyIndex, (String)priKeyPwd);
        }
        catch (Exception e) {
            this.logger.info("\u5f02\u5e38\uff1a\u5bc6\u94a5\u8bbf\u95ee\u63a7\u5236\u7801\u9519\u8bef", (Throwable)e);
            result.setError(ErrorEnum.RA_SERVER_PRIKEYPWD_ERROR);
            return result;
        }
        if (!pwdBoolean) {
            this.logger.info("\u5bc6\u94a5\u8bbf\u95ee\u63a7\u5236\u7801\u9519\u8bef");
            result.setError(ErrorEnum.RA_SERVER_PRIKEYPWD_ERROR);
            return result;
        }
        CaCertDO newCaCertInfo = this.caCertDao.getNewCaCertInfo();
        if (newCaCertInfo == null) {
            this.logger.info("\u83b7\u53d6CA\u8bc1\u4e66\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_CA_CERT_INFO_IS_EMPTY);
            return result;
        }
        X509Certificate caRootCert = CertUtils.getCertFromStr((String)newCaCertInfo.getCertInfo());
        String encCertB64String = null;
        X509Certificate encCert = null;
        try {
            encCertB64String = CertUtils.getEncCertByEnvelopDataByHsm((int)keyIndex, (String)priKeyPwd, (MultipartFile)enc);
            encCert = CertUtils.getCertFromStr((String)encCertB64String);
        }
        catch (Exception e) {
            this.logger.info("\u89e3\u6790\u4fe1\u5c01\u5931\u8d25", (Throwable)e);
            result.setError(ErrorEnum.GET_RA_SERVER_ENC_CERT_ERROR);
            return result;
        }
        byte[] fileBytes = null;
        try {
            fileBytes = certChain.getBytes();
        }
        catch (Exception e) {
            this.logger.info("\u6587\u4ef6\u8f6c\u6362bytes\u5f02\u5e38");
            result.setError(ErrorEnum.FILE_TO_BYTES_ERROR);
            return result;
        }
        Result verifyResult = VerifyCert.verifyP7bCertList((byte[])fileBytes);
        if (!verifyResult.isSuccess()) {
            result.setError(verifyResult.getError());
            return result;
        }
        List certs = null;
        try {
            certs = SignedDataUtils.resolveCertChain((byte[])fileBytes);
            if (certs.size() < 2) {
                this.logger.error("RA\u670d\u52a1\u5668\u8bc1\u4e66\u94fe\u5927\u5c0f\u9519\u8bef");
                result.setError(ErrorEnum.CONVERT_CERT_ERROR);
                return result;
            }
        }
        catch (Exception e) {
            this.logger.error("RA\u670d\u52a1\u89e3\u6790\u8bc1\u4e66\u94fe\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CONVERT_CERT_ERROR);
            return result;
        }
        X509Certificate signCert = (X509Certificate)certs.get(0);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("RA\u7684\u7b7e\u540d\u8bc1\u4e66:{}", (Object)signCert);
        }
        certs.remove(0);
        String p7bContent = null;
        try {
            p7bContent = Base64.toBase64String((byte[])fileBytes);
        }
        catch (Exception e) {
            this.logger.error("\u914d\u7f6eRA\u670d\u52a1\u8bfb\u53d6\u8bc1\u4e66\u94febase64\u503c\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CERT_P7B_INFO_READ_ERROR);
            return result;
        }
        try {
            String signDN = CertUtils.getIssuerByX509Cert((X509Certificate)signCert);
            String encDN = CertUtils.getIssuerByX509Cert((X509Certificate)encCert);
            String caDN = CertUtils.getSubjectByX509Cert((X509Certificate)caRootCert);
            this.logger.info("signDN:{},encDN:{},caDN:{} ", new Object[]{signDN, encDN, caDN});
            if (!signDN.equals(caDN) || !encDN.equals(caDN)) {
                this.logger.info("DN\u4e0d\u4e00\u81f4\uff1a\u975e\u5f53\u524dCA\u7b7e\u53d1\u7684\u670d\u52a1\u5668\u8bc1\u4e66");
                result.setError(ErrorEnum.CERT_P7B_VERIFY_ERROR);
                return result;
            }
            PublicKey publicKey = caRootCert.getPublicKey();
            boolean signVerify = HsmUtils.verifyCertByYunHsm((X509Certificate)signCert, (PublicKey)publicKey);
            if (!signVerify) {
                this.logger.info("\u7b7e\u540d\u8bc1\u4e66\u9a8c\u7b7e\uff1a\u975e\u5f53\u524dCA\u7b7e\u53d1\u7684\u670d\u52a1\u5668\u8bc1\u4e66");
                result.setError(ErrorEnum.CERT_P7B_VERIFY_ERROR);
                return result;
            }
            boolean encVerify = HsmUtils.verifyCertByYunHsm((X509Certificate)encCert, (PublicKey)publicKey);
            if (!encVerify) {
                this.logger.info("\u52a0\u5bc6\u8bc1\u4e66\u9a8c\u7b7e\uff1a\u975e\u5f53\u524dCA\u7b7e\u53d1\u7684\u670d\u52a1\u5668\u8bc1\u4e66");
                result.setError(ErrorEnum.GET_RA_SERVER_ENC_CERT_ERROR);
                return result;
            }
        }
        catch (Exception e) {
            this.logger.info("\u5bc6\u7801\u673a\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CERT_P7B_VERIFY_ERROR);
            return result;
        }
        String signCertPem = null;
        String encCertPem = null;
        try {
            signCertPem = CertUtils.writeObject((Object)signCert);
            encCertPem = CertUtils.writeObject((Object)encCert);
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u53d6RA\u670d\u52a1\u8bc1\u4e66pem\u503c\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.READ_RA_SERVER_CERT_PEM_ERROR);
            return result;
        }
        try {
            String stringPublicKey = Base64.toBase64String((byte[])signCert.getPublicKey().getEncoded());
            PublicKey signPublicKey = null;
            try {
                signPublicKey = GMSSLSM2KeyUtils.getSignPublicKeyByYunhsm((int)keyIndex);
            }
            catch (Exception e) {
                this.logger.error("\u5bc6\u94a5\u7d22\u5f15\u9519\u8bef", (Throwable)e);
                result.setError(ErrorEnum.RA_SERVER_KEYINDEX_ERROR);
                return result;
            }
            String stringSignPublicKey = Base64.toBase64String((byte[])signPublicKey.getEncoded());
            if (!stringPublicKey.equals(stringSignPublicKey)) {
                this.logger.info("\u8bc1\u4e66\u4e2d\u7684\u516c\u94a5\u548c\u7533\u8bf7\u65f6\u7684\u516c\u94a5\u4e0d\u4e00\u81f4");
                result.setError(ErrorEnum.CERT_PUB_KEY_NOT_SAME_REQ_PUB_KEY);
                return result;
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u516c\u94a5\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.GET_PUB_KEY_INFO_EXCEPTION);
            return result;
        }
        RaCertDO raSignCertDO = new RaCertDO();
        RaCertDO raEncCertDO = new RaCertDO();
        long pairCertIndex = System.nanoTime();
        raSignCertDO.setPairCertIndex(Long.valueOf(pairCertIndex));
        raSignCertDO.setCaCertId(newCaCertInfo.getId());
        raSignCertDO.setCertDn(CertUtils.getSubjectByX509Cert((X509Certificate)signCert));
        raSignCertDO.setCertSn(signCert.getSerialNumber().toString(16).toLowerCase());
        raSignCertDO.setPublicKeyAlg(signCert.getPublicKey().getAlgorithm());
        raSignCertDO.setCertType(Integer.valueOf(2));
        try {
            int publicKeyLength = CertUtils.getPublicKeyLength((X509Certificate)signCert);
            raSignCertDO.setPrivateKeyLength(Integer.valueOf(publicKeyLength));
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u8bc1\u4e66\u516c\u94a5\u957f\u5ea6\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.GET_CERT_PUBLIC_KEY_LENGTH_EXCEPTION);
            return result;
        }
        try {
            raSignCertDO.setSignAlg(signCert.getSigAlgName());
            raSignCertDO.setHsmKeyIndex(keyIndex);
            raSignCertDO.setCertInfo(signCertPem);
            raSignCertDO.setCertP7b(p7bContent);
            raSignCertDO.setGmtCreate(new Timestamp(System.currentTimeMillis()));
            raSignCertDO.setGmtUpdate(new Timestamp(System.currentTimeMillis()));
            BeanUtils.copyProperties((Object)raSignCertDO, (Object)raEncCertDO);
            raEncCertDO.setCertP7b(null);
            raEncCertDO.setCertDn(CertUtils.getSubjectByX509Cert((X509Certificate)encCert));
            raEncCertDO.setCertSn(encCert.getSerialNumber().toString(16).toLowerCase());
            raEncCertDO.setCertType(Integer.valueOf(3));
            raEncCertDO.setSignAlg(encCert.getSigAlgName());
            raEncCertDO.setCertInfo(encCertPem);
            this.raCertDao.insertRaCertInfo(raSignCertDO);
            this.raCertDao.insertRaCertInfo(raEncCertDO);
        }
        catch (Exception e) {
            this.logger.error("RA\u670d\u52a1\u5668\u8bc1\u4e66\u5b58ra_cert\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.INSERT_RA_CERT_INFO_ERROR);
            return result;
        }
        try {
            FileUtils.saveFile((String)signCertPem, (String)PathConstants.RA_SERVICE_CERT_FILE_PATH);
        }
        catch (Exception e) {
            this.logger.info("\u8bc1\u4e66\u4fdd\u5b58\u5728\u6307\u5b9a\u8def\u5f84\u4e2d\u9519\u8bef", (Throwable)e);
            result.setError(ErrorEnum.SAVE_RA_CERT_IS_ERROR);
            return result;
        }
        try {
            GMSSLTomcatUtils.openHttpsPortByYunHsm((List)certs, (X509Certificate)signCert, (X509Certificate)encCert, (int)keyIndex, (String)priKeyPwd, (String)this.tomcatPath, (int)Integer.parseInt(this.httpsPort));
        }
        catch (Exception e) {
            this.logger.error("\u542f\u7528https\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.START_TOMCAT_HTTPS);
            return result;
        }
        try {
            RaServerConfig raServerConfig;
            Config config = this.systemService.getConfigFile("config.json");
            if (initType) {
                config.setInitStep(3);
            }
            if (null == (raServerConfig = config.getRaServerConfig())) {
                raServerConfig = new RaServerConfig();
            }
            String signCertName = certChain.getOriginalFilename();
            raServerConfig.setSignCertName(signCertName.substring(signCertName.lastIndexOf("\\") + 1));
            String encCertName = enc.getOriginalFilename();
            raServerConfig.setEncCertName(encCertName.substring(encCertName.lastIndexOf("\\") + 1));
            if (keyIndex != 0 && !StringUtils.isBlank((CharSequence)priKeyPwd)) {
                raServerConfig.setKeyIndex(keyIndex.intValue());
                raServerConfig.setPriKeyPwd(priKeyPwd);
                CommonVariable.setKeyPwd((String)priKeyPwd);
            }
            config.setRaServerConfig(raServerConfig);
            config.setSigAlgName(signCert.getSigAlgName());
            if (!initType) {
                config = HsmUtils.cryptConfigRaPwd((boolean)true, (Config)config);
            }
            this.systemService.updateConfigFile(config);
        }
        catch (Exception e) {
            this.logger.info("\u4fee\u6539\u521d\u59cb\u5316\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
        CommonVariable.setRaSingSn((String)signCert.getSerialNumber().toString(16).toLowerCase());
        CommonVariable.setKeyIndex((int)keyIndex);
        CommonVariable.setSigAlgName((String)signCert.getSigAlgName());
        return result;
    }

    private Result raServerSaveByBC(String signCertName, byte[] signCertChain, String encCertName, byte[] encEncCert, boolean initType) {
        PrivateKey signPriKey;
        X509Certificate encCert;
        PrivateKey encPriKey;
        Result result = Result.success();
        CaCertDO newCaCertInfo = this.caCertDao.getNewCaCertInfo();
        if (newCaCertInfo == null) {
            this.logger.info("\u83b7\u53d6CA\u8bc1\u4e66\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_CA_CERT_INFO_IS_EMPTY);
            return result;
        }
        X509Certificate caRootCert = CertUtils.getCertFromStr((String)newCaCertInfo.getCertInfo());
        try {
            boolean isEncPwd = false;
            if (initType) {
                isEncPwd = true;
            }
            encPriKey = KeyStoreUtils.readServerPrivateKey((boolean)false, (String)PathConstants.SOFT_ALG_FOLDER_PATH_TEMP, (boolean)isEncPwd);
            String encCertB64String = CertUtils.getDataFromEnvelopDataByBc((byte[])encPriKey.getEncoded(), (byte[])encEncCert, (String)CommonVariable.getKeyAlgName());
            encCert = CertUtils.getCertFromStr((String)encCertB64String);
            signPriKey = KeyStoreUtils.readServerPrivateKey((boolean)true, (String)PathConstants.SOFT_ALG_FOLDER_PATH_TEMP, (boolean)isEncPwd);
        }
        catch (Exception e) {
            this.logger.info("\u89e3\u6790\u4fe1\u5c01\u5931\u8d25", (Throwable)e);
            result.setError(ErrorEnum.GET_RA_SERVER_ENC_CERT_ERROR);
            return result;
        }
        Result verifyResult = VerifyCert.verifyP7bCertList((byte[])signCertChain);
        if (!verifyResult.isSuccess()) {
            result.setError(verifyResult.getError());
            return result;
        }
        List certs = null;
        try {
            certs = SignedDataUtils.resolveCertChain((byte[])signCertChain);
            if (certs.size() < 2) {
                this.logger.error("RA\u670d\u52a1\u5668\u8bc1\u4e66\u94fe\u5927\u5c0f\u9519\u8bef");
                result.setError(ErrorEnum.CONVERT_CERT_ERROR);
                return result;
            }
        }
        catch (Exception e) {
            this.logger.error("RA\u670d\u52a1\u89e3\u6790\u8bc1\u4e66\u94fe\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CONVERT_CERT_ERROR);
            return result;
        }
        X509Certificate signCert = (X509Certificate)certs.get(0);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("RA\u7684\u7b7e\u540d\u8bc1\u4e66:{}", (Object)signCert);
        }
        this.logger.info("\u622a\u53d6\u524d\u4fe1\u4efb\u94fe\u7684\u5927\u5c0f\u4e3a\uff1a{}", (Object)certs.size());
        certs.remove(0);
        this.logger.info("\u622a\u53d6\u540e\u4fe1\u4efb\u94fe\u7684\u5927\u5c0f\u4e3a\uff1a{}", (Object)certs.size());
        String p7bContent = null;
        try {
            p7bContent = Base64.toBase64String((byte[])signCertChain);
        }
        catch (Exception e) {
            this.logger.error("\u914d\u7f6eRA\u670d\u52a1\u8bfb\u53d6\u8bc1\u4e66\u94febase64\u503c\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CERT_P7B_INFO_READ_ERROR);
            return result;
        }
        try {
            String signDN = signCert.getIssuerDN().getName();
            String encDN = encCert.getIssuerDN().getName();
            String caDN = caRootCert.getSubjectDN().getName();
            this.logger.info("signDN:{},encDN:{},caDN:{} ", new Object[]{signDN, encDN, caDN});
            if (!signDN.equals(caDN) || !encDN.equals(caDN)) {
                this.logger.info("DN\u4e0d\u4e00\u81f4\uff1a\u975e\u5f53\u524dCA\u7b7e\u53d1\u7684\u670d\u52a1\u5668\u8bc1\u4e66");
                result.setError(ErrorEnum.CERT_P7B_VERIFY_ERROR);
                return result;
            }
            PublicKey publicKey = caRootCert.getPublicKey();
            boolean signVerify = HsmUtils.verifyCertByBC((String)signCert.getSigAlgName(), (PublicKey)publicKey, (byte[])signCert.getSignature(), (byte[])signCert.getTBSCertificate());
            if (!signVerify) {
                this.logger.info("\u7b7e\u540d\u8bc1\u4e66\u9a8c\u7b7e\uff1a\u975e\u5f53\u524dCA\u7b7e\u53d1\u7684\u670d\u52a1\u5668\u8bc1\u4e66");
                result.setError(ErrorEnum.CERT_P7B_VERIFY_ERROR);
                return result;
            }
            boolean encVerify = HsmUtils.verifyCertByBC((String)encCert.getSigAlgName(), (PublicKey)publicKey, (byte[])encCert.getSignature(), (byte[])encCert.getTBSCertificate());
            if (!encVerify) {
                this.logger.info("\u52a0\u5bc6\u8bc1\u4e66\u9a8c\u7b7e\uff1a\u975e\u5f53\u524dCA\u7b7e\u53d1\u7684\u670d\u52a1\u5668\u8bc1\u4e66");
                result.setError(ErrorEnum.GET_RA_SERVER_ENC_CERT_ERROR);
                return result;
            }
        }
        catch (Exception e) {
            this.logger.info("\u5bc6\u7801\u673a\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CERT_P7B_VERIFY_ERROR);
            return result;
        }
        String signCertPem = null;
        String encCertPem = null;
        try {
            signCertPem = CertUtils.writeObject((Object)signCert);
            encCertPem = CertUtils.writeObject((Object)encCert);
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u53d6RA\u670d\u52a1\u8bc1\u4e66pem\u503c\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.READ_RA_SERVER_CERT_PEM_ERROR);
            return result;
        }
        try {
            byte[] signCertPubKey = signCert.getPublicKey().getEncoded();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("1:{}", (Object)Base64.toBase64String((byte[])signCertPubKey));
            }
            String signP10 = FileUtils.readByBytes((String)(PathConstants.SOFT_ALG_FOLDER_PATH_TEMP + "CertReq.p10"));
            PKCS10CertificationRequest pkcs10CertificationRequest = GMSSLP10Utils.decodeP10((String)signP10);
            byte[] p10PubKey = pkcs10CertificationRequest.getSubjectPublicKeyInfo().getEncoded();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("2:{}", (Object)Base64.toBase64String((byte[])p10PubKey));
            }
            byte[] encPubKey = FileUtils.readByBinary((String)(PathConstants.SOFT_ALG_FOLDER_PATH_TEMP + "EncPubKey.pem"));
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)Base64.decode((byte[])encPubKey));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("3:{}", (Object)Base64.toBase64String((byte[])subjectPublicKeyInfo.getEncoded()));
            }
            byte[] encCertPubKey = encCert.getPublicKey().getEncoded();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("4:{}", (Object)Base64.toBase64String((byte[])encCertPubKey));
            }
            if (!Arrays.equals(signCertPubKey, p10PubKey) || !Arrays.equals(encCertPubKey, subjectPublicKeyInfo.getEncoded())) {
                this.logger.error("\u8bc1\u4e66\u4e2d\u7684\u516c\u94a5\u548c\u7533\u8bf7\u65f6\u7684\u516c\u94a5\u4e0d\u4e00\u81f4");
                result.setError(ErrorEnum.CERT_PUB_KEY_NOT_SAME_REQ_PUB_KEY);
                return result;
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u516c\u94a5\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.GET_PUB_KEY_INFO_EXCEPTION);
            return result;
        }
        RaCertDO raSignCertDO = new RaCertDO();
        RaCertDO raEncCertDO = new RaCertDO();
        long pairCertIndex = System.nanoTime();
        raSignCertDO.setPairCertIndex(Long.valueOf(pairCertIndex));
        raSignCertDO.setCaCertId(newCaCertInfo.getId());
        raSignCertDO.setCertDn(CertUtils.getSubjectByX509Cert((X509Certificate)signCert));
        raSignCertDO.setCertSn(signCert.getSerialNumber().toString(16).toLowerCase());
        raSignCertDO.setPublicKeyAlg(signCert.getPublicKey().getAlgorithm());
        raSignCertDO.setCertType(Integer.valueOf(2));
        try {
            int publicKeyLength = CertUtils.getPublicKeyLength((X509Certificate)signCert);
            raSignCertDO.setPrivateKeyLength(Integer.valueOf(publicKeyLength));
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u8bc1\u4e66\u516c\u94a5\u957f\u5ea6\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.GET_CERT_PUBLIC_KEY_LENGTH_EXCEPTION);
            return result;
        }
        raSignCertDO.setSignAlg(signCert.getSigAlgName());
        raSignCertDO.setCertInfo(signCertPem);
        raSignCertDO.setCertP7b(p7bContent);
        raSignCertDO.setGmtCreate(new Timestamp(System.currentTimeMillis()));
        raSignCertDO.setGmtUpdate(new Timestamp(System.currentTimeMillis()));
        BeanUtils.copyProperties((Object)raSignCertDO, (Object)raEncCertDO);
        raEncCertDO.setCertP7b(null);
        raEncCertDO.setCertDn(CertUtils.getSubjectByX509Cert((X509Certificate)encCert));
        raEncCertDO.setCertSn(encCert.getSerialNumber().toString(16).toLowerCase());
        raEncCertDO.setCertType(Integer.valueOf(3));
        raEncCertDO.setSignAlg(encCert.getSigAlgName());
        raEncCertDO.setCertInfo(encCertPem);
        try {
            FileUtils.saveFile((String)signCertPem, (String)PathConstants.RA_SERVICE_CERT_FILE_PATH);
            boolean isEncPwd = true;
            if (!initType) {
                isEncPwd = false;
            }
            KeyStoreUtils.saveServerPrivateKey((boolean)true, (String)PathConstants.SOFT_ALG_FOLDER_PATH, (PrivateKey)signPriKey, (X509Certificate[])new X509Certificate[]{signCert}, (boolean)isEncPwd);
            KeyStoreUtils.saveServerPrivateKey((boolean)false, (String)PathConstants.SOFT_ALG_FOLDER_PATH, (PrivateKey)encPriKey, (X509Certificate[])new X509Certificate[]{encCert}, (boolean)isEncPwd);
        }
        catch (Exception e) {
            this.logger.info("\u8bc1\u4e66\u548c\u5bf9\u5e94\u79c1\u94a5\u4fdd\u5b58\u5728\u6307\u5b9a\u8def\u5f84\u4e2d\u9519\u8bef", (Throwable)e);
            result.setError(ErrorEnum.SAVE_RA_CERT_IS_ERROR);
            return result;
        }
        try {
            this.raCertDao.insertRaCertInfo(raSignCertDO);
            this.raCertDao.insertRaCertInfo(raEncCertDO);
        }
        catch (Exception e) {
            this.logger.error("RA\u670d\u52a1\u5668\u8bc1\u4e66\u5b58ra_cert\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.INSERT_RA_CERT_INFO_ERROR);
            return result;
        }
        try {
            if (CommonVariable.getKeyAlgName().equalsIgnoreCase("SM2")) {
                GMSSLTomcatUtils.openHttpsPortByBC((List)certs, (X509Certificate)signCert, (X509Certificate)encCert, (PrivateKey)signPriKey, (PrivateKey)encPriKey, (String)this.tomcatPath, (int)Integer.parseInt(this.httpsPort));
            } else if (CommonVariable.getKeyAlgName().equalsIgnoreCase("RSA")) {
                GMSSLTomcatUtils.openHttpsPortByJKSWithRSA((List)certs, (X509Certificate)signCert, (X509Certificate)encCert, (PrivateKey)signPriKey, (PrivateKey)encPriKey, (String)this.tomcatPath, (int)Integer.parseInt(this.httpsPort));
            } else {
                GMSSLTomcatUtils.openHttpsPortByJKSWithNist((List)certs, (X509Certificate)signCert, (X509Certificate)encCert, (PrivateKey)signPriKey, (PrivateKey)encPriKey, (String)this.tomcatPath, (int)Integer.parseInt(this.httpsPort));
            }
        }
        catch (Exception e) {
            this.logger.error("\u542f\u7528https\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.START_TOMCAT_HTTPS);
            return result;
        }
        RaServerConfig raServerConfig = null;
        try {
            Config config = this.systemService.getConfigFile("config.json");
            if (initType) {
                config.setInitStep(3);
            } else if (Constants.DATA_IS_ENCRYPTION_1.equals(CommonVariable.getIsEncrypt()) && 1 != CommonVariable.getIsHsm()) {
                byte[] key = HsmUtils.publicKeyEncryptDate((PublicKey)encCert.getPublicKey(), (byte[])Base64.decode((String)CommonVariable.getEncryptKey()));
                config.setEncryptKey(Base64.toBase64String((byte[])key));
            }
            raServerConfig = config.getRaServerConfig();
            if (null == raServerConfig) {
                raServerConfig = new RaServerConfig();
            }
            raServerConfig.setSignCertName(signCertName.substring(signCertName.lastIndexOf("\\") + 1));
            raServerConfig.setEncCertName(encCertName.substring(encCertName.lastIndexOf("\\") + 1));
            config.setRaServerConfig(raServerConfig);
            config.setSigAlgName(signCert.getSigAlgName());
            this.systemService.updateConfigFile(config);
        }
        catch (Exception e) {
            this.logger.info("\u4fee\u6539\u521d\u59cb\u5316\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
        CommonVariable.setRaSingSn((String)signCert.getSerialNumber().toString(16).toLowerCase());
        CommonVariable.setRaSignPriKey((byte[])signPriKey.getEncoded());
        CommonVariable.setRaEncPriKey((PrivateKey)encPriKey);
        CommonVariable.setSigAlgName((String)signCert.getSigAlgName());
        CommonVariable.setRaEncPublicKey((PublicKey)encCert.getPublicKey());
        return result;
    }

    public Result isUseHsmInfo() {
        Result result = new Result();
        String keyAlg = CommonVariable.getKeyAlgName();
        Integer isHsm = CommonVariable.getIsHsm();
        this.logger.info("\u83b7\u53d6\u5f53\u524d\u3010\u7cfb\u7edf\u5bc6\u94a5\u7b97\u6cd5\u3011\u7c7b\u578b\uff1a{}", (Object)keyAlg);
        if (2 == isHsm && "NISTP256".equalsIgnoreCase(keyAlg)) {
            this.logger.error("\u4e09\u672a\u4fe1\u5b89\u5bc6\u7801\u673a\u4e0d\u652f\u6301NIST256\u7b97\u6cd5");
            result.setError(ErrorEnum.SWXA_HSM_NOT_SUPPORT_NIST);
            return result;
        }
        HsmResp hsmResp = new HsmResp();
        hsmResp.setHsmType(isHsm.intValue());
        if (1 == isHsm && "SM2".equalsIgnoreCase(keyAlg)) {
            hsmResp.setJump(true);
        }
        if (!"RSA".equalsIgnoreCase(keyAlg)) {
            hsmResp.setKeyLength(Integer.valueOf(256));
        } else {
            hsmResp.setKeyLength(Integer.valueOf(2048));
        }
        result.setInfo((Object)hsmResp);
        return result;
    }

    public Result genRaServerCertP10(String certDn, int keyLength, String keyAlg, boolean isInit) throws Exception {
        Result result = new Result();
        KeyPair signKeyPair = KeyUtils.genKeyPair((String)keyAlg, (int)keyLength);
        PublicKey signPubKey = signKeyPair.getPublic();
        PrivateKey signPriKey = signKeyPair.getPrivate();
        KeyPair encKeyPair = KeyUtils.genKeyPair((String)keyAlg, (int)keyLength);
        PublicKey encPubKey = encKeyPair.getPublic();
        PrivateKey encPriKey = encKeyPair.getPrivate();
        Result verifyRaServerCertDn = this.verifyRaServerCertDn(certDn);
        if (!verifyRaServerCertDn.isSuccess()) {
            result.setError(verifyRaServerCertDn.getError());
            return result;
        }
        X500Name x500Name = DnUtil.getRFC4519X500Name((String)certDn);
        PKCS10CertificationRequest p10 = null;
        p10 = "SM2".equals(keyAlg) ? P10Utils.createP10ByAlgType((X500Name)x500Name, (PublicKey)signPubKey, (PrivateKey)signPriKey, (String)"SM3withSM2") : ("RSA".equals(keyAlg) ? P10Utils.createP10ByAlgType((X500Name)x500Name, (PublicKey)signPubKey, (PrivateKey)signPriKey, (String)"SHA256withRSA") : P10Utils.createP10ByAlgType((X500Name)x500Name, (PublicKey)signPubKey, (PrivateKey)signPriKey, (String)"SHA256withECDSA"));
        String p10Name = PathConstants.SOFT_ALG_FOLDER_PATH_TEMP + "CertReq.p10";
        FileUtils.saveFile((String)Base64.toBase64String((byte[])p10.getEncoded()), (String)p10Name);
        boolean isEncPwd = false;
        if (isInit) {
            isEncPwd = true;
        }
        KeyStoreUtils.saveServerPrivateKey((boolean)true, (String)PathConstants.SOFT_ALG_FOLDER_PATH_TEMP, (PrivateKey)signPriKey, (X509Certificate[])new X509Certificate[]{CommonVariable.getCaServiceCert()}, (boolean)isEncPwd);
        String encPubKeyName = PathConstants.SOFT_ALG_FOLDER_PATH_TEMP + "EncPubKey.pem";
        FileUtils.saveFile((String)Base64.toBase64String((byte[])encPubKey.getEncoded()), (String)encPubKeyName);
        KeyStoreUtils.saveServerPrivateKey((boolean)false, (String)PathConstants.SOFT_ALG_FOLDER_PATH_TEMP, (PrivateKey)encPriKey, (X509Certificate[])new X509Certificate[]{CommonVariable.getCaServiceCert()}, (boolean)isEncPwd);
        ArrayList list = new ArrayList();
        HashMap<String, Object> signMap = new HashMap<String, Object>();
        signMap.put("name", "RACertReq");
        signMap.put("suffix", "p10");
        signMap.put("buffer", Base64.encode((byte[])p10.getEncoded()));
        list.add(signMap);
        HashMap<String, Object> encMap = new HashMap<String, Object>();
        encMap.put("name", "RAEncPubKey");
        encMap.put("suffix", "pem");
        encMap.put("buffer", Base64.encode((byte[])encPubKey.getEncoded()));
        list.add(encMap);
        byte[] certReq = ZipUtils.generateZipByte(list);
        String fileName = "RACertReq_" + System.currentTimeMillis() + ".zip";
        FileUtils.saveFile((byte[])certReq, (String)(PathConstants.SOFT_ALG_FOLDER_PATH_TEMP + fileName));
        result.setInfo((Object)fileName);
        return result;
    }

    public Result downloadRaServerCertReq(String zipFileName) {
        Result result = new Result();
        byte[] certReq = FileUtils.readByBinary((String)(PathConstants.SOFT_ALG_FOLDER_PATH_TEMP + zipFileName));
        if (certReq == null) {
            this.logger.info("\u83b7\u53d6\u670d\u52a1\u5668\u8bc1\u4e66\u7533\u8bf7\u6587\u4ef6\u5939\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_RA_CERT_REQ_FILE_IS_EMPTY);
            return result;
        }
        result.setInfo((Object)certReq);
        return result;
    }

    public static KeyPair getKeyPair(int keyLength, String alg) throws Exception {
        SecureRandom secureRandom = new SecureRandom();
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(alg);
        keyPairGenerator.initialize(keyLength, secureRandom);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        return keyPair;
    }

    private Result verifyRaServerCertDn(String certDn) {
        Result result = new Result();
        X500Name x500Name = null;
        try {
            x500Name = DnUtil.getRFC4519X500Name((String)certDn);
            String certDnFormat = x500Name.toString();
            this.logger.info("\u683c\u5f0f\u5316\u4e4b\u540e\u7684RA\u670d\u52a1\u5668\u8bc1\u4e66DN\uff1a" + certDnFormat);
            Result checkResult = CertDnVerifyUtils.checkDn((X500Name)x500Name);
            if (!checkResult.isSuccess()) {
                result.setError(checkResult.getError());
                return result;
            }
        }
        catch (Exception e) {
            this.logger.info("certDn\u4e0d\u6b63\u786e{}", (Object)e.getMessage());
            result.setError(ErrorEnum.CERT_APPLY_DN_IS_ERROR);
            return result;
        }
        return result;
    }

    public String getRAServiceDnName() {
        RaCertDO newRaCertInfo = null;
        try {
            newRaCertInfo = this.raCertDao.getNewRaCertInfo();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6RA\u670d\u52a1\u5668\u8bc1\u4e66\u5f02\u5e38", (Throwable)e);
            return null;
        }
        if (newRaCertInfo == null) {
            return null;
        }
        String certInfo = newRaCertInfo.getCertInfo();
        X509Certificate certFromStr = CertUtils.getCertFromStr((String)certInfo);
        String raServiceDnName = CertUtils.getSubjectByX509Cert((X509Certificate)certFromStr);
        return raServiceDnName;
    }
}

