/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.system;

import com.xdja.pki.gmssl.sdf.yunhsm.utils.GMSSLSancHsmUtils;
import com.xdja.pki.gmssl.sdf.yunhsm.utils.GMSSLYunHsmUtils;
import com.xdja.pki.gmssl.x509.utils.bean.YunHsmExceptionEnum;
import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.config.CaServerConf;
import com.xdja.pki.ra.core.config.Config;
import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.manager.sdk.business.CaBusinessManager;
import com.xdja.pki.ra.service.manager.system.CaService;
import com.xdja.pki.ra.service.manager.system.HsmServer;
import com.xdja.pki.ra.service.manager.system.ServerStatus;
import com.xdja.pki.ra.service.manager.system.SystemService;
import com.xdja.pki.ra.service.manager.system.bean.ServerStatusResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ServerStatusImpl
implements ServerStatus {
    @Autowired
    CaService caService;
    @Autowired
    HsmServer hsmServer;
    @Autowired
    CaBusinessManager caBusinessManager;
    @Autowired
    SystemService systemService;
    @Value(value="${cluster.deployment.type}")
    private String deploymentType;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public Result testServerConnect() {
        Integer isHsm;
        Result result = new Result();
        Config config = null;
        try {
            config = this.systemService.getConfigFile("config.json");
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
        CaServerConf caServerConf = config.getCaServerConf();
        String ip = caServerConf.getCaServerIp();
        int port = caServerConf.getCaServerPort();
        ServerStatusResp serverStatusResp = new ServerStatusResp();
        Result testCaResult = this.caBusinessManager.testCaServerConnect(null, ip, port);
        if (testCaResult.isSuccess()) {
            serverStatusResp.setCaServer(true);
        }
        if (1 == (isHsm = CommonVariable.getIsHsm())) {
            serverStatusResp.setHsmServer(GMSSLYunHsmUtils.testConnect());
        } else if (2 == isHsm) {
            YunHsmExceptionEnum yunHsmExceptionEnum = GMSSLSancHsmUtils.testConnect();
            if (YunHsmExceptionEnum.NORMAL.id == yunHsmExceptionEnum.id) {
                serverStatusResp.setHsmServer(true);
            } else {
                this.logger.info("\u6d4b\u8bd5SWXA\u5bc6\u7801\u673a\u8fde\u901a\u6027\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + yunHsmExceptionEnum.value);
            }
        }
        result.setInfo((Object)serverStatusResp);
        return result;
    }

    public Result getEncryptKeyInfo() {
        Result result = new Result();
        try {
            Config config = this.systemService.getConfigFile("config.json");
            if (null == config) {
                result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
                return result;
            }
            int encryptType = Constants.DATA_NOT_ENCRYPTION_0;
            int encryptKeyIndex = config.getEncryptKeyIndex();
            String encryptKey = config.getEncryptKey();
            if (null != encryptKey) {
                encryptType = Constants.DATA_ENCRYPTION_2;
            }
            if (0 != encryptKeyIndex) {
                encryptType = Constants.DATA_ENCRYPTION_1;
            }
            result.setInfo((Object)encryptType);
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CONFIG_JSON_FILE_OPERATION_ERROR);
            return result;
        }
    }

    public Result getDeploymentType() {
        return Result.success((Object)this.deploymentType);
    }
}

