/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.system;

import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.config.Config;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.manager.dao.SystemDao;
import com.xdja.pki.ra.manager.dao.model.ConfigFileDO;
import com.xdja.pki.ra.service.manager.system.SystemService;
import java.sql.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SystemServiceImpl
implements SystemService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    SystemDao systemDao;

    public Config getConfigFile(String fileName) {
        ConfigFileDO configFileDO = this.systemDao.getConfigFile(fileName);
        if (null == configFileDO) {
            return null;
        }
        String content = configFileDO.getFileValue();
        Config config = (Config)JsonUtils.json2Object((String)content, Config.class);
        if ("null".equalsIgnoreCase(config.getEncryptKey())) {
            config.setEncryptKey("");
        }
        return config;
    }

    public Result updateConfigFile(Config config) {
        ConfigFileDO configFileDO = this.systemDao.getConfigFile("config.json");
        String fileValue = JsonUtils.object2Json((Object)config);
        configFileDO.setFileValue(fileValue);
        configFileDO.setGmtModified(new Timestamp(System.currentTimeMillis()));
        this.systemDao.updateConfigFile(configFileDO);
        return Result.success();
    }

    public void saveConfigFile(Config config) {
        ConfigFileDO configFileDO = new ConfigFileDO();
        configFileDO.setFileName("config.json");
        String fileValue = JsonUtils.object2Json((Object)config);
        configFileDO.setFileValue(fileValue);
        configFileDO.setGmtCreate(new Timestamp(System.currentTimeMillis()));
        configFileDO.setGmtModified(new Timestamp(System.currentTimeMillis()));
        this.systemDao.saveConfigFile(configFileDO);
    }
}

