/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.tbox;

import com.xdja.pki.ra.cache.CertTempCache;
import com.xdja.pki.ra.cache.RaSdkCache;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.util.file.HexUtils;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.manager.dao.BaseUserDao;
import com.xdja.pki.ra.manager.dao.CaCertDao;
import com.xdja.pki.ra.manager.dao.CertTempDao;
import com.xdja.pki.ra.manager.dao.DeviceKeyDao;
import com.xdja.pki.ra.manager.dao.DeviceUserDao;
import com.xdja.pki.ra.manager.dao.UserCertDao;
import com.xdja.pki.ra.manager.dao.model.BaseUserDO;
import com.xdja.pki.ra.manager.dao.model.CertTempDO;
import com.xdja.pki.ra.manager.dao.model.DeviceKeyDO;
import com.xdja.pki.ra.manager.dao.model.UserCertDO;
import com.xdja.pki.ra.manager.dto.DeviceUserDTO;
import com.xdja.pki.ra.manager.dto.IssueApplyDTO;
import com.xdja.pki.ra.manager.dto.UpdateApplyDTO;
import com.xdja.pki.ra.service.manager.baseuser.bean.EncryptUserInfo;
import com.xdja.pki.ra.service.manager.certapply.CertApplyService;
import com.xdja.pki.ra.service.manager.certapply.IssueApplyService;
import com.xdja.pki.ra.service.manager.certapply.UpdateApplyService;
import com.xdja.pki.ra.service.manager.deviceuser.DeviceUserService;
import com.xdja.pki.ra.service.manager.deviceuser.bean.DeviceUserInfo;
import com.xdja.pki.ra.service.manager.deviceuser.bean.UserInfo;
import com.xdja.pki.ra.service.manager.tbox.TboxDeviceService;
import com.xdja.pki.ra.service.manager.tbox.bean.SharedKeyInfo;
import java.security.SecureRandom;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class TboxDeviceServiceImpl
implements TboxDeviceService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    DeviceUserService deviceUserService;
    @Autowired
    DeviceUserDao deviceUserDao;
    @Autowired
    DeviceKeyDao deviceKeyDao;
    @Autowired
    BaseUserDao baseUserDao;
    @Autowired
    IssueApplyService issueApplyService;
    @Autowired
    UpdateApplyService updateApplyService;
    @Autowired
    CertTempDao certTempDao;
    @Autowired
    Environment env;
    @Autowired
    CaCertDao caCertDao;
    @Autowired
    UserCertDao userCertDao;
    @Autowired
    CertApplyService certApplyService;
    @Autowired
    RaSdkCache raSdkCache;
    @Autowired
    CertTempCache certTempCache;

    @Transactional
    public Result registerTboxDeviceUser(String deviceNo, int deviceType, String deviceName, String deviceDesc) {
        String licenseNumberEncrypt;
        Result result = new Result();
        DeviceUserInfo deviceUserInfo = new DeviceUserInfo();
        deviceUserInfo.setUserName(deviceName);
        deviceUserInfo.setLicenseType(Integer.valueOf(deviceType));
        deviceUserInfo.setDeviceDesc(deviceDesc);
        deviceUserInfo.setLicenseNumber(deviceNo);
        UserInfo contactUserInfo = new UserInfo();
        try {
            licenseNumberEncrypt = EncryptUserInfo.getEncryptString((String)deviceUserInfo.getLicenseNumber());
        }
        catch (Exception e) {
            result.setError(ErrorEnum.DECRYPT_ENCRYPT_INFO_ERROR);
            return result;
        }
        List deviceUserDTOList = this.deviceUserDao.queryDeviceUserByLicenseType(licenseNumberEncrypt, deviceType);
        if (!CollectionUtils.isEmpty((Collection)deviceUserDTOList)) {
            this.logger.info("\u8be5\u8bbe\u5907\u5df2\u6ce8\u518c ============ deviceNo:" + deviceNo + " deviceType:" + deviceType + " size:" + deviceUserDTOList.size());
            DeviceUserDTO deviceUserDTO = (DeviceUserDTO)deviceUserDTOList.get(0);
            int status = deviceUserDTO.getStatus();
            if (status == 1) {
                result.setError(ErrorEnum.TBOX_DEVICE_STATUS_IS_STOP);
                return result;
            }
        } else {
            deviceUserInfo.setSystemFlag("V2X");
            Result registerResult = this.deviceUserService.registerDeviceUser(deviceUserInfo, contactUserInfo, true);
            if (!registerResult.isSuccess()) {
                this.logger.info("\u8bbe\u5907\u6ce8\u518c\u5931\u8d25\uff1a" + JsonUtils.object2Json((Object)registerResult));
                result.setError(registerResult.getError());
                return result;
            }
        }
        byte[] sharedKey = new byte[16];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(sharedKey);
        String sharedKeyId = String.valueOf(System.currentTimeMillis());
        String sharedKeyValue = HexUtils.bytesToHexFun1((byte[])sharedKey);
        Timestamp timestamp = new Timestamp(new Date().getTime());
        this.deviceKeyDao.addDeviceSharedKey(new DeviceKeyDO(deviceNo, sharedKeyId, sharedKeyValue, timestamp, timestamp));
        result.setInfo((Object)new SharedKeyInfo(sharedKeyId, sharedKeyValue));
        return result;
    }

    public Result getTboxDeviceInfo(String deviceNo, String keyId) {
        return null;
    }

    public Result insertIssueCertApply(String deviceNo, String userCertDn) {
        BaseUserDO baseUser;
        Result result = new Result();
        try {
            String encryptDeviceNo = EncryptUserInfo.getEncryptString((String)deviceNo);
            baseUser = this.baseUserDao.queryUserByUserType(encryptDeviceNo, 3);
        }
        catch (Exception e) {
            result.setError(ErrorEnum.ONLINE_DEVICE_INFO_NOT_EXIST);
            return result;
        }
        if (baseUser == null) {
            result.setError(ErrorEnum.ONLINE_DEVICE_INFO_NOT_EXIST);
            return result;
        }
        Integer deviceStatus = baseUser.getStatus();
        if (1 == deviceStatus) {
            result.setError(ErrorEnum.TBOX_DEVICE_STATUS_IS_STOP);
            return result;
        }
        String tboxTemplateNo = null;
        try {
            tboxTemplateNo = this.env.getProperty("tbox.cert.template.no");
        }
        catch (Exception e) {
            result.setError(ErrorEnum.GET_TBOX_TEMPLATE_EXCEPTION);
            return result;
        }
        if (StringUtils.isBlank((CharSequence)tboxTemplateNo)) {
            result.setError(ErrorEnum.TBOX_TEMPLATE_NO_NOT_EXIST);
            return result;
        }
        this.logger.info(" =========== tbox\u8bc1\u4e66\u6a21\u677f\u7f16\u53f7:{}", (Object)tboxTemplateNo);
        CertTempDO certTempDO = this.certTempCache.getCertTempInfoByTempNo(tboxTemplateNo);
        if (certTempDO == null) {
            result.setError(ErrorEnum.TBOX_TEMPLATE_NO_NOT_EXIST);
            return result;
        }
        int tempStatus = certTempDO.getTempStatus();
        int tempBound = certTempDO.getTempBound();
        if (3 == tempStatus || 2 == tempBound) {
            result.setError(ErrorEnum.TBOX_TEMPLATE_IS_STOP_OR_UNBOUND);
            return result;
        }
        IssueApplyDTO issueApplyDTO = new IssueApplyDTO();
        issueApplyDTO.setUserId(baseUser.getId());
        issueApplyDTO.setTempNo(tboxTemplateNo);
        issueApplyDTO.setCertDn(userCertDn);
        issueApplyDTO.setSignAlg(certTempDO.getSignAlg());
        issueApplyDTO.setKeyAlg(certTempDO.getPublicKeyAlg());
        issueApplyDTO.setPrivateKeyLength(certTempDO.getPrivateKeyLength());
        issueApplyDTO.setCertValidity(certTempDO.getMaxValidity());
        issueApplyDTO.setApplyReason("Tbox\u8bbe\u5907\u5728\u7ebf\u53d1\u8d77\u8bbe\u5907\u6ce8\u518c\u548c\u7b7e\u53d1\u8bc1\u4e66\u7533\u8bf7");
        issueApplyDTO.setTempId(certTempDO.getId());
        issueApplyDTO.setCertPatterm(certTempDO.getCertPatterm());
        String applyNo = this.raSdkCache.getIncApplyNo();
        issueApplyDTO.setApplyNo(applyNo);
        Result issueApplyResult = this.issueApplyService.insertCertIssueApply(Integer.valueOf(3), "V2X", issueApplyDTO, certTempDO);
        if (!issueApplyResult.isSuccess()) {
            result.setError(issueApplyResult.getError());
            return result;
        }
        issueApplyDTO.setApplyId((Long)issueApplyResult.getInfo());
        this.certApplyService.insertCertApplyRecord(1, 1, applyNo, "V2X", 1, issueApplyDTO.getApplyReason(), 1, false, true);
        this.certApplyService.insertCertApplyRecord(1, 3, applyNo, "V2X", 3, "\u81ea\u52a8\u5ba1\u6838\u7c7b\u6a21\u677f-\u5ba1\u6838\u6210\u529f", 4, true, true);
        result.setInfo((Object)issueApplyDTO);
        return result;
    }

    @Transactional
    public Result insertUpdateCertApply(String deviceNo, String userCertDn, String signSn, Integer certValidity, boolean isUpdateKey) {
        BaseUserDO baseUser;
        Result result = new Result();
        try {
            baseUser = this.baseUserDao.queryUserByUserType(EncryptUserInfo.getEncryptString((String)deviceNo), 3);
        }
        catch (Exception e) {
            result.setError(ErrorEnum.ONLINE_DEVICE_INFO_NOT_EXIST);
            return result;
        }
        if (baseUser == null) {
            result.setError(ErrorEnum.ONLINE_DEVICE_INFO_NOT_EXIST);
            return result;
        }
        Integer deviceStatus = baseUser.getStatus();
        if (1 == deviceStatus) {
            result.setError(ErrorEnum.TBOX_DEVICE_STATUS_IS_STOP);
            return result;
        }
        if (!"V2X".equalsIgnoreCase(baseUser.getSystemFlag())) {
            result.setError(ErrorEnum.DEVICE_NO_IS_NOT_TBOX_SYSTEM);
            return result;
        }
        UserCertDO userCertDO = this.userCertDao.getUserCertBaseInfo(signSn);
        if (userCertDO == null || userCertDO.getUserId().longValue() != baseUser.getId().longValue()) {
            result.setError(ErrorEnum.ONLINE_DEVICE_NO_GET_CERT_ERROR);
            return result;
        }
        long time = userCertDO.getFailureTime().getTime() - System.currentTimeMillis();
        if (1 != userCertDO.getCertStatus() || time < 0L) {
            this.logger.info("\u5f85\u66f4\u65b0\u8bc1\u4e66\u4e0d\u662f\u6b63\u5e38\u72b6\u6001");
            result.setError(ErrorEnum.USER_CERT_IS_NOT_NORMAL_STATUS);
            return result;
        }
        this.logger.info(" =========== \u8bc1\u4e66\u7b7e\u53d1\u65f6\u4f7f\u7528\u6a21\u677f\u7f16\u53f7:" + userCertDO.getTempNo());
        CertTempDO certTempDO = this.certTempCache.getCertTempInfoByTempNo(userCertDO.getTempNo());
        if (certTempDO == null) {
            result.setError(ErrorEnum.TBOX_TEMPLATE_NO_NOT_EXIST);
            return result;
        }
        int tempStatus = certTempDO.getTempStatus();
        int tempBound = certTempDO.getTempBound();
        if (3 == tempStatus || 2 == tempBound) {
            result.setError(ErrorEnum.OLD_TEMPLATE_IS_STOP_OR_UNBOUND);
            return result;
        }
        UpdateApplyDTO updateApplyDTO = new UpdateApplyDTO();
        updateApplyDTO.setUserId(baseUser.getId());
        updateApplyDTO.setTempNo(userCertDO.getTempNo());
        updateApplyDTO.setCertDn(userCertDO.getCertDn());
        updateApplyDTO.setSignAlg(certTempDO.getSignAlg());
        updateApplyDTO.setKeyAlg(certTempDO.getPublicKeyAlg());
        updateApplyDTO.setPrivateKeyLength(certTempDO.getPrivateKeyLength());
        updateApplyDTO.setCertValidity(certValidity == 0 || certValidity > certTempDO.getMaxValidity() ? certTempDO.getMaxValidity() : certValidity);
        updateApplyDTO.setApplyReason("Tbox\u8bbe\u5907\u5728\u7ebf\u53d1\u8d77\u66f4\u65b0\u8bc1\u4e66\u7533\u8bf7");
        updateApplyDTO.setUpdateKey(Boolean.valueOf(isUpdateKey));
        updateApplyDTO.setSignSn(signSn);
        updateApplyDTO.setUpdateValidity(Boolean.valueOf(certValidity != 0));
        updateApplyDTO.setCertPatterm(certTempDO.getCertPatterm());
        updateApplyDTO.setTempId(certTempDO.getId());
        String applyNo = this.raSdkCache.getIncApplyNo();
        updateApplyDTO.setApplyNo(applyNo);
        Result updateApplyResult = this.updateApplyService.insertCertUpdateApply(updateApplyDTO, userCertDO, certTempDO, false);
        if (!updateApplyResult.isSuccess()) {
            result.setError(updateApplyResult.getError());
            return result;
        }
        updateApplyDTO.setApplyId((Long)updateApplyResult.getInfo());
        this.certApplyService.insertCertApplyRecord(2, 1, applyNo, "V2X", 1, updateApplyDTO.getApplyReason(), 1, false, true);
        this.certApplyService.insertCertApplyRecord(2, 3, applyNo, "V2X", 3, "\u81ea\u52a8\u5ba1\u6838\u7c7b\u6a21\u677f-\u5ba1\u6838\u6210\u529f", 4, true, true);
        result.setInfo((Object)updateApplyDTO);
        return result;
    }
}

