/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.template;

import com.xdja.pki.ra.cache.CertTempCache;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.manager.dao.AdminCertDao;
import com.xdja.pki.ra.manager.dao.CaCertDao;
import com.xdja.pki.ra.manager.dao.CertTempDao;
import com.xdja.pki.ra.manager.dao.RaCertDao;
import com.xdja.pki.ra.manager.dao.UserCertDao;
import com.xdja.pki.ra.manager.dao.model.CertTempDO;
import com.xdja.pki.ra.manager.dao.model.UserCertDO;
import com.xdja.pki.ra.manager.page.PageInfo;
import com.xdja.pki.ra.manager.sdk.business.CaBusinessManager;
import com.xdja.pki.ra.manager.sdk.business.SynTempInfo;
import com.xdja.pki.ra.service.manager.template.CertTempResp;
import com.xdja.pki.ra.service.manager.template.CertTempService;
import com.xdja.pki.ra.service.manager.template.CertTempVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CertTempServiceImpl
implements CertTempService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    CertTempDao certTempDao;
    @Autowired
    RaCertDao raCertDao;
    @Autowired
    CaCertDao caCertDao;
    @Autowired
    CaBusinessManager caBusinessManager;
    @Autowired
    UserCertDao userCertDao;
    @Autowired
    AdminCertDao adminCertDao;
    @Autowired
    CertTempCache certTempCache;

    public Result listCertTemplate(String tempName, int tempStatus, int pageNo, int pageSize, String userCA) {
        CertTempResp certTempResp = new CertTempResp();
        Result result = new Result();
        PageInfo certTempDOPageInfo = this.certTempCache.listPageAppUserCert(tempName, tempStatus, pageNo, pageSize, userCA);
        if (certTempDOPageInfo == null) {
            result.setError(ErrorEnum.QUERY_TEMP_LIST_ERROR);
            return result;
        }
        ArrayList<CertTempVO> certTempVOList = new ArrayList<CertTempVO>();
        List certTempDOList = certTempDOPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)certTempDOList)) {
            certTempResp.setRecordCount(0);
            certTempResp.setPageCount(0);
            certTempResp.setDatas(certTempVOList);
            result.setInfo((Object)certTempResp);
            return result;
        }
        for (CertTempDO certTempDO : certTempDOList) {
            CertTempVO certTempVO = new CertTempVO();
            BeanUtils.copyProperties((Object)certTempDO, (Object)certTempVO);
            certTempVOList.add(certTempVO);
        }
        certTempResp.setDatas(certTempVOList);
        certTempResp.setPageCount(certTempDOPageInfo.getPageCount());
        certTempResp.setRecordCount(certTempDOPageInfo.getRecordCount());
        result.setInfo((Object)certTempResp);
        return result;
    }

    @Transactional
    public Result synCertTemplateList(int pageNo, int pageSize) {
        Result result = new Result();
        Result synResult = this.caBusinessManager.synCertTemplateList();
        if (!synResult.isSuccess()) {
            return synResult;
        }
        List synTempInfoList = (List)synResult.getInfo();
        this.logger.info("RA\u8c03\u7528CA\u8bc1\u4e66\u6a21\u677f\u901a\u8fc7\u63a5\u53e3\u8fd4\u56de\u7684\u6a21\u677f\u4fe1\u606f\uff1a{}", (Object)JsonUtils.object2Json((Object)synTempInfoList));
        if (CollectionUtils.isEmpty((Collection)synTempInfoList)) {
            this.certTempDao.updateCertTempNewStatus();
        } else {
            List localTempDoList = this.certTempCache.getAllNewCertTemplateList();
            if (!CollectionUtils.isEmpty((Collection)localTempDoList)) {
                HashMap<String, String> tempStrategy = new HashMap<String, String>();
                for (CertTempDO certTempDO : localTempDoList) {
                    tempStrategy.put(certTempDO.getTempNo(), String.valueOf(certTempDO.getCheckStrategy()));
                }
                this.certTempDao.updateCertTempNewStatus();
                for (SynTempInfo synTempInfo : synTempInfoList) {
                    CertTempDO certTempDO = new CertTempDO();
                    if (tempStrategy.containsKey(synTempInfo.getCode())) {
                        certTempDO.setCheckStrategy(Integer.valueOf((String)tempStrategy.get(synTempInfo.getCode())));
                        tempStrategy.remove(synTempInfo.getCode());
                    } else {
                        certTempDO.setCheckStrategy(Integer.valueOf(2));
                    }
                    certTempDO.setCaId(synTempInfo.getCaId());
                    certTempDO.setTempNo(synTempInfo.getCode());
                    certTempDO.setTempName(synTempInfo.getName());
                    certTempDO.setTempBound(Integer.valueOf(synTempInfo.getBound()));
                    certTempDO.setMaxValidity(Integer.valueOf(synTempInfo.getMaxValidity()));
                    certTempDO.setSignAlg(synTempInfo.getSignAlg());
                    certTempDO.setPrivateKeyLength(Integer.valueOf(synTempInfo.getKeySize()));
                    certTempDO.setPublicKeyAlg(synTempInfo.getKeyAlg());
                    certTempDO.setTempType(Integer.valueOf(synTempInfo.getType()));
                    certTempDO.setTempParas(synTempInfo.getTemParas());
                    certTempDO.setGmtCreate(new Timestamp(System.currentTimeMillis()));
                    certTempDO.setGmtUpdate(new Timestamp(System.currentTimeMillis()));
                    certTempDO.setTempStatus(Integer.valueOf(synTempInfo.getStatus()));
                    certTempDO.setIsNewestTemp(Integer.valueOf(1));
                    certTempDO.setCertPatterm(synTempInfo.getCertPatterm());
                    certTempDO.setBaseDn(synTempInfo.getBaseDn());
                    certTempDO.setUserCA(synTempInfo.getUserCA());
                    this.certTempDao.insertCertTemp(certTempDO);
                }
                if (!tempStrategy.isEmpty()) {
                    for (String obj : tempStrategy.keySet()) {
                        this.certTempDao.updateCertTempNotBound(obj);
                    }
                }
            } else {
                for (SynTempInfo synTempInfo : synTempInfoList) {
                    CertTempDO certTempDO = new CertTempDO();
                    certTempDO.setCaId(synTempInfo.getCaId());
                    certTempDO.setTempNo(synTempInfo.getCode());
                    certTempDO.setTempName(synTempInfo.getName());
                    certTempDO.setTempBound(Integer.valueOf(synTempInfo.getBound()));
                    certTempDO.setMaxValidity(Integer.valueOf(synTempInfo.getMaxValidity()));
                    certTempDO.setSignAlg(synTempInfo.getSignAlg());
                    certTempDO.setPrivateKeyLength(Integer.valueOf(synTempInfo.getKeySize()));
                    certTempDO.setPublicKeyAlg(synTempInfo.getKeyAlg());
                    certTempDO.setTempType(Integer.valueOf(synTempInfo.getType()));
                    certTempDO.setTempParas(synTempInfo.getTemParas());
                    certTempDO.setGmtCreate(new Timestamp(System.currentTimeMillis()));
                    certTempDO.setGmtUpdate(new Timestamp(System.currentTimeMillis()));
                    certTempDO.setTempStatus(Integer.valueOf(synTempInfo.getStatus()));
                    certTempDO.setIsNewestTemp(Integer.valueOf(1));
                    certTempDO.setCheckStrategy(Integer.valueOf(2));
                    certTempDO.setCertPatterm(synTempInfo.getCertPatterm());
                    certTempDO.setBaseDn(synTempInfo.getBaseDn());
                    certTempDO.setUserCA(synTempInfo.getUserCA());
                    this.certTempDao.insertCertTemp(certTempDO);
                }
            }
        }
        this.certTempCache.updateCertTempNewStatus();
        Result listCertTemplateResult = this.listCertTemplate(null, 0, pageNo, pageSize, null);
        if (!listCertTemplateResult.isSuccess()) {
            this.logger.info("\u6309\u67e5\u8be2\u6761\u4ef6\uff0c\u5206\u9875\u67e5\u8be2\u8bc1\u4e66\u6a21\u677f\u4fe1\u606f\u5217\u8868\u5931\u8d25");
            result.setError(synResult.getError());
            return result;
        }
        result.setInfo(listCertTemplateResult.getInfo());
        return result;
    }

    public Result updateCertTempCheckStrategy(String tempNo, int checkStrategy) {
        Result result = new Result();
        int isOk = this.certTempDao.updateCertTempCheckStrategy(tempNo, checkStrategy);
        this.certTempCache.updateCertTempNewStatus();
        CertTempDO certTempInfoByTempNo = this.certTempCache.getCertTempInfoByTempNo(tempNo);
        String userCA = certTempInfoByTempNo.getUserCA();
        StringBuilder stringBuilder = new StringBuilder();
        result.setLogContent(stringBuilder.append("\uff0c\u6240\u5c5eCA=").append(userCA).toString());
        if (isOk != 1) {
            this.logger.info("\u66f4\u65b0\u6a21\u677f\u5ba1\u6838\u7b56\u7565\u5931\u8d25");
            result.setError(ErrorEnum.UPDATE_CHECK_STRATEGY_FAIL);
            return result;
        }
        return result;
    }

    public Result listCertTemplateDropDownList(String userCA) {
        Result result = new Result();
        List certTempDOList = null;
        try {
            certTempDOList = this.certTempCache.listCertTemplateDropDownList(userCA);
        }
        catch (EmptyResultDataAccessException e) {
            this.logger.info("listCertTemplateDropDownList \u67e5\u8be2\u6240\u6709\u7684\u4e0b\u62c9\u5217\u8868\u5185\u5bb9\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)certTempDOList)) {
            result.setInfo(null);
            return result;
        }
        ArrayList<CertTempVO> list = new ArrayList<CertTempVO>();
        for (CertTempDO certTempDO : certTempDOList) {
            CertTempVO certTempVO = new CertTempVO();
            BeanUtils.copyProperties((Object)certTempDO, (Object)certTempVO);
            list.add(certTempVO);
        }
        result.setInfo(list);
        return result;
    }

    public Result getCertApplyMaxValidity(String tempNo, int updateKey, String signSn, boolean isOnline) {
        int tempMaxValidity;
        this.logger.info("getCertApplyMaxValidity---------------------\u83b7\u53d6\u6700\u5927\u7533\u8bf7\u7f16\u53f7");
        Result result = new Result();
        CertTempDO certTempInfoByTempNo = this.certTempCache.getCertTempInfoByTempNo(tempNo);
        if (certTempInfoByTempNo == null) {
            result.setError(ErrorEnum.GET_CERT_TEMP_INFO_IS_EMPTY);
            return result;
        }
        int min = tempMaxValidity = certTempInfoByTempNo.getMaxValidity().intValue();
        if (isOnline) {
            this.logger.info("\u7528\u6237\u6a21\u677f:{},\u6a21\u677f\u6700\u5927\u6709\u6548\u671f:{}", (Object)tempNo, (Object)tempMaxValidity);
        } else {
            Result userCACert = this.caBusinessManager.getUserCACertFileTime(certTempInfoByTempNo.getCaId());
            if (!userCACert.isSuccess()) {
                return userCACert;
            }
            long afterTime = Long.parseLong(new String((byte[])userCACert.getInfo()));
            long nowTime = System.currentTimeMillis();
            int caValidity = (int)((afterTime - nowTime) / 86400000L);
            min = Math.min(caValidity, min);
            this.logger.info("\u7528\u6237\u6a21\u677f:{}, \u6a21\u677f\u6700\u5927\u6709\u6548\u671f:{},\u7528\u6237CA\u6700\u5927\u6709\u6548\u671f:{}", new Object[]{tempNo, tempMaxValidity, caValidity});
        }
        if (updateKey == 0) {
            UserCertDO userCertBaseInfo = this.userCertDao.getUserCertBaseInfo(signSn);
            int priKeyValidity = userCertBaseInfo.getEncKeyValidity();
            min = Math.min(priKeyValidity, min);
            this.logger.info("\u4e0d\u66f4\u65b0\u5bc6\u94a5,\u52a0\u5bc6\u5bc6\u94a5\u6700\u5927\u6709\u6548\u671f:{}", (Object)priKeyValidity);
        }
        return Result.success((Object)min);
    }
}

