/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.usercert;

import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.manager.dao.CertTempDao;
import com.xdja.pki.ra.manager.dao.CustomerDao;
import com.xdja.pki.ra.manager.dao.UserCertDao;
import com.xdja.pki.ra.manager.dao.model.UserCertDO;
import com.xdja.pki.ra.manager.dto.UserCertDTO;
import com.xdja.pki.ra.manager.page.PageInfo;
import com.xdja.pki.ra.manager.sdk.business.CaBusinessManager;
import com.xdja.pki.ra.service.manager.usercert.UserCertResp;
import com.xdja.pki.ra.service.manager.usercert.UserCertService;
import com.xdja.pki.ra.service.manager.usercert.UserCertVO;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserCertServiceImpl
implements UserCertService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    UserCertDao userCertDao;
    @Autowired
    CustomerDao customerDao;
    @Autowired
    CertTempDao certTempDao;
    @Autowired
    CaBusinessManager caBusinessManager;

    public Result listUserCert(String certDn, String userName, int userType, int pageNo, int pageSize, int leftDate, Boolean effectiveTimeAsc, Boolean failureTimeAsc) {
        UserCertResp userCertResp = new UserCertResp();
        Result result = new Result();
        PageInfo userCertDTOPageInfo = this.userCertDao.listPageUserCert(certDn, userType, userName, pageNo, pageSize, effectiveTimeAsc, failureTimeAsc, leftDate);
        if (userCertDTOPageInfo == null) {
            result.setError(ErrorEnum.QUERY_USER_CERT_LIST_ERROR);
            return result;
        }
        ArrayList<UserCertVO> userCertVOList = new ArrayList<UserCertVO>();
        List userCertDTOList = userCertDTOPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)userCertDTOList)) {
            userCertResp.setRecordCount(0);
            userCertResp.setPageCount(0);
            userCertResp.setDatas(userCertVOList);
            result.setInfo((Object)userCertResp);
            return result;
        }
        for (UserCertDTO userCertDTO : userCertDTOList) {
            UserCertVO userCertVO = new UserCertVO();
            BeanUtils.copyProperties((Object)userCertDTO, (Object)userCertVO);
            Timestamp effectiveTime = userCertDTO.getEffectiveTime();
            userCertVO.setEffectiveTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(effectiveTime));
            Timestamp failureTime = userCertDTO.getFailureTime();
            userCertVO.setFailureTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(failureTime));
            if (System.currentTimeMillis() > failureTime.getTime()) {
                userCertVO.setCertStatus(Integer.valueOf(2));
            }
            int leftDates = (int)((failureTime.getTime() - System.currentTimeMillis()) / 86400000L);
            userCertVO.setLeftValidity(Integer.valueOf(leftDates));
            userCertVOList.add(userCertVO);
        }
        userCertResp.setDatas(userCertVOList);
        userCertResp.setPageCount(userCertDTOPageInfo.getPageCount());
        userCertResp.setRecordCount(userCertDTOPageInfo.getRecordCount());
        result.setInfo((Object)userCertResp);
        return result;
    }

    public Result listUserCertNew(String certDn, String userName, String userCA, int pageNo, int pageSize, int leftDate, Boolean effectiveTimeAsc, Boolean failureTimeAsc, String startTime, String endTime) {
        UserCertResp userCertResp = new UserCertResp();
        Result result = new Result();
        PageInfo userCertDTOPageInfo = this.userCertDao.listPageUserCertNew(certDn, userCA, userName, pageNo, pageSize, effectiveTimeAsc, failureTimeAsc, leftDate, startTime, endTime);
        if (userCertDTOPageInfo == null) {
            result.setError(ErrorEnum.QUERY_USER_CERT_LIST_ERROR);
            return result;
        }
        ArrayList<UserCertVO> userCertVOList = new ArrayList<UserCertVO>();
        List userCertDTOList = userCertDTOPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)userCertDTOList)) {
            userCertResp.setRecordCount(0);
            userCertResp.setPageCount(0);
            userCertResp.setDatas(userCertVOList);
            result.setInfo((Object)userCertResp);
            return result;
        }
        for (UserCertDTO userCertDTO : userCertDTOList) {
            UserCertVO userCertVO = new UserCertVO();
            BeanUtils.copyProperties((Object)userCertDTO, (Object)userCertVO);
            UserCertDTO certListInfo = this.userCertDao.getCertListInfo(userCertDTO.getSystemFlag(), userCertDTO.getTempId());
            userCertVO.setSystemName(certListInfo.getSystemName());
            userCertVO.setCertPatterm(certListInfo.getCertPatterm());
            userCertVO.setCheckStrategy(String.valueOf(certListInfo.getCheckStrategy()));
            userCertVO.setTempName(certListInfo.getTempName());
            userCertVO.setTempNo(certListInfo.getTempNo());
            userCertVO.setUserCA(certListInfo.getUserCA());
            Timestamp effectiveTime = userCertDTO.getEffectiveTime();
            userCertVO.setEffectiveTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(effectiveTime));
            Timestamp failureTime = userCertDTO.getFailureTime();
            userCertVO.setFailureTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(failureTime));
            if (System.currentTimeMillis() > failureTime.getTime()) {
                userCertVO.setCertStatus(Integer.valueOf(2));
            }
            int leftDates = (int)((failureTime.getTime() - System.currentTimeMillis()) / 86400000L);
            userCertVO.setLeftValidity(Integer.valueOf(leftDates));
            userCertVOList.add(userCertVO);
        }
        userCertResp.setDatas(userCertVOList);
        userCertResp.setPageCount(userCertDTOPageInfo.getPageCount());
        userCertResp.setRecordCount(userCertDTOPageInfo.getRecordCount());
        result.setInfo((Object)userCertResp);
        return result;
    }

    public Result getUserCertStatus(String certSn) {
        Result result = new Result();
        Result certStatusResult = this.caBusinessManager.getCertStatus(certSn);
        if (!certStatusResult.isSuccess()) {
            return certStatusResult;
        }
        int status = (Integer)certStatusResult.getInfo();
        if (status != 0) {
            try {
                this.userCertDao.updateDoubleUserCertStatus(status, certSn);
            }
            catch (Exception e) {
                this.logger.error("\u66f4\u65b0\u7528\u6237\u8bc1\u4e66\u72b6\u6001\u5f02\u5e38{}", (Throwable)e);
                result.setError(ErrorEnum.UPDATE_USER_CERT_STATUS_EXCEPTION);
                return result;
            }
        }
        return certStatusResult;
    }

    public Result exportUserDoubleCerts(String certSn) {
        Result result = new Result();
        Result certDataInfoResult = this.caBusinessManager.downloadCertDataInfo(certSn, false);
        if (!certDataInfoResult.isSuccess()) {
            return certDataInfoResult;
        }
        Map map = (Map)certDataInfoResult.getInfo();
        ArrayList list = new ArrayList();
        HashMap<String, Object> caCertMap = new HashMap<String, Object>();
        caCertMap.put("name", "CACert");
        caCertMap.put("suffix", "p7b");
        byte[] caCertByte = ((String)map.get("CACert")).getBytes();
        caCertMap.put("buffer", caCertByte);
        list.add(caCertMap);
        HashMap<String, Object> signMap = new HashMap<String, Object>();
        signMap.put("name", "UserCert");
        if (null != map.get("encCert")) {
            HashMap<String, Object> encMap = new HashMap<String, Object>();
            encMap.put("name", "EncCert");
            encMap.put("suffix", "p7b");
            byte[] encByte = ((String)map.get("encCert")).getBytes();
            encMap.put("buffer", encByte);
            list.add(encMap);
            signMap.put("name", "SignCert");
        }
        signMap.put("suffix", "p7b");
        byte[] signByte = ((String)map.get("signCert")).getBytes();
        signMap.put("buffer", signByte);
        list.add(signMap);
        result.setInfo(list);
        return result;
    }

    public Result getUserCertBaseInfo(String certSn) {
        Result result = new Result();
        UserCertDO userCertBaseInfo = this.userCertDao.getUserCertBaseInfo(certSn);
        if (userCertBaseInfo == null) {
            this.logger.info("\u83b7\u53d6\u7528\u6237\u8bc1\u4e66\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_USER_CERT_INFO_IS_EMPTY);
            return result;
        }
        result.setInfo((Object)userCertBaseInfo);
        return result;
    }

    public Result updateUserCertStatus(int certStatus, String certSn) {
        Result result = new Result();
        try {
            this.userCertDao.updateDoubleUserCertStatus(certStatus, certSn);
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u7528\u6237\u8bc1\u4e66\u72b6\u6001\u5f02\u5e38 certSn:" + certSn, (Throwable)e);
            result.setError(ErrorEnum.UPDATE_USER_CERT_STATUS_EXCEPTION);
            return result;
        }
        return result;
    }
}

