/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.service.manager.usercertmanager;

import com.alibaba.fastjson.JSONObject;
import com.xdja.pki.ra.cache.CertTempCache;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.exception.ServiceException;
import com.xdja.pki.ra.core.util.file.ZipUtils;
import com.xdja.pki.ra.manager.dao.BaseUserDao;
import com.xdja.pki.ra.manager.dao.UserCertDao;
import com.xdja.pki.ra.manager.dao.model.CertTempDO;
import com.xdja.pki.ra.manager.dao.model.UserCertDO;
import com.xdja.pki.ra.manager.dto.UserCertDTO;
import com.xdja.pki.ra.manager.sdk.business.CaBusinessManager;
import com.xdja.pki.ra.service.manager.baseuser.BaseUserService;
import com.xdja.pki.ra.service.manager.usercert.UserCertService;
import com.xdja.pki.ra.service.manager.usercert.UserCertStr;
import com.xdja.pki.ra.service.manager.usercertmanager.UserCertManagerService;
import com.xdja.pki.ra.service.manager.usercertmanager.bean.CertBaseInfo;
import com.xdja.pki.ra.service.manager.usercertmanager.bean.UserCertInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserCertManagerImpl
implements UserCertManagerService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private BaseUserDao baseUserDao;
    @Autowired
    private UserCertDao userCertDao;
    @Autowired
    private CaBusinessManager caBusinessManager;
    @Autowired
    private UserCertService userCertService;
    @Autowired
    BaseUserService baseUserService;
    @Autowired
    CertTempCache certTempCache;

    public Result getUserCertInfoList(Integer userType, Integer identType, String identNumber, String systemFlag) {
        try {
            Result result = new Result();
            Long userId = this.baseUserService.queryUserId(userType.intValue(), systemFlag, identType, identNumber);
            if (null == userId) {
                this.logger.error("\u67e5\u8be2\u7528\u6237\u4e0d\u5b58\u5728\uff1auserType:[{}],identType:[{}],licenseNumber:[{}],systemFlag:[{}]", new Object[]{userType, identType, identNumber, systemFlag});
                return Result.failure((ErrorEnum)ErrorEnum.GET_PERSON_USER_INFO_IS_EMPTY);
            }
            List userCertDOS = this.userCertDao.getUserCertList(userId.longValue());
            this.logger.debug("\u67e5\u8be2\u7528\u6237userId:" + userId);
            if (userCertDOS.isEmpty()) {
                result.setInfo(null);
                return result;
            }
            ArrayList<UserCertInfo> userCertInfos = new ArrayList<UserCertInfo>();
            for (UserCertDTO userCertDO : userCertDOS) {
                UserCertInfo userCertInfo = new UserCertInfo();
                BeanUtils.copyProperties((Object)userCertDO, (Object)userCertInfo);
                if (1 == userCertDO.getIsRecovery() || 1 == userCertDO.getCertType()) {
                    userCertInfo.setEncSn(null);
                }
                Integer leftTime = 0;
                leftTime = (int)((userCertDO.getFailureTime().getTime() - System.currentTimeMillis()) / 86400000L);
                userCertInfo.setLeftValidity(leftTime);
                userCertInfo.setEffectiveTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(userCertDO.getEffectiveTime()));
                userCertInfo.setFailureTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(userCertDO.getFailureTime()));
                userCertInfos.add(userCertInfo);
            }
            result.setInfo(userCertInfos);
            return result;
        }
        catch (BeansException e) {
            throw new ServiceException("\u67e5\u8be2\u7528\u6237\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
    }

    public Result getUserCertBaseInfo(String certSn, String systemFLag) {
        CertBaseInfo certBaseInfo = new CertBaseInfo();
        UserCertDO userCertDO = this.userCertDao.getUserDetail(certSn);
        if (null == userCertDO) {
            return Result.failure((ErrorEnum)ErrorEnum.THE_SN_IS_INVALID);
        }
        boolean flag = this.baseUserDao.isAuthorize(systemFLag, Integer.valueOf(userCertDO.getUserId().intValue()));
        if (!flag) {
            return Result.failure((ErrorEnum)ErrorEnum.THE_CERT_IS_NOT_BELONG_TO_THE_SYSTEM);
        }
        BeanUtils.copyProperties((Object)userCertDO, (Object)certBaseInfo);
        certBaseInfo.setFailureTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(userCertDO.getFailureTime()));
        certBaseInfo.setEffectiveTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(userCertDO.getEffectiveTime()));
        CertTempDO certTempDO = this.certTempCache.getCertTempInfoByTempNo(userCertDO.getTempNo());
        certBaseInfo.setTempName(certTempDO.getTempName());
        Result result = this.caBusinessManager.getCertDetailInfoBySingSn(certSn);
        if (!result.isSuccess()) {
            return result;
        }
        JSONObject detail = JSONObject.parseObject((String)result.getInfo().toString());
        certBaseInfo.setVersion((String)detail.get((Object)"version"));
        certBaseInfo.setIssuerDn((String)detail.get((Object)"issuer"));
        certBaseInfo.setSubjectDn((String)detail.get((Object)"subject"));
        certBaseInfo.setSubjectPublicKeyInfo((String)detail.get((Object)"subjectPublicKeyInfo"));
        result.setInfo((Object)certBaseInfo);
        return result;
    }

    public Result downLoadUserCertFile(String signSn, String systemFlag) {
        Result x = this.checkSystem(signSn, systemFlag);
        if (x != null) {
            return x;
        }
        Result result = this.userCertService.exportUserDoubleCerts(signSn);
        List list = (List)result.getInfo();
        byte[] data = new byte[]{};
        try {
            data = ZipUtils.generateZipByte((List)list);
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51fazip\u538b\u7f29\u5305\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            return Result.failure((ErrorEnum)ErrorEnum.MAKE_ZIP_FILE_EXCEPTION);
        }
        result.setInfo((Object)data);
        return result;
    }

    public Result getUserCert(String signSn, String systemFlag) {
        Result x = this.checkSystem(signSn, systemFlag);
        if (x != null) {
            return x;
        }
        Result result = new Result();
        Result certDataInfoResult = this.caBusinessManager.downloadCertDataInfo(signSn, true);
        if (!certDataInfoResult.isSuccess()) {
            return certDataInfoResult;
        }
        Map map = (Map)certDataInfoResult.getInfo();
        UserCertStr userCertStr = new UserCertStr();
        userCertStr.setSignCert((String)map.get("signCert"));
        String encCert = (String)map.get("encCert");
        if (null != encCert) {
            userCertStr.setEncCert(encCert);
        }
        result.setInfo((Object)userCertStr);
        return result;
    }

    private Result checkSystem(String signSn, String systemFlag) {
        UserCertDO userCertDO = this.userCertDao.getUserCertBaseInfoBySignSn(signSn);
        if (null == userCertDO) {
            return Result.failure((ErrorEnum)ErrorEnum.THE_SN_IS_INVALID);
        }
        boolean flag = this.baseUserDao.isAuthorize(systemFlag, Integer.valueOf(userCertDO.getUserId().intValue()));
        if (!flag) {
            return Result.failure((ErrorEnum)ErrorEnum.THE_CERT_IS_NOT_BELONG_TO_THE_SYSTEM);
        }
        return null;
    }
}

