/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.kdc.service.util;

import java.io.ByteArrayInputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

public class CertUtil {
    public static final String CERT_HEAD = "-----BEGIN CERTIFICATE-----";
    public static final String CERT_TAIL = "-----END CERTIFICATE-----";

    public static X509Certificate getCertFromStr16(String str) {
        byte[] bs = CertUtil.hex2byte(str);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            ByteArrayInputStream inStream = new ByteArrayInputStream(bs);
            X509Certificate x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception e) {
            System.err.println("getCertFromFullStr error: " + e.toString());
            return null;
        }
    }

    public static byte[] hex2byte(String str) {
        if (null == str || str.equals("")) {
            return null;
        }
        StringBuffer sb = new StringBuffer(str = str.trim());
        int len = sb.length();
        if (len == 0 || len % 2 == 1) {
            return null;
        }
        byte[] b = new byte[len / 2];
        try {
            for (int i = 0; i < len; i += 2) {
                b[i / 2] = (byte)Integer.decode("0x" + sb.substring(i, i + 2)).intValue();
            }
            return b;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getPubKey(String str, int caAlg) {
        String pubKey;
        System.out.println("\u8fdb\u5165CertUtil->getPubKey: str:\n" + str);
        X509Certificate x509Cert = CertUtil.getCertFromStr(str);
        if (caAlg == 1) {
            RSAPublicKey rsa = (RSAPublicKey)x509Cert.getPublicKey();
            pubKey = rsa.getModulus().toString(16).toUpperCase();
        } else {
            ECPublicKey sm2 = (ECPublicKey)x509Cert.getPublicKey();
            pubKey = sm2.getW().getAffineX().toString(16) + "#" + sm2.getW().getAffineY().toString(16);
        }
        return pubKey;
    }

    public static X509Certificate getCertFromStr(String str) {
        str = str.replace(CERT_HEAD, "").replace(CERT_TAIL, "");
        str = str.replace("\r", "").replace("\n", "");
        X509Certificate x509Cert = CertUtil.getCertFromB64(str = str.replace("\\r", "").replace("\\n", ""));
        if (x509Cert == null) {
            x509Cert = CertUtil.getCertFromFullStr(str);
        }
        if (x509Cert == null) {
            x509Cert = CertUtil.getCertFromStr16(str);
        }
        return x509Cert;
    }

    public static X509Certificate getCertFromFullStr(String str) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            ByteArrayInputStream inStream = new ByteArrayInputStream(str.getBytes());
            X509Certificate x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception e) {
            System.err.println("getCertFromFullStr error: " + e.toString());
            return null;
        }
    }

    public static synchronized X509Certificate getCertFromB64(String b64) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            byte[] bsCert = Base64.decode((String)b64);
            ByteArrayInputStream inStream = new ByteArrayInputStream(bsCert);
            X509Certificate x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception e) {
            System.err.println("getCertFromB64 error: " + e.toString());
            return null;
        }
    }

    public static String getSn(X509Certificate cert) {
        return cert.getSerialNumber().toString(16).toLowerCase();
    }

    public static String certToFullB64(Certificate cert) {
        String certb64 = "";
        try {
            certb64 = CertUtil.bytesToFullB64(cert.getEncoded());
        }
        catch (Exception e) {
            System.err.println("certToFullB64 error:" + e.toString());
        }
        return certb64;
    }

    public static String bytesToFullB64(byte[] certder) {
        try {
            String certb64 = new String(Base64.encode((byte[])certder));
            certb64 = "-----BEGIN CERTIFICATE-----\n" + certb64 + "\n" + CERT_TAIL + "\n";
            return certb64;
        }
        catch (Exception e) {
            System.err.println("certDerToFullB64 error:" + e.toString());
            return null;
        }
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

