/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.kdc.service.util;

import com.xdja.safecenter.kdc.service.util.Sm4_context;

public class Sm4 {
    public static final byte[] keys = new byte[]{1, 35, 69, 100, -119, -85, -51, -17, -2, -36, -70, -104, 118, 84, 50, 16};
    private static final byte[][] SboxTable = new byte[][]{{-42, -112, -23, -2, -52, -31, 61, -73, 22, -74, 20, -62, 40, -5, 44, 5}, {43, 103, -102, 118, 42, -66, 4, -61, -86, 68, 19, 38, 73, -122, 6, -103}, {-100, 66, 80, -12, -111, -17, -104, 122, 51, 84, 11, 67, -19, -49, -84, 98}, {-28, -77, 28, -87, -55, 8, -24, -107, -128, -33, -108, -6, 117, -113, 63, -90}, {71, 7, -89, -4, -13, 115, 23, -70, -125, 89, 60, 25, -26, -123, 79, -88}, {104, 107, -127, -78, 113, 100, -38, -117, -8, -21, 15, 75, 112, 86, -99, 53}, {30, 36, 14, 94, 99, 88, -47, -94, 37, 34, 124, 59, 1, 33, 120, -121}, {-44, 0, 70, 87, -97, -45, 39, 82, 76, 54, 2, -25, -96, -60, -56, -98}, {-22, -65, -118, -46, 64, -57, 56, -75, -93, -9, -14, -50, -7, 97, 21, -95}, {-32, -82, 93, -92, -101, 52, 26, 85, -83, -109, 50, 48, -11, -116, -79, -29}, {29, -10, -30, 46, -126, 102, -54, 96, -64, 41, 35, -85, 13, 83, 78, 111}, {-43, -37, 55, 69, -34, -3, -114, 47, 3, -1, 106, 114, 109, 108, 91, 81}, {-115, 27, -81, -110, -69, -35, -68, 127, 17, -39, 92, 65, 31, 16, 90, -40}, {10, -63, 49, -120, -91, -51, 123, -67, 45, 116, -48, 18, -72, -27, -76, -80}, {-119, 105, -105, 74, 12, -106, 119, 126, 101, -71, -15, 9, -59, 110, -58, -124}, {24, -16, 125, -20, 58, -36, 77, 32, 121, -18, 95, 62, -41, -53, 57, 72}};
    private static int[] FK = new int[]{-1548633402, 1453994832, 1736282519, -1301273892};
    private static int[] CK = new int[]{462357, 472066609, 943670861, 1415275113, 1886879365, -1936483679, -1464879427, -993275175, -521670923, -66909679, 404694573, 876298825, 1347903077, 1819507329, -2003855715, -1532251463, -1060647211, -589042959, -117504499, 337322537, 808926789, 1280531041, 1752135293, -2071227751, -1599623499, -1128019247, -656414995, -184876535, 269950501, 741554753, 1213159005, 1684763257};

    private static int GET_ULONG_BE(byte[] b, int pos) {
        return b[pos] << 24 & 0xFF000000 | b[pos + 1] << 16 & 0xFF0000 | b[pos + 2] << 8 & 0xFF00 | b[pos + 3] & 0xFF;
    }

    private static void PUT_ULONG_BE(int n, byte[] b, int pos) {
        b[pos] = (byte)(n >> 24);
        b[pos + 1] = (byte)(n >> 16);
        b[pos + 2] = (byte)(n >> 8);
        b[pos + 3] = (byte)n;
    }

    private static int SHL(int x, int n) {
        return (x & 0xFFFFFFFF) << n;
    }

    private static int ROTL(int x, int n) {
        return Sm4.SHL(x, n) | x >>> 32 - n;
    }

    private static byte sm4Sbox(byte inch) {
        return SboxTable[(inch & 0xF0) >> 4][inch & 0xF];
    }

    private static int T(int ka) {
        int bb = 0;
        int c = 0;
        byte[] a = new byte[4];
        Sm4.PUT_ULONG_BE(ka, a, 0);
        byte[] b = Sm4.t(a);
        bb = Sm4.GET_ULONG_BE(b, 0);
        c = Sm4.L(bb);
        return c;
    }

    private static int L(int bb) {
        int c = bb ^ Sm4.ROTL(bb, 2) ^ Sm4.ROTL(bb, 10) ^ Sm4.ROTL(bb, 18) ^ Sm4.ROTL(bb, 24);
        return c;
    }

    private static byte[] t(byte[] a) {
        byte[] b = new byte[]{Sm4.sm4Sbox(a[0]), Sm4.sm4Sbox(a[1]), Sm4.sm4Sbox(a[2]), Sm4.sm4Sbox(a[3])};
        return b;
    }

    private static int sm4F(int x0, int x1, int x2, int x3, int rk) {
        return x0 ^ Sm4.T(x1 ^ x2 ^ x3 ^ rk);
    }

    private static int T2(int ka) {
        int bb = 0;
        int rk = 0;
        byte[] a = new byte[4];
        byte[] b = new byte[4];
        Sm4.PUT_ULONG_BE(ka, a, 0);
        b = Sm4.t(a);
        bb = Sm4.GET_ULONG_BE(b, 0);
        rk = Sm4.L2(bb);
        return rk;
    }

    private static int L2(int bb) {
        int rk = bb ^ Sm4.ROTL(bb, 13) ^ Sm4.ROTL(bb, 23);
        return rk;
    }

    private static void sm4_setkey(int[] SK, byte[] key) {
        int[] MK = new int[4];
        int[] k = new int[36];
        MK[0] = Sm4.GET_ULONG_BE(key, 0);
        MK[1] = Sm4.GET_ULONG_BE(key, 4);
        MK[2] = Sm4.GET_ULONG_BE(key, 8);
        MK[3] = Sm4.GET_ULONG_BE(key, 12);
        k[0] = MK[0] ^ FK[0];
        k[1] = MK[1] ^ FK[1];
        k[2] = MK[2] ^ FK[2];
        k[3] = MK[3] ^ FK[3];
        for (int i = 0; i < 32; ++i) {
            k[i + 4] = k[i] ^ Sm4.T2(k[i + 1] ^ k[i + 2] ^ k[i + 3] ^ CK[i]);
            SK[i] = k[i + 4];
        }
    }

    private static void sm4_one_round(int[] sk, byte[] input, byte[] output, int pos) {
        int[] ulbuf = new int[36];
        ulbuf[0] = Sm4.GET_ULONG_BE(input, pos + 0);
        ulbuf[1] = Sm4.GET_ULONG_BE(input, pos + 4);
        ulbuf[2] = Sm4.GET_ULONG_BE(input, pos + 8);
        ulbuf[3] = Sm4.GET_ULONG_BE(input, pos + 12);
        for (int i = 0; i < 32; ++i) {
            ulbuf[i + 4] = Sm4.sm4F(ulbuf[i], ulbuf[i + 1], ulbuf[i + 2], ulbuf[i + 3], sk[i]);
        }
        Sm4.PUT_ULONG_BE(ulbuf[35], output, pos + 0);
        Sm4.PUT_ULONG_BE(ulbuf[34], output, pos + 4);
        Sm4.PUT_ULONG_BE(ulbuf[33], output, pos + 8);
        Sm4.PUT_ULONG_BE(ulbuf[32], output, pos + 12);
    }

    private static void sm4_setkey_enc(Sm4_context ctx, byte[] key) {
        ctx.mode = 1;
        Sm4.sm4_setkey(ctx.sk, key);
    }

    private static void sm4_setkey_dec(Sm4_context ctx, byte[] key) {
        ctx.mode = 1;
        Sm4.sm4_setkey(ctx.sk, key);
        for (int i = 0; i < ctx.sk.length / 2; ++i) {
            int tmp = ctx.sk[i];
            ctx.sk[i] = ctx.sk[31 - i];
            ctx.sk[31 - i] = tmp;
        }
    }

    private static void sm4_crypt_ecb(Sm4_context ctx, int length, byte[] input, byte[] output) {
        for (int i = 0; i < length; i += 16) {
            Sm4.sm4_one_round(ctx.sk, input, output, i);
        }
    }

    public static byte[] sm4_encrypt_ecb_fill(byte[] key, byte[] plain) {
        if (key == null || key.length != 16) {
            throw new IllegalArgumentException("key can't be null, and len must 16 bytes");
        }
        if (plain == null || plain.length == 0) {
            throw new IllegalArgumentException("plain can't be null");
        }
        int padLen = 16 - plain.length % 16;
        byte[] padPlain = new byte[plain.length + padLen];
        System.arraycopy(plain, 0, padPlain, 0, plain.length);
        for (int i = 0; i < padLen; ++i) {
            padPlain[plain.length + i] = (byte)(padLen - 1);
        }
        byte[] secure = new byte[padPlain.length];
        Sm4_context ctx = new Sm4_context();
        Sm4.sm4_setkey_enc(ctx, key);
        Sm4.sm4_crypt_ecb(ctx, padPlain.length, padPlain, secure);
        return secure;
    }

    public static byte[] sm4_encrypt_ecb(byte[] key, byte[] plain) {
        if (key == null || key.length != 16) {
            throw new IllegalArgumentException("key can't be null, and len must 16 bytes");
        }
        if (plain == null || plain.length == 0) {
            throw new IllegalArgumentException("plain can't be null");
        }
        if (plain.length % 16 != 0) {
            throw new IllegalArgumentException("plain len must 16 bytes");
        }
        byte[] secure = new byte[plain.length];
        Sm4_context ctx = new Sm4_context();
        Sm4.sm4_setkey_enc(ctx, key);
        Sm4.sm4_crypt_ecb(ctx, plain.length, plain, secure);
        return secure;
    }

    public static byte[] sm4_decrypt_ecb_fill(byte[] key, byte[] secure) {
        if (key == null || key.length != 16) {
            throw new IllegalArgumentException("key can't be null, and len must 16 bytes");
        }
        if (secure == null || secure.length % 16 != 0) {
            throw new IllegalArgumentException("secure can't be null, and must multiple of 16");
        }
        byte[] padPlain = new byte[secure.length];
        Sm4_context ctx = new Sm4_context();
        Sm4.sm4_setkey_dec(ctx, key);
        Sm4.sm4_crypt_ecb(ctx, secure.length, secure, padPlain);
        int padLen = padPlain[padPlain.length - 1] + 1;
        if (padLen < 1 || padLen > 16 || padPlain.length < padLen) {
            return null;
        }
        byte[] plain = new byte[padPlain.length - padLen];
        System.arraycopy(padPlain, 0, plain, 0, plain.length);
        return plain;
    }

    public static byte[] sm4_decrypt_ecb(byte[] key, byte[] secure) {
        if (key == null || key.length != 16) {
            throw new IllegalArgumentException("key can't be null, and len must 16 bytes");
        }
        if (secure == null || secure.length % 16 != 0) {
            throw new IllegalArgumentException("secure can't be null, and must multiple of 16");
        }
        byte[] padPlain = new byte[secure.length];
        Sm4_context ctx = new Sm4_context();
        Sm4.sm4_setkey_dec(ctx, key);
        Sm4.sm4_crypt_ecb(ctx, secure.length, secure, padPlain);
        return padPlain;
    }
}

