/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.kdc.service.impl;

import com.xdja.cssp.sm2cipher.sm2.cipher.SM2CipherImpl;
import com.xdja.cssp.sm2cipher.sm2.cipher.SM3Digest;
import com.xdja.safecenter.kdc.service.IKdcService;
import com.xdja.safecenter.kdc.service.constants.ALG_TYPE;
import com.xdja.safecenter.kdc.service.constants.KEY_TYPE;
import com.xdja.safecenter.kdc.service.util.Sm4;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class KdcServiceImpl
implements IKdcService {
    Logger logger = LoggerFactory.getLogger(KdcServiceImpl.class);

    public Map<String, byte[]> generateKey(int keyType, int length, byte[] enceyptKey) {
        byte[] key = this.createKey(length);
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        if (keyType == KEY_TYPE.uKey.value) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < key.length; ++i) {
                sb.append(key[i]).append(" ");
            }
            this.logger.info("\u660e\u6587 key \u7684\u957f\u5ea6" + key.length + ";  \u5185\u5bb9\u4e3a\uff1a" + sb.toString());
            System.out.println("\u660e\u6587 key \u7684\u957f\u5ea6" + key.length + ";  \u5185\u5bb9\u4e3a\uff1a" + sb.toString());
            byte[] eKey = this.encryptWithSM2(new String(enceyptKey), key);
            sb = new StringBuilder();
            for (int i = 0; i < eKey.length; ++i) {
                sb.append(eKey[i]).append(" ");
            }
            this.logger.info("\u52a0\u5bc6\u540e key \u7684\u957f\u5ea6" + eKey.length + ";  \u5185\u5bb9\u4e3a\uff1a" + sb.toString());
            System.out.println("\u52a0\u5bc6\u540e key \u7684\u957f\u5ea6" + eKey.length + ";  \u5185\u5bb9\u4e3a\uff1a" + sb.toString());
            byte[] encryptKey = Base64.encode((byte[])eKey);
            byte[] hash = this.hashBySM3(key);
            map.put("key", encryptKey);
            map.put("hash", hash);
            map.put("plainKey", Base64.encode((byte[])key));
            return map;
        }
        if (keyType == KEY_TYPE.sKey.value) {
            byte[] userKey = Base64.decode((byte[])enceyptKey);
            byte[] encryptKey = Base64.encode((byte[])Sm4.sm4_encrypt_ecb((byte[])userKey, (byte[])key));
            byte[] hash = this.hashBySM3(key);
            map.put("key", encryptKey);
            map.put("hash", hash);
            return map;
        }
        return null;
    }

    public String decryptUserCode(byte[] key, byte[] data) {
        byte[] decryptKey = Base64.decode((byte[])key);
        byte[] plainByte = this.decrypt(ALG_TYPE.sm4.value, decryptKey, Base64.decode((byte[])data));
        return new String(plainByte);
    }

    public byte[] encrypt(int algType, byte[] key, byte[] data) {
        if (algType == ALG_TYPE.sm4.value) {
            return Sm4.sm4_encrypt_ecb((byte[])key, (byte[])data);
        }
        if (algType == ALG_TYPE.sm2.value) {
            return this.encryptWithSM2(new String(key), data);
        }
        return new byte[0];
    }

    public byte[] decrypt(int algType, byte[] key, byte[] data) {
        if (algType == ALG_TYPE.sm4.value) {
            return Sm4.sm4_decrypt_ecb((byte[])key, (byte[])data);
        }
        if (algType == ALG_TYPE.sm2.value) {
            return this.decryptWithSM2(new String(key), data);
        }
        return new byte[0];
    }

    private byte[] encryptWithSM2(String key, byte[] data) {
        SM2CipherImpl cipher = new SM2CipherImpl();
        return cipher.encrypt(key, data);
    }

    private byte[] decryptWithSM2(String key, byte[] data) {
        SM2CipherImpl cipher = new SM2CipherImpl();
        return cipher.decrypt(key, data);
    }

    private byte[] createKey(int length) {
        byte[] randomByte = new byte[length];
        SecureRandom random = null;
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
            random.nextBytes(randomByte);
            return randomByte;
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    private byte[] hashBySHA1(byte[] data) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        byte[] sh1Byte = md.digest(data);
        return sh1Byte;
    }

    public byte[] hashBySM3(byte[] data) {
        SM3Digest digest = new SM3Digest();
        digest.update(data);
        byte[] hashData = digest.doFinal();
        return Base64.encode((byte[])hashData);
    }

    public static void main(String[] args) {
        KdcServiceImpl service = new KdcServiceImpl();
        String key = "IS3TdPobVgkzCLbw5Hhk3Q==";
        String plain = "11111111||123||88888888";
        byte[] s = Sm4.sm4_encrypt_ecb((byte[])Base64.decode((byte[])key.getBytes()), (byte[])plain.getBytes());
        service.decryptUserCode(key.getBytes(), "WHZ3ljKLubyVglDHTK1s/MMm7WdvKc5V93nhSjSpuLI=".getBytes());
    }
}

