/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.controller;

import com.xdja.platform.common.lite.kit.json.JSONException;
import com.xdja.platform.common.lite.kit.json.JsonMapper;
import com.xdja.safecenter.secret.controller.ErrorMessage;
import com.xdja.safecenter.secret.controller.HttpError;
import com.xdja.safecenter.secret.core.util.LogUtil;
import com.xdja.safecenter.secret.provider.verfiy.IVerifyProvider;
import com.xdja.safecenter.secret.struct.SourceDataStruct;
import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestHeader;

public abstract class AbstractController {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IVerifyProvider provider;
    protected HttpSession session;

    @ModelAttribute
    public void setModelAttribute(HttpServletRequest request, HttpServletResponse response, @RequestHeader String appID, @RequestHeader String chipID, @RequestHeader String SN) {
        this.session = request.getSession();
    }

    protected final void renderError(HttpServletResponse response, HttpError error) {
        ErrorMessage msg = error.handle(response);
        try {
            this.logger.error(JsonMapper.alwaysMapper().toJson((Object)msg));
            response.getWriter().println(JsonMapper.alwaysMapper().toJson((Object)msg));
        }
        catch (IOException e) {
            this.logger.error("\u6253\u5f00HttpServletResponse\u7684writer\u5931\u8d25\uff0c\u53ef\u80fd\u8fde\u63a5\u5df2\u7ecf\u5173\u95ed", (Throwable)e);
        }
        catch (JSONException e) {
            this.logger.error("\u8f6c\u6362\u5f02\u5e38\u4fe1\u606f\u4e3ajson\u4e32\u65f6\u5931\u8d25", (Throwable)e);
        }
    }

    protected final boolean verifyWithSN(SourceDataStruct sourceData) {
        if (this.provider.verifyWithSN(sourceData.getInfo(), sourceData.getSd(), sourceData.getSalg(), sourceData.getSkeyID())) {
            return true;
        }
        this.logger.error("\u5143\u6570\u636e\u3010{}\u3011\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25\uff0c\u7b7e\u540d\u503c\u3010{}\u3011\uff0c\u7b7e\u540d\u7b97\u6cd5\u3010{}\u3011\uff0c\u7b7e\u540d\u8bc1\u4e66SN\u3010{}\u3011", new Object[]{sourceData.getInfo(), sourceData.getSd(), sourceData.getSalg(), sourceData.getSkeyID()});
        return false;
    }

    protected final boolean verifyWithSyncPubK(SourceDataStruct sourceData, String appID, String sn) {
        if (this.provider.verifyWithSyncPK(sourceData.getInfo(), sourceData.getSd(), sourceData.getSalg(), sourceData.getSkeyID(), appID, sn)) {
            return true;
        }
        this.logger.error("\u5143\u6570\u636e\u3010{}\u3011\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25\uff0c\u7b7e\u540d\u503c\u3010{}\u3011\uff0c\u7b7e\u540d\u7b97\u6cd5\u3010{}\u3011\uff0c\u7b7e\u540d\u5bc6\u94a5ID\u3010{}\u3011", new Object[]{sourceData.getInfo(), sourceData.getSd(), sourceData.getSalg(), sourceData.getSkeyID()});
        return false;
    }

    protected final boolean verifyWithSyncPubKData(SourceDataStruct sourceData, String syncPubKeyData) {
        if (this.provider.verifyWithSyncPKData(sourceData.getInfo(), sourceData.getSd(), sourceData.getSalg(), syncPubKeyData)) {
            return true;
        }
        this.logger.error("\u5143\u6570\u636e\u3010{}\u3011\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25\uff0c\u7b7e\u540d\u503c\u3010{}\u3011\uff0c\u7b7e\u540d\u7b97\u6cd5\u3010{}\u3011\uff0c\u516c\u94a5\u3010{}\u3011", new Object[]{sourceData.getInfo(), sourceData.getSd(), sourceData.getSalg(), syncPubKeyData});
        return false;
    }

    protected final SourceDataStruct convertToStruct(String structJsonStr) {
        return SourceDataStruct.fromJsonStr((String)structJsonStr);
    }

    protected String getChipID(HttpServletRequest request) {
        return request == null ? "" : request.getHeader("chipID");
    }

    protected String getAppID(HttpServletRequest request) {
        return request == null ? "" : request.getHeader("appID");
    }

    protected String getSN(HttpServletRequest request) {
        return request == null ? "" : request.getHeader("SN");
    }

    protected String format(HttpServletRequest request, String entityId, String groupId, String msg) {
        return LogUtil.formatLog((String)this.getAppID(request), (String)this.getSN(request), (String)entityId, (String)groupId, (String)msg);
    }

    protected String getCardId(HttpServletRequest request) {
        return request == null ? "" : request.getHeader("cardId");
    }

    protected String getSn(HttpServletRequest request) {
        return request == null ? "" : request.getHeader("sn");
    }
}

