/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.controller.v2.backup;

import com.xdja.log.analysis.aop.annoation.AopLog;
import com.xdja.platform.common.lite.kit.json.JSONException;
import com.xdja.safecenter.secret.controller.AbstractController;
import com.xdja.safecenter.secret.controller.HttpError;
import com.xdja.safecenter.secret.provider.backup.BackupProvider;
import com.xdja.safecenter.secret.provider.backup.bean.ResultBean;
import com.xdja.safecenter.secret.struct.SourceDataStruct;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class BackupController
extends AbstractController {
    @Autowired
    private BackupProvider backupProvider;

    @AopLog
    @RequestMapping(value={"/api/v2/backup/bind"}, consumes={"application/json"}, method={RequestMethod.GET})
    public Object queryBindBackupCard(HttpServletRequest req, HttpServletResponse resp) {
        this.logger.debug("\u6536\u5230\u67e5\u8be2\u8bbe\u5907\u5df2\u7ed1\u5b9a\u5907\u4efd\u5361\u8bf7\u6c42");
        String chipSn = this.getSn(req);
        if (StringUtils.isBlank((CharSequence)chipSn)) {
            return HttpError.MISSING_REQUIRED_PARAMETERS.handle(resp);
        }
        String sn = this.backupProvider.querySnByChipSn(chipSn);
        if (StringUtils.isBlank((CharSequence)sn)) {
            this.logger.debug("{}\u672a\u7ed1\u5b9a\u5907\u4efd\u5361", (Object)chipSn);
            return HttpError.NOT_BIND_BACKUP_CARD.handle(resp);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("sn", sn);
        this.logger.debug("\u67e5\u8be2\u8bbe\u5907\u5df2\u7ed1\u5b9a\u5907\u4efd\u5361\u6267\u884c\u5b8c\u6210");
        return result;
    }

    @AopLog
    @RequestMapping(value={"/api/v2/backup/check/{bSn}/{bCode}/status"}, consumes={"application/json"}, method={RequestMethod.GET})
    public Object checkBackupCardStatus(@PathVariable(value="bSn") String bSn, @PathVariable(value="bCode") String bCode, HttpServletResponse resp) {
        this.logger.debug("\u6536\u5230\u68c0\u6d4b\u5907\u4efd\u5361\u72b6\u6001\u8bf7\u6c42");
        if (StringUtils.isBlank((CharSequence)bSn) || StringUtils.isBlank((CharSequence)bCode)) {
            return HttpError.ILLEGAL_REQUEST_PARAMETER.handle(resp);
        }
        ResultBean result = this.backupProvider.checkBackupCardStatus(bSn, bCode);
        switch (result.getCode()) {
            case 2: {
                this.logger.debug("{}\u5907\u4efd\u5361\u72b6\u6001\u68c0\u6d4b\u7ed3\u679c\uff1a\u5907\u4efd\u5361\u4e0d\u5b58\u5728", (Object)bSn);
                return HttpError.BACKUP_CARD_NOT_EXIST.handle(resp);
            }
            case 3: {
                this.logger.debug("{}\u5907\u4efd\u5361\u72b6\u6001\u68c0\u6d4b\u7ed3\u679c\uff1a\u65e0\u6548\u7684\u5907\u4efd\u5361", (Object)bSn);
                return HttpError.INVALID_BACKUP_CARD.handle(resp);
            }
            case 4: {
                this.logger.debug("{}\u5907\u4efd\u5361\u72b6\u6001\u68c0\u6d4b\u7ed3\u679c\uff1a\u5907\u4efd\u5361\u5df2\u4f7f\u7528", (Object)bSn);
                return HttpError.BACKUP_CARD_ALREADY_USE.handle(resp);
            }
            case 5: {
                this.logger.debug("{}\u5907\u4efd\u5361\u72b6\u6001\u68c0\u6d4b\u7ed3\u679c\uff1a\u6821\u9a8c\u7801\u4e0d\u4e00\u81f4", (Object)bSn);
                return HttpError.CHECK_CODE_DISACCORD.handle(resp);
            }
        }
        this.logger.debug("\u68c0\u6d4b\u5907\u4efd\u5361\u72b6\u6001\u8bf7\u6c42\u6267\u884c\u5b8c\u6210");
        return result.getInfo();
    }

    @AopLog
    @RequestMapping(value={"/api/v2/backup/upload/kek"}, consumes={"application/json"}, method={RequestMethod.POST})
    public Object uploadKek(@RequestBody SourceDataStruct baKek, HttpServletResponse resp) throws JSONException {
        this.logger.debug("\u6536\u5230\u4e0a\u4f20\u5907\u4efd\u5361\u516c\u94a5\u52a0\u5bc6Kek\u8bf7\u6c42");
        if (null == baKek) {
            return HttpError.ILLEGAL_REQUEST_PARAMETER.handle(resp);
        }
        if (!this.verifyWithSN(baKek)) {
            return HttpError.VERIFY_WITH_CHIP_ERROR.handle(resp);
        }
        int result = this.backupProvider.doUploadKek(baKek);
        switch (result) {
            case 2: {
                this.logger.debug("\u4e0a\u4f20\u5907\u4efd\u5361\u516c\u94a5\u52a0\u5bc6\u7684kek\uff1a\u5907\u4efd\u5361\u4e0d\u5b58\u5728");
                return HttpError.BACKUP_CARD_NOT_EXIST.handle(resp);
            }
            case 3: {
                this.logger.debug("\u4e0a\u4f20\u5907\u4efd\u5361\u516c\u94a5\u52a0\u5bc6\u7684kek\uff1a\u65e0\u6548\u7684\u5907\u4efd\u5361");
                return HttpError.INVALID_BACKUP_CARD.handle(resp);
            }
            case 4: {
                this.logger.debug("\u4e0a\u4f20\u5907\u4efd\u5361\u516c\u94a5\u52a0\u5bc6\u7684kek\uff1a\u5907\u4efd\u5361\u5df2\u4f7f\u7528");
                return HttpError.BACKUP_CARD_ALREADY_USE.handle(resp);
            }
        }
        this.logger.debug("\u4e0a\u4f20\u5907\u4efd\u5361\u516c\u94a5\u52a0\u5bc6Kek\u8bf7\u6c42\u6267\u884c\u5b8c\u6210");
        return null;
    }

    @AopLog
    @RequestMapping(value={"/api/v2/backup/unbind"}, consumes={"application/json"}, method={RequestMethod.POST})
    public Object unbindBackupCard(@RequestBody SourceDataStruct unbindInfo, HttpServletRequest req, HttpServletResponse resp) throws JSONException {
        this.logger.debug("\u6536\u5230\u89e3\u7ed1\u5907\u4efd\u5361\u8bf7\u6c42");
        if (null == unbindInfo) {
            return HttpError.ILLEGAL_REQUEST_PARAMETER.handle(resp);
        }
        if (!this.verifyWithSN(unbindInfo)) {
            return HttpError.VERIFY_WITH_CHIP_ERROR.handle(resp);
        }
        int result = this.backupProvider.unbindBackupCard(unbindInfo);
        switch (result) {
            case 2: {
                this.logger.debug("\u89e3\u7ed1\u5907\u4efd\u5361\u7ed3\u679c\uff1a\u5907\u4efd\u5361\u4e0d\u5b58\u5728");
                return HttpError.BACKUP_CARD_NOT_EXIST.handle(resp);
            }
            case 6: {
                this.logger.debug("\u89e3\u7ed1\u5907\u4efd\u5361\u7ed3\u679c\uff1a\u5907\u4efd\u5361\u672a\u4f7f\u7528");
                return HttpError.BACKUP_CARD_NOT_USE.handle(resp);
            }
            case 7: {
                this.logger.debug("\u89e3\u7ed1\u5907\u4efd\u5361\u7ed3\u679c\uff1a\u672a\u7ed1\u5b9a\u5907\u4efd\u5361");
                return HttpError.NOT_BIND_BACKUP_CARD.handle(resp);
            }
        }
        this.logger.debug("\u89e3\u7ed1\u5907\u4efd\u5361\u8bf7\u6c42\u6267\u884c\u5b8c\u6210");
        return null;
    }
}

