/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.controller.v2.chipcert;

import com.xdja.log.analysis.aop.annoation.AopLog;
import com.xdja.safecenter.secret.controller.AbstractController;
import com.xdja.safecenter.secret.controller.HttpError;
import com.xdja.safecenter.secret.core.verify.VerifyUtil;
import com.xdja.safecenter.secret.provider.chipCert.IChipCertProvider;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ChipCertController
extends AbstractController {
    @Resource
    protected IChipCertProvider provider;

    @AopLog
    @RequestMapping(value={"/api/v2/certs/"}, consumes={"application/json"}, method={RequestMethod.POST})
    public Object query(HttpServletResponse resp, @RequestBody(required=true) Map<String, String> snMap) {
        if (VerifyUtil.isEmpty(snMap)) {
            this.logger.error("\u67e5\u8be2\u7b7e\u540d\u8bc1\u4e66\u65f6\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
            return HttpError.MISSING_REQUIRED_PARAMETERS.handle(resp);
        }
        return this.queryCerts(resp, snMap);
    }

    protected Object queryCerts(HttpServletResponse resp, @RequestBody(required=true) Map<String, String> snMap) {
        try {
            Map map = this.provider.queryCertsBySN(snMap);
            if (map == null || map.isEmpty()) {
                this.logger.error("\u672a\u67e5\u8be2\u5230\u7b7e\u540d\u8bc1\u4e66\uff0c\u8bf7\u6c42sn:{}", snMap);
                return HttpError.CERT_NOT_EXIST.handle(resp);
            }
            return map;
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u7b7e\u540d\u8bc1\u4e66\u65f6\u8c03\u7528rpc\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            return HttpError.SERVER_INTERNAL_EXCEPTION.handle(resp);
        }
    }
}

