/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.controller.v2.ciphermeta;

import com.xdja.log.analysis.aop.annoation.AopLog;
import com.xdja.platform.common.lite.kit.StrKit;
import com.xdja.platform.common.lite.kit.json.JSONException;
import com.xdja.platform.common.lite.kit.json.JsonMapper;
import com.xdja.safecenter.secret.controller.AbstractController;
import com.xdja.safecenter.secret.controller.HttpError;
import com.xdja.safecenter.secret.core.verify.VerifyUtil;
import com.xdja.safecenter.secret.provider.cellgroup.IEntityProvider;
import com.xdja.safecenter.secret.provider.ciphermeta.ICipherMetaProvider;
import com.xdja.safecenter.secret.provider.partygroup.IPartyGroupProvider;
import com.xdja.safecenter.secret.struct.SourceDataStruct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CipherMetaController
extends AbstractController {
    @Resource
    private ICipherMetaProvider provider;
    @Resource
    private IEntityProvider entityProvider;
    @Resource
    private IPartyGroupProvider partyGroupProvider;

    @AopLog
    @RequestMapping(value={"/api/v2/cipherMetas"}, consumes={"application/json"}, method={RequestMethod.POST})
    public Object uploadCipherMeta(HttpServletRequest request, HttpServletResponse resp, @RequestBody(required=true) SourceDataStruct sourceData) throws JSONException {
        String sn;
        if (VerifyUtil.hasNull((Object)sourceData)) {
            return HttpError.MISSING_REQUIRED_PARAMETERS.handle(resp);
        }
        String appID = this.getAppID(request);
        if (!this.verifyWithSyncPubK(sourceData, appID, sn = this.getSN(request))) {
            return HttpError.VERIFY_WITH_SYNCPUB_ERROR.handle(resp);
        }
        Map map = (Map)JsonMapper.alwaysMapper().fromJson(sourceData.getInfo(), HashMap.class);
        String pgID = (String)map.get("pgID");
        String currAppID = (String)map.get("appID");
        if (!appID.equals(currAppID)) {
            this.logger.error("\u8bf7\u6c42\u53c2\u6570\u4e2d \u5e94\u7528ID\u3010{}\u3011 \u4e0e\u5143\u6570\u636e\u4e2d\u5e94\u7528ID\u3010{}\u3011\u4e0d\u4e00\u81f4", (Object)appID, (Object)currAppID);
            return HttpError.ILLEGAL_REQUEST_PARAMETER.handle(resp);
        }
        List cgids = this.entityProvider.queryEntityIDs(currAppID, sn);
        if (null == cgids || cgids.isEmpty()) {
            this.logger.error("\u82af\u7247\u3010{}\u3011\u5728\u5e94\u7528\u3010{}\u3011\u4e2d\u4e0d\u5c5e\u4e8e\u4efb\u4f55Entity", (Object)sn, (Object)appID);
            return HttpError.OPERATE_DEVICE_NOT_IN_ENTITY.handle(resp);
        }
        List pcgIDs = this.partyGroupProvider.queryEntityIDsByPartyGroupID(pgID);
        if (pcgIDs != null && !pcgIDs.isEmpty()) {
            for (String entityID : cgids) {
                if (!pcgIDs.contains(entityID)) continue;
                long index = this.provider.saveCipherMeta(sourceData.toString());
                this.logger.info(this.format(request, entityID, pgID, "\u4e0a\u4f20\u5bc6\u6587\u5143\u6570\u636e\u3010" + index + "\u3011"));
                return index;
            }
        }
        this.logger.error("\u82af\u7247\u3010{}\u3011\u5728\u5e94\u7528\u3010{}\u3011\u4e2d\u6240\u5c5e\u7684Entity\u4e0d\u662fPartyGroup\u3010{}\u3011\u7684\u6210\u5458", new Object[]{sn, appID, pgID});
        return HttpError.OPERATE_ENTITY_NOT_IN_PARTYGROUP.handle(resp);
    }

    @AopLog
    @RequestMapping(value={"/api/v2/cipherMetas/{id}"}, method={RequestMethod.GET})
    public Object getCipherMeta(HttpServletRequest request, HttpServletResponse resp, @PathVariable(value="id") Long cipherMetaID) {
        String cipherMetaData = this.provider.get(cipherMetaID.longValue());
        if (StrKit.isBlank((String)cipherMetaData)) {
            return HttpError.META_NOT_EXIST.handle(resp);
        }
        this.logger.info(this.format(request, null, null, "\u83b7\u53d6\u5bc6\u6587\u5143\u6570\u636e\u3010" + cipherMetaID + "\u3011"));
        return this.convertToStruct(cipherMetaData);
    }
}

