/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.controller.v2.entity;

import com.xdja.log.analysis.aop.annoation.AopLog;
import com.xdja.platform.common.lite.kit.json.JSONException;
import com.xdja.platform.common.lite.kit.json.JsonMapper;
import com.xdja.safecenter.ckms.opcode.OpCodeFactory;
import com.xdja.safecenter.secret.controller.AbstractController;
import com.xdja.safecenter.secret.controller.HttpError;
import com.xdja.safecenter.secret.core.verify.VerifyUtil;
import com.xdja.safecenter.secret.provider.cellgroup.IEntityProvider;
import com.xdja.safecenter.secret.provider.cellgroup.bean.request.CreateDeviceAddRequestReq;
import com.xdja.safecenter.secret.provider.cellgroup.bean.request.CreateEntityReq;
import com.xdja.safecenter.secret.provider.cellgroup.bean.request.DestroyEntityReq;
import com.xdja.safecenter.secret.provider.cellgroup.bean.request.DeviceAddReq;
import com.xdja.safecenter.secret.provider.cellgroup.bean.request.DeviceForceAddReq;
import com.xdja.safecenter.secret.provider.cellgroup.bean.request.DeviceSyncWKReq;
import com.xdja.safecenter.secret.provider.cellgroup.bean.request.GetDeviceAddReq;
import com.xdja.safecenter.secret.provider.cellgroup.bean.request.QuitEntityReq;
import com.xdja.safecenter.secret.provider.cellgroup.bean.request.RemoveDeviceReq;
import com.xdja.safecenter.secret.provider.cellgroup.bean.response.GetEntityResp;
import com.xdja.safecenter.secret.provider.cellgroup.bean.response.GetSyncPairResp;
import com.xdja.safecenter.secret.provider.open.IOpenServiceProvider;
import com.xdja.safecenter.secret.provider.todo.ITodoProvider;
import com.xdja.safecenter.secret.struct.SourceDataStruct;
import com.xdja.safecenter.secret.struct.v2.CellGroupStruct;
import com.xdja.safecenter.secret.struct.v2.DestroyInfo;
import com.xdja.safecenter.secret.struct.v2.QuitInfo;
import com.xdja.safecenter.secret.struct.v2.ReqAddCellGroup;
import com.xdja.safecenter.secret.struct.v2.ReqSyncWrapKey;
import com.xdja.safecenter.secret.struct.v2.SyncPubKey;
import com.xdja.safecenter.secret.struct.v2.SyncedWrapKey;
import com.xdja.safecenter.secret.struct.v2.WrapKey;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class EntityController
extends AbstractController {
    private static final String ORIGIN_VERSION = "0";
    @Resource
    protected IEntityProvider EntityProvider;
    @Resource
    protected ITodoProvider TodoProvider;
    @Resource
    protected IOpenServiceProvider opCodeProvider;

    @AopLog
    @RequestMapping(value={"/api/v2/entities/id"}, consumes={"application/json"}, method={RequestMethod.POST})
    public Object getEntities(HttpServletRequest request, @RequestBody List<String> snList) {
        this.logger.info(this.format(request, null, null, "\u83b7\u53d6Entity\u5217\u8868"));
        return this.EntityProvider.getEntitiesBySnAndAppId(snList, this.getAppID(request));
    }

    @AopLog
    @RequestMapping(value={"/api/v2/entities"}, consumes={"application/json"}, method={RequestMethod.POST})
    public void createEntity(HttpServletRequest request, HttpServletResponse response, @RequestBody CreateEntityReq req) throws JSONException {
        String sn = this.getSN(request);
        String appId = this.getAppID(request);
        String chipId = this.getChipID(request);
        SourceDataStruct cellGroup = req.getCellGroup();
        CellGroupStruct cellGroupStruct = (CellGroupStruct)JsonMapper.alwaysMapper().fromJson(cellGroup.getInfo(), CellGroupStruct.class);
        if (!this.opCodeProvider.verifySign(this.getAppID(request), OpCodeFactory.Coder().createEntity(sn, cellGroupStruct.getCgID()), req.getOpCode())) {
            this.renderError(response, HttpError.ILLEGAL_OP_CODE);
            return;
        }
        if (VerifyUtil.hasNull((Object)req)) {
            this.renderError(response, HttpError.MISSING_REQUIRED_PARAMETERS);
            return;
        }
        if (!this.verifyWithSN(req.getCellGroup()) || !this.verifyWithSN(req.getSyncPubKey())) {
            this.renderError(response, HttpError.VERIFY_WITH_CHIP_ERROR);
            return;
        }
        SyncPubKey skPubKey = (SyncPubKey)JsonMapper.alwaysMapper().fromJson(req.getSyncPubKey().getInfo(), SyncPubKey.class);
        if (!this.verifyWithSyncPubKData(req.getWrapKey(), skPubKey.getSkPub()) || !this.verifyWithSyncPubKData(req.getSyncPriKey(), skPubKey.getSkPub())) {
            this.renderError(response, HttpError.VERIFY_WITH_SYNCPUB_ERROR);
            return;
        }
        if (!(sn.equals(skPubKey.getSn()) && chipId.equals(skPubKey.getCiD()) && appId.equals(skPubKey.getAppID()) && appId.equals(cellGroupStruct.getAppID()) && sn.equals(cellGroupStruct.getSn()))) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("sn[{}],skPubKey.getSn()[{}]", (Object)sn, (Object)skPubKey.getSn());
                this.logger.debug("chipId[{}],skPubKey.getCiD()[{}]", (Object)chipId, (Object)skPubKey.getCiD());
                this.logger.debug("appId[{}],skPubKey.getAppID()[{}]", (Object)appId, (Object)skPubKey.getAppID());
                this.logger.debug("appId[{}],cellGroupStruct.getAppID()[{}]", (Object)appId, (Object)cellGroupStruct.getAppID());
                this.logger.debug("sn[{}],cellGroupStruct.getSn()[{}]", (Object)sn, (Object)cellGroupStruct.getSn());
            }
            this.renderError(response, HttpError.SOURCE_DATA_ILLEGAL);
            return;
        }
        if (!ORIGIN_VERSION.equals(cellGroupStruct.getCgVer()) || !ORIGIN_VERSION.equals(cellGroupStruct.getWkVer())) {
            this.renderError(response, HttpError.ILLEGAL_SOURCE_DATA_OF_VERSION);
            return;
        }
        if (this.EntityProvider.existEntity(this.getAppID(request), cellGroupStruct.getCgID())) {
            this.renderError(response, HttpError.ENTITY_IS_EXIST);
            return;
        }
        this.EntityProvider.doCreateEntity(req.getCellGroup(), req.getWrapKey(), req.getKekWrapKey(), req.getSyncPriKey(), req.getSyncPubKey());
        this.logger.info(this.format(request, cellGroupStruct.getCgID(), null, "\u521b\u5efaEntity"));
    }

    @AopLog
    @RequestMapping(value={"/api/v2/entities/devices"}, consumes={"application/json"}, method={RequestMethod.POST})
    public Object getDevicies(HttpServletRequest request, @RequestBody List<String> entityIDs) {
        return this.EntityProvider.getDevicesByEnityAndAppId(entityIDs, this.getAppID(request));
    }

    @AopLog
    @RequestMapping(value={"/api/v2/entities/{entityID}/deviceAddRequest"}, consumes={"application/json"}, method={RequestMethod.POST})
    public Object createDeviceAddRequest(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="entityID") String entityID, @RequestBody CreateDeviceAddRequestReq req) throws JSONException {
        String sn = this.getSN(request);
        String appId = this.getAppID(request);
        String chipId = this.getChipID(request);
        if (VerifyUtil.hasNull((Object)req)) {
            return HttpError.MISSING_REQUIRED_PARAMETERS.handle(response);
        }
        if (!this.EntityProvider.existEntity(this.getAppID(request), entityID)) {
            return HttpError.ENTITY_NOT_EXIST.handle(response);
        }
        if (this.EntityProvider.existDevice(this.getAppID(request), this.getSN(request), entityID)) {
            return HttpError.DEVICE_ALREADY_BINDING_ENTITY.handle(response);
        }
        if (!this.verifyWithSN(req.getReqAddCellGroup()) || !this.verifyWithSN(req.getSyncPubKey())) {
            return HttpError.VERIFY_WITH_CHIP_ERROR.handle(response);
        }
        SyncPubKey skPubKey = (SyncPubKey)JsonMapper.alwaysMapper().fromJson(req.getSyncPubKey().getInfo(), SyncPubKey.class);
        SourceDataStruct syncPriKey = (SourceDataStruct)JsonMapper.alwaysMapper().fromJson((Object)req.getSyncPriKey(), SourceDataStruct.class);
        if (!this.verifyWithSyncPubKData(syncPriKey, skPubKey.getSkPub())) {
            return HttpError.VERIFY_WITH_SYNCPUB_ERROR.handle(response);
        }
        ReqAddCellGroup reqAddCellGroup = (ReqAddCellGroup)JsonMapper.alwaysMapper().fromJson(req.getReqAddCellGroup().getInfo(), ReqAddCellGroup.class);
        if (!(sn.equals(skPubKey.getSn()) && chipId.equals(skPubKey.getCiD()) && appId.equals(skPubKey.getAppID()) && appId.equals(reqAddCellGroup.getAppID()) && sn.equals(reqAddCellGroup.getSn()))) {
            return HttpError.SOURCE_DATA_ILLEGAL.handle(response);
        }
        this.EntityProvider.deleteDeviceAddRequestBySnAndEntity(this.getSN(request), this.getAppID(request), entityID);
        long index = this.EntityProvider.doCreateDeviceAddRequest(req.getSyncPubKey(), req.getSyncPriKey(), req.getReqAddCellGroup());
        this.logger.info(this.format(request, entityID, null, "\u8981\u6c42\u52a0\u5165Entity,\u8bf7\u6c42\u6807\u8bc6\u3010" + index + "\u3011"));
        return index;
    }

    @AopLog
    @RequestMapping(value={"/api/v2/entities/deviceAddRequest/{request_index}"}, consumes={"application/json"}, method={RequestMethod.GET})
    public Object getDeviceAddRequest(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="request_index") String request_index) throws JSONException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        GetDeviceAddReq bean = this.EntityProvider.getRequestBeanByIndex(request_index);
        if (bean == null || !this.getAppID(request).equals(bean.getAppId())) {
            return HttpError.ADD_REQINDEX_NOT_EXIST.handle(response);
        }
        result.put("reqAddCellGroup", JsonMapper.alwaysMapper().fromJson(bean.getReqData(), SourceDataStruct.class));
        result.put("syncPubKey", JsonMapper.alwaysMapper().fromJson(bean.getPubData(), SourceDataStruct.class));
        return result;
    }

    @AopLog
    @RequestMapping(value={"/api/v2/entities/{entityID}/_search"}, consumes={"application/json"}, method={RequestMethod.GET})
    public Object getEntity(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="entityID") String entityID, @RequestParam int todo) throws JSONException {
        List ts;
        if (!this.EntityProvider.existEntity(this.getAppID(request), entityID)) {
            return HttpError.ENTITY_NOT_EXIST.handle(response);
        }
        if (todo == 1 && (ts = this.TodoProvider.getMissionsByGetEntity(this.getSN(request), this.getAppID(request), entityID, true)).size() > 0) {
            GetEntityResp resp = new GetEntityResp();
            resp.setTodo((Object)ts);
            return resp;
        }
        this.logger.info(this.format(request, entityID, null, "\u83b7\u53d6Entity"));
        return this.EntityProvider.getEntityInfos(this.getAppID(request), entityID, this.getSN(request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AopLog
    @RequestMapping(value={"/api/v2/entities/deviceAdd"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public void deviceAdd(HttpServletRequest request, HttpServletResponse response, @RequestBody DeviceAddReq req) throws JSONException {
        String appID = this.getAppID(request);
        if (VerifyUtil.hasNull((Object)req)) {
            this.renderError(response, HttpError.MISSING_REQUIRED_PARAMETERS);
            return;
        }
        if (!this.verifyWithSN(req.getCellGroup())) {
            this.renderError(response, HttpError.VERIFY_WITH_CHIP_ERROR);
            return;
        }
        CellGroupStruct cellGroupStruct = (CellGroupStruct)JsonMapper.alwaysMapper().fromJson(req.getCellGroup().getInfo(), CellGroupStruct.class);
        if (this.EntityProvider.checkRequestByIndex(req.getIndex(), appID, req.getOpId()) || !req.getOpId().equals(cellGroupStruct.getCgID()) || !this.EntityProvider.existDevice(appID, this.getSN(request), req.getOpId())) {
            this.renderError(response, HttpError.DEVICE_OPERATE_ILLEGAL);
            return;
        }
        if (this.EntityProvider.checkWrapKeyVersionIllegal(appID, cellGroupStruct.getCgID(), this.getMaxWrapKeyVersion(req.getSyncedWrapKey()))) {
            this.renderError(response, HttpError.ILLEGAL_SOURCE_DATA_OF_VERSION);
            return;
        }
        if (this.EntityProvider.checkEntityVersionIllegal(appID, cellGroupStruct.getCgID(), Long.valueOf(cellGroupStruct.getCgVer()))) {
            this.renderError(response, HttpError.ILLEGAL_SOURCE_DATA_OF_VERSION);
            return;
        }
        if (this.EntityProvider.checkEntityWrapkeyVersionIllegal(appID, cellGroupStruct.getCgID(), Long.valueOf(cellGroupStruct.getWkVer()))) {
            this.renderError(response, HttpError.ILLEGAL_SOURCE_DATA_OF_VERSION);
            return;
        }
        String sn = this.EntityProvider.getSnByIndex(req.getIndex());
        if (!this.opCodeProvider.verifySign(this.getAppID(request), OpCodeFactory.Coder().addDevice(this.getSN(request), req.getOpId(), sn), req.getOpCode())) {
            this.renderError(response, HttpError.ILLEGAL_OP_CODE);
            return;
        }
        if (!this.EntityProvider.lock(this.getAppID(request), cellGroupStruct.getCgID())) {
            this.renderError(response, HttpError.ILLEGAL_SOURCE_DATA_OF_VERSION);
            return;
        }
        try {
            this.EntityProvider.doAddDevice(req.getCellGroup(), req.getSyncedWrapKey(), req.getIndex(), this.getSN(request));
        }
        finally {
            this.EntityProvider.unlock(this.getAppID(request), cellGroupStruct.getCgID());
        }
        this.logger.info(this.format(request, req.getOpId(), null, "\u901a\u8fc7\u8bf7\u6c42\u6807\u8bc6\u3010" + req.getIndex() + "\u3011\u65b0\u589e\u8bbe\u5907"));
    }

    private long getMaxWrapKeyVersion(List<SyncedWrapKey> syncedWrapKey) {
        long max = 0L;
        for (SyncedWrapKey wrapKey : syncedWrapKey) {
            long ver = Long.valueOf(wrapKey.getWkVer());
            if (ver <= max) continue;
            max = ver;
        }
        return max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AopLog
    @RequestMapping(value={"/api/v2/entities/{entityID}/deviceForceAdd"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public void deviceForceAdd(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="entityID") String entityID, @RequestBody DeviceForceAddReq req) throws JSONException {
        if (VerifyUtil.hasNull((Object)req)) {
            this.renderError(response, HttpError.MISSING_REQUIRED_PARAMETERS);
            return;
        }
        String appID = this.getAppID(request);
        if (!this.verifyWithSN(req.getCellGroup()) || !this.verifyWithSN(req.getSyncPubKey())) {
            this.renderError(response, HttpError.VERIFY_WITH_CHIP_ERROR);
            return;
        }
        SyncPubKey skPubKey = (SyncPubKey)JsonMapper.alwaysMapper().fromJson(req.getSyncPubKey().getInfo(), SyncPubKey.class);
        if (!this.verifyWithSyncPubKData(req.getWrapKey(), skPubKey.getSkPub()) || !this.verifyWithSyncPubKData(req.getSyncPriKey(), skPubKey.getSkPub())) {
            this.renderError(response, HttpError.VERIFY_WITH_SYNCPUB_ERROR);
            return;
        }
        if (!this.opCodeProvider.verifySign(this.getAppID(request), OpCodeFactory.Coder().forceAddDevice(this.getSN(request), entityID), req.getOpCode())) {
            this.renderError(response, HttpError.ILLEGAL_OP_CODE);
            return;
        }
        if (!this.EntityProvider.existEntity(this.getAppID(request), entityID)) {
            this.renderError(response, HttpError.ENTITY_NOT_EXIST);
            return;
        }
        if (this.EntityProvider.existDevice(this.getAppID(request), this.getSN(request), entityID)) {
            this.renderError(response, HttpError.DEVICE_ALREADY_BINDING_ENTITY);
            return;
        }
        CellGroupStruct cellGroupStruct = (CellGroupStruct)JsonMapper.alwaysMapper().fromJson(req.getCellGroup().getInfo(), CellGroupStruct.class);
        WrapKey wrapKey = (WrapKey)JsonMapper.alwaysMapper().fromJson(req.getWrapKey().getInfo(), WrapKey.class);
        if (!(entityID.equals(req.getKekWrapKey().getCgID()) && wrapKey.getWkVer().equals(req.getKekWrapKey().getWkVer()) && wrapKey.getWkVer().equals(cellGroupStruct.getWkVer()) && cellGroupStruct.getCgID().equals(entityID) && skPubKey.getCiD().equals(this.getChipID(request)) && skPubKey.getSn().equals(this.getSN(request)))) {
            this.renderError(response, HttpError.SOURCE_DATA_ILLEGAL);
            return;
        }
        if (!this.EntityProvider.lock(this.getAppID(request), cellGroupStruct.getCgID())) {
            this.renderError(response, HttpError.ILLEGAL_SOURCE_DATA_OF_VERSION);
            return;
        }
        try {
            if (this.EntityProvider.checkWrapKeyVersionIllegalByUpdate(appID, cellGroupStruct.getCgID(), wrapKey.getWkVer())) {
                this.renderError(response, HttpError.ILLEGAL_SOURCE_DATA_OF_VERSION);
                return;
            }
            if (this.EntityProvider.checkEntityVersionIllegal(appID, cellGroupStruct.getCgID(), Long.valueOf(cellGroupStruct.getCgVer()))) {
                this.renderError(response, HttpError.ILLEGAL_SOURCE_DATA_OF_VERSION);
                return;
            }
            this.EntityProvider.doDeviceForceAdd(req.getCellGroup(), req.getKekWrapKey(), req.getWrapKey(), req.getSyncPubKey(), req.getSyncPriKey(), req.getSyncedWrapKey());
            this.logger.info(this.format(request, entityID, null, "\u5f3a\u5236\u767b\u5f55\u5173\u8054Entity"));
        }
        finally {
            this.EntityProvider.unlock(this.getAppID(request), cellGroupStruct.getCgID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AopLog
    @RequestMapping(value={"/api/v2/entities/removeDevice"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public void removeDevice(HttpServletRequest request, HttpServletResponse response, @RequestBody RemoveDeviceReq req) throws JSONException {
        String appID = this.getAppID(request);
        String sn = this.getSN(request);
        if (VerifyUtil.hasNull((Object)req)) {
            this.renderError(response, HttpError.MISSING_REQUIRED_PARAMETERS);
            return;
        }
        if (!this.verifyWithSN(req.getCellGroup())) {
            this.renderError(response, HttpError.VERIFY_WITH_CHIP_ERROR);
            return;
        }
        if (!this.verifyWithSyncPubK(req.getWrapKey(), appID, sn)) {
            this.renderError(response, HttpError.VERIFY_WITH_SYNCPUB_ERROR);
            return;
        }
        CellGroupStruct cellGroupStruct = (CellGroupStruct)JsonMapper.alwaysMapper().fromJson(req.getCellGroup().getInfo(), CellGroupStruct.class);
        WrapKey wrapKey = (WrapKey)JsonMapper.alwaysMapper().fromJson(req.getWrapKey().getInfo(), WrapKey.class);
        List devices = req.getDevices();
        if (!this.opCodeProvider.verifySign(this.getAppID(request), OpCodeFactory.Coder().removeDevice(sn, cellGroupStruct.getCgID(), devices.toArray(new String[devices.size()])), req.getOpCode())) {
            this.renderError(response, HttpError.ILLEGAL_OP_CODE);
            return;
        }
        if (!cellGroupStruct.getCgID().equals(req.getOpId())) {
            this.renderError(response, HttpError.SOURCE_DATA_ILLEGAL);
            return;
        }
        if (!this.EntityProvider.existEntity(appID, req.getOpId())) {
            this.renderError(response, HttpError.ENTITY_NOT_EXIST);
            return;
        }
        if (!this.EntityProvider.existDevice(appID, sn, req.getOpId())) {
            this.renderError(response, HttpError.OPERATE_DEVICE_NOT_IN_ENTITY);
            return;
        }
        if (this.EntityProvider.checkIsLastDevice(appID, req.getOpId())) {
            this.renderError(response, HttpError.ENTITY_OPERATE_ILLEGAL);
            return;
        }
        for (String dev : req.getDevices()) {
            if (this.EntityProvider.existDevice(appID, dev, req.getOpId())) continue;
            this.renderError(response, HttpError.OPERATE_DEVICE_NOT_IN_ENTITY);
            return;
        }
        if (!this.EntityProvider.lock(this.getAppID(request), cellGroupStruct.getCgID())) {
            this.renderError(response, HttpError.ILLEGAL_SOURCE_DATA_OF_VERSION);
            return;
        }
        try {
            if (this.EntityProvider.checkEntityVersionIllegal(appID, cellGroupStruct.getCgID(), Long.valueOf(cellGroupStruct.getCgVer()))) {
                this.renderError(response, HttpError.ILLEGAL_SOURCE_DATA_OF_VERSION);
                return;
            }
            if (this.EntityProvider.checkWrapKeyVersionIllegalByUpdate(appID, cellGroupStruct.getCgID(), wrapKey.getWkVer())) {
                this.renderError(response, HttpError.ILLEGAL_SOURCE_DATA_OF_VERSION);
                return;
            }
            this.EntityProvider.deleteDevice(req.getDevices(), req.getCellGroup(), req.getKekWrapKey(), req.getWrapKey(), req.getSyncedWrapKey());
            this.logger.info(this.format(request, req.getOpId(), null, "\u4eceEntity\u4e2d\u79fb\u9664\u8bbe\u5907\u3010" + req.getDevices() + "\u3011"));
        }
        finally {
            this.EntityProvider.unlock(this.getAppID(request), cellGroupStruct.getCgID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AopLog
    @RequestMapping(value={"/api/v2/entities/quit"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public void quitEntity(HttpServletRequest request, HttpServletResponse response, @RequestBody QuitEntityReq req) throws JSONException {
        String appID = this.getAppID(request);
        String sn = this.getSN(request);
        if (VerifyUtil.hasNull((Object)req.getQuitInfo())) {
            this.renderError(response, HttpError.MISSING_REQUIRED_PARAMETERS);
            return;
        }
        if (!this.verifyWithSN(req.getQuitInfo())) {
            this.renderError(response, HttpError.VERIFY_WITH_CHIP_ERROR);
            return;
        }
        if (!this.verifyWithSN(req.getCellGroup())) {
            this.renderError(response, HttpError.VERIFY_WITH_CHIP_ERROR);
            return;
        }
        if (!this.opCodeProvider.verifySign(this.getAppID(request), OpCodeFactory.Coder().quitEntity(sn, req.getOpId()), req.getOpCode())) {
            this.renderError(response, HttpError.ILLEGAL_OP_CODE);
            return;
        }
        CellGroupStruct cellGroupStruct = (CellGroupStruct)JsonMapper.alwaysMapper().fromJson(req.getCellGroup().getInfo(), CellGroupStruct.class);
        QuitInfo quitInfo = (QuitInfo)JsonMapper.alwaysMapper().fromJson(req.getQuitInfo().getInfo(), QuitInfo.class);
        if (VerifyUtil.hasNull((Object)quitInfo)) {
            this.renderError(response, HttpError.MISSING_REQUIRED_PARAMETERS);
            return;
        }
        if (!(cellGroupStruct.getCgID().equals(req.getOpId()) && quitInfo.getCgID().equals(req.getOpId()) && quitInfo.getAppID().equals(appID) && quitInfo.getType().equals("1") && quitInfo.getId().equals(sn))) {
            this.renderError(response, HttpError.SOURCE_DATA_ILLEGAL);
            return;
        }
        if (!this.EntityProvider.existEntity(appID, req.getOpId())) {
            this.renderError(response, HttpError.ENTITY_NOT_EXIST);
            return;
        }
        if (!this.EntityProvider.existDevice(appID, sn, req.getOpId())) {
            this.renderError(response, HttpError.OPERATE_DEVICE_NOT_IN_ENTITY);
            return;
        }
        if (this.EntityProvider.checkIsLastDevice(appID, req.getOpId())) {
            this.renderError(response, HttpError.ENTITY_OPERATE_ILLEGAL);
            return;
        }
        if (!this.EntityProvider.lock(this.getAppID(request), cellGroupStruct.getCgID())) {
            this.renderError(response, HttpError.ILLEGAL_SOURCE_DATA_OF_VERSION);
            return;
        }
        try {
            if (this.EntityProvider.checkEntityVersionIllegal(appID, cellGroupStruct.getCgID(), Long.valueOf(cellGroupStruct.getCgVer()))) {
                this.renderError(response, HttpError.ILLEGAL_SOURCE_DATA_OF_VERSION);
                return;
            }
            if (this.EntityProvider.checkWrapKeyVersionIllegalByUpdate(appID, cellGroupStruct.getCgID(), cellGroupStruct.getWkVer())) {
                this.renderError(response, HttpError.ILLEGAL_SOURCE_DATA_OF_VERSION);
                return;
            }
            this.EntityProvider.doQuit(req.getCellGroup(), req.getQuitInfo());
            this.logger.info(this.format(request, req.getOpId(), null, "\u4eceEntity\u4e2d\u4e3b\u52a8\u9000\u51fa"));
        }
        finally {
            this.EntityProvider.unlock(this.getAppID(request), cellGroupStruct.getCgID());
        }
    }

    @AopLog
    @RequestMapping(value={"/api/v2/entities/destroy"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public void destroyEntity(HttpServletRequest request, HttpServletResponse response, @RequestBody DestroyEntityReq req) throws JSONException {
        if (VerifyUtil.hasNull((Object)req.getDestroyInfo())) {
            this.renderError(response, HttpError.MISSING_REQUIRED_PARAMETERS);
            return;
        }
        if (!this.verifyWithSN(req.getDestroyInfo())) {
            this.renderError(response, HttpError.VERIFY_WITH_CHIP_ERROR);
            return;
        }
        if (!this.opCodeProvider.verifySign(this.getAppID(request), OpCodeFactory.Coder().destroyEntity(this.getSN(request), req.getOpId()), req.getOpCode())) {
            this.renderError(response, HttpError.ILLEGAL_OP_CODE);
            return;
        }
        String appID = this.getAppID(request);
        String sn = this.getSN(request);
        DestroyInfo destroyInfo = (DestroyInfo)JsonMapper.alwaysMapper().fromJson(req.getDestroyInfo().getInfo(), DestroyInfo.class);
        if (!(destroyInfo.getId().equals(req.getOpId()) && destroyInfo.getAppID().equals(appID) && destroyInfo.getType().equals("C"))) {
            this.renderError(response, HttpError.SOURCE_DATA_ILLEGAL);
            return;
        }
        if (!this.EntityProvider.existEntity(appID, req.getOpId())) {
            this.renderError(response, HttpError.ENTITY_NOT_EXIST);
            return;
        }
        if (!this.EntityProvider.existDevice(appID, sn, req.getOpId())) {
            this.renderError(response, HttpError.OPERATE_DEVICE_NOT_IN_ENTITY);
            return;
        }
        if (!this.EntityProvider.checkIsLastDevice(appID, req.getOpId())) {
            this.renderError(response, HttpError.ENTITY_CAN_NOT_DESTROY);
            return;
        }
        this.EntityProvider.doDestroy(req.getDestroyInfo(), appID, req.getOpId(), sn);
        this.logger.info(this.format(request, req.getOpId(), null, "\u9500\u6bc1Entity"));
    }

    @AopLog
    @RequestMapping(value={"/api/v2/entities/{entityID}/syncPair"}, consumes={"application/json"}, method={RequestMethod.GET})
    public Object getSyncPair(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="entityID") String entityId) throws JSONException {
        GetSyncPairResp resp = this.EntityProvider.getSyncPairByEntityAndAppId(this.getAppID(request), entityId, this.getSN(request));
        if (resp == null) {
            return HttpError.SYNC_PAIR_NOT_EXIST.handle(response);
        }
        this.logger.info(this.format(request, entityId, null, "\u83b7\u53d6Entity\u516c\u79c1\u94a5\u5bf9"));
        return resp;
    }

    @AopLog
    @RequestMapping(value={"/api/v2/entities/getAll"}, consumes={"application/json"}, method={RequestMethod.POST})
    public Object getEntities(HttpServletRequest request, HttpServletResponse response, @RequestBody List<String> entityIds) throws JSONException {
        List entities = this.EntityProvider.getEntitiesByEntityIdAndAppId(entityIds, this.getAppID(request));
        if (entities == null) {
            return HttpError.ENTITY_NOT_EXIST.handle(response);
        }
        this.logger.info(this.format(request, entityIds.toString(), null, "\u83b7\u53d6Entity\u516c\u79c1\u94a5\u5bf9"));
        return entities;
    }

    @AopLog
    @RequestMapping(value={"/api/v2/entities/{entityID}/syncWrapKeyRequest"}, consumes={"application/json"}, method={RequestMethod.POST})
    public Object createDeviceSyncKeyRequest(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="entityID") String entityID, @RequestBody SourceDataStruct req) throws JSONException {
        String sn = this.getSN(request);
        String appId = this.getAppID(request);
        String chipId = this.getChipID(request);
        if (VerifyUtil.hasNull((Object)req)) {
            return HttpError.MISSING_REQUIRED_PARAMETERS.handle(response);
        }
        if (!this.verifyWithSyncPubK(req, appId, sn)) {
            return HttpError.VERIFY_WITH_SYNCPUB_ERROR.handle(response);
        }
        ReqSyncWrapKey reqSyncWrapKey = (ReqSyncWrapKey)JsonMapper.alwaysMapper().fromJson(req.getInfo(), ReqSyncWrapKey.class);
        if (!(sn.equals(reqSyncWrapKey.getSn()) && appId.equals(reqSyncWrapKey.getAppID()) && entityID.equals(reqSyncWrapKey.getCgID()) && chipId.equals(reqSyncWrapKey.getCiD()))) {
            return HttpError.HEAD_PARAM_NOT_MATCH_SOURCE.handle(response);
        }
        if (!this.EntityProvider.existEntity(appId, entityID)) {
            return HttpError.ENTITY_NOT_EXIST.handle(response);
        }
        if (!this.EntityProvider.existForceAddDevice(appId, sn, entityID)) {
            return HttpError.DEVICE_NOT_FORCE_ADD.handle(response);
        }
        if (!this.EntityProvider.verifySyncPub(reqSyncWrapKey)) {
            return HttpError.DEVICE_OPERATE_ILLEGAL.handle(response);
        }
        this.EntityProvider.deleteDeviceSyncWkRequestBySnAndEntity(sn, appId, entityID);
        long index = this.EntityProvider.doCreateDeviceSyncWkRequest(req);
        this.logger.info(this.format(request, entityID, null, "\u540c\u6b65Entity Wrapkey,\u8bf7\u6c42\u6807\u8bc6\u3010" + index + "\u3011"));
        return index;
    }

    @AopLog
    @RequestMapping(value={"/api/v2/entities/syncWrapKeyRequest/{request_index}"}, consumes={"application/json"}, method={RequestMethod.GET})
    public Object getDeviceSyncKeyRequest(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="request_index") String request_index) throws JSONException {
        String requestInfo = this.EntityProvider.getSyncWkRequestByIndex(request_index);
        if (StringUtils.isBlank((CharSequence)requestInfo)) {
            return HttpError.SYNC_REQINDEX_NOT_EXIST.handle(response);
        }
        SourceDataStruct data = (SourceDataStruct)JsonMapper.alwaysMapper().fromJson(requestInfo, SourceDataStruct.class);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AopLog
    @RequestMapping(value={"/api/v2/entities/syncWrapKey"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public void deviceSyncWrapKey(HttpServletRequest request, HttpServletResponse response, @RequestBody DeviceSyncWKReq req) throws JSONException {
        String appID = this.getAppID(request);
        if (VerifyUtil.hasNull((Object)req)) {
            this.renderError(response, HttpError.MISSING_REQUIRED_PARAMETERS);
            return;
        }
        if (req.getCellGroup() != null) {
            if (!this.verifyWithSN(req.getCellGroup())) {
                this.renderError(response, HttpError.VERIFY_WITH_CHIP_ERROR);
                return;
            }
            CellGroupStruct cellGroupStruct = (CellGroupStruct)JsonMapper.alwaysMapper().fromJson(req.getCellGroup().getInfo(), CellGroupStruct.class);
            if (this.EntityProvider.checkEntityVersionIllegal(appID, cellGroupStruct.getCgID(), Long.valueOf(cellGroupStruct.getCgVer()))) {
                this.renderError(response, HttpError.ILLEGAL_SOURCE_DATA_OF_VERSION);
                return;
            }
        }
        if (this.EntityProvider.checkSyncWkRequestByIndex(req.getIndex(), appID, req.getOpId()) || !this.EntityProvider.existDevice(appID, this.getSN(request), req.getOpId())) {
            this.renderError(response, HttpError.DEVICE_OPERATE_ILLEGAL);
            return;
        }
        if (this.EntityProvider.checkWrapKeyVersionIllegal(appID, req.getOpId(), this.getMaxWrapKeyVersion(req.getSyncedWrapKey()))) {
            this.renderError(response, HttpError.ILLEGAL_SOURCE_DATA_OF_VERSION);
            return;
        }
        String sn = this.EntityProvider.getSnBySyncIndex(req.getIndex());
        if (!this.EntityProvider.lock(this.getAppID(request), req.getOpId())) {
            this.renderError(response, HttpError.ILLEGAL_SOURCE_DATA_OF_VERSION);
            return;
        }
        if (!this.opCodeProvider.verifySign(this.getAppID(request), OpCodeFactory.Coder().syncSecPower(this.getSN(request), req.getOpId(), sn), req.getOpCode())) {
            this.renderError(response, HttpError.ILLEGAL_OP_CODE);
            return;
        }
        try {
            this.EntityProvider.doSyncWrapKey(req, appID, this.getSN(request), sn);
        }
        finally {
            this.EntityProvider.unlock(this.getAppID(request), req.getOpId());
        }
        this.logger.info(this.format(request, req.getOpId(), null, "\u901a\u8fc7\u540c\u6b65WrapKey\u8bf7\u6c42\u6807\u8bc6\u3010" + req.getIndex() + "\u3011\u540c\u6b65WrapKey"));
    }
}

