/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.controller.v2.entity;

import com.xdja.log.analysis.aop.annoation.AopLog;
import com.xdja.platform.common.lite.kit.json.JSONException;
import com.xdja.platform.common.lite.kit.json.JsonMapper;
import com.xdja.safecenter.secret.controller.AbstractController;
import com.xdja.safecenter.secret.controller.HttpError;
import com.xdja.safecenter.secret.core.verify.VerifyUtil;
import com.xdja.safecenter.secret.provider.cellgroup.IEntityProvider;
import com.xdja.safecenter.secret.struct.SourceDataStruct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SyncKeyController
extends AbstractController {
    @Resource
    protected IEntityProvider EntityProvider;

    @AopLog
    @RequestMapping(value={"/api/v2/syncKey/syncKeyIDs"}, consumes={"application/json"}, method={RequestMethod.POST})
    public Object getSyncPubKeys(HttpServletRequest request, HttpServletResponse response, @RequestBody List<String> skIDs) throws JSONException {
        if (VerifyUtil.isEmpty(skIDs)) {
            return HttpError.MISSING_REQUIRED_PARAMETERS.handle(response);
        }
        HashMap result = new HashMap();
        Map SyncPubKeys = this.EntityProvider.getSyncPubKeyDatas(skIDs);
        if (SyncPubKeys == null || SyncPubKeys.isEmpty()) {
            this.logger.error("\u672a\u67e5\u8be2\u5230\u540c\u6b65\u516c\u94a5\uff0c\u8bf7\u6c42\u7684ID:{}", skIDs);
            return HttpError.SYNC_PAIR_NOT_EXIST.handle(response);
        }
        for (Map.Entry entry : SyncPubKeys.entrySet()) {
            result.put(entry.getKey(), JsonMapper.alwaysMapper().fromJson((String)entry.getValue(), SourceDataStruct.class));
        }
        this.logger.info(this.format(request, null, null, "\u83b7\u53d6\u540c\u6b65\u516c\u94a5\u3010" + skIDs + "\u3011"));
        return result;
    }
}

