/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.controller.v2.entity;

import com.xdja.log.analysis.aop.annoation.AopLog;
import com.xdja.platform.common.lite.kit.json.JSONException;
import com.xdja.safecenter.secret.controller.AbstractController;
import com.xdja.safecenter.secret.controller.HttpError;
import com.xdja.safecenter.secret.provider.cellgroup.IEntityProvider;
import com.xdja.safecenter.secret.provider.cellgroup.bean.response.GetWrapKeysResp;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class WrapKeyController
extends AbstractController {
    @Resource
    protected IEntityProvider EntityProvider;

    @AopLog
    @RequestMapping(value={"/api/v2/entities/{entityID}/wrapKeys"}, consumes={"application/json"}, method={RequestMethod.GET})
    public Object getWrapKeys(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="entityID") String entityId) throws JSONException {
        long ver;
        String wrapKeyVersion = request.getParameter("wrapKeyVersion");
        if (StringUtils.isEmpty((CharSequence)wrapKeyVersion)) {
            return HttpError.ILLEGAL_REQUEST_PARAMETER.handle(response);
        }
        try {
            ver = Long.valueOf(wrapKeyVersion);
        }
        catch (NumberFormatException ex) {
            this.logger.error("wrapKeyVersion \u4e0d\u5408\u6cd5 \u3010{}\u3011", (Object)wrapKeyVersion);
            return HttpError.ILLEGAL_REQUEST_PARAMETER.handle(response);
        }
        GetWrapKeysResp resp = this.EntityProvider.getWrapKeys(this.getSN(request), this.getAppID(request), entityId, ver);
        if (resp == null) {
            return HttpError.WRAPKEY_IS_NOT_EXIST.handle(response);
        }
        this.logger.info(this.format(request, entityId, null, "\u83b7\u53d6Entity\u4e0b\u7684WrapKey\uff0c\u7248\u672c\u3010" + wrapKeyVersion + "\u3011"));
        return resp;
    }
}

