/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.controller.v2.kek;

import com.xdja.log.analysis.aop.annoation.AopLog;
import com.xdja.platform.common.lite.kit.json.JSONException;
import com.xdja.safecenter.secret.controller.AbstractController;
import com.xdja.safecenter.secret.controller.HttpError;
import com.xdja.safecenter.secret.core.verify.VerifyUtil;
import com.xdja.safecenter.secret.provider.kek.IKekProvider;
import com.xdja.safecenter.secret.struct.SourceDataStruct;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class KekController
extends AbstractController {
    @Resource
    protected IKekProvider KekProvider;

    @AopLog
    @RequestMapping(value={"/api/v2/kek"}, consumes={"application/json"}, method={RequestMethod.GET})
    public Object getKek(HttpServletRequest request) throws JSONException {
        this.logger.info(this.format(request, null, null, "\u83b7\u53d6\u5f53\u524d\u8bbe\u5907KEK"));
        SourceDataStruct re = this.KekProvider.getKekBySn(this.getSN(request));
        return re == null ? "" : re;
    }

    @AopLog
    @RequestMapping(value={"/api/v2/kek"}, consumes={"application/json"}, method={RequestMethod.POST})
    public void saveKek(HttpServletRequest request, HttpServletResponse response, @RequestBody SourceDataStruct kek) throws JSONException {
        if (VerifyUtil.hasNull((Object)kek)) {
            this.renderError(response, HttpError.MISSING_REQUIRED_PARAMETERS);
            return;
        }
        if (!this.verifyWithSN(kek)) {
            this.renderError(response, HttpError.VERIFY_WITH_CHIP_ERROR);
            return;
        }
        if (this.KekProvider.existKek(this.getSN(request))) {
            this.renderError(response, HttpError.KEK_ALREADY_EXIST);
            return;
        }
        this.KekProvider.saveKek(kek);
        this.logger.info(this.format(request, null, null, "\u5907\u4efd\u5f53\u524d\u8bbe\u5907KEK"));
    }
}

