/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.controller.v2.localkey;

import com.xdja.log.analysis.aop.annoation.AopLog;
import com.xdja.safecenter.secret.controller.AbstractController;
import com.xdja.safecenter.secret.controller.HttpError;
import com.xdja.safecenter.secret.provider.chipCert.IChipCertProvider;
import com.xdja.safecenter.secret.provider.localkey.ILocalKeyProvider;
import com.xdja.safecenter.secret.provider.localkey.exception.CertParseException;
import com.xdja.safecenter.secret.provider.localkey.exception.KeyFileNotExistException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class LocalKeyController
extends AbstractController {
    protected static final String HASH_KEY = "hash";
    public static final String CIPHER_KEY = "cipherKey";
    public static final String CIPHER = "cipher";
    public static final String HASH_ALG = "hashAlg";
    public static final String HASH_SM3 = "1";
    public static final String HASH_MD5 = "2";
    protected static final String SM_3_WITHSM_2 = "2";
    protected static final String SM2_NOT_EXIST_ERROR = "SM2\u52a0\u5bc6\u8bc1\u4e66\u4e0d\u5b58\u5728 SN{}";
    @Resource
    protected ILocalKeyProvider localKeyProvider;
    @Resource
    protected IChipCertProvider chipCertProvider;

    @AopLog
    @RequestMapping(value={"/api/v2/server/{encSn}/keys "}, method={RequestMethod.GET})
    public Object getLocalKey(HttpServletRequest request, HttpServletResponse resp, @PathVariable(value="encSn") String encSn) {
        HashMap<String, String> result = new HashMap<String, String>();
        HashMap<String, String> snMap = new HashMap<String, String>();
        snMap.put(encSn, "2");
        Map certMap = this.chipCertProvider.queryCertsBySN(snMap);
        if (certMap.isEmpty()) {
            this.logger.error(SM2_NOT_EXIST_ERROR, (Object)encSn);
            return HttpError.ENC_CERT_NOT_EXIST.handle(resp);
        }
        try {
            String hash = this.localKeyProvider.getLocalKeyHash();
            result.put(HASH_KEY, hash);
            String[] encData = this.localKeyProvider.getCipherLocalKey((String)certMap.get(encSn));
            result.put(HASH_ALG, HASH_SM3);
            result.put(CIPHER_KEY, encData[0]);
            result.put(CIPHER, encData[1]);
        }
        catch (KeyFileNotExistException e) {
            this.logger.error("\u670d\u52a1\u7aef\u5bc6\u94a5\u6587\u4ef6\u4e0d\u5b58\u5728", (Throwable)e);
            return HttpError.LOCAL_KEY_NOT_EXIST.handle(resp);
        }
        catch (CertParseException e) {
            this.logger.error("\u52a0\u5bc6\u8bc1\u4e66\u683c\u5f0f\u9519\u8bef", (Throwable)e);
            return HttpError.ENC_CERT_ERROR.handle(resp);
        }
        this.logger.info(this.format(request, null, null, "\u83b7\u53d6\u672c\u5730\u670d\u52a1\u5bc6\u94a5"));
        return result;
    }
}

