/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.controller.v2.partygroup;

import com.xdja.log.analysis.aop.annoation.AopLog;
import com.xdja.platform.common.lite.kit.StrKit;
import com.xdja.platform.common.lite.kit.json.JSONException;
import com.xdja.platform.common.lite.kit.json.JsonMapper;
import com.xdja.safecenter.ckms.opcode.OpCodeFactory;
import com.xdja.safecenter.secret.DataNotFoundException;
import com.xdja.safecenter.secret.controller.AbstractController;
import com.xdja.safecenter.secret.controller.ErrorMessage;
import com.xdja.safecenter.secret.controller.HttpError;
import com.xdja.safecenter.secret.core.verify.VerifyUtil;
import com.xdja.safecenter.secret.provider.cellgroup.IEntityProvider;
import com.xdja.safecenter.secret.provider.open.IOpenServiceProvider;
import com.xdja.safecenter.secret.provider.partygroup.IPartyGroupKeyProvider;
import com.xdja.safecenter.secret.provider.partygroup.IPartyGroupProvider;
import com.xdja.safecenter.secret.provider.partygroup.bean.request.DestroyPartyGroupBean;
import com.xdja.safecenter.secret.provider.partygroup.bean.request.EntityAddBean;
import com.xdja.safecenter.secret.provider.partygroup.bean.request.EntityQuitBean;
import com.xdja.safecenter.secret.provider.partygroup.bean.request.EntityRemoveBean;
import com.xdja.safecenter.secret.provider.partygroup.bean.request.Groupinfo;
import com.xdja.safecenter.secret.provider.partygroup.bean.request.PartyGroupCreateBean;
import com.xdja.safecenter.secret.provider.partygroup.bean.request.QuitAllGroupsBean;
import com.xdja.safecenter.secret.provider.partygroup.bean.request.UpdatePGKBean;
import com.xdja.safecenter.secret.provider.partygroup.bean.response.PEntityBean;
import com.xdja.safecenter.secret.provider.partygroup.exception.IllegalVersionException;
import com.xdja.safecenter.secret.provider.partygroup.exception.IsExsitException;
import com.xdja.safecenter.secret.provider.partygroup.exception.PartyGroupException;
import com.xdja.safecenter.secret.provider.todo.ITodoProvider;
import com.xdja.safecenter.secret.struct.Constants;
import com.xdja.safecenter.secret.struct.SourceDataStruct;
import com.xdja.safecenter.secret.struct.v2.DestroyInfo;
import com.xdja.safecenter.secret.struct.v2.EntityInfo;
import com.xdja.safecenter.secret.struct.v2.PartyGroupKey;
import com.xdja.safecenter.secret.struct.v2.PartyGroupStruct;
import com.xdja.safecenter.secret.struct.v2.QuitInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PartyGroupController
extends AbstractController {
    @Resource
    private IPartyGroupProvider partyGroupProvider;
    @Resource
    private IEntityProvider entityProvider;
    @Resource
    private IPartyGroupKeyProvider partyGroupKeyProvider;
    @Resource
    protected ITodoProvider TodoProvider;
    @Resource
    protected IOpenServiceProvider opCodeProvider;

    @AopLog
    @RequestMapping(value={"/api/v2/partyGroups"}, consumes={"application/json"}, method={RequestMethod.POST})
    public void create(HttpServletRequest request, HttpServletResponse resp, @RequestBody PartyGroupCreateBean reqBean) throws JSONException {
        if (VerifyUtil.hasNull((Object)reqBean)) {
            this.renderError(resp, HttpError.MISSING_REQUIRED_PARAMETERS);
            return;
        }
        String appID = this.getAppID(request);
        String sn = this.getSN(request);
        if (!this.verifyWithSyncPubK(reqBean.getPartyGroup(), appID, sn) || !this.verifyWithSyncPubK(reqBean.getPartyGroupKey(), appID, sn)) {
            this.renderError(resp, HttpError.VERIFY_WITH_SYNCPUB_ERROR);
            return;
        }
        if (!this.entityProvider.existEntity(appID, reqBean.getOpId())) {
            this.logger.error("\u5f85\u6dfb\u52a0\u7684entity\u4e0d\u5b58\u5728,\u521b\u5efaPartyGroup\u5931\u8d25");
            this.renderError(resp, HttpError.ENTITY_NOT_EXIST);
            return;
        }
        PartyGroupStruct partyGroupStruct = (PartyGroupStruct)JsonMapper.alwaysMapper().fromJson(reqBean.getPartyGroup().getInfo(), PartyGroupStruct.class);
        if (!partyGroupStruct.getCgIDs().containsKey(appID)) {
            this.renderError(resp, HttpError.HEAD_PARAM_NOT_MATCH_SOURCE);
            return;
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (EntityInfo bean : (List)partyGroupStruct.getCgIDs().get(appID)) {
            ids.add(bean.getCgID());
        }
        Map entityIDs = this.entityProvider.querycgIDsByEntityIds(appID, ids);
        if (ids.size() != entityIDs.size()) {
            this.logger.error("\u5f85\u6dfb\u52a0\u7684entity\u4e0d\u5b58\u5728,\u521b\u5efaPartyGroup\u5931\u8d25");
            this.renderError(resp, HttpError.ENTITY_NOT_EXIST);
            return;
        }
        if (!this.opCodeProvider.verifySign(this.getAppID(request), OpCodeFactory.Coder().createGroup(sn, partyGroupStruct.getPgID(), reqBean.getOpId(), ids.toArray(new String[ids.size()])), reqBean.getOpCode())) {
            this.renderError(resp, HttpError.ILLEGAL_OP_CODE);
            return;
        }
        try {
            this.partyGroupProvider.create(reqBean.getPartyGroup(), reqBean.getPartyGroupKey(), reqBean.getSyncedPgKey(), reqBean.getWrapedPgKey(), entityIDs);
        }
        catch (PartyGroupException e) {
            this.logger.error("\u521b\u5efaPartyGroup\u5931\u8d25", (Throwable)e);
            this.renderError(resp, HttpError.ILLEGAL_REQUEST_PARAMETER);
        }
        catch (IllegalVersionException e) {
            this.logger.error("\u521b\u5efaPartyGroup\u5931\u8d25", (Throwable)e);
            this.renderError(resp, HttpError.ILLEGAL_SOURCE_DATA_OF_VERSION);
        }
        catch (IsExsitException e) {
            this.logger.error("\u5f85\u521b\u5efa\u7684partyGroup\u5df2\u5b58\u5728", (Throwable)e);
            this.renderError(resp, HttpError.PARTYGROUP_IS_EXIST);
        }
        this.logger.info(this.format(request, reqBean.getOpId(), reqBean.getWrapedPgKey().getPgID(), "\u521b\u5efaGroup"));
    }

    @AopLog
    @RequestMapping(value={"/api/v2/partyGroups/{partyGroupID}/_search"}, consumes={"application/json"}, method={RequestMethod.POST})
    public Object getPartyGroup(HttpServletRequest request, HttpServletResponse resp, @PathVariable(value="partyGroupID") String partyGroupID, @RequestParam(required=true) String entityID, @RequestBody List<String> entityIDs) {
        if (VerifyUtil.isEmpty(entityIDs)) {
            return HttpError.MISSING_REQUIRED_PARAMETERS.handle(resp);
        }
        String appID = this.getAppID(request);
        String sn = this.getSN(request);
        if (!this.partyGroupProvider.existPartyGroup(partyGroupID)) {
            return HttpError.PARTYGROUP_NOT_EXIST.handle(resp);
        }
        HashMap<String, Object> respResult = new HashMap<String, Object>();
        if (!this.partyGroupProvider.isExsitCellGroupPartyGroup(entityID, partyGroupID)) {
            this.logger.error("entity\u3010{}\u3011\u4e0d\u5b58\u5728\u4e8ePartyGroup\u3010[]\u3011\u4e2d", (Object)entityID, (Object)partyGroupID);
            return HttpError.OPERATE_ENTITY_NOT_IN_PARTYGROUP.handle(resp);
        }
        if (!this.entityProvider.existDevice(appID, sn, entityID)) {
            this.logger.error("entity\u3010{}\u3011\u4e0d\u5b58\u5728\u8bbe\u5907\u3010[]\u3011", (Object)entityID, (Object)sn);
            return HttpError.DEVICE_OPERATE_ILLEGAL.handle(resp);
        }
        String pgData = this.partyGroupProvider.getPartyGroupData(partyGroupID);
        if (StrKit.isBlank((String)pgData)) {
            this.logger.error("\u3010{}\u3011\u5bf9\u5e94\u7684PartyGroup\u7ed3\u6784\u4f53\u5143\u6570\u636e\u4e0d\u5b58\u5728", (Object)partyGroupID);
            return HttpError.PARTYGROUP_NOT_EXIST.handle(resp);
        }
        respResult.put("partyGroup", this.convertToStruct(pgData));
        List<SourceDataStruct> cellGroupInfos = this.getCellGroupInfos(appID, entityIDs);
        if (entityIDs.size() != cellGroupInfos.size()) {
            this.logger.error("\u63d0\u4f9b\u7684Entity\u6807\u8bc6\u3010{}\u3011\u4e0e\u67e5\u627e\u5230\u7684\u7ed3\u6784\u4f53\u4e0d\u5339\u914d", entityIDs);
            return HttpError.ENTITY_NOT_EXIST.handle(resp);
        }
        respResult.put("cellGroupInfos", cellGroupInfos);
        try {
            respResult.put("wrapedPgKeys", this.partyGroupKeyProvider.getWrapedPgKeyDatas(partyGroupID, entityID, Constants.TYPE_ALL_WRAPPGKEY_VERSION, appID, sn));
            respResult.put("syncPgKeys", this.partyGroupKeyProvider.getUnwrapedPGK(appID, sn, entityID, partyGroupID, Constants.TYPE_ALL_WRAPPGKEY_VERSION));
        }
        catch (DataNotFoundException e) {
            return HttpError.PARTYGROUP_NOT_EXIST.handle(resp);
        }
        this.logger.info(this.format(request, entityID, partyGroupID, "\u83b7\u53d6Group"));
        return respResult;
    }

    private List<SourceDataStruct> getCellGroupInfos(String appID, List<String> entityIDs) {
        ArrayList<SourceDataStruct> cellGroupInfos = new ArrayList<SourceDataStruct>();
        String[] ids = new String[entityIDs.size()];
        for (String cellGroupData : this.entityProvider.getCellGroupDatasByEntityIDs(appID, entityIDs.toArray(ids))) {
            cellGroupInfos.add(this.convertToStruct(cellGroupData));
        }
        return cellGroupInfos;
    }

    @AopLog
    @RequestMapping(value={"/api/v2/partyGroups/{partyGroupID}/_searchAll"}, method={RequestMethod.POST})
    public Object getPartyGroup(HttpServletRequest request, HttpServletResponse resp, @PathVariable(value="partyGroupID") String partyGroupID, @RequestParam String result, @RequestParam int todo, @RequestBody String opId) {
        List ts;
        if (StringUtils.isBlank((CharSequence)opId)) {
            return HttpError.MISSING_REQUIRED_PARAMETERS.handle(resp);
        }
        if (!this.partyGroupProvider.existPartyGroup(partyGroupID)) {
            return HttpError.PARTYGROUP_NOT_EXIST.handle(resp);
        }
        if (!this.partyGroupProvider.isExsitCellGroupPartyGroup(opId, partyGroupID)) {
            this.logger.error("entity\u3010{}\u3011\u4e0d\u5b58\u5728\u4e8ePartyGroup\u3010[]\u3011\u4e2d", (Object)opId, (Object)partyGroupID);
            return HttpError.OPERATE_ENTITY_NOT_IN_PARTYGROUP.handle(resp);
        }
        if (!this.entityProvider.existDevice(this.getAppID(request), this.getSN(request), opId)) {
            return HttpError.ENTITY_NOT_EXIST.handle(resp);
        }
        HashMap respResult = new HashMap();
        if (todo == 1 && (ts = this.TodoProvider.getMissionsByGetEntity(this.getSN(request), this.getAppID(request), opId, false)).size() > 0) {
            respResult.put("todo", ts);
            return respResult;
        }
        String appID = this.getAppID(request);
        if (result.contains("partyGroup")) {
            respResult.put("partyGroup", this.convertToStruct(this.partyGroupProvider.getPartyGroupData(partyGroupID)));
            try {
                respResult.put("partyGroupKey", this.convertToStruct(this.partyGroupKeyProvider.getLatestPGKData(partyGroupID)));
            }
            catch (DataNotFoundException e) {
                return HttpError.PARTYGROUP_NOT_EXIST.handle(resp);
            }
        }
        if (result.contains("allPublicKey")) {
            List cellGroupIDs = this.partyGroupProvider.queryEntityIDsByPartyGroupID(partyGroupID);
            respResult.put("cellGroupInfos", this.getCellGroupInfos(appID, cellGroupIDs));
        }
        this.logger.info(this.format(request, opId, partyGroupID, "\u83b7\u53d6Group\u53ca\u6240\u6709\u540c\u6b65\u516c\u94a5"));
        return respResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AopLog
    @RequestMapping(value={"/api/v2/partyGroups/{partyGroupID}/entityAdd"}, method={RequestMethod.PUT})
    public void addEntity(HttpServletRequest request, HttpServletResponse resp, @PathVariable(value="partyGroupID") String partyGroupID, @RequestBody EntityAddBean reqBean) {
        String appID = this.getAppID(request);
        String sn = this.getSN(request);
        if (VerifyUtil.hasNull((Object)reqBean)) {
            this.renderError(resp, HttpError.MISSING_REQUIRED_PARAMETERS);
            return;
        }
        if (!this.partyGroupProvider.existPartyGroup(partyGroupID)) {
            this.renderError(resp, HttpError.PARTYGROUP_NOT_EXIST);
            return;
        }
        if (!this.verifyWithSyncPubK(reqBean.getPartyGroup(), appID, sn)) {
            this.renderError(resp, HttpError.VERIFY_WITH_SYNCPUB_ERROR);
            return;
        }
        if (!reqBean.getCgIDs().containsKey(appID)) {
            this.renderError(resp, HttpError.HEAD_PARAM_NOT_MATCH_SOURCE);
            return;
        }
        List ids = (List)reqBean.getCgIDs().get(appID);
        if (!this.opCodeProvider.verifySign(this.getAppID(request), OpCodeFactory.Coder().addEntity(sn, partyGroupID, reqBean.getOpId(), ids.toArray(new String[ids.size()])), reqBean.getOpCode())) {
            this.renderError(resp, HttpError.ILLEGAL_OP_CODE);
            return;
        }
        if (!this.partyGroupProvider.lock(partyGroupID)) {
            this.renderError(resp, HttpError.ILLEGAL_SOURCE_DATA_OF_VERSION);
            return;
        }
        try {
            Map entityIDs = this.entityProvider.querycgIDsByEntityIds(appID, ids);
            if (((List)reqBean.getCgIDs().get(appID)).size() != entityIDs.size()) {
                this.logger.error("\u5f85\u6dfb\u52a0\u7684entity\u4e0d\u5b58\u5728,\u65b0\u589eentity\u5931\u8d25");
                this.renderError(resp, HttpError.ENTITY_NOT_EXIST);
                return;
            }
            try {
                this.partyGroupProvider.addEntity(partyGroupID, reqBean.getPartyGroup(), (List)reqBean.getCgIDs().get(appID), reqBean.getSyncedPgKey(), entityIDs, sn);
            }
            catch (PartyGroupException e) {
                this.logger.error("\u5411PartyGroup\u6dfb\u52a0Entity\u5931\u8d25", (Throwable)e);
                this.renderError(resp, HttpError.ILLEGAL_REQUEST_PARAMETER);
            }
            catch (IllegalVersionException e) {
                this.logger.error("partyGroup\u7684\u7248\u672c\u53f7\u4e0d\u5339\u914d\uff0c\u5411PartyGroup\u6dfb\u52a0Entity\u5931\u8d25", (Throwable)e);
                this.renderError(resp, HttpError.ILLEGAL_SOURCE_DATA_OF_VERSION);
            }
            catch (IsExsitException e) {
                this.logger.error("Entity\u5df2\u5728partyGroup\u5185\uff0c\u5411PartyGroup\u6dfb\u52a0Entity\u5931\u8d25", (Throwable)e);
                this.renderError(resp, HttpError.ENTITY_IS_ALREADY_IN_PARTYGROUP);
            }
            this.logger.info(this.format(request, reqBean.getOpId(), partyGroupID, "\u5411Group\u4e2d\u65b0\u589eEntity\u3010" + reqBean.getCgIDs() + "\u3011"));
        }
        finally {
            this.partyGroupProvider.unlock(partyGroupID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AopLog
    @RequestMapping(value={"/api/v2/partyGroups/{partyGroupID}/entityRemove"}, method={RequestMethod.PUT})
    public void removeEntity(HttpServletRequest request, HttpServletResponse resp, @PathVariable(value="partyGroupID") String partyGroupID, @RequestBody EntityRemoveBean reqBean) throws JSONException {
        String appID = this.getAppID(request);
        String sn = this.getSN(request);
        if (VerifyUtil.hasNull((Object)reqBean)) {
            this.renderError(resp, HttpError.MISSING_REQUIRED_PARAMETERS);
            return;
        }
        PartyGroupStruct partyGroupStruct = (PartyGroupStruct)JsonMapper.alwaysMapper().fromJson(reqBean.getPartyGroup().getInfo(), PartyGroupStruct.class);
        if (!(Objects.equals(partyGroupID, reqBean.getWrapedPgKey().getPgID()) && Objects.equals(partyGroupID, partyGroupStruct.getPgID()) && Objects.equals(reqBean.getOpId(), reqBean.getWrapedPgKey().getCgID()))) {
            this.renderError(resp, HttpError.URL_PARAM_NOT_MATCH_SOURCE);
            return;
        }
        List ids = (List)reqBean.getCgIDs().get(appID);
        if (!this.opCodeProvider.verifySign(this.getAppID(request), OpCodeFactory.Coder().removeEntity(sn, partyGroupID, reqBean.getOpId(), ids.toArray(new String[ids.size()])), reqBean.getOpCode())) {
            this.renderError(resp, HttpError.ILLEGAL_OP_CODE);
            return;
        }
        if (!this.partyGroupProvider.lock(partyGroupID)) {
            this.renderError(resp, HttpError.ILLEGAL_SOURCE_DATA_OF_VERSION);
            return;
        }
        try {
            if (!this.partyGroupProvider.existPartyGroup(partyGroupID)) {
                this.renderError(resp, HttpError.PARTYGROUP_NOT_EXIST);
                return;
            }
            if (!this.entityProvider.existDevice(appID, sn, reqBean.getOpId())) {
                this.logger.error("\u82af\u7247\u3010{}\u3011\u5728\u5e94\u7528\u3010{}\u3011\u4e2d\u4e0d\u5c5e\u4e8e\u4efb\u4f55entity", (Object)sn, (Object)appID);
                this.renderError(resp, HttpError.OPERATE_DEVICE_NOT_IN_ENTITY);
                return;
            }
            if (!this.verifyWithSyncPubK(reqBean.getPartyGroup(), appID, sn) || !this.verifyWithSyncPubK(reqBean.getPartyGroupKey(), appID, sn)) {
                this.renderError(resp, HttpError.VERIFY_WITH_SYNCPUB_ERROR);
                return;
            }
            List cgIDs = this.partyGroupProvider.queryEntityIDsByPartyGroupID(partyGroupID);
            if (cgIDs == null || !cgIDs.contains(reqBean.getOpId())) {
                this.logger.error("\u82af\u7247\u3010{}\u3011\u5728\u5e94\u7528\u3010{}\u3011\u4e2d\u6240\u5c5e\u7684Entity{}\u4e0d\u662fPartyGroup\u3010{}\u3011\u7684\u6210\u5458", new Object[]{sn, appID, reqBean.getOpId(), partyGroupID});
                this.renderError(resp, HttpError.OPERATE_ENTITY_NOT_IN_PARTYGROUP);
                return;
            }
            if (!Objects.equals(partyGroupStruct.getAppID(), appID)) {
                this.renderError(resp, HttpError.HEAD_PARAM_NOT_MATCH_SOURCE);
                return;
            }
            for (String idStr : (List)reqBean.getCgIDs().get(appID)) {
                if (cgIDs.contains(idStr)) continue;
                this.logger.error("PartyGroup\u79fb\u9664Entity\u5931\u8d25, \u5f85\u5220\u9664EntityID\u3010{}\u3011\u5728partyGroup\u4e2d\u4e0d\u5b58\u5728\uff0cpartyGroup EntityIDs\u3010{}\u3011", (Object)idStr, (Object)cgIDs);
                this.renderError(resp, HttpError.ENTITY_OPERATE_ILLEGAL);
                return;
            }
            try {
                this.partyGroupProvider.removeEntity(partyGroupID, reqBean.getPartyGroup(), reqBean.getPartyGroupKey(), reqBean.getSyncedPgKey(), reqBean.getWrapedPgKey(), sn, (List)reqBean.getCgIDs().get(appID));
            }
            catch (PartyGroupException e) {
                this.logger.error("PartyGroupCel\u79fb\u9664lGroup\u5931\u8d25", (Throwable)e);
                this.renderError(resp, HttpError.ILLEGAL_REQUEST_PARAMETER);
            }
            catch (IllegalVersionException e) {
                this.logger.error("partyGroup\u7684\u7248\u672c\u4e0d\u5408\u6cd5\uff0c\u79fb\u9664Group\u5931\u8d25", (Throwable)e);
                this.renderError(resp, HttpError.ILLEGAL_SOURCE_DATA_OF_VERSION);
            }
            this.logger.info(this.format(request, reqBean.getOpId(), partyGroupID, "\u4eceGroup\u4e2d\u79fb\u9664Entity\u3010" + reqBean.getCgIDs() + "\u3011"));
        }
        finally {
            this.partyGroupProvider.unlock(partyGroupID);
        }
    }

    @AopLog
    @RequestMapping(value={"/api/v2/partyGroups/{partyGroupID}/entities"}, method={RequestMethod.GET})
    public Object getEntyties(HttpServletRequest request, HttpServletResponse resp, @PathVariable(value="partyGroupID") String partyGroupID) {
        if (!this.partyGroupProvider.existPartyGroup(partyGroupID)) {
            return HttpError.PARTYGROUP_NOT_EXIST.handle(resp);
        }
        String chipID = this.getChipID(request);
        String appID = this.getAppID(request);
        String sn = this.getSN(request);
        ArrayList<String> snList = new ArrayList<String>();
        snList.add(sn);
        HashMap snEntityIds = this.entityProvider.getEntitiesBySnAndAppId(snList, appID);
        if (!snEntityIds.containsKey(sn)) {
            this.logger.error("\u82af\u7247\u3010{}\u3011\u5728\u5e94\u7528\u3010{}\u3011\u4e2d\u4e0d\u5c5e\u4e8e\u4efb\u4f55entity", (Object)chipID, (Object)appID);
            return HttpError.OPERATE_DEVICE_NOT_IN_ENTITY.handle(resp);
        }
        Map result = this.partyGroupProvider.queryEntitiesByPartyGroupID(partyGroupID);
        List entities = (List)result.get(appID);
        if (entities != null && !entities.isEmpty()) {
            for (PEntityBean bean : entities) {
                if (!((List)snEntityIds.get(sn)).contains(bean.getEntityID())) continue;
                this.logger.info(this.format(request, bean.getEntityID(), partyGroupID, "\u83b7\u53d6Group\u4e2d\u6240\u6709\u7684Entity"));
                return result;
            }
        }
        return HttpError.OPERATE_ENTITY_NOT_IN_PARTYGROUP.handle(resp);
    }

    @AopLog
    @RequestMapping(value={"/api/v2/partyGroups/_search"}, method={RequestMethod.POST})
    public Object getPartyGroup(HttpServletRequest request, HttpServletResponse resp, @RequestBody List<String> entityIDs) {
        if (VerifyUtil.isEmpty(entityIDs)) {
            return HttpError.MISSING_REQUIRED_PARAMETERS.handle(resp);
        }
        String appID = this.getAppID(request);
        Map result = this.partyGroupProvider.queryPartyGroupIDsByEntityIDs(appID, entityIDs);
        if (result == null || result.isEmpty()) {
            return HttpError.ENTITY_NOT_IN_ANY_PARTYGROUP.handle(resp);
        }
        this.logger.info(this.format(request, entityIDs.toString(), null, "\u83b7\u53d6Entity\u6240\u5c5e\u7684\u6240\u6709Group"));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AopLog
    @RequestMapping(value={"/api/v2/partyGroups/{partyGroupID}/entities/drop"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public void entityQuit(HttpServletRequest request, HttpServletResponse resp, @PathVariable(value="partyGroupID") String partyGroupID, @RequestBody EntityQuitBean reqBean) throws JSONException {
        if (VerifyUtil.hasNull((Object)reqBean)) {
            this.renderError(resp, HttpError.MISSING_REQUIRED_PARAMETERS);
            return;
        }
        String appID = this.getAppID(request);
        String sn = this.getSN(request);
        if (!this.opCodeProvider.verifySign(this.getAppID(request), OpCodeFactory.Coder().quitGroup(sn, partyGroupID, reqBean.getOpId()), reqBean.getOpCode())) {
            this.renderError(resp, HttpError.ILLEGAL_OP_CODE);
            return;
        }
        if (!this.partyGroupProvider.lock(partyGroupID)) {
            this.renderError(resp, HttpError.ILLEGAL_SOURCE_DATA_OF_VERSION);
            return;
        }
        try {
            if (!this.partyGroupProvider.existPartyGroup(partyGroupID)) {
                this.renderError(resp, HttpError.PARTYGROUP_NOT_EXIST);
                return;
            }
            QuitInfo quitInfo = (QuitInfo)JsonMapper.alwaysMapper().fromJson(reqBean.getQuitInfo().getInfo(), QuitInfo.class);
            PartyGroupStruct partyGroup = (PartyGroupStruct)JsonMapper.alwaysMapper().fromJson(reqBean.getPartyGroup().getInfo(), PartyGroupStruct.class);
            if (!"2".equals(quitInfo.getType())) {
                this.logger.error("\u4f20\u5165\u7684\u4e3b\u52a8\u4ecePartyGroup\u9000\u51fa\u7c7b\u578b\u975e\u6cd5\uff0c\u5fc5\u987b\u662f\u30102\u3011\uff0c\u4e0d\u80fd\u662f\u3010{}\u3011", (Object)quitInfo.getType());
                this.renderError(resp, HttpError.ILLEGAL_REQUEST_PARAMETER);
                return;
            }
            if (!(Objects.equals(quitInfo.getAppID(), appID) && Objects.equals(partyGroup.getAppID(), appID) && Objects.equals(quitInfo.getId(), partyGroupID) && Objects.equals(partyGroup.getPgID(), partyGroupID) && reqBean.getOpId().equals(quitInfo.getCgID()))) {
                this.logger.error("entity\u4e3b\u52a8\u9000\u51fapartyGroup\u5931\u8d25 head\u4e2d\u53c2\u6570\u4e0e\u7ed3\u6784\u4f53\u53c2\u6570\u4e0d\u5339\u914d", (Object)sn, (Object)appID);
                this.renderError(resp, HttpError.URL_PARAM_NOT_MATCH_SOURCE);
                return;
            }
            if (!this.entityProvider.existDevice(appID, sn, reqBean.getOpId())) {
                this.logger.error("\u82af\u7247\u3010{}\u3011\u5728\u5e94\u7528\u3010{}\u3011\u4e2d\u4e0d\u5c5e\u4e8e\u4efb\u4f55entity", (Object)sn, (Object)appID);
                this.renderError(resp, HttpError.OPERATE_DEVICE_NOT_IN_ENTITY);
                return;
            }
            List cgIDs = this.partyGroupProvider.queryEntityIDsByPartyGroupID(partyGroupID);
            if (cgIDs == null || !cgIDs.contains(reqBean.getOpId())) {
                this.logger.error("\u82af\u7247\u3010{}\u3011\u5728\u5e94\u7528\u3010{}\u3011\u4e2d\u6240\u5c5e\u7684Entity{}\u4e0d\u662fPartyGroup\u3010{}\u3011\u7684\u6210\u5458", new Object[]{sn, appID, reqBean.getOpId(), partyGroupID});
                this.renderError(resp, HttpError.OPERATE_ENTITY_NOT_IN_PARTYGROUP);
                return;
            }
            if (!this.verifyWithSyncPubK(reqBean.getPartyGroup(), appID, sn) || !this.verifyWithSN(reqBean.getQuitInfo())) {
                this.renderError(resp, HttpError.VERIFY_WITH_SYNCPUB_ERROR);
                return;
            }
            try {
                if (cgIDs.size() == 1) {
                    this.partyGroupProvider.doDestroy(quitInfo.getId(), null);
                } else {
                    this.partyGroupProvider.doQuit(quitInfo, reqBean.getQuitInfo(), partyGroup, reqBean.getPartyGroup());
                }
            }
            catch (IllegalVersionException e) {
                this.logger.error("entity\u4e3b\u52a8\u9000\u51faPartyGroup\u5931\u8d25", (Throwable)e);
                this.renderError(resp, HttpError.ILLEGAL_SOURCE_DATA_OF_VERSION);
                this.partyGroupProvider.unlock(partyGroupID);
                return;
            }
            this.logger.info(this.format(request, reqBean.getOpId(), partyGroupID, "Entity\u4e3b\u52a8\u4eceGroup\u4e2d\u9000\u51fa"));
        }
        finally {
            this.partyGroupProvider.unlock(partyGroupID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AopLog
    @RequestMapping(value={"/api/v2/partyGroups/partyGroup/destroy"}, method={RequestMethod.PUT})
    public void partyGroupDestory(HttpServletRequest request, HttpServletResponse resp, @RequestBody DestroyPartyGroupBean reqBean) throws JSONException {
        if (VerifyUtil.hasNull((Object)reqBean)) {
            this.renderError(resp, HttpError.MISSING_REQUIRED_PARAMETERS);
            return;
        }
        String appID = this.getAppID(request);
        String sn = this.getSN(request);
        DestroyInfo info = (DestroyInfo)JsonMapper.alwaysMapper().fromJson(reqBean.getDestroyInfo().getInfo(), DestroyInfo.class);
        if (!this.opCodeProvider.verifySign(this.getAppID(request), OpCodeFactory.Coder().destroyGroup(sn, info.getId(), reqBean.getOpId()), reqBean.getOpCode())) {
            this.renderError(resp, HttpError.ILLEGAL_OP_CODE);
            return;
        }
        if (!this.partyGroupProvider.existPartyGroup(info.getId())) {
            this.renderError(resp, HttpError.PARTYGROUP_NOT_EXIST);
            return;
        }
        if (!"P".equalsIgnoreCase(info.getType())) {
            this.logger.error("\u9500\u6bc1PartyGroup\u7c7b\u578b\u975e\u6cd5\uff0c\u5fc5\u987b\u662f\u3010P\u3011\uff0c\u4e0d\u80fd\u662f\u3010{}\u3011", (Object)info.getType());
            this.renderError(resp, HttpError.ILLEGAL_REQUEST_PARAMETER);
            return;
        }
        if (!Objects.equals(info.getAppID(), appID)) {
            this.logger.error("\u9500\u6bc1PartyGroup\u5931\u8d25 head\u4e2d\u53c2\u6570\u4e0e\u7ed3\u6784\u4f53\u53c2\u6570\u4e0d\u5339\u914d", (Object)sn, (Object)appID);
            this.renderError(resp, HttpError.URL_PARAM_NOT_MATCH_SOURCE);
            return;
        }
        if (!this.verifyWithSN(reqBean.getDestroyInfo())) {
            this.renderError(resp, HttpError.VERIFY_WITH_CHIP_ERROR);
            return;
        }
        if (!this.partyGroupProvider.lock(info.getId())) {
            this.renderError(resp, HttpError.ILLEGAL_SOURCE_DATA_OF_VERSION);
            return;
        }
        try {
            if (!this.entityProvider.existDevice(appID, sn, reqBean.getOpId())) {
                this.logger.error("\u82af\u7247\u3010{}\u3011\u5728\u5e94\u7528\u3010{}\u3011\u4e2d\u4e0d\u5c5e\u4e8e\u4efb\u4f55entity", (Object)sn, (Object)appID);
                this.renderError(resp, HttpError.OPERATE_DEVICE_NOT_IN_ENTITY);
                return;
            }
            List cgIDs = this.partyGroupProvider.queryEntityIDsByPartyGroupID(info.getId());
            if (cgIDs == null || !cgIDs.contains(reqBean.getOpId())) {
                this.logger.error("\u82af\u7247\u3010{}\u3011\u5728\u5e94\u7528\u3010{}\u3011\u4e2d\u6240\u5c5e\u7684Entity{}\u4e0d\u662fPartyGroup\u3010{}\u3011\u7684\u6210\u5458", new Object[]{sn, appID, reqBean.getOpId(), info.getId()});
                this.renderError(resp, HttpError.OPERATE_ENTITY_NOT_IN_PARTYGROUP);
                return;
            }
            this.partyGroupProvider.doDestroy(info.getId(), reqBean.getDestroyInfo().toString());
            this.logger.info(this.format(request, reqBean.getOpId(), info.getId(), "\u9500\u6bc1Group"));
        }
        finally {
            this.partyGroupProvider.unlock(info.getId());
        }
    }

    @AopLog
    @RequestMapping(value={"/api/v2/partyGroups/{partyGroupID}/partyGroupKeys"}, method={RequestMethod.GET})
    public Object queryPGK(HttpServletRequest request, HttpServletResponse resp, @PathVariable(value="partyGroupID") String partyGroupID, @RequestParam String entityID, @RequestParam Long pgkVersion) {
        String sn;
        String appID = this.getAppID(request);
        if (!this.entityProvider.existDevice(appID, sn = this.getSN(request), entityID)) {
            return HttpError.ENTITY_NOT_EXIST.handle(resp);
        }
        if (!this.partyGroupProvider.isExsitCellGroupPartyGroup(entityID, partyGroupID)) {
            return HttpError.OPERATE_ENTITY_NOT_IN_PARTYGROUP.handle(resp);
        }
        LinkedHashMap<String, Object> respResult = new LinkedHashMap<String, Object>();
        try {
            List list = this.partyGroupKeyProvider.getWrapedPgKeyDatas(partyGroupID, entityID, pgkVersion, appID, sn);
            List syncPgKeys = this.partyGroupKeyProvider.getUnwrapedPGK(appID, sn, entityID, partyGroupID, pgkVersion);
            if ((list == null || list.isEmpty()) && (syncPgKeys == null || syncPgKeys.isEmpty())) {
                if (Objects.equals(pgkVersion, Constants.TYPE_ALL_WRAPPGKEY_VERSION)) {
                    return HttpError.PGKEY_IS_NOT_EXIS.handle(resp);
                }
                respResult.put("pgkVer", this.partyGroupKeyProvider.getLastedPgkVersion(partyGroupID) + "");
            }
            respResult.put("wrapedPgKeys", list);
            respResult.put("syncPgKeys", syncPgKeys);
        }
        catch (DataNotFoundException e) {
            return HttpError.PGKEY_IS_NOT_EXIS.handle(resp);
        }
        this.logger.info(this.format(request, entityID, partyGroupID, "\u83b7\u53d6Group\u4e0b\u7684Pgk\uff0c\u7248\u672c\u3010" + pgkVersion + "\u3011"));
        return respResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AopLog
    @RequestMapping(value={"/api/v2/partyGroups/{partyGroupID}/updatePGK"}, method={RequestMethod.PUT})
    public void updatePGK(HttpServletRequest request, HttpServletResponse resp, @PathVariable(value="partyGroupID") String partyGroupID, @RequestBody List<UpdatePGKBean> reqBeans) throws JSONException {
        String appID = this.getAppID(request);
        String sn = this.getSN(request);
        for (UpdatePGKBean reqBean : reqBeans) {
            if (VerifyUtil.hasNull((Object)reqBean)) {
                this.renderError(resp, HttpError.MISSING_REQUIRED_PARAMETERS);
                return;
            }
            if (!this.partyGroupProvider.lock(partyGroupID)) {
                this.renderError(resp, HttpError.ILLEGAL_SOURCE_DATA_OF_VERSION);
                return;
            }
            PartyGroupKey partyGroupKey = (PartyGroupKey)JsonMapper.alwaysMapper().fromJson(reqBean.getPartyGroupKey().getInfo(), PartyGroupKey.class);
            if (!Objects.equals(partyGroupID, partyGroupKey.getPgID()) || !Objects.equals(appID, partyGroupKey.getAppID())) {
                this.logger.error("\u66f4\u65b0pgk\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\u4e0e\u7ed3\u6784\u4f53\u53c2\u6570\u4e0d\u5339\u914d");
                this.renderError(resp, HttpError.URL_PARAM_NOT_MATCH_SOURCE);
                return;
            }
            try {
                Object pgKey2;
                if (!this.partyGroupProvider.existPartyGroup(partyGroupID)) {
                    this.renderError(resp, HttpError.PARTYGROUP_NOT_EXIST);
                    return;
                }
                if (!this.verifyWithSyncPubK(reqBean.getPartyGroupKey(), appID, sn)) {
                    this.renderError(resp, HttpError.VERIFY_WITH_SYNCPUB_ERROR);
                    return;
                }
                HashMap snEntityIds = this.entityProvider.getEntitiesBySnAndAppId(Collections.singletonList(sn), appID);
                if (!((List)snEntityIds.get(sn)).contains(reqBean.getOpId())) {
                    this.logger.error("\u66f4\u65b0pgk\u5931\u8d25\uff0c\u8bbe\u5907{}\u4e0d\u5728entity{}\u5185", (Object)sn, (Object)reqBean.getOpId());
                    this.renderError(resp, HttpError.OPERATE_DEVICE_NOT_IN_ENTITY);
                    return;
                }
                ArrayList<String> ids = new ArrayList<String>();
                for (Object pgKey2 : reqBean.getSyncedPgKey()) {
                    ids.add(pgKey2.getCgID());
                }
                Map entityIDs = this.entityProvider.querycgIDsByEntityIds(appID, ids);
                pgKey2 = ids.iterator();
                while (pgKey2.hasNext()) {
                    String eid = (String)pgKey2.next();
                    if (entityIDs.containsKey(eid)) continue;
                    this.logger.error("\u66f4\u65b0pgk\u5931\u8d25,\u65b0\u589eentity\u5931\u8d25");
                    this.renderError(resp, HttpError.ENTITY_NOT_EXIST);
                    return;
                }
                List pEntityIDs = this.partyGroupProvider.queryEntityIDsByPartyGroupID(partyGroupID);
                if (!pEntityIDs.contains(reqBean.getOpId())) {
                    this.logger.error("\u66f4\u65b0pgk\u5931\u8d25\uff0centity{}\u4e0d\u5728partyGroup{}\u5185", (Object)reqBean.getOpId(), (Object)partyGroupID);
                    this.renderError(resp, HttpError.OPERATE_ENTITY_NOT_IN_PARTYGROUP);
                    return;
                }
                try {
                    this.partyGroupProvider.doUpdatePGK(appID, reqBean, entityIDs, sn);
                }
                catch (PartyGroupException e) {
                    this.logger.error("\u66f4\u65b0pgk\u5931\u8d25", (Throwable)e);
                    this.renderError(resp, HttpError.ILLEGAL_REQUEST_PARAMETER);
                }
                catch (IllegalVersionException e) {
                    this.logger.error("partyGroup\u7684\u7248\u672c\u53f7\u4e0d\u5339\u914d\uff0c\u66f4\u65b0pgk\u5931\u8d25", (Throwable)e);
                    this.renderError(resp, HttpError.ILLEGAL_SOURCE_DATA_OF_VERSION);
                }
                this.logger.info(this.format(request, reqBean.getOpId(), partyGroupID, "\u66f4\u65b0PGK"));
            }
            finally {
                this.partyGroupProvider.unlock(partyGroupID);
            }
        }
    }

    @AopLog
    @RequestMapping(value={"/api/v2/partyGroups/{entityID}/getAll"}, method={RequestMethod.GET})
    public Object getAllGroups(HttpServletRequest request, HttpServletResponse resp, @PathVariable(value="entityID") String entityID) throws JSONException {
        String sn;
        String appID = this.getAppID(request);
        if (!this.entityProvider.existDevice(appID, sn = this.getSN(request), entityID)) {
            return HttpError.OPERATE_DEVICE_NOT_IN_ENTITY.handle(resp);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        Map groupsMap = this.partyGroupProvider.queryPartyGroupIDsByEntityIDs(appID, Collections.singletonList(entityID));
        List groupIds = (List)groupsMap.get(entityID);
        if (groupIds == null || groupIds.size() == 0) {
            return result;
        }
        for (String gid : groupIds) {
            String groupData = this.partyGroupProvider.getPartyGroupData(gid);
            if (!StringUtils.isNotEmpty((CharSequence)groupData)) continue;
            result.add(JsonMapper.alwaysMapper().fromJson(groupData, SourceDataStruct.class));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AopLog
    @RequestMapping(value={"/api/v2/partyGroups/entities/quit"}, method={RequestMethod.PUT})
    public Object quitGroups(HttpServletRequest request, HttpServletResponse resp, @RequestBody QuitAllGroupsBean reqBean) throws JSONException {
        if (VerifyUtil.hasNull((Object)reqBean)) {
            return HttpError.MISSING_REQUIRED_PARAMETERS.handle(resp);
        }
        String appID = this.getAppID(request);
        String sn = this.getSN(request);
        if (!this.opCodeProvider.verifySign(this.getAppID(request), OpCodeFactory.Coder().destroyEntity(sn, reqBean.getOpId()), reqBean.getOpCode())) {
            return HttpError.ILLEGAL_OP_CODE.handle(resp);
        }
        boolean done = true;
        for (Groupinfo info : reqBean.getGroups()) {
            List cgIDs;
            String partyGroupID;
            PartyGroupStruct partyGroup;
            QuitInfo quitInfo;
            block25: {
                block24: {
                    block23: {
                        block22: {
                            ErrorMessage errorMessage;
                            block21: {
                                block20: {
                                    quitInfo = (QuitInfo)JsonMapper.alwaysMapper().fromJson(info.getQuitInfo().getInfo(), QuitInfo.class);
                                    partyGroup = (PartyGroupStruct)JsonMapper.alwaysMapper().fromJson(info.getPartyGroup().getInfo(), PartyGroupStruct.class);
                                    partyGroupID = partyGroup.getPgID();
                                    if (!this.partyGroupProvider.lock(partyGroupID)) {
                                        this.logger.error("\u6307\u5b9aGroup\u3010{}\u3011\u4fee\u6539\u5e76\u53d1\u51b2\u7a81", (Object)partyGroupID);
                                        done = false;
                                        continue;
                                    }
                                    if (this.partyGroupProvider.existPartyGroup(partyGroupID)) break block20;
                                    this.logger.error("\u4e0d\u5b58\u5728\u6307\u5b9aGroup\u3010{}\u3011", (Object)partyGroupID);
                                    done = false;
                                    this.partyGroupProvider.unlock(partyGroupID);
                                    continue;
                                }
                                if ("2".equals(quitInfo.getType())) break block21;
                                this.logger.error("\u4f20\u5165\u7684\u4e3b\u52a8\u4ecePartyGroup\u9000\u51fa\u7c7b\u578b\u975e\u6cd5\uff0c\u5fc5\u987b\u662f\u30102\u3011\uff0c\u4e0d\u80fd\u662f\u3010{}\u3011", (Object)quitInfo.getType());
                                errorMessage = HttpError.ILLEGAL_REQUEST_PARAMETER.handle(resp);
                                this.partyGroupProvider.unlock(partyGroupID);
                                return errorMessage;
                            }
                            if (Objects.equals(quitInfo.getAppID(), appID) && Objects.equals(partyGroup.getAppID(), appID) && Objects.equals(quitInfo.getId(), partyGroupID) && Objects.equals(partyGroup.getPgID(), partyGroupID) && reqBean.getOpId().equals(quitInfo.getCgID())) break block22;
                            this.logger.error("entity\u4e3b\u52a8\u9000\u51fapartyGroup\u5931\u8d25 head\u4e2d\u53c2\u6570\u4e0e\u7ed3\u6784\u4f53\u53c2\u6570\u4e0d\u5339\u914d", (Object)sn, (Object)appID);
                            errorMessage = HttpError.URL_PARAM_NOT_MATCH_SOURCE.handle(resp);
                            this.partyGroupProvider.unlock(partyGroupID);
                            return errorMessage;
                        }
                        if (this.entityProvider.existDevice(appID, sn, reqBean.getOpId())) break block23;
                        this.logger.error("\u82af\u7247\u3010{}\u3011\u5728\u5e94\u7528\u3010{}\u3011\u4e2d\u4e0d\u5c5e\u4e8e\u4efb\u4f55entity", (Object)sn, (Object)appID);
                        done = false;
                        this.partyGroupProvider.unlock(partyGroupID);
                        continue;
                    }
                    cgIDs = this.partyGroupProvider.queryEntityIDsByPartyGroupID(partyGroupID);
                    if (cgIDs != null && cgIDs.contains(reqBean.getOpId())) break block24;
                    this.logger.error("\u82af\u7247\u3010{}\u3011\u5728\u5e94\u7528\u3010{}\u3011\u4e2d\u6240\u5c5e\u7684Entity\u3010{}\u3011\u4e0d\u662fPartyGroup\u3010{}\u3011\u7684\u6210\u5458", new Object[]{sn, appID, reqBean.getOpId(), partyGroupID});
                    done = false;
                    this.partyGroupProvider.unlock(partyGroupID);
                    continue;
                }
                if (this.verifyWithSyncPubK(info.getPartyGroup(), appID, sn) && this.verifyWithSN(info.getQuitInfo())) break block25;
                done = false;
                this.partyGroupProvider.unlock(partyGroupID);
                continue;
            }
            try {
                if (cgIDs.size() == 1) {
                    this.partyGroupProvider.doDestroy(quitInfo.getId(), null);
                } else {
                    this.partyGroupProvider.doQuit(quitInfo, info.getQuitInfo(), partyGroup, info.getPartyGroup());
                }
            }
            catch (IllegalVersionException e) {
                this.logger.error("\u4fee\u6539Group\u3010{}\u3011\u7684\u7248\u672c\u53f7\u4e0d\u5339\u914d:{}", (Object)partyGroupID, (Object)e.getMessage());
                done = false;
                this.partyGroupProvider.unlock(partyGroupID);
                continue;
            }
            try {
                this.logger.info(this.format(request, reqBean.getOpId(), partyGroupID, "Entity\u4e3b\u52a8\u4eceGroup\u4e2d\u9000\u51fa"));
            }
            finally {
                this.partyGroupProvider.unlock(partyGroupID);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (done) {
            result.put("code", 0);
        } else {
            result.put("code", 1);
            result.put("msg", "Quit Error");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @AopLog
    @RequestMapping(value={"/api/v2/partyGroups/{partyGroupID}/updatePGKNew"}, method={RequestMethod.PUT})
    public Object updatePGKNew(HttpServletRequest request, HttpServletResponse resp, @PathVariable(value="partyGroupID") String partyGroupID, @RequestBody List<UpdatePGKBean> reqBeans) throws JSONException {
        LinkedHashMap<String, Integer> respResult = new LinkedHashMap<String, Integer>();
        String appID = this.getAppID(request);
        String sn = this.getSN(request);
        if (VerifyUtil.isEmpty(reqBeans)) {
            return HttpError.MISSING_REQUIRED_PARAMETERS.handle(resp);
        }
        for (UpdatePGKBean reqBean : reqBeans) {
            if (VerifyUtil.hasNull((Object)reqBean)) {
                return HttpError.MISSING_REQUIRED_PARAMETERS.handle(resp);
            }
            if (!this.partyGroupProvider.lock(partyGroupID)) {
                return HttpError.ILLEGAL_SOURCE_DATA_OF_VERSION.handle(resp);
            }
            PartyGroupKey partyGroupKey = (PartyGroupKey)JsonMapper.alwaysMapper().fromJson(reqBean.getPartyGroupKey().getInfo(), PartyGroupKey.class);
            if (!Objects.equals(partyGroupID, partyGroupKey.getPgID()) || !Objects.equals(appID, partyGroupKey.getAppID())) {
                this.logger.error("\u66f4\u65b0pgk\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\u4e0e\u7ed3\u6784\u4f53\u53c2\u6570\u4e0d\u5339\u914d");
                return HttpError.ILLEGAL_SOURCE_DATA_OF_VERSION.handle(resp);
            }
            try {
                Object eid;
                Object pgKey2222;
                ErrorMessage errorMessage;
                if (!this.partyGroupProvider.existPartyGroup(partyGroupID)) {
                    errorMessage = HttpError.PARTYGROUP_NOT_EXIST.handle(resp);
                    return errorMessage;
                }
                if (!this.verifyWithSyncPubK(reqBean.getPartyGroupKey(), appID, sn)) {
                    errorMessage = HttpError.VERIFY_WITH_SYNCPUB_ERROR.handle(resp);
                    return errorMessage;
                }
                HashMap snEntityIds = this.entityProvider.getEntitiesBySnAndAppId(Collections.singletonList(sn), appID);
                if (!((List)snEntityIds.get(sn)).contains(reqBean.getOpId())) {
                    this.logger.error("\u66f4\u65b0pgk\u5931\u8d25\uff0c\u8bbe\u5907{}\u4e0d\u5728entity{}\u5185", (Object)sn, (Object)reqBean.getOpId());
                    ErrorMessage errorMessage2 = HttpError.OPERATE_DEVICE_NOT_IN_ENTITY.handle(resp);
                    return errorMessage2;
                }
                long pgkver = this.partyGroupKeyProvider.getLastedPgkVersion(partyGroupID);
                if (String.valueOf(pgkver).equals(partyGroupKey.getPgkVer())) {
                    respResult.put("flag", 1);
                    try {
                        List list = this.partyGroupKeyProvider.getWrapedPgKeyDatas(partyGroupID, reqBean.getOpId(), Long.valueOf(pgkver), appID, sn);
                        if (list != null && !list.isEmpty()) {
                            respResult.put("wrapedPgKey", (Integer)list.get(0));
                        }
                    }
                    catch (DataNotFoundException list) {
                        // empty catch block
                    }
                    List syncPgKeys = this.partyGroupKeyProvider.getUnwrapedPGK(appID, sn, reqBean.getOpId(), partyGroupID, Long.valueOf(pgkver));
                    if (syncPgKeys != null && !syncPgKeys.isEmpty()) {
                        respResult.put("syncPgKey", (Integer)syncPgKeys.get(0));
                    }
                    LinkedHashMap<String, Integer> linkedHashMap = respResult;
                    return linkedHashMap;
                }
                ArrayList<String> ids = new ArrayList<String>();
                for (Object pgKey2222 : reqBean.getSyncedPgKey()) {
                    ids.add(pgKey2222.getCgID());
                }
                Map entityIDs = this.entityProvider.querycgIDsByEntityIds(appID, ids);
                pgKey2222 = ids.iterator();
                while (pgKey2222.hasNext()) {
                    eid = (String)pgKey2222.next();
                    if (entityIDs.containsKey(eid)) continue;
                    this.logger.error("\u66f4\u65b0pgk\u5931\u8d25,\u65b0\u589eentity\u5931\u8d25");
                    ErrorMessage errorMessage3 = HttpError.ENTITY_NOT_EXIST.handle(resp);
                    return errorMessage3;
                }
                List pEntityIDs = this.partyGroupProvider.queryEntityIDsByPartyGroupID(partyGroupID);
                if (!pEntityIDs.contains(reqBean.getOpId())) {
                    this.logger.error("\u66f4\u65b0pgk\u5931\u8d25\uff0centity{}\u4e0d\u5728partyGroup{}\u5185", (Object)reqBean.getOpId(), (Object)partyGroupID);
                    eid = HttpError.OPERATE_ENTITY_NOT_IN_PARTYGROUP.handle(resp);
                    return eid;
                }
                try {
                    this.partyGroupProvider.doUpdatePGK(appID, reqBean, entityIDs, sn);
                }
                catch (PartyGroupException e) {
                    this.logger.error("\u66f4\u65b0pgk\u5931\u8d25", (Throwable)e);
                    ErrorMessage errorMessage4 = HttpError.ILLEGAL_REQUEST_PARAMETER.handle(resp);
                    this.partyGroupProvider.unlock(partyGroupID);
                    return errorMessage4;
                }
                catch (IllegalVersionException e) {
                    this.logger.error("partyGroup\u7684\u7248\u672c\u53f7\u4e0d\u5339\u914d\uff0c\u66f4\u65b0pgk\u5931\u8d25", (Throwable)e);
                    ErrorMessage errorMessage5 = HttpError.ILLEGAL_SOURCE_DATA_OF_VERSION.handle(resp);
                    this.partyGroupProvider.unlock(partyGroupID);
                    return errorMessage5;
                }
                this.logger.info(this.format(request, reqBean.getOpId(), partyGroupID, "\u66f4\u65b0PGK"));
                continue;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.partyGroupProvider.unlock(partyGroupID);
            }
        }
        respResult.put("flag", 0);
        return respResult;
    }
}

