/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.controller.v2.region;

import com.xdja.log.analysis.aop.annoation.AopLog;
import com.xdja.platform.common.lite.kit.json.JSONException;
import com.xdja.platform.common.lite.kit.json.JsonMapper;
import com.xdja.safecenter.secret.controller.AbstractController;
import com.xdja.safecenter.secret.controller.HttpError;
import com.xdja.safecenter.secret.provider.backup.bean.ResultBean;
import com.xdja.safecenter.secret.provider.cellgroup.IEntityProvider;
import com.xdja.safecenter.secret.provider.region.IRegionProvider;
import com.xdja.safecenter.secret.provider.region.bean.RegionBean;
import com.xdja.safecenter.secret.provider.region.bean.RestoreResult;
import com.xdja.safecenter.secret.provider.restore.RestoreProvider;
import com.xdja.safecenter.secret.provider.restore.bean.EntityInfo;
import com.xdja.safecenter.secret.provider.restore.bean.UploadRestoreKeyReq;
import com.xdja.safecenter.secret.provider.restore.bean.UploadSecretkeyInfo;
import com.xdja.safecenter.secret.provider.todo.ITodoProvider;
import com.xdja.safecenter.secret.struct.v2.CellGroupStruct;
import com.xdja.safecenter.secret.struct.v2.KekWrapKey;
import com.xdja.safecenter.secret.struct.v2.SyncPubKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RegionController
extends AbstractController {
    @Resource
    private IRegionProvider regionProvider;
    @Resource
    private IEntityProvider entityProvider;
    @Resource
    private RestoreProvider restoreProvider;
    @Resource
    protected ITodoProvider toDoProvider;

    @AopLog
    @RequestMapping(value={"/api/v2/region/report"}, method={RequestMethod.POST}, consumes={"application/json"})
    public void reportRegion(@RequestBody RegionBean req, HttpServletRequest request, HttpServletResponse resp) {
        this.logger.debug("\u6536\u5230\u4e0a\u62a5\u8bbe\u5907\u79c1\u6709\u57df\u4fe1\u606f\u8bf7\u6c42\uff0c[sn={}\uff0cRegion={}]", (Object)this.getSn(request), (Object)req.toString());
        if (null == req || StringUtils.isBlank((CharSequence)this.getSn(request)) || StringUtils.isBlank((CharSequence)req.getName()) || StringUtils.isBlank((CharSequence)req.getAppName()) || StringUtils.isBlank((CharSequence)req.getPkName()) || StringUtils.isBlank((CharSequence)req.getInterfaceId()) || StringUtils.isBlank((CharSequence)req.getDesc())) {
            this.renderError(resp, HttpError.ILLEGAL_REQUEST_PARAMETER);
            return;
        }
        this.regionProvider.doReportRegion(req, this.getSN(request));
        this.logger.info("\u4e0a\u62a5\u8bbe\u5907\u79c1\u6709\u57df\u4fe1\u606f\u6210\u529f\uff0c[sn={}\uff0cRegionBean={}]", (Object)this.getSn(request), (Object)req.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AopLog
    @RequestMapping(value={"/api/v2/region/upload/{chipSn}/{backNo}/kek"}, method={RequestMethod.POST}, consumes={"application/json"})
    public void uploadDeviceEncKek(@PathVariable(value="chipSn") String chipSn, @PathVariable(value="backNo") String backNo, @RequestBody UploadRestoreKeyReq req, HttpServletRequest request, HttpServletResponse resp) throws JSONException {
        this.logger.debug("\u6536\u5230\u4e0a\u4f20\u6062\u590d\u8bbe\u5907\u52a0\u5bc6KEK\u8bf7\u6c42");
        if (!this.checkParams(chipSn, this.getSn(request), backNo, req)) {
            this.renderError(resp, HttpError.ILLEGAL_REQUEST_PARAMETER);
            return;
        }
        HashMap<String, List<String>> appEntityIds = new HashMap<String, List<String>>();
        HttpError httpError = this.checSecretKey(req, appEntityIds);
        if (null != httpError) {
            this.renderError(resp, httpError);
            return;
        }
        if (!this.lock(appEntityIds, true)) {
            this.renderError(resp, HttpError.ILLEGAL_SOURCE_DATA_OF_VERSION);
            return;
        }
        try {
            int result = this.regionProvider.doUploadDeviceEncKek(chipSn, backNo, this.getSn(request), this.getCardId(request), req);
            switch (result) {
                case 2: {
                    this.logger.error("\u4e0a\u4f20\u6062\u590d\u8bbe\u5907\u52a0\u5bc6KEK\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5907\u4efd\u8bbe\u5907\u4e0e\u5907\u4efd\u5361\u672a\u7ed1\u5b9a, [bSn={},backNo={}]", (Object)chipSn, (Object)backNo);
                    this.renderError(resp, HttpError.BA_DEV_AND_BA_CARD_NOT_BIND);
                    return;
                }
                case 3: {
                    this.logger.error("\u4e0a\u4f20\u6062\u590d\u8bbe\u5907\u52a0\u5bc6KEK\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6062\u590d\u8bbe\u5907\u7684kek\u4e0d\u5b58\u5728, [rSn={},kekId={}]", (Object)this.getSn(request), (Object)req.getEncKekId());
                    this.renderError(resp, HttpError.RESTORE_DEV_KEK_NOT_EXIST);
                    return;
                }
                case 4: {
                    this.logger.error("\u4e0a\u4f20\u6062\u590d\u8bbe\u5907\u52a0\u5bc6KEK\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8bbe\u5907\u4e0ekek\u4e0d\u5339\u914d, [rSn={},kekId={}]", (Object)this.getSn(request), (Object)req.getEncKekId());
                    this.renderError(resp, HttpError.DEV_KEK_NOT_RELATION);
                    return;
                }
                case 5: {
                    this.logger.error("\u4e0a\u4f20\u6062\u590d\u8bbe\u5907\u52a0\u5bc6KEK\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u65e0\u6548\u7684\u5907\u4efd\u5361, [backNo={}]", (Object)backNo);
                    this.renderError(resp, HttpError.INVALID_BACKUP_CARD);
                    return;
                }
                case 6: {
                    this.logger.error("\u4e0a\u4f20\u6062\u590d\u8bbe\u5907\u52a0\u5bc6KEK\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5907\u4efd\u4e0e\u6062\u590d\u8bbe\u5907\u4e0d\u80fd\u4e00\u6837, [bSn={},rSn={}]", (Object)chipSn, (Object)this.getSn(request));
                    this.renderError(resp, HttpError.BA_DEV_AND_RES_DEV_NOT_SAME);
                    return;
                }
            }
            this.logger.info("\u6267\u884c\u4e0a\u4f20\u6062\u590d\u8bbe\u5907\u52a0\u5bc6KEK\u6210\u529f [bSn={},rSn={},backNo={},kekId={}]", new Object[]{chipSn, this.getSn(request), backNo, req.getEncKekId()});
        }
        finally {
            this.lock(appEntityIds, false);
        }
    }

    @AopLog
    @RequestMapping(value={"/api/v2/region/restore/result"}, method={RequestMethod.POST}, consumes={"application/json"})
    public void reportRestoreResult(@RequestBody List<RestoreResult> req, HttpServletRequest request, HttpServletResponse resp) {
        this.logger.debug("\u6536\u5230\u4e0a\u62a5\u79c1\u6709\u57df\u6062\u590d\u7ed3\u679c\u8bf7\u6c42");
        if (!this.checkRestoreResultParams(req, this.getSn(request))) {
            this.renderError(resp, HttpError.ILLEGAL_REQUEST_PARAMETER);
            return;
        }
        int result = this.regionProvider.doReportRestoreResult(req, this.getSn(request));
        switch (result) {
            case 2: {
                this.logger.error("\u4e0a\u62a5\u79c1\u6709\u57df\u6062\u590d\u7ed3\u679c\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6062\u590d\u8bbe\u5907\u4e0e\u5907\u4efd\u5361\u65e0\u5bf9\u5e94\u5173\u7cfb");
                this.renderError(resp, HttpError.RES_DEV_AND_BA_CARD_NOT_RELATION);
                return;
            }
            case 3: {
                this.logger.error("\u4e0a\u62a5\u79c1\u6709\u57df\u6062\u590d\u7ed3\u679c\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5907\u4efd\u3001\u6062\u590d\u8bbe\u5907\u65e0\u6062\u590d\u5173\u7cfb");
                this.renderError(resp, HttpError.BA_RES_DEV_NOT_RESTORE_RELATION);
                return;
            }
            case 4: {
                this.logger.error("\u4e0a\u62a5\u79c1\u6709\u57df\u6062\u590d\u7ed3\u679c\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u79c1\u6709\u57df\u4e0d\u5728\u6062\u590d\u8303\u56f4");
                this.renderError(resp, HttpError.REGION_NOT_IN_RESTORE_SCOPE);
                return;
            }
        }
        this.logger.debug("\u4e0a\u62a5\u79c1\u6709\u57df\u6062\u590d\u7ed3\u679c\u6210\u529f");
    }

    @AopLog
    @RequestMapping(value={"/api/v2/region/{backNo}"}, method={RequestMethod.GET}, consumes={"application/json"})
    public Object getStayRestoreRegion(@PathVariable String backNo, HttpServletRequest request, HttpServletResponse resp) {
        this.logger.debug("\u6536\u5230\u83b7\u53d6\u5f85\u6062\u590d\u79c1\u6709\u57df\u5217\u8868\u8bf7\u6c42");
        if (StringUtils.isBlank((CharSequence)backNo) || StringUtils.isBlank((CharSequence)this.getSn(request))) {
            return HttpError.ILLEGAL_REQUEST_PARAMETER.handle(resp);
        }
        ResultBean result = this.regionProvider.getStayRestoreRegion(this.getSn(request), backNo);
        switch (result.getCode()) {
            case 2: {
                this.logger.error("\u83b7\u53d6\u5f85\u6062\u590d\u79c1\u6709\u57df\u5217\u8868\u6267\u884c\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u67e5\u8be2\u5230\u5f85\u6062\u590d\u79c1\u6709\u57df\uff0c[sn={},backNo={}]", (Object)this.getSn(request), (Object)backNo);
                return HttpError.NOT_QUERY_STAY_RESTORE_REGION.handle(resp);
            }
            case 3: {
                this.logger.error("\u83b7\u53d6\u5f85\u6062\u590d\u79c1\u6709\u57df\u5217\u8868\u6267\u884c\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u67e5\u8be2\u5230\u6062\u590d\u8bbe\u5907kek\u52a0\u5bc6\u7684\u5907\u4efd\u8bbe\u5907kek\uff0c[sn={},backNo={}]", (Object)this.getSn(request), (Object)backNo);
                return HttpError.NOT_QUERY_RES_DEV_ENC_KEK.handle(resp);
            }
        }
        this.logger.info("\u83b7\u53d6\u5f85\u6062\u590d\u79c1\u6709\u57df\u5217\u8868\u6267\u884c\u6210\u529f\uff0c[sn={},backNo={}]", (Object)this.getSn(request), (Object)backNo);
        return result.getInfo();
    }

    @AopLog
    @RequestMapping(value={"/api/v2/region/records"}, method={RequestMethod.GET}, consumes={"application/json"})
    public Object queryRestoreRecord(HttpServletRequest request, HttpServletResponse resp) throws JSONException {
        this.logger.debug("\u6536\u5230\u67e5\u8be2\u8bbe\u5907\u6062\u590d\u8bb0\u5f55\u8bf7\u6c42  [sn={}]", (Object)this.getSn(request));
        if (StringUtils.isBlank((CharSequence)this.getSn(request))) {
            return HttpError.ILLEGAL_REQUEST_PARAMETER.handle(resp);
        }
        List result = this.regionProvider.queryRestorerecord(this.getSn(request));
        this.logger.debug("\u67e5\u8be2\u8bbe\u5907\u6062\u590d\u8bb0\u5f55\u8bf7\u6c42\u6267\u884c\u5b8c\u6210");
        return result;
    }

    @AopLog
    @RequestMapping(value={"/api/v2/region/restore/{chipSn}/{backNo}/secretKey"}, method={RequestMethod.GET}, consumes={"application/json"})
    public Object queryRegionSecretKey(@PathVariable(value="chipSn") String chipSn, @PathVariable(value="backNo") String backNo, @RequestParam int todo, HttpServletRequest req, HttpServletResponse resp) throws JSONException {
        List toDoList;
        this.logger.debug("\u6536\u5230\u67e5\u8be2\u79c1\u6709\u57df\u8bbe\u5907\u5f85\u6062\u590d\u5bc6\u94a5\u8bf7\u6c42");
        if (StringUtils.isBlank((CharSequence)chipSn) || StringUtils.isBlank((CharSequence)backNo) || StringUtils.isBlank((CharSequence)this.getSn(req)) || todo != 0 && todo != 1) {
            return HttpError.ILLEGAL_REQUEST_PARAMETER.handle(resp);
        }
        if (this.regionProvider.isRestoreSuccess(this.getSn(req), backNo)) {
            this.logger.error("\u67e5\u8be2\u79c1\u6709\u57df\u8bbe\u5907\u5f85\u6062\u590d\u5bc6\u94a5\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8bbe\u5907\u4e0a\u6b21\u5df2\u6062\u590d\u6210\u529f  [bSn={},rSn={},backNo={}]", new Object[]{chipSn, this.getSn(req), backNo});
            return HttpError.DEV_ALREADY_RESTORE_SUCCESS.handle(resp);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("todo", new Object[0]);
        result.put("secretKeys", new Object[0]);
        if (todo == 1 && null != (toDoList = this.toDoProvider.getRestoreMissionsByDevice(chipSn, null, null, null)) && !toDoList.isEmpty()) {
            result.put("todo", toDoList);
            return result;
        }
        List secretKeys = this.restoreProvider.querySecretKeys(chipSn);
        if (null != secretKeys) {
            result.put("secretKeys", secretKeys);
        }
        this.logger.debug("\u67e5\u8be2\u79c1\u6709\u57df\u8bbe\u5907\u5f85\u6062\u590d\u5bc6\u94a5\u8bf7\u6c42\u6267\u884c\u5b8c\u6210");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AopLog
    @RequestMapping(value={"/api/v2/region/restore/{chipSn}/{backNo}/upload/secretKey"}, method={RequestMethod.POST}, consumes={"application/json"})
    public void uploadRegionSecretKey(@PathVariable(value="chipSn") String chipSn, @PathVariable(value="backNo") String backNo, @RequestBody UploadRestoreKeyReq req, HttpServletRequest request, HttpServletResponse resp) throws JSONException {
        this.logger.debug("\u6536\u5230\u4e0a\u4f20\u79c1\u6709\u57df\u5df2\u6062\u590d\u5bc6\u94a5\u8bf7\u6c42");
        if (!this.checkParams(chipSn, this.getSn(request), backNo, req)) {
            this.renderError(resp, HttpError.ILLEGAL_REQUEST_PARAMETER);
            return;
        }
        HashMap<String, List<String>> appEntityIds = new HashMap<String, List<String>>();
        HttpError httpError = this.checSecretKey(req, appEntityIds);
        if (null != httpError) {
            this.renderError(resp, httpError);
            return;
        }
        if (this.regionProvider.isRestoreSuccess(this.getSn(request), backNo)) {
            this.logger.error("\u4e0a\u4f20\u79c1\u6709\u57df\u5df2\u6062\u590d\u5bc6\u94a5\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8bbe\u5907\u4e0a\u6b21\u5df2\u6062\u590d\u6210\u529f  [bSn={},rSn={},backNo={}]", new Object[]{chipSn, this.getSn(request), backNo});
            this.renderError(resp, HttpError.DEV_ALREADY_RESTORE_SUCCESS);
            return;
        }
        if (!this.lock(appEntityIds, true)) {
            this.renderError(resp, HttpError.ILLEGAL_SOURCE_DATA_OF_VERSION);
            return;
        }
        try {
            int result = this.regionProvider.doUploadRegionSecretKey(chipSn, backNo, this.getSn(request), this.getCardId(request), req);
            switch (result) {
                case 2: {
                    this.logger.error("\u4e0a\u4f20\u79c1\u6709\u57df\u5df2\u6062\u590d\u5bc6\u94a5\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5907\u4efd\u4e0e\u6062\u590d\u8bbe\u5907\u4e0d\u80fd\u4e00\u6837, [bSn={},rSn={}]", (Object)chipSn, (Object)this.getSn(request));
                    this.renderError(resp, HttpError.BA_DEV_AND_RES_DEV_NOT_SAME);
                    return;
                }
                case 3: {
                    this.logger.error("\u4e0a\u4f20\u79c1\u6709\u57df\u5df2\u6062\u590d\u5bc6\u94a5\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6062\u590d\u8bbe\u5907\u7684kek\u4e0d\u5b58\u5728, [rSn={},kekId={}]", (Object)this.getSn(request), (Object)req.getEncKekId());
                    this.renderError(resp, HttpError.RESTORE_DEV_KEK_NOT_EXIST);
                    return;
                }
                case 4: {
                    this.logger.error("\u4e0a\u4f20\u79c1\u6709\u57df\u5df2\u6062\u590d\u5bc6\u94a5\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8bbe\u5907\u4e0ekek\u4e0d\u5339\u914d, [rSn={},kekId={}]", (Object)this.getSn(request), (Object)req.getEncKekId());
                    this.renderError(resp, HttpError.DEV_KEK_NOT_RELATION);
                    return;
                }
            }
            this.logger.info("\u6267\u884c\u4e0a\u4f20\u79c1\u6709\u57df\u5df2\u6062\u590d\u5bc6\u94a5\u6210\u529f [bSn={},rSn={},backNo={},kekId={}]", new Object[]{chipSn, this.getSn(request), backNo, req.getEncKekId()});
        }
        finally {
            this.lock(appEntityIds, false);
        }
    }

    @RequestMapping(value={"/api/v2/region/{chipSn}/{backNo}/info"}, method={RequestMethod.GET}, consumes={"application/json"})
    public Object queryBackDevRegions(@PathVariable String chipSn, @PathVariable String backNo, HttpServletResponse resp) {
        this.logger.debug("\u6536\u5230\u83b7\u53d6\u5907\u4efd\u8bbe\u5907\u79c1\u6709\u57df\u5217\u8868\u8bf7\u6c42");
        if (StringUtils.isBlank((CharSequence)chipSn) || StringUtils.isBlank((CharSequence)backNo)) {
            return HttpError.ILLEGAL_REQUEST_PARAMETER.handle(resp);
        }
        ResultBean result = this.regionProvider.queryBackDevRegions(chipSn, backNo);
        switch (result.getCode()) {
            case 2: {
                this.logger.error("\u83b7\u53d6\u5907\u4efd\u8bbe\u5907\u79c1\u6709\u57df\u5217\u8868\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u65e0\u6548\u7684\u5907\u4efd\u5361 [chipSn={},backNo={}]", (Object)chipSn, (Object)backNo);
                return HttpError.INVALID_BACKUP_CARD.handle(resp);
            }
            case 3: {
                this.logger.error("\u83b7\u53d6\u5907\u4efd\u8bbe\u5907\u79c1\u6709\u57df\u5217\u8868\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5907\u4efd\u8bbe\u5907\u672a\u7ed1\u5b9a\u8be5\u5907\u4efd\u5361 [chipSn={},backNo={}]", (Object)chipSn, (Object)backNo);
                return HttpError.NOT_BIND_BACKUP_CARD.handle(resp);
            }
        }
        this.logger.debug("\u83b7\u53d6\u5907\u4efd\u8bbe\u5907\u79c1\u6709\u57df\u5217\u8868\u8bf7\u6c42\u6267\u884c\u6210\u529f");
        return result.getInfo();
    }

    private boolean checkRestoreResultParams(List<RestoreResult> req, String sn) {
        if (null == req || req.isEmpty() || StringUtils.isBlank((CharSequence)sn)) {
            return false;
        }
        ArrayList<String> backNoList = new ArrayList<String>();
        for (RestoreResult item : req) {
            if (null == item || null == item.getRegionIds() || item.getRegionIds().isEmpty() || StringUtils.isBlank((CharSequence)item.getBackNo()) || StringUtils.isBlank((CharSequence)item.getBackSn())) {
                return false;
            }
            if (backNoList.contains(item.getBackNo())) {
                return false;
            }
            backNoList.add(item.getBackNo());
        }
        return true;
    }

    private boolean lock(Map<String, List<String>> appEntityIds, boolean lock) {
        try {
            HashMap<String, String> lockCgIds = new HashMap<String, String>();
            for (Map.Entry<String, List<String>> item : appEntityIds.entrySet()) {
                for (String cgId : item.getValue()) {
                    if (lock) {
                        if (!this.entityProvider.lock(item.getKey(), cgId)) {
                            for (Map.Entry entry : lockCgIds.entrySet()) {
                                this.entityProvider.unlock((String)entry.getKey(), (String)entry.getValue());
                            }
                            return false;
                        }
                        lockCgIds.put(item.getKey(), cgId);
                        continue;
                    }
                    this.entityProvider.unlock(item.getKey(), cgId);
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private HttpError checSecretKey(UploadRestoreKeyReq req, Map<String, List<String>> appEntityIds) throws JSONException {
        for (UploadSecretkeyInfo info : req.getSecretKeys()) {
            appEntityIds.put(info.getAppId(), new ArrayList());
            for (EntityInfo entityInfo : info.getEntities()) {
                if (!this.verifyWithSN(entityInfo.getCellGroup())) {
                    return HttpError.VERIFY_WITH_CHIP_ERROR;
                }
                if (entityInfo.getIn() == 0) {
                    if (!this.verifyWithSN(entityInfo.getSyncPubKey())) {
                        return HttpError.VERIFY_WITH_CHIP_ERROR;
                    }
                    SyncPubKey skPubKey = (SyncPubKey)JsonMapper.alwaysMapper().fromJson(entityInfo.getSyncPubKey().getInfo(), SyncPubKey.class);
                    if (!this.verifyWithSyncPubKData(entityInfo.getSyncPriKey(), skPubKey.getSkPub())) {
                        return HttpError.VERIFY_WITH_SYNCPUB_ERROR;
                    }
                }
                CellGroupStruct cellGroupStruct = (CellGroupStruct)JsonMapper.alwaysMapper().fromJson(entityInfo.getCellGroup().getInfo(), CellGroupStruct.class);
                if (!this.entityProvider.existEntity(info.getAppId(), cellGroupStruct.getCgID())) {
                    return HttpError.ENTITY_NOT_EXIST;
                }
                if (entityInfo.getIn() == 0 && this.entityProvider.checkEntityVersionIllegal(info.getAppId(), cellGroupStruct.getCgID(), Long.valueOf(cellGroupStruct.getCgVer()))) {
                    return HttpError.ILLEGAL_SOURCE_DATA_OF_VERSION;
                }
                for (KekWrapKey kekwrap : entityInfo.getKekWrapKey()) {
                    if (cellGroupStruct.getCgID().equals(kekwrap.getCgID()) && Long.parseLong(cellGroupStruct.getWkVer()) >= Long.parseLong(kekwrap.getWkVer())) continue;
                    return HttpError.URL_PARAM_NOT_MATCH_SOURCE;
                }
                appEntityIds.get(info.getAppId()).add(cellGroupStruct.getCgID());
            }
        }
        return null;
    }

    private boolean checkParams(String chipSn, String rSn, String backNo, UploadRestoreKeyReq req) {
        if (null == req || null == req.getSecretKeys() || StringUtils.isBlank((CharSequence)chipSn) || StringUtils.isBlank((CharSequence)rSn) || StringUtils.isBlank((CharSequence)backNo) || StringUtils.isBlank((CharSequence)req.getEncKek()) || StringUtils.isBlank((CharSequence)req.getEncKekId())) {
            return false;
        }
        if (!req.getSecretKeys().isEmpty()) {
            for (UploadSecretkeyInfo item : req.getSecretKeys()) {
                if (null == item) {
                    return false;
                }
                if (StringUtils.isBlank((CharSequence)item.getAppId()) || null == item.getEntities() || item.getEntities().isEmpty()) {
                    return false;
                }
                for (EntityInfo entity : item.getEntities()) {
                    if (null == entity.getCellGroup() || null == entity.getKekWrapKey() || entity.getKekWrapKey().isEmpty() || entity.getIn() != 0 && entity.getIn() != 1) {
                        return false;
                    }
                    if (entity.getIn() == 0 && (null == entity.getSyncPubKey() || null == entity.getSyncPriKey())) {
                        return false;
                    }
                    for (KekWrapKey key : entity.getKekWrapKey()) {
                        if (null != key) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }
}

