/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.controller.v2.restore;

import com.xdja.log.analysis.aop.annoation.AopLog;
import com.xdja.platform.common.lite.kit.json.JSONException;
import com.xdja.platform.common.lite.kit.json.JsonMapper;
import com.xdja.safecenter.secret.controller.AbstractController;
import com.xdja.safecenter.secret.controller.HttpError;
import com.xdja.safecenter.secret.provider.backup.BackupProvider;
import com.xdja.safecenter.secret.provider.backup.bean.ResultBean;
import com.xdja.safecenter.secret.provider.cellgroup.IEntityProvider;
import com.xdja.safecenter.secret.provider.kek.IKekProvider;
import com.xdja.safecenter.secret.provider.restore.RestoreProvider;
import com.xdja.safecenter.secret.provider.restore.bean.EntityInfo;
import com.xdja.safecenter.secret.provider.restore.bean.UploadRestoreKeyReq;
import com.xdja.safecenter.secret.provider.restore.bean.UploadSecretkeyInfo;
import com.xdja.safecenter.secret.provider.todo.ITodoProvider;
import com.xdja.safecenter.secret.struct.SourceDataStruct;
import com.xdja.safecenter.secret.struct.v2.CellGroupStruct;
import com.xdja.safecenter.secret.struct.v2.Kek;
import com.xdja.safecenter.secret.struct.v2.KekWrapKey;
import com.xdja.safecenter.secret.struct.v2.SyncPubKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RestoreController
extends AbstractController {
    @Autowired
    private RestoreProvider restoreProvider;
    @Resource
    protected ITodoProvider toDoProvider;
    @Resource
    private BackupProvider backupProvider;
    @Resource
    private IKekProvider kekProvider;
    @Resource
    private IEntityProvider entityProvider;

    @AopLog
    @RequestMapping(value={"/api/v2/restore/check/{bSn}/{rCode}"}, consumes={"application/json"}, method={RequestMethod.GET})
    public Object checkBackupCardCode(@PathVariable(value="bSn") String bSn, @PathVariable(value="rCode") String rCode, HttpServletRequest req, HttpServletResponse resp) throws JSONException {
        this.logger.debug("\u6536\u5230\u9a8c\u8bc1\u5907\u4efd\u5361\u6821\u9a8c\u7801\u8bf7\u6c42");
        String chipSn = this.getSn(req);
        if (StringUtils.isBlank((CharSequence)chipSn)) {
            return HttpError.MISSING_REQUIRED_PARAMETERS.handle(resp);
        }
        if (StringUtils.isBlank((CharSequence)bSn) || StringUtils.isBlank((CharSequence)rCode)) {
            return HttpError.ILLEGAL_REQUEST_PARAMETER.handle(resp);
        }
        ResultBean result = this.restoreProvider.checkBackupCardCode(chipSn, bSn, rCode);
        switch (result.getCode()) {
            case 2: {
                this.logger.debug("\u9a8c\u8bc1\u5907\u4efd\u5361\u6821\u9a8c\u7801\u7ed3\u679c\uff1a\u5907\u4efd\u5361\u4e0d\u5b58\u5728");
                return HttpError.BACKUP_CARD_NOT_EXIST.handle(resp);
            }
            case 3: {
                this.logger.debug("\u9a8c\u8bc1\u5907\u4efd\u5361\u6821\u9a8c\u7801\u7ed3\u679c\uff1a\u65e0\u6548\u7684\u5907\u4efd\u5361");
                return HttpError.INVALID_BACKUP_CARD.handle(resp);
            }
            case 5: {
                this.logger.debug("\u9a8c\u8bc1\u5907\u4efd\u5361\u6821\u9a8c\u7801\u7ed3\u679c\uff1a\u6821\u9a8c\u7801\u4e0d\u4e00\u81f4");
                return HttpError.CHECK_CODE_DISACCORD.handle(resp);
            }
            case 6: {
                this.logger.debug("\u9a8c\u8bc1\u5907\u4efd\u5361\u6821\u9a8c\u7801\u7ed3\u679c\uff1a\u5907\u4efd\u5361\u672a\u4f7f\u7528");
                return HttpError.BACKUP_CARD_NOT_USE.handle(resp);
            }
            case 8: {
                this.logger.debug("\u9a8c\u8bc1\u5907\u4efd\u5361\u6821\u9a8c\u7801\u7ed3\u679c\uff1a\u5907\u4efd\u8bbe\u5907\u4e0e\u6062\u590d\u8bbe\u5907\u4e0d\u80fd\u4e00\u6837");
                return HttpError.BA_DEV_AND_RES_DEV_NOT_SAME.handle(resp);
            }
        }
        this.logger.debug("\u9a8c\u8bc1\u5907\u4efd\u5361\u6821\u9a8c\u7801\u8bf7\u6c42\u6267\u884c\u5b8c\u6210");
        return result.getInfo();
    }

    @AopLog
    @RequestMapping(value={"/api/v2/restore/{chipSn}/secretKey"}, consumes={"application/json"}, method={RequestMethod.GET})
    public Object querySecretKey(@PathVariable String chipSn, @RequestParam int todo, HttpServletRequest req, HttpServletResponse resp) throws JSONException {
        List toDoList;
        this.logger.debug("\u6536\u5230\u67e5\u8be2\u8bbe\u5907\u5f85\u6062\u590d\u79d8\u94a5\u8bf7\u6c42");
        if (StringUtils.isBlank((CharSequence)chipSn) || todo != 0 && todo != 1) {
            return HttpError.ILLEGAL_REQUEST_PARAMETER.handle(resp);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("todo", new Object[0]);
        result.put("secretKeys", new Object[0]);
        if (todo == 1 && null != (toDoList = this.toDoProvider.getRestoreMissionsByDevice(chipSn, null, null, null)) && !toDoList.isEmpty()) {
            result.put("todo", toDoList);
            return result;
        }
        List secretKeys = this.restoreProvider.querySecretKeys(chipSn);
        if (null != secretKeys) {
            result.put("secretKeys", secretKeys);
        }
        this.logger.debug("\u67e5\u8be2\u8bbe\u5907\u5f85\u6062\u590d\u79d8\u94a5\u8bf7\u6c42\u6267\u884c\u5b8c\u6210");
        return result;
    }

    @AopLog
    @RequestMapping(value={"/api/v2/restore/{chipSn}/upload/secretKey"}, consumes={"application/json"}, method={RequestMethod.POST})
    public void uploadSecretKey(@PathVariable String chipSn, @RequestBody UploadRestoreKeyReq reqInfo, HttpServletRequest req, HttpServletResponse resp) throws JSONException {
        this.logger.debug("\u6536\u5230\u4e0a\u4f20\u5df2\u6062\u590d\u5bc6\u94a5\u8bf7\u6c42");
        if (this.getSn(req).equals(chipSn)) {
            this.logger.error("\u4e0a\u4f20\u6062\u590d\u5bc6\u94a5\u5931\u8d25\uff0c\u5907\u4efd\u8bbe\u5907\u4e0d\u80fd\u4e0e\u6062\u590d\u8bbe\u5907\u76f8\u540c", (Object)chipSn);
            this.renderError(resp, HttpError.BA_DEV_AND_RES_DEV_NOT_SAME);
            return;
        }
        if (!this.checkDeviceBindBCard(chipSn)) {
            this.logger.error("\u4e0a\u4f20\u6062\u590d\u5bc6\u94a5\u5931\u8d25\uff0c\u5907\u4efd\u8bbe\u5907SN\u3010{}\u3011\u672a\u7ed1\u5b9a\u5907\u4efd\u5361", (Object)chipSn);
            this.renderError(resp, HttpError.NOT_BIND_BACKUP_CARD);
            return;
        }
        if (!this.checkAndSaveSecretKey(this.getCardId(req), this.getSn(req), chipSn, reqInfo, resp)) {
            return;
        }
        this.logger.debug("\u4e0a\u4f20\u5df2\u6062\u590d\u5bc6\u94a5\u8bf7\u6c42\u6267\u884c\u5b8c\u6210");
    }

    @AopLog
    @RequestMapping(value={"/api/v2/restore/records"}, consumes={"application/json"}, method={RequestMethod.GET})
    public Object queryRestoreRecord(HttpServletRequest req, HttpServletResponse resp) throws JSONException {
        this.logger.debug("\u6536\u5230\u67e5\u8be2\u8bbe\u5907\u6062\u590d\u8bb0\u5f55\u8bf7\u6c42");
        String sn = this.getSn(req);
        List result = this.restoreProvider.getRestoreRecords(sn);
        this.logger.debug("\u67e5\u8be2\u8bbe\u5907\u6062\u590d\u8bb0\u5f55\u8bf7\u6c42\u6267\u884c\u5b8c\u6210");
        return result;
    }

    @AopLog
    @RequestMapping(value={"/api/v2/restore/{chipSn}/suits"}, consumes={"application/json"}, method={RequestMethod.GET})
    public Object queryAppSuits(@PathVariable String chipSn, HttpServletResponse resp) throws JSONException {
        this.logger.debug("\u6536\u5230\u67e5\u8be2\u5907\u4efd\u8bbe\u5907\u5e94\u7528\u5957\u4ef6\u8bf7\u6c42");
        if (StringUtils.isBlank((CharSequence)chipSn)) {
            return HttpError.ILLEGAL_REQUEST_PARAMETER.handle(resp);
        }
        Map result = this.restoreProvider.queryAppSuits(chipSn);
        this.logger.debug("\u67e5\u8be2\u5907\u4efd\u8bbe\u5907\u5e94\u7528\u5957\u4ef6\u8bf7\u6c42\u6267\u884c\u5b8c\u6210");
        return result;
    }

    @AopLog
    @RequestMapping(value={"/api/v2/restore/{bKeySn}/backup"}, consumes={"application/json"}, method={RequestMethod.GET})
    public Object getBackupKey(@PathVariable(value="bKeySn") String bKeySn, HttpServletRequest req, HttpServletResponse resp) throws JSONException {
        this.logger.debug("\u6536\u5230\u83b7\u53d6\u5907\u4efdKEY\u5907\u4efd\u5bc6\u94a5\u8bf7\u6c42");
        String chipSn = this.getSn(req);
        if (StringUtils.isBlank((CharSequence)chipSn)) {
            return HttpError.MISSING_REQUIRED_PARAMETERS.handle(resp);
        }
        if (StringUtils.isBlank((CharSequence)bKeySn)) {
            return HttpError.ILLEGAL_REQUEST_PARAMETER.handle(resp);
        }
        ResultBean result = this.restoreProvider.getBackupKey(chipSn, bKeySn);
        switch (result.getCode()) {
            case 2: {
                this.logger.debug("\u83b7\u53d6\u5907\u4efdKEY\u5907\u4efd\u5bc6\u94a5\u7ed3\u679c\uff1a\u5907\u4efdKEY\u4e0d\u5b58\u5728");
                return HttpError.BACKUP_KEY_NOT_EXIST.handle(resp);
            }
            case 3: {
                this.logger.debug("\u83b7\u53d6\u5907\u4efdKEY\u5907\u4efd\u5bc6\u94a5\u7ed3\u679c\uff1a\u65e0\u6548\u7684\u5907\u4efdKEY");
                return HttpError.INVALID_BACKUP_KEY.handle(resp);
            }
            case 6: {
                this.logger.debug("\u83b7\u53d6\u5907\u4efdKEY\u5907\u4efd\u5bc6\u94a5\u7ed3\u679c\uff1a\u5907\u4efdKEY\u672a\u4f7f\u7528");
                return HttpError.BACKUP_KEY_NOT_USE.handle(resp);
            }
            case 8: {
                this.logger.debug("\u83b7\u53d6\u5907\u4efdKEY\u5907\u4efd\u5bc6\u94a5\u7ed3\u679c\uff1a\u5907\u4efd\u8bbe\u5907\u4e0e\u6062\u590d\u8bbe\u5907\u4e0d\u80fd\u4e00\u6837");
                return HttpError.BA_DEV_AND_RES_DEV_NOT_SAME.handle(resp);
            }
        }
        this.logger.debug("\u83b7\u53d6\u5907\u4efdKEY\u5907\u4efd\u5bc6\u94a5\u6267\u884c\u5b8c\u6210");
        return result.getInfo();
    }

    @AopLog
    @RequestMapping(value={"/api/v2/restore/upload/{bKeySn}/secretKey"}, consumes={"application/json"}, method={RequestMethod.POST})
    public void uploadBackupSecretKey(@PathVariable String bKeySn, @RequestBody UploadRestoreKeyReq reqInfo, HttpServletRequest req, HttpServletResponse resp) throws JSONException {
        this.logger.debug("\u6536\u5230\u4e0a\u4f20\u5907\u4efd\u8bbe\u5907\u5df2\u6062\u590d\u5bc6\u94a5\u8bf7\u6c42");
        String cardNo = this.getCardId(req);
        String chipSn = this.getSn(req);
        if (StringUtils.isBlank((CharSequence)chipSn) || StringUtils.isBlank((CharSequence)cardNo)) {
            this.renderError(resp, HttpError.MISSING_REQUIRED_PARAMETERS);
            return;
        }
        if (StringUtils.isBlank((CharSequence)bKeySn)) {
            this.renderError(resp, HttpError.ILLEGAL_REQUEST_PARAMETER);
            return;
        }
        ResultBean result = this.restoreProvider.checkBackupKey(bKeySn, chipSn);
        switch (result.getCode()) {
            case 2: {
                this.logger.debug("\u83b7\u53d6\u5907\u4efdKEY\u5907\u4efd\u5bc6\u94a5\u7ed3\u679c\uff1a\u5907\u4efdKEY\u4e0d\u5b58\u5728");
                this.renderError(resp, HttpError.BACKUP_KEY_NOT_EXIST);
                return;
            }
            case 3: {
                this.logger.debug("\u83b7\u53d6\u5907\u4efdKEY\u5907\u4efd\u5bc6\u94a5\u7ed3\u679c\uff1a\u65e0\u6548\u7684\u5907\u4efdKEY");
                this.renderError(resp, HttpError.INVALID_BACKUP_KEY);
                return;
            }
            case 6: {
                this.logger.debug("\u83b7\u53d6\u5907\u4efdKEY\u5907\u4efd\u5bc6\u94a5\u7ed3\u679c\uff1a\u5907\u4efdKEY\u672a\u4f7f\u7528");
                this.renderError(resp, HttpError.BACKUP_KEY_NOT_USE);
                return;
            }
            case 8: {
                this.logger.debug("\u83b7\u53d6\u5907\u4efdKEY\u5907\u4efd\u5bc6\u94a5\u7ed3\u679c\uff1a\u5907\u4efd\u8bbe\u5907\u4e0e\u6062\u590d\u8bbe\u5907\u4e0d\u80fd\u4e00\u6837");
                this.renderError(resp, HttpError.BA_DEV_AND_RES_DEV_NOT_SAME);
                return;
            }
        }
        if (!this.checkAndSaveSecretKey(cardNo, chipSn, String.valueOf(result.getInfo()), reqInfo, resp)) {
            return;
        }
        this.logger.debug("\u4e0a\u4f20\u5907\u4efd\u8bbe\u5907\u5df2\u6062\u590d\u5bc6\u94a5\u8bf7\u6c42\u6267\u884c\u5b8c\u6210");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkAndSaveSecretKey(String cardNo, String rSn, String bSn, UploadRestoreKeyReq reqInfo, HttpServletResponse resp) throws JSONException {
        boolean result = false;
        SourceDataStruct kekSource = this.kekProvider.getKekBySn(rSn);
        if (kekSource == null) {
            this.logger.error("\u4e0a\u4f20\u5907\u4efd\u8bbe\u5907\u5df2\u6062\u590d\u5bc6\u94a5\u5931\u8d25\uff0c\u6062\u590d\u8bbe\u5907SN\u3010{}\u3011kek\u4e0d\u5b58\u5728", (Object)rSn);
            this.renderError(resp, HttpError.RES_DEV_KEK_NOT_EXIST);
            return result;
        }
        Kek kek = (Kek)JsonMapper.alwaysMapper().fromJson(kekSource.getInfo(), Kek.class);
        if (!kek.getKekID().equals(reqInfo.getEncKekId())) {
            this.logger.error("\u4e0a\u4f20\u5907\u4efd\u8bbe\u5907\u5df2\u6062\u590d\u5bc6\u94a5\u5931\u8d25\uff0c\u6062\u590d\u8bbe\u5907SN\u3010{}\u3011\u4e0ekekID\u3010{}\u3011\u4e0d\u5339\u914d", (Object)rSn, (Object)kek.getKekID());
            this.renderError(resp, HttpError.DEV_KEK_NOT_MATCH);
            return result;
        }
        HashMap appEntityIds = new HashMap();
        for (UploadSecretkeyInfo info : reqInfo.getSecretKeys()) {
            appEntityIds.put(info.getAppId(), new ArrayList());
            for (EntityInfo entityInfo : info.getEntities()) {
                if (!this.verifyWithSN(entityInfo.getCellGroup())) {
                    this.renderError(resp, HttpError.VERIFY_WITH_CHIP_ERROR);
                    return result;
                }
                if (entityInfo.getIn() == 0) {
                    if (!this.verifyWithSN(entityInfo.getSyncPubKey())) {
                        this.renderError(resp, HttpError.VERIFY_WITH_CHIP_ERROR);
                        return result;
                    }
                    SyncPubKey skPubKey = (SyncPubKey)JsonMapper.alwaysMapper().fromJson(entityInfo.getSyncPubKey().getInfo(), SyncPubKey.class);
                    if (!this.verifyWithSyncPubKData(entityInfo.getSyncPriKey(), skPubKey.getSkPub())) {
                        this.renderError(resp, HttpError.VERIFY_WITH_SYNCPUB_ERROR);
                        return result;
                    }
                }
                CellGroupStruct cellGroupStruct = (CellGroupStruct)JsonMapper.alwaysMapper().fromJson(entityInfo.getCellGroup().getInfo(), CellGroupStruct.class);
                if (!this.entityProvider.existEntity(info.getAppId(), cellGroupStruct.getCgID())) {
                    this.renderError(resp, HttpError.ENTITY_NOT_EXIST);
                    return result;
                }
                if (entityInfo.getIn() == 0 && this.entityProvider.checkEntityVersionIllegal(info.getAppId(), cellGroupStruct.getCgID(), Long.valueOf(cellGroupStruct.getCgVer()))) {
                    this.renderError(resp, HttpError.ILLEGAL_SOURCE_DATA_OF_VERSION);
                    return result;
                }
                for (KekWrapKey kekwrap : entityInfo.getKekWrapKey()) {
                    if (cellGroupStruct.getCgID().equals(kekwrap.getCgID()) && Long.parseLong(cellGroupStruct.getWkVer()) >= Long.parseLong(kekwrap.getWkVer())) continue;
                    this.renderError(resp, HttpError.URL_PARAM_NOT_MATCH_SOURCE);
                    return result;
                }
                ((List)appEntityIds.get(info.getAppId())).add(cellGroupStruct.getCgID());
            }
        }
        Set appIds = appEntityIds.keySet();
        for (String appId : appIds) {
            for (String cgID : (List)appEntityIds.get(appId)) {
                if (this.entityProvider.lock(appId, cgID)) continue;
                this.renderError(resp, HttpError.ILLEGAL_SOURCE_DATA_OF_VERSION);
                return result;
            }
        }
        try {
            this.restoreProvider.doUploadRestoreSecretKey(bSn, rSn, cardNo, reqInfo);
            result = true;
        }
        finally {
            for (String appId : appIds) {
                for (String cgID : (List)appEntityIds.get(appId)) {
                    this.entityProvider.unlock(appId, cgID);
                }
            }
        }
        return result;
    }

    private boolean checkDeviceBindBCard(String chipSn) {
        return StringUtils.isNotBlank((CharSequence)this.backupProvider.querySnByChipSn(chipSn));
    }
}

