/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.controller.v2.todo;

import com.xdja.log.analysis.aop.annoation.AopLog;
import com.xdja.platform.common.lite.kit.json.JSONException;
import com.xdja.platform.common.lite.kit.json.JsonMapper;
import com.xdja.safecenter.secret.controller.AbstractController;
import com.xdja.safecenter.secret.core.util.LogUtil;
import com.xdja.safecenter.secret.core.verify.VerifyUtil;
import com.xdja.safecenter.secret.provider.cellgroup.IEntityProvider;
import com.xdja.safecenter.secret.provider.partygroup.IPartyGroupKeyProvider;
import com.xdja.safecenter.secret.provider.partygroup.IPartyGroupProvider;
import com.xdja.safecenter.secret.provider.todo.ITodoProvider;
import com.xdja.safecenter.secret.provider.todo.bean.request.KekWrapKeyReq;
import com.xdja.safecenter.secret.provider.todo.bean.request.UpdatePgkReq;
import com.xdja.safecenter.secret.provider.todo.bean.request.UpdateWrapkeyReq;
import com.xdja.safecenter.secret.provider.todo.bean.request.WrapPgkReq;
import com.xdja.safecenter.secret.provider.todo.bean.response.CommonResponseBean;
import com.xdja.safecenter.secret.struct.v2.KekWrapKey;
import com.xdja.safecenter.secret.struct.v2.PartyGroupKey;
import com.xdja.safecenter.secret.struct.v2.WrapKey;
import com.xdja.safecenter.secret.struct.v2.WrapedPgKey;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TodoController
extends AbstractController {
    private static final int RETURN_TODO = 1;
    @Resource
    protected ITodoProvider provider;
    @Resource
    private IPartyGroupProvider partyGroupProvider;
    @Resource
    private IPartyGroupKeyProvider partyGroupKeyProvider;
    @Resource
    private IEntityProvider entityProvider;

    @AopLog
    @RequestMapping(value={"/api/v2/schedules"}, consumes={"application/json"}, method={RequestMethod.GET})
    public Object getTodo(HttpServletRequest request, @RequestParam String appID) throws JSONException {
        String entityId = request.getParameter("entityId");
        String type = request.getParameter("type");
        this.logger.info(this.format(request, entityId, null, "\u83b7\u53d6\u5f85\u529e\u4e8b\u9879"));
        return this.provider.getMissionsByDevice(this.getSN(request), appID, entityId, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AopLog
    @RequestMapping(value={"/api/v2/schedule/updateWrapKey"}, consumes={"application/json"}, method={RequestMethod.POST})
    public Object updateWrapkey(HttpServletRequest request, @RequestParam String appID, @RequestParam int todo, @RequestBody List<UpdateWrapkeyReq> req) throws JSONException {
        String sn = this.getSN(request);
        String headAppID = this.getAppID(request);
        if (VerifyUtil.isEmpty(req)) {
            return new CommonResponseBean(-2, "Illegeal_mission", null);
        }
        for (UpdateWrapkeyReq reqBean : req) {
            if (VerifyUtil.hasNull((Object)reqBean)) {
                return new CommonResponseBean(-2, "Illegeal_mission", null);
            }
            if (!this.provider.existMission(reqBean.getMid())) {
                return new CommonResponseBean(1, "mission_already_done", null);
            }
            if (!this.provider.checkMission(reqBean.getMid(), 0, sn)) {
                this.logger.error("\u4e0a\u4f20\u66f4\u65b0Wrapkey\u5904\u7406\u7ed3\u679c \u4ee3\u529e\u4e8b\u9879\u3010mid\u3011:{}\uff0c\u4ee3\u529e\u4e8b\u9879\u3010type\u3011:{}\u4e0e\u8bbe\u5907\u3010SN\u3011:{}\u4e0d\u5339\u914d", new Object[]{reqBean.getMid(), 0, sn});
                return new CommonResponseBean(-2, "Illegeal_mission", null);
            }
            WrapKey wrapKey = (WrapKey)JsonMapper.alwaysMapper().fromJson(reqBean.getWrapKey().getInfo(), WrapKey.class);
            String cgID = wrapKey.getCgID();
            if (!this.entityProvider.existEntity(headAppID, cgID)) {
                this.logger.error("\u4e0a\u4f20\u66f4\u65b0Wrapkey\u5904\u7406\u7ed3\u679c \u4ee3\u529e\u4e8b\u9879\u3010mid\u3011:{} \u6d89\u53ca\u7684Entity\u4e0d\u5b58\u5728", (Object)reqBean.getMid());
                return new CommonResponseBean(-2, "Illegeal_mission", null);
            }
            try {
                long wrapKeyVer = Long.parseLong(wrapKey.getWkVer());
                if (!this.entityProvider.lock(headAppID, cgID)) {
                    CommonResponseBean commonResponseBean = new CommonResponseBean(-1, "mission_doing", null);
                    return commonResponseBean;
                }
                if (this.entityProvider.checkWrapKeyVersionExist(headAppID, cgID, wrapKeyVer)) {
                    CommonResponseBean commonResponseBean = new CommonResponseBean(1, "mission_already_done", null);
                    return commonResponseBean;
                }
                if (this.entityProvider.getLastWrapVersion(headAppID, cgID) < wrapKeyVer) {
                    CommonResponseBean commonResponseBean = new CommonResponseBean(-2, "Illegeal_mission", null);
                    return commonResponseBean;
                }
                this.provider.doUploadUpdateWrapKey(headAppID, reqBean);
            }
            finally {
                this.entityProvider.unlock(headAppID, cgID);
            }
            this.logger.info(LogUtil.formatLog((String)this.getAppID(request), (String)this.getSN(request), null, null, (String)("\u66f4\u65b0WrapKey\u5f85\u529e\u4e8b\u9879\u3010" + reqBean.getMid() + "\u3011")));
        }
        CommonResponseBean resp = new CommonResponseBean(0, "success", null);
        if (todo == 1) {
            resp.setTodos(this.provider.getMissionsByDevice(this.getSN(request), appID, null, null));
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AopLog
    @RequestMapping(value={"/api/v2/schedule/updatePGK"}, consumes={"application/json"}, method={RequestMethod.POST})
    public Object updatePGK(HttpServletRequest request, @RequestParam String appID, @RequestParam int todo, @RequestBody List<UpdatePgkReq> req) throws JSONException {
        String sn = this.getSN(request);
        String headAppID = this.getAppID(request);
        if (VerifyUtil.isEmpty(req)) {
            return new CommonResponseBean(-2, "Illegeal_mission", null);
        }
        for (UpdatePgkReq reqBean : req) {
            if (VerifyUtil.hasNull((Object)reqBean)) {
                return new CommonResponseBean(-2, "Illegeal_mission", null);
            }
            if (!this.provider.existMission(reqBean.getMid())) {
                return new CommonResponseBean(1, "mission_already_done", null);
            }
            if (!this.provider.checkMission(reqBean.getMid(), 2, sn)) {
                this.logger.error("\u4e0a\u4f20\u66f4\u65b0PGK\u5904\u7406\u7ed3\u679c \u4ee3\u529e\u4e8b\u9879\u3010mid\u3011:{}\uff0c\u4ee3\u529e\u4e8b\u9879\u3010type\u3011:{}\u4e0e\u8bbe\u5907\u3010SN\u3011:{}\u4e0d\u5339\u914d", new Object[]{reqBean.getMid(), 2, sn});
                return new CommonResponseBean(-2, "Illegeal_mission", null);
            }
            PartyGroupKey partyGroupKey = (PartyGroupKey)JsonMapper.alwaysMapper().fromJson(reqBean.getPartyGroupKey().getInfo(), PartyGroupKey.class);
            if (!this.partyGroupProvider.existPartyGroup(partyGroupKey.getPgID())) {
                this.logger.error("\u4e0a\u4f20\u66f4\u65b0PGK\u5904\u7406\u7ed3\u679c \u4ee3\u529e\u4e8b\u9879\u3010mid\u3011:{} \u6d89\u53ca\u7684partyGroup\u4e0d\u5b58\u5728", (Object)reqBean.getMid());
                return new CommonResponseBean(-2, "Illegeal_mission", null);
            }
            if (!this.entityProvider.existEntity(headAppID, reqBean.getWrapedPgKey().getCgID())) {
                this.logger.error("\u4e0a\u4f20\u66f4\u65b0PGK\u5904\u7406\u7ed3\u679c \u4ee3\u529e\u4e8b\u9879\u3010mid\u3011:{} \u6d89\u53ca\u7684Entity\u4e0d\u5b58\u5728", (Object)reqBean.getMid());
                return new CommonResponseBean(-2, "Illegeal_mission", null);
            }
            try {
                if (!this.partyGroupProvider.lock(partyGroupKey.getPgID())) {
                    CommonResponseBean commonResponseBean = new CommonResponseBean(-1, "mission_doing", null);
                    return commonResponseBean;
                }
                if (String.valueOf(this.partyGroupKeyProvider.getLastedPgkVersion(partyGroupKey.getPgID())).equals(partyGroupKey.getPgkVer())) {
                    CommonResponseBean commonResponseBean = new CommonResponseBean(1, "mission_already_done", null);
                    return commonResponseBean;
                }
                this.provider.doUploadUpdatePgk(headAppID, reqBean);
            }
            finally {
                this.partyGroupProvider.unlock(partyGroupKey.getPgID());
            }
            this.logger.info(LogUtil.formatLog((String)this.getAppID(request), (String)this.getSN(request), null, null, (String)("\u66f4\u65b0PGK\u5f85\u529e\u4e8b\u9879\u3010" + reqBean.getMid() + "\u3011")));
        }
        CommonResponseBean resp = new CommonResponseBean(0, "success", null);
        if (todo == 1) {
            resp.setTodos(this.provider.getMissionsByDevice(this.getSN(request), appID, null, null));
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AopLog
    @RequestMapping(value={"/api/v2/schedule/wrapPGK"}, consumes={"application/json"}, method={RequestMethod.POST})
    public Object wrapPGK(HttpServletRequest request, @RequestParam String appID, @RequestParam int todo, @RequestBody List<WrapPgkReq> req) throws JSONException {
        String sn = this.getSN(request);
        String headAppID = this.getAppID(request);
        if (VerifyUtil.isEmpty(req)) {
            return new CommonResponseBean(-2, "Illegeal_mission", null);
        }
        for (WrapPgkReq reqBean : req) {
            if (VerifyUtil.hasNull((Object)reqBean)) {
                return new CommonResponseBean(-2, "Illegeal_mission", null);
            }
            if (!this.provider.existMission(reqBean.getMid())) {
                new CommonResponseBean(-2, "Illegeal_mission", null);
            }
            if (!this.provider.checkMission(reqBean.getMid(), 5, sn) && !this.provider.checkMission(reqBean.getMid(), 7, sn)) {
                this.logger.error("\u4e0a\u4f20\u5f52\u6863PGK\u5904\u7406\u7ed3\u679c \u4ee3\u529e\u4e8b\u9879\u3010mid\u3011:{}\uff0c\u4ee3\u529e\u4e8b\u9879\u3010type\u3011:{}\u4e0e\u8bbe\u5907\u3010SN\u3011:{}\u4e0d\u5339\u914d", new Object[]{reqBean.getMid(), "5\u62167", sn});
                return new CommonResponseBean(-2, "Illegeal_mission", null);
            }
            String pgID = ((WrapedPgKey)reqBean.getWrapedPgKey().get(0)).getPgID();
            String cgID = ((WrapedPgKey)reqBean.getWrapedPgKey().get(0)).getCgID();
            for (WrapedPgKey wrapedPgKey : reqBean.getWrapedPgKey()) {
                if (pgID.equals(wrapedPgKey.getPgID()) && cgID.equals(wrapedPgKey.getCgID())) continue;
                this.logger.error("\u4e0a\u4f20\u5f52\u6863PGK\u5904\u7406\u7ed3\u679c \u4ee3\u529e\u4e8b\u9879\u3010mid\u3011:{}\uff0c\u53c2\u6570\u4e0d\u5408\u6cd5", (Object)reqBean.getMid());
                return new CommonResponseBean(-2, "Illegeal_mission", null);
            }
            List entityIds = this.partyGroupProvider.queryEntityIDsByPartyGroupID(pgID);
            if (!entityIds.contains(cgID)) {
                this.logger.error("\u4e0a\u4f20\u5f52\u6863PGK\u5904\u7406\u7ed3\u679c \u4ee3\u529e\u4e8b\u9879\u3010mid\u3011:{} \u6d89\u53ca\u7684partyGroup\u548cEntityID\u4e0d\u5339\u914d", (Object)reqBean.getMid());
                return new CommonResponseBean(-2, "Illegeal_mission", null);
            }
            WrapedPgKey wrapPgk = (WrapedPgKey)reqBean.getWrapedPgKey().get(0);
            try {
                if (!this.partyGroupProvider.lockWrapPgkVersion(wrapPgk.getPgID(), wrapPgk.getCgID(), wrapPgk.getPgkVer())) {
                    CommonResponseBean commonResponseBean = new CommonResponseBean(-1, "mission_doing", null);
                    return commonResponseBean;
                }
                this.provider.doUploadWrapPgk(headAppID, reqBean);
            }
            finally {
                this.partyGroupProvider.unLockWrapPgkVersion(wrapPgk.getPgID(), wrapPgk.getCgID(), wrapPgk.getPgkVer());
            }
            this.logger.info(LogUtil.formatLog((String)this.getAppID(request), (String)this.getSN(request), null, null, (String)("\u4e0a\u4f20\u5f52\u6863PGK\u5f85\u529e\u4e8b\u9879\u3010" + reqBean.getMid() + "\u3011")));
        }
        CommonResponseBean resp = new CommonResponseBean(0, "success", null);
        if (todo == 1) {
            resp.setTodos(this.provider.getMissionsByDevice(this.getSN(request), appID, null, null));
        }
        return resp;
    }

    @AopLog
    @RequestMapping(value={"/api/v2/schedule/wrapKey"}, consumes={"application/json"}, method={RequestMethod.POST})
    public Object kekWrapKey(HttpServletRequest request, @RequestParam String appID, @RequestParam int todo, @RequestBody List<KekWrapKeyReq> req) throws JSONException {
        String sn = this.getSN(request);
        String headAppID = this.getAppID(request);
        if (VerifyUtil.isEmpty(req)) {
            return new CommonResponseBean(-2, "Illegeal_mission", null);
        }
        for (KekWrapKeyReq reqBean : req) {
            if (VerifyUtil.hasNull((Object)reqBean)) {
                return new CommonResponseBean(-2, "Illegeal_mission", null);
            }
            if (!this.provider.existMission(reqBean.getMid())) {
                return new CommonResponseBean(-2, "Illegeal_mission", null);
            }
            if (!this.provider.checkMission(reqBean.getMid(), 4, sn) && !this.provider.checkMission(reqBean.getMid(), 6, sn)) {
                this.logger.error("\u4e0a\u4f20\u5f52\u6863WrapKey\u5904\u7406\u7ed3\u679c \u4ee3\u529e\u4e8b\u9879\u3010mid\u3011:{}\uff0c\u4ee3\u529e\u4e8b\u9879\u3010type\u3011:{}\u4e0e\u8bbe\u5907\u3010SN\u3011:{}\u4e0d\u5339\u914d", new Object[]{reqBean.getMid(), "4\u62166", sn});
                return new CommonResponseBean(-2, "Illegeal_mission", null);
            }
            String cgID = ((KekWrapKey)reqBean.getKekWrapKey().get(0)).getCgID();
            for (KekWrapKey keyWrapKey : reqBean.getKekWrapKey()) {
                if (cgID.equals(keyWrapKey.getCgID())) continue;
                this.logger.error("\u4e0a\u4f20\u5f52\u6863WrapKey\u5904\u7406\u7ed3\u679c \u4ee3\u529e\u4e8b\u9879\u3010mid\u3011:{}\uff0c\u53c2\u6570\u4e0d\u5408\u6cd5", (Object)reqBean.getMid());
                return new CommonResponseBean(-2, "Illegeal_mission", null);
            }
            if (!this.entityProvider.existEntity(headAppID, cgID)) {
                this.logger.error("\u4e0a\u4f20\u66f4\u65b0WrapKey\u5904\u7406\u7ed3\u679c \u4ee3\u529e\u4e8b\u9879\u3010mid\u3011:{} \u6d89\u53ca\u7684Entity\u4e0d\u5b58\u5728", (Object)reqBean.getMid());
                return new CommonResponseBean(-2, "Illegeal_mission", null);
            }
            this.provider.doUploadWrapWrapKey(headAppID, reqBean);
            this.logger.info(LogUtil.formatLog((String)this.getAppID(request), (String)this.getSN(request), null, null, (String)("\u4e0a\u4f20\u5f52\u6863WrapKey\u5f85\u529e\u4e8b\u9879\u3010" + reqBean.getMid() + "\u3011")));
        }
        CommonResponseBean resp = new CommonResponseBean(0, "success", null);
        if (todo == 1) {
            resp.setTodos(this.provider.getMissionsByDevice(this.getSN(request), appID, null, null));
        }
        return resp;
    }

    @AopLog
    @RequestMapping(value={"/api/v2/schedule/notice"}, consumes={"application/json"}, method={RequestMethod.POST})
    public Object notice(HttpServletRequest request, @RequestBody List<String> mids, @RequestParam int todo, @RequestParam String appID) throws JSONException {
        this.provider.doCompleteMissions(mids);
        this.logger.info(this.format(request, null, null, "\u901a\u77e5\u5f85\u529e\u4e8b\u9879\u3010" + mids + "\u3011\u5904\u7406"));
        CommonResponseBean resp = new CommonResponseBean(0, "success", null);
        if (todo == 1) {
            resp.setTodos(this.provider.getMissionsByDevice(this.getSN(request), appID, null, null));
        }
        return resp;
    }
}

