/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.controller.v2.todo;

import com.xdja.log.analysis.aop.annoation.AopLog;
import com.xdja.platform.common.lite.kit.json.JSONException;
import com.xdja.platform.common.lite.kit.json.JsonMapper;
import com.xdja.safecenter.secret.controller.AbstractController;
import com.xdja.safecenter.secret.controller.HttpError;
import com.xdja.safecenter.secret.core.CommonSetting;
import com.xdja.safecenter.secret.core.util.LogUtil;
import com.xdja.safecenter.secret.core.verify.VerifyUtil;
import com.xdja.safecenter.secret.provider.backup.BackupProvider;
import com.xdja.safecenter.secret.provider.cellgroup.IEntityProvider;
import com.xdja.safecenter.secret.provider.cellgroup.bean.response.GetSyncPairResp;
import com.xdja.safecenter.secret.provider.cellgroup.bean.response.GetWrapKeysResp;
import com.xdja.safecenter.secret.provider.partygroup.IPartyGroupKeyProvider;
import com.xdja.safecenter.secret.provider.partygroup.IPartyGroupProvider;
import com.xdja.safecenter.secret.provider.todo.ITodoProvider;
import com.xdja.safecenter.secret.provider.todo.bean.request.KekWrapKeyReq;
import com.xdja.safecenter.secret.provider.todo.bean.request.UpdatePgkReq;
import com.xdja.safecenter.secret.provider.todo.bean.request.UpdateWrapkeyReq;
import com.xdja.safecenter.secret.provider.todo.bean.request.WrapPgkReq;
import com.xdja.safecenter.secret.provider.todo.bean.response.CommonResponseBean;
import com.xdja.safecenter.secret.struct.v2.KekWrapKey;
import com.xdja.safecenter.secret.struct.v2.PartyGroupKey;
import com.xdja.safecenter.secret.struct.v2.WrapKey;
import com.xdja.safecenter.secret.struct.v2.WrapedPgKey;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TodoRestoreController
extends AbstractController {
    private static final int RETURN_TODO = 1;
    private static final int GET_LAST_VERSION = -2;
    @Resource
    protected ITodoProvider provider;
    @Resource
    private IPartyGroupProvider partyGroupProvider;
    @Resource
    private IPartyGroupKeyProvider partyGroupKeyProvider;
    @Resource
    private IEntityProvider entityProvider;
    @Resource
    private BackupProvider backupProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AopLog
    @RequestMapping(value={"/api/v2/restore/{chipSn}/schedule/updateWrapKey"}, consumes={"application/json"}, method={RequestMethod.POST})
    public Object updateWrapkeyRestore(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="chipSn") String chipSn, @RequestParam int todo, @RequestBody List<UpdateWrapkeyReq> req) throws JSONException {
        if (this.getSn(request).equals(chipSn)) {
            this.logger.error("\u66f4\u65b0\u5907\u4efd\u8bbe\u5907WrapKey\u5f85\u529e\u4e8b\u9879\u5904\u7406\u7ed3\u679c\u5931\u8d25\uff0c\u5907\u4efd\u8bbe\u5907\u4e0d\u80fd\u4e0e\u6062\u590d\u8bbe\u5907\u76f8\u540c", (Object)chipSn);
            return HttpError.BA_DEV_AND_RES_DEV_NOT_SAME.handle(response);
        }
        if (CommonSetting.BACKUP_TRIGGER && !this.checkDeviceBindBCard(chipSn)) {
            this.logger.error("\u8bbe\u5907 \u3010{}\u3011\u672a\u7ed1\u5b9a\u5907\u4efd\u5361", (Object)chipSn);
            return HttpError.NOT_BIND_BACKUP_CARD.handle(response);
        }
        String appID = "";
        if (VerifyUtil.isEmpty(req)) {
            return new CommonResponseBean(-2, "Illegeal_mission", null);
        }
        for (UpdateWrapkeyReq reqBean : req) {
            String cgID;
            if (VerifyUtil.hasNull((Object)reqBean)) {
                return new CommonResponseBean(-2, "Illegeal_mission", null);
            }
            if (!this.provider.existMission(reqBean.getMid())) {
                return new CommonResponseBean(1, "success", null);
            }
            if (!this.provider.checkMission(reqBean.getMid(), 0, chipSn)) {
                this.logger.error("\u4e0a\u4f20\u66f4\u65b0Wrapkey\u5904\u7406\u7ed3\u679c \u4ee3\u529e\u4e8b\u9879\u3010mid\u3011:{}\uff0c\u4ee3\u529e\u4e8b\u9879\u3010type\u3011:{}\u4e0e\u8bbe\u5907\u3010SN\u3011:{}\u4e0d\u5339\u914d", new Object[]{reqBean.getMid(), 0, chipSn});
                return new CommonResponseBean(-2, "Illegeal_mission", null);
            }
            WrapKey wrapKey = (WrapKey)JsonMapper.alwaysMapper().fromJson(reqBean.getWrapKey().getInfo(), WrapKey.class);
            appID = wrapKey.getAppID();
            if (!this.entityProvider.existEntity(appID, cgID = wrapKey.getCgID())) {
                this.logger.error("\u4e0a\u4f20\u66f4\u65b0Wrapkey\u5904\u7406\u7ed3\u679c \u4ee3\u529e\u4e8b\u9879\u3010mid\u3011:{} \u6d89\u53ca\u7684Entity\u4e0d\u5b58\u5728", (Object)reqBean.getMid());
                return new CommonResponseBean(-2, "Illegeal_mission", null);
            }
            try {
                long wrapKeyVer = Long.parseLong(wrapKey.getWkVer());
                if (!this.entityProvider.lock(appID, cgID)) {
                    CommonResponseBean commonResponseBean = new CommonResponseBean(-1, "mission_doing", null);
                    return commonResponseBean;
                }
                if (this.entityProvider.checkWrapKeyVersionExist(appID, cgID, wrapKeyVer)) {
                    CommonResponseBean commonResponseBean = new CommonResponseBean(1, "success", null);
                    return commonResponseBean;
                }
                if (this.entityProvider.getLastWrapVersion(appID, cgID) < wrapKeyVer) {
                    CommonResponseBean commonResponseBean = new CommonResponseBean(-2, "Illegeal_mission", null);
                    return commonResponseBean;
                }
                this.provider.doUploadUpdateWrapKey(appID, reqBean);
            }
            finally {
                this.entityProvider.unlock(appID, cgID);
            }
            this.logger.info(LogUtil.formatLog((String)this.getAppID(request), (String)this.getSn(request), null, null, (String)("\u66f4\u65b0\u5907\u4efd\u8bbe\u5907WrapKey\u5f85\u529e\u4e8b\u9879\u3010" + reqBean.getMid() + "\u3011")));
        }
        CommonResponseBean resp = new CommonResponseBean(0, "success", null);
        if (todo == 1) {
            resp.setTodos(this.provider.getRestoreMissionsByDevice(chipSn, appID, null, null));
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AopLog
    @RequestMapping(value={"/api/v2/restore/{chipSn}/schedule/updatePGK"}, consumes={"application/json"}, method={RequestMethod.POST})
    public Object updatePGKRestore(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="chipSn") String chipSn, @RequestParam int todo, @RequestBody List<UpdatePgkReq> req) throws JSONException {
        if (this.getSn(request).equals(chipSn)) {
            this.logger.error("\u5907\u4efd\u8bbe\u5907\u66f4\u65b0PGK\u5f85\u529e\u4e8b\u9879\u5904\u7406\u7ed3\u679c\u5931\u8d25\uff0c\u5907\u4efd\u8bbe\u5907\u4e0d\u80fd\u4e0e\u6062\u590d\u8bbe\u5907\u76f8\u540c", (Object)chipSn);
            return HttpError.BA_DEV_AND_RES_DEV_NOT_SAME.handle(response);
        }
        if (CommonSetting.BACKUP_TRIGGER && !this.checkDeviceBindBCard(chipSn)) {
            this.logger.error("\u8bbe\u5907 \u3010{}\u3011\u672a\u7ed1\u5b9a\u5907\u4efd\u5361", (Object)chipSn);
            return HttpError.NOT_BIND_BACKUP_CARD.handle(response);
        }
        String headAppID = "";
        if (VerifyUtil.isEmpty(req)) {
            return new CommonResponseBean(-2, "Illegeal_mission", null);
        }
        for (UpdatePgkReq reqBean : req) {
            if (VerifyUtil.hasNull((Object)reqBean)) {
                return new CommonResponseBean(-2, "Illegeal_mission", null);
            }
            if (!this.provider.existMission(reqBean.getMid())) {
                return new CommonResponseBean(1, "success", null);
            }
            if (!this.provider.checkMission(reqBean.getMid(), 2, chipSn)) {
                this.logger.error("\u4e0a\u4f20\u5907\u4efd\u8bbe\u5907\u66f4\u65b0PGK\u5904\u7406\u7ed3\u679c \u4ee3\u529e\u4e8b\u9879\u3010mid\u3011:{}\uff0c\u4ee3\u529e\u4e8b\u9879\u3010type\u3011:{}\u4e0e\u8bbe\u5907\u3010SN\u3011:{}\u4e0d\u5339\u914d", new Object[]{reqBean.getMid(), 2, chipSn});
                return new CommonResponseBean(-2, "Illegeal_mission", null);
            }
            PartyGroupKey partyGroupKey = (PartyGroupKey)JsonMapper.alwaysMapper().fromJson(reqBean.getPartyGroupKey().getInfo(), PartyGroupKey.class);
            headAppID = partyGroupKey.getAppID();
            if (!this.partyGroupProvider.existPartyGroup(partyGroupKey.getPgID())) {
                this.logger.error("\u4e0a\u4f20\u5907\u4efd\u8bbe\u5907\u66f4\u65b0PGK\u5904\u7406\u7ed3\u679c \u4ee3\u529e\u4e8b\u9879\u3010mid\u3011:{} \u6d89\u53ca\u7684partyGroup\u4e0d\u5b58\u5728", (Object)reqBean.getMid());
                return new CommonResponseBean(-2, "Illegeal_mission", null);
            }
            if (!this.entityProvider.existEntity(headAppID, reqBean.getWrapedPgKey().getCgID())) {
                this.logger.error("\u4e0a\u4f20\u5907\u4efd\u8bbe\u5907\u66f4\u65b0PGK\u5904\u7406\u7ed3\u679c \u4ee3\u529e\u4e8b\u9879\u3010mid\u3011:{} \u6d89\u53ca\u7684Entity\u4e0d\u5b58\u5728", (Object)reqBean.getMid());
                return new CommonResponseBean(-2, "Illegeal_mission", null);
            }
            try {
                if (!this.partyGroupProvider.lock(partyGroupKey.getPgID())) {
                    CommonResponseBean commonResponseBean = new CommonResponseBean(-1, "mission_doing", null);
                    return commonResponseBean;
                }
                if (String.valueOf(this.partyGroupKeyProvider.getLastedPgkVersion(partyGroupKey.getPgID())).equals(partyGroupKey.getPgkVer())) {
                    CommonResponseBean commonResponseBean = new CommonResponseBean(1, "success", null);
                    return commonResponseBean;
                }
                this.provider.doUploadUpdatePgk(headAppID, reqBean);
            }
            finally {
                this.partyGroupProvider.unlock(partyGroupKey.getPgID());
            }
            this.logger.info(LogUtil.formatLog((String)this.getAppID(request), (String)this.getSn(request), null, null, (String)("\u66f4\u65b0\u5907\u4efd\u8bbe\u5907PGK\u5f85\u529e\u4e8b\u9879\u3010" + reqBean.getMid() + "\u3011")));
        }
        CommonResponseBean resp = new CommonResponseBean(0, "success", null);
        if (todo == 1) {
            resp.setTodos(this.provider.getRestoreMissionsByDevice(chipSn, headAppID, null, null));
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AopLog
    @RequestMapping(value={"/api/v2/restore/{chipSn}/{appID}/schedule/wrapPGK"}, consumes={"application/json"}, method={RequestMethod.POST})
    public Object wrapPGKRestore(HttpServletRequest request, HttpServletResponse response, @PathVariable String chipSn, @PathVariable String appID, @RequestParam int todo, @RequestBody List<WrapPgkReq> req) throws JSONException {
        if (this.getSn(request).equals(chipSn)) {
            this.logger.error("\u5907\u4efd\u8bbe\u5907\u4e0a\u4f20\u5f52\u6863PGK\u5f85\u529e\u4e8b\u9879\u5904\u7406\u7ed3\u679c\u5931\u8d25\uff0c\u5907\u4efd\u8bbe\u5907\u4e0d\u80fd\u4e0e\u6062\u590d\u8bbe\u5907\u76f8\u540c", (Object)chipSn);
            return HttpError.BA_DEV_AND_RES_DEV_NOT_SAME.handle(response);
        }
        if (CommonSetting.BACKUP_TRIGGER && !this.checkDeviceBindBCard(chipSn)) {
            this.logger.error("\u8bbe\u5907 \u3010{}\u3011\u672a\u7ed1\u5b9a\u5907\u4efd\u5361", (Object)chipSn);
            return HttpError.NOT_BIND_BACKUP_CARD.handle(response);
        }
        if (VerifyUtil.isEmpty(req)) {
            return new CommonResponseBean(-2, "Illegeal_mission", null);
        }
        for (WrapPgkReq reqBean : req) {
            if (VerifyUtil.hasNull((Object)reqBean)) {
                return new CommonResponseBean(-2, "Illegeal_mission", null);
            }
            if (!this.provider.existMission(reqBean.getMid())) {
                return new CommonResponseBean(-2, "Illegeal_mission", null);
            }
            if (!this.provider.checkMission(reqBean.getMid(), 5, chipSn)) {
                this.logger.error("\u4e0a\u4f20\u5907\u4efd\u8bbe\u5907\u5f52\u6863PGK\u5904\u7406\u7ed3\u679c \u4ee3\u529e\u4e8b\u9879\u3010mid\u3011:{}\uff0c\u4ee3\u529e\u4e8b\u9879\u3010type\u3011:{}\u4e0e\u8bbe\u5907\u3010SN\u3011:{}\u4e0d\u5339\u914d", new Object[]{reqBean.getMid(), 5, chipSn});
                return new CommonResponseBean(-2, "Illegeal_mission", null);
            }
            String pgID = ((WrapedPgKey)reqBean.getWrapedPgKey().get(0)).getPgID();
            String cgID = ((WrapedPgKey)reqBean.getWrapedPgKey().get(0)).getCgID();
            for (WrapedPgKey wrapedPgKey : reqBean.getWrapedPgKey()) {
                if (pgID.equals(wrapedPgKey.getPgID()) && cgID.equals(wrapedPgKey.getCgID())) continue;
                this.logger.error("\u4e0a\u4f20\u5907\u4efd\u8bbe\u5907\u5f52\u6863PGK\u5904\u7406\u7ed3\u679c \u4ee3\u529e\u4e8b\u9879\u3010mid\u3011:{}\uff0c\u53c2\u6570\u4e0d\u5408\u6cd5", (Object)reqBean.getMid());
                return new CommonResponseBean(-2, "Illegeal_mission", null);
            }
            List entityIds = this.partyGroupProvider.queryEntityIDsByPartyGroupID(pgID);
            if (!entityIds.contains(cgID)) {
                this.logger.error("\u4e0a\u4f20\u5907\u4efd\u8bbe\u5907\u5f52\u6863PGK\u5904\u7406\u7ed3\u679c \u4ee3\u529e\u4e8b\u9879\u3010mid\u3011:{} \u6d89\u53ca\u7684partyGroup\u548cEntityID\u4e0d\u5339\u914d", (Object)reqBean.getMid());
                return new CommonResponseBean(-2, "Illegeal_mission", null);
            }
            WrapedPgKey wrapPgk = (WrapedPgKey)reqBean.getWrapedPgKey().get(0);
            try {
                if (!this.partyGroupProvider.lockWrapPgkVersion(wrapPgk.getPgID(), wrapPgk.getCgID(), wrapPgk.getPgkVer())) {
                    CommonResponseBean commonResponseBean = new CommonResponseBean(-1, "mission_doing", null);
                    return commonResponseBean;
                }
                this.provider.doUploadWrapPgk(appID, reqBean);
            }
            finally {
                this.partyGroupProvider.unLockWrapPgkVersion(wrapPgk.getPgID(), wrapPgk.getCgID(), wrapPgk.getPgkVer());
            }
            this.logger.info(LogUtil.formatLog((String)this.getAppID(request), (String)this.getSn(request), null, null, (String)("\u4e0a\u4f20\u5907\u4efd\u8bbe\u5907\u5f52\u6863PGK\u5f85\u529e\u4e8b\u9879\u3010" + reqBean.getMid() + "\u3011")));
        }
        CommonResponseBean resp = new CommonResponseBean(0, "success", null);
        if (todo == 1) {
            resp.setTodos(this.provider.getRestoreMissionsByDevice(chipSn, appID, null, null));
        }
        return resp;
    }

    @AopLog
    @RequestMapping(value={"/api/v2/restore/{chipSn}/{appID}/schedule/wrapKey"}, consumes={"application/json"}, method={RequestMethod.POST})
    public Object kekWrapKeyRestore(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="chipSn") String chipSn, @PathVariable String appID, @RequestParam int todo, @RequestBody List<KekWrapKeyReq> req) throws JSONException {
        if (this.getSn(request).equals(chipSn)) {
            this.logger.error("\u4e0a\u4f20\u5907\u4efd\u8bbe\u5907\u5f52\u6863WrapKey\u5f85\u529e\u4e8b\u9879\u5904\u7406\u7ed3\u679c\u5931\u8d25\uff0c\u5907\u4efd\u8bbe\u5907\u4e0d\u80fd\u4e0e\u6062\u590d\u8bbe\u5907\u76f8\u540c", (Object)chipSn);
            return HttpError.BA_DEV_AND_RES_DEV_NOT_SAME.handle(response);
        }
        if (CommonSetting.BACKUP_TRIGGER && !this.checkDeviceBindBCard(chipSn)) {
            this.logger.error("\u8bbe\u5907 \u3010{}\u3011\u672a\u7ed1\u5b9a\u5907\u4efd\u5361", (Object)chipSn);
            return HttpError.NOT_BIND_BACKUP_CARD.handle(response);
        }
        if (VerifyUtil.isEmpty(req)) {
            return new CommonResponseBean(-2, "Illegeal_mission", null);
        }
        for (KekWrapKeyReq reqBean : req) {
            if (VerifyUtil.hasNull((Object)reqBean)) {
                return new CommonResponseBean(-2, "Illegeal_mission", null);
            }
            if (!this.provider.existMission(reqBean.getMid())) {
                return new CommonResponseBean(-2, "Illegeal_mission", null);
            }
            if (!this.provider.checkMission(reqBean.getMid(), 4, chipSn)) {
                this.logger.error("\u4e0a\u4f20\u5f52\u6863WrapKey\u5904\u7406\u7ed3\u679c \u4ee3\u529e\u4e8b\u9879\u3010mid\u3011:{}\uff0c\u4ee3\u529e\u4e8b\u9879\u3010type\u3011:{}\u4e0e\u8bbe\u5907\u3010SN\u3011:{}\u4e0d\u5339\u914d", new Object[]{reqBean.getMid(), 4, chipSn});
                return new CommonResponseBean(-2, "Illegeal_mission", null);
            }
            String cgID = ((KekWrapKey)reqBean.getKekWrapKey().get(0)).getCgID();
            for (KekWrapKey keyWrapKey : reqBean.getKekWrapKey()) {
                if (cgID.equals(keyWrapKey.getCgID())) continue;
                this.logger.error("\u4e0a\u4f20\u5907\u4efd\u8bbe\u5907\u5f52\u6863WrapKey\u5904\u7406\u7ed3\u679c \u4ee3\u529e\u4e8b\u9879\u3010mid\u3011:{}\uff0c\u53c2\u6570\u4e0d\u5408\u6cd5", (Object)reqBean.getMid());
                return new CommonResponseBean(-2, "Illegeal_mission", null);
            }
            if (!this.entityProvider.existEntity(appID, cgID)) {
                this.logger.error("\u4e0a\u4f20\u5907\u4efd\u8bbe\u5907\u5f52\u6863WrapKey\u5904\u7406\u7ed3\u679c \u4ee3\u529e\u4e8b\u9879\u3010mid\u3011:{} \u6d89\u53ca\u7684Entity\u4e0d\u5b58\u5728", (Object)reqBean.getMid());
                return new CommonResponseBean(-2, "Illegeal_mission", null);
            }
            this.provider.doUploadWrapWrapKey(appID, reqBean);
            this.logger.info(LogUtil.formatLog((String)this.getAppID(request), (String)this.getSn(request), null, null, (String)("\u4e0a\u4f20\u5907\u4efd\u8bbe\u5907\u5f52\u6863WrapKey\u5f85\u529e\u4e8b\u9879\u3010" + reqBean.getMid() + "\u3011")));
        }
        CommonResponseBean resp = new CommonResponseBean(0, "success", null);
        if (todo == 1) {
            resp.setTodos(this.provider.getRestoreMissionsByDevice(chipSn, appID, null, null));
        }
        return resp;
    }

    @AopLog
    @RequestMapping(value={"/api/v2/restore/{chipSn}/{appID}/schedule/notice"}, consumes={"application/json"}, method={RequestMethod.POST})
    public Object noticeRestore(HttpServletRequest request, HttpServletResponse response, @RequestBody List<String> mids, @PathVariable(value="chipSn") String chipSN, @PathVariable(value="appID") String appID, @RequestParam int todo) throws JSONException {
        if (this.getSn(request).equals(chipSN)) {
            this.logger.error("\u901a\u77e5\u5907\u4efd\u8bbe\u5907\u5f85\u529e\u5904\u7406\u5931\u8d25\uff0c\u5907\u4efd\u8bbe\u5907\u4e0d\u80fd\u4e0e\u6062\u590d\u8bbe\u5907\u76f8\u540c", (Object)chipSN);
            return HttpError.BA_DEV_AND_RES_DEV_NOT_SAME.handle(response);
        }
        this.provider.doCompleteMissions(mids);
        this.logger.info(this.format(request, null, null, "\u901a\u77e5\u5907\u4efd\u8bbe\u5907\u5f85\u529e\u4e8b\u9879\u3010" + mids + "\u3011\u5904\u7406"));
        CommonResponseBean resp = new CommonResponseBean(0, "success", null);
        if (todo == 1) {
            resp.setTodos(this.provider.getRestoreMissionsByDevice(chipSN, appID, null, null));
        }
        return resp;
    }

    @AopLog
    @RequestMapping(value={"/api/v2/restore/{chipSn}/{entityID}/{appID}/syncPair"}, consumes={"application/json"}, method={RequestMethod.GET})
    public Object getSyncPairRestore(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="chipSn") String chipSn, @PathVariable(value="entityID") String entityId, @PathVariable(value="appID") String appID) throws JSONException {
        if (CommonSetting.BACKUP_TRIGGER && !this.checkDeviceBindBCard(chipSn)) {
            this.logger.error("\u8bbe\u5907 \u3010{}\u3011\u672a\u7ed1\u5b9a\u5907\u4efd\u5361", (Object)chipSn);
            return HttpError.NOT_BIND_BACKUP_CARD.handle(response);
        }
        GetSyncPairResp resp = this.entityProvider.getSyncPairByEntityAndAppId(appID, entityId, chipSn);
        if (resp == null) {
            return HttpError.SYNC_PAIR_NOT_EXIST.handle(response);
        }
        this.logger.info(this.format(request, entityId, null, "\u83b7\u53d6\u5907\u4efd\u8bbe\u5907Entity\u516c\u79c1\u94a5\u5bf9"));
        return resp;
    }

    @AopLog
    @RequestMapping(value={"/api/v2/restore/{chipSn}/{entityID}/{appID}/wrapKeys"}, consumes={"application/json"}, method={RequestMethod.GET})
    public Object getWrapKeysRestore(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="chipSn") String chipSn, @PathVariable(value="entityID") String entityId, @PathVariable(value="appID") String appID) throws JSONException {
        long ver;
        if (CommonSetting.BACKUP_TRIGGER && !this.checkDeviceBindBCard(chipSn)) {
            this.logger.error("\u8bbe\u5907 \u3010{}\u3011\u672a\u7ed1\u5b9a\u5907\u4efd\u5361", (Object)chipSn);
            return HttpError.NOT_BIND_BACKUP_CARD.handle(response);
        }
        String wrapKeyVersion = request.getParameter("wrapKeyVersion");
        if (StringUtils.isEmpty((CharSequence)wrapKeyVersion)) {
            return HttpError.ILLEGAL_REQUEST_PARAMETER.handle(response);
        }
        try {
            ver = Long.valueOf(wrapKeyVersion);
            if (ver == -2L) {
                ver = this.entityProvider.getLastExistWrapKeyVersion(entityId, appID);
            }
        }
        catch (NumberFormatException ex) {
            this.logger.error("wrapKeyVersion \u4e0d\u5408\u6cd5 \u3010{}\u3011", (Object)wrapKeyVersion);
            return HttpError.ILLEGAL_REQUEST_PARAMETER.handle(response);
        }
        GetWrapKeysResp resp = this.entityProvider.getWrapKeys(chipSn, appID, entityId, ver);
        if (resp == null) {
            return HttpError.WRAPKEY_IS_NOT_EXIST.handle(response);
        }
        this.logger.info(this.format(request, entityId, null, "\u83b7\u53d6\u5907\u4efd\u8bbe\u5907Entity\u4e0b\u7684WrapKey\uff0c\u7248\u672c\u3010" + wrapKeyVersion + "\u3011"));
        return resp;
    }

    private boolean checkDeviceBindBCard(String chipSn) {
        return StringUtils.isNotBlank((CharSequence)this.backupProvider.querySnByChipSn(chipSn));
    }
}

