/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.exception.handler;

import com.xdja.platform.common.lite.kit.json.JSONException;
import com.xdja.safecenter.secret.controller.HttpError;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.TypeMismatchException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.NoHandlerFoundException;

@ControllerAdvice
public class CommonExceptionHandler {
    private Logger logger = LoggerFactory.getLogger(CommonExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Object handleException(Exception exception, HttpServletResponse resp) {
        this.logger.error("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef", (Throwable)exception);
        return HttpError.SERVER_INTERNAL_EXCEPTION.handle(resp);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseBody
    public Object handleException(HttpMessageNotReadableException exception, HttpServletResponse resp) {
        this.logger.error("\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5", (Throwable)exception);
        return HttpError.ILLEGAL_REQUEST_PARAMETER.handle(resp);
    }

    @ExceptionHandler(value={TypeMismatchException.class})
    @ResponseBody
    public Object handleException(TypeMismatchException exception, HttpServletResponse resp) {
        this.logger.error("\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5", (Throwable)exception);
        return HttpError.ILLEGAL_REQUEST_PARAMETER.handle(resp);
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseBody
    public Object handleException(MissingServletRequestParameterException exception, HttpServletResponse resp) {
        this.logger.error("\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5", (Throwable)exception);
        return HttpError.MISSING_REQUIRED_PARAMETERS.handle(resp);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseBody
    public Object handleException(IllegalArgumentException exception, HttpServletResponse resp) {
        this.logger.error("\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5", (Throwable)exception);
        return HttpError.ILLEGAL_REQUEST_PARAMETER.handle(resp);
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseBody
    public Object handleException(HttpRequestMethodNotSupportedException exception, HttpServletResponse resp) {
        this.logger.error("\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u5408\u6cd5", (Throwable)exception);
        return HttpError.REQUEST_METHOD_NOT_SUPPORTED.handle(resp);
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    @ResponseBody
    public Object handleException(HttpMediaTypeNotSupportedException exception, HttpServletResponse resp) {
        this.logger.error("\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u5408\u6cd5", (Throwable)exception);
        return HttpError.REQUEST_METHOD_NOT_SUPPORTED.handle(resp);
    }

    @ExceptionHandler(value={ServletRequestBindingException.class})
    @ResponseBody
    public Object handleException(ServletRequestBindingException exception, HttpServletResponse resp) {
        this.logger.error("\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5", (Throwable)exception);
        return HttpError.MISSING_REQUIRED_PARAMETERS.handle(resp);
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    @ResponseBody
    public Object handleException(NoHandlerFoundException exception, HttpServletRequest request, HttpServletResponse resp) {
        this.logger.error("\u3010{}\u3011\u8bf7\u6c42\u7684URI\u4e0d\u5b58\u5728", (Object)request.getRemoteHost(), (Object)exception);
        resp.setStatus(404);
        return exception.getMessage();
    }

    @ExceptionHandler(value={JSONException.class})
    @ResponseBody
    public Object handleException(JSONException exception, HttpServletResponse resp) {
        this.logger.error("\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u975e\u6cd5", (Throwable)exception);
        return HttpError.ILLEGAL_REQUEST_PARAMETER.handle(resp);
    }
}

