/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.common.datasource.config;

import java.util.Collections;
import java.util.HashMap;
import org.aopalliance.aop.Advice;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;

@Order(value=2)
@Aspect
@Configuration
public class TransactionConfiguration {
    @Value(value="${saps.config.tx.timeout:30}")
    private int txTimeOut = 30;
    private final PlatformTransactionManager transactionManager;

    @Bean
    public TransactionInterceptor txAdvice() {
        RuleBasedTransactionAttribute readOnlyRule = new RuleBasedTransactionAttribute();
        readOnlyRule.setReadOnly(true);
        readOnlyRule.setPropagationBehavior(1);
        RuleBasedTransactionAttribute requireRule = new RuleBasedTransactionAttribute(0, Collections.singletonList(new RollbackRuleAttribute(Exception.class)));
        requireRule.setTimeout(this.txTimeOut);
        HashMap<String, RuleBasedTransactionAttribute> nameMap = new HashMap<String, RuleBasedTransactionAttribute>();
        nameMap.put("add*", requireRule);
        nameMap.put("save*", requireRule);
        nameMap.put("insert*", requireRule);
        nameMap.put("create*", requireRule);
        nameMap.put("update*", requireRule);
        nameMap.put("modify*", requireRule);
        nameMap.put("delete*", requireRule);
        nameMap.put("remove*", requireRule);
        nameMap.put("exec*", requireRule);
        nameMap.put("do*", requireRule);
        nameMap.put("get*", readOnlyRule);
        nameMap.put("list*", readOnlyRule);
        nameMap.put("query*", readOnlyRule);
        nameMap.put("find*", readOnlyRule);
        nameMap.put("select*", readOnlyRule);
        nameMap.put("count*", readOnlyRule);
        nameMap.put("exist*", readOnlyRule);
        NameMatchTransactionAttributeSource source = new NameMatchTransactionAttributeSource();
        source.setNameMap(nameMap);
        return new TransactionInterceptor(this.transactionManager, (TransactionAttributeSource)source);
    }

    @Bean
    public Advisor txAdviceAdvisor() {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression("execution (public * com.xdja.saps..service.*.*ServiceImpl.*(..))");
        return new DefaultPointcutAdvisor((Pointcut)pointcut, (Advice)this.txAdvice());
    }

    public TransactionConfiguration(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }
}

