/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.common.http;

import com.xdja.saps.view.common.http.bean.HttpResult;
import java.util.Map;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class SapsViewHttpClient {
    private final RestTemplate restTemplate;

    public SapsViewHttpClient(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public HttpResult get(String url) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        return this.get(url, null, httpHeaders);
    }

    public HttpResult get(String url, @Nullable HttpHeaders headers) {
        try {
            HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, byte[].class, new Object[0]);
            return HttpResult.build((ResponseEntity<byte[]>)responseEntity);
        }
        catch (HttpClientErrorException exception) {
            return HttpResult.build(exception);
        }
        catch (RestClientException e) {
            return HttpResult.build(e);
        }
    }

    public HttpResult get(String url, @Nullable byte[] body, @Nullable HttpHeaders headers) {
        try {
            HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, byte[].class, new Object[0]);
            return HttpResult.build((ResponseEntity<byte[]>)responseEntity);
        }
        catch (HttpClientErrorException exception) {
            return HttpResult.build(exception);
        }
        catch (RestClientException e) {
            return HttpResult.build(e);
        }
    }

    public HttpResult post(String url, byte[] body) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        return this.post(url, body, httpHeaders);
    }

    public HttpResult post(String url, byte[] body, @Nullable HttpHeaders headers) {
        try {
            HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, byte[].class, new Object[0]);
            return HttpResult.build((ResponseEntity<byte[]>)responseEntity);
        }
        catch (HttpClientErrorException exception) {
            return HttpResult.build(exception);
        }
        catch (RestClientException e) {
            return HttpResult.build(e);
        }
    }

    public HttpResult put(String url, byte[] body, @Nullable HttpHeaders headers) {
        try {
            HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.PUT, httpEntity, byte[].class, new Object[0]);
            return HttpResult.build((ResponseEntity<byte[]>)responseEntity);
        }
        catch (HttpClientErrorException exception) {
            return HttpResult.build(exception);
        }
        catch (RestClientException e) {
            return HttpResult.build(e);
        }
    }

    public HttpResult delete(String url) {
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.DELETE, null, byte[].class, new Object[0]);
            return HttpResult.build((ResponseEntity<byte[]>)responseEntity);
        }
        catch (HttpClientErrorException exception) {
            return HttpResult.build(exception);
        }
        catch (RestClientException e) {
            return HttpResult.build(e);
        }
    }

    public HttpHeaders buildHttpHeaders(MediaType mediaType, Map<String, String> params) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(mediaType);
        if (null != params && !params.isEmpty()) {
            params.forEach((arg_0, arg_1) -> ((HttpHeaders)headers).add(arg_0, arg_1));
        }
        return headers;
    }
}

