/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.common.http.bean;

import java.util.StringJoiner;
import org.bouncycastle.util.encoders.Hex;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

public class HttpResult {
    private HttpStatus httpStatus;
    private int statusCode;
    private HttpHeaders headers;
    private byte[] body;
    private String errorMsg;

    public static HttpResult build(ResponseEntity<byte[]> responseEntity) {
        HttpResult httpResult = new HttpResult();
        httpResult.setHttpStatus(responseEntity.getStatusCode());
        httpResult.setStatusCode(responseEntity.getStatusCodeValue());
        httpResult.setHeaders(responseEntity.getHeaders());
        if (responseEntity.hasBody()) {
            httpResult.setBody((byte[])responseEntity.getBody());
        }
        return httpResult;
    }

    public static HttpResult build(HttpClientErrorException exception) {
        HttpResult httpResult = new HttpResult();
        httpResult.setHttpStatus(exception.getStatusCode());
        httpResult.setStatusCode(exception.getRawStatusCode());
        httpResult.setBody(exception.getResponseBodyAsByteArray());
        httpResult.setErrorMsg(exception.getMessage());
        return httpResult;
    }

    public static HttpResult build(RestClientException exception) {
        HttpResult httpResult = new HttpResult();
        httpResult.setStatusCode(-1);
        httpResult.setErrorMsg(exception.getMessage());
        return httpResult;
    }

    public String toString() {
        StringJoiner stringJoiner = new StringJoiner(", ", HttpResult.class.getSimpleName() + "[", "]").add("statusCode=" + this.statusCode).add("headers=" + this.headers).add("errorMsg='" + this.errorMsg + "'");
        if (null != this.body) {
            stringJoiner.add("body=" + Hex.toHexString((byte[])this.body));
        }
        return stringJoiner.toString();
    }

    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public byte[] getBody() {
        return this.body;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setHttpStatus(HttpStatus httpStatus) {
        this.httpStatus = httpStatus;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public void setHeaders(HttpHeaders headers) {
        this.headers = headers;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }
}

