/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.common.http.config;

import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

@Configuration
public class RestTemplateConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RestTemplateConfiguration.class);
    @Value(value="${http.max-idle-connections:300}")
    private Integer maxIdleConnections;
    @Value(value="${http.connect-timeout:5000}")
    private Integer connectTimeout;
    @Value(value="${http.max.retry.count:3}")
    private Integer maxRetryCount;
    @Value(value="${http.retry.interval:1000}")
    private Integer retryInterval;

    @Bean
    public RestTemplate restTemplate() {
        RestTemplate restTemplate = new RestTemplate(this.clientHttpRequestFactory());
        List converterList = restTemplate.getMessageConverters();
        HttpMessageConverter converterTarget = null;
        for (HttpMessageConverter item : converterList) {
            if (StringHttpMessageConverter.class != item.getClass()) continue;
            converterTarget = item;
            break;
        }
        if (null != converterTarget) {
            converterList.remove(converterTarget);
        }
        converterList.add(0, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        return restTemplate;
    }

    @Bean
    public ClientHttpRequestFactory clientHttpRequestFactory() {
        return new HttpComponentsClientHttpRequestFactory(this.httpClient());
    }

    @Bean
    public HttpClient httpClient() {
        SSLContext sslContext = SSLContexts.createDefault();
        try {
            sslContext.init(null, this.getTrustAllManager(), null);
        }
        catch (KeyManagementException e) {
            log.error("init ssl context error", (Throwable)e);
        }
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext, this.getTrustAllHostnameVerifier());
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)socketFactory).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
        connectionManager.setMaxTotal(this.maxIdleConnections.intValue());
        connectionManager.setDefaultMaxPerRoute(this.maxIdleConnections.intValue());
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.connectTimeout.intValue()).build();
        ConnectionKeepAliveStrategy connectionKeepAliveStrategy = (httpResponse, httpContext) -> 36000000L;
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connectionManager).setKeepAliveStrategy(connectionKeepAliveStrategy).setRetryHandler(this.buildHttpRequestRetryHandler(this.maxRetryCount, this.retryInterval)).build();
    }

    private HttpRequestRetryHandler buildHttpRequestRetryHandler(int maxRetryCount, int retryInterval) {
        return (exception, retryTimes, context) -> {
            boolean idempotent;
            if (retryTimes > maxRetryCount) {
                return false;
            }
            if (exception instanceof ConnectTimeoutException || exception instanceof NoHttpResponseException || exception instanceof SocketTimeoutException || !(exception instanceof UnknownHostException) || !(exception instanceof InterruptedIOException) || !(exception instanceof SSLException) || !(exception instanceof SSLHandshakeException)) {
                try {
                    Thread.sleep((long)retryInterval + (long)(retryTimes - 1) * (long)retryInterval);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.error("\u7ebf\u7a0b\u4f11\u7720\u51fa\u9519", (Throwable)e);
                }
                return true;
            }
            log.error("\u672a\u8bb0\u5f55\u7684\u8bf7\u6c42\u5f02\u5e38\uff1a{}", exception.getClass());
            HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
            HttpRequest request = clientContext.getRequest();
            boolean bl = idempotent = !(request instanceof HttpEntityEnclosingRequest);
            return idempotent;
        };
    }

    private TrustManager[] getTrustAllManager() {
        X509TrustManager x509TrustManager = new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                if (chain == null || chain.length < 1 || authType == null || authType.length() < 1) {
                    throw new IllegalArgumentException();
                }
                String string = chain[0].getSubjectX500Principal().getName();
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                if (chain == null || chain.length < 1 || authType == null || authType.length() < 1) {
                    throw new IllegalArgumentException();
                }
                String string = chain[0].getSubjectX500Principal().getName();
            }
        };
        return new TrustManager[]{x509TrustManager};
    }

    private HostnameVerifier getTrustAllHostnameVerifier() {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        };
    }

    private ServiceUnavailableRetryStrategy buildServiceUnavailableRetryStrategy(final int maxRetryCount, final int retryInterval) {
        return new ServiceUnavailableRetryStrategy(){

            public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
                int statusCode = response.getStatusLine().getStatusCode();
                return executionCount <= maxRetryCount && statusCode >= 500 && statusCode < 600;
            }

            public long getRetryInterval() {
                return retryInterval;
            }
        };
    }
}

