/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.mmc.client.netty;

import com.xdja.saps.mmc.client.netty.NettyClientHandler;
import com.xdja.saps.mmc.client.netty.util.ChannelUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.Attribute;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class NettyChannelPool {
    private String ip;
    private int port;
    private Channel[] channels;
    private Object[] locks;
    private int maxChannel;
    private int timeoutMillis;
    private int heartbeatTimeMillis;

    public NettyChannelPool(String ip, int port, int maxChannel, int timeoutMillis, int heartbeatTimeMillis) {
        this.ip = ip;
        this.port = port;
        this.maxChannel = maxChannel;
        this.timeoutMillis = timeoutMillis;
        this.heartbeatTimeMillis = heartbeatTimeMillis;
        this.channels = new Channel[maxChannel];
        this.locks = new Object[maxChannel];
        for (int i = 0; i < maxChannel; ++i) {
            this.locks[i] = new Object();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel getChannel() throws InterruptedException {
        int index = new Random().nextInt(this.maxChannel);
        Channel channel = this.channels[index];
        if (channel != null && channel.isActive()) {
            return channel;
        }
        Object object = this.locks[index];
        synchronized (object) {
            channel = this.channels[index];
            if (channel != null && channel.isActive()) {
                return channel;
            }
            this.channels[index] = channel = this.connectToServer();
        }
        return channel;
    }

    private Channel connectToServer() throws InterruptedException {
        NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup();
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)Boolean.FALSE)).option(ChannelOption.TCP_NODELAY, (Object)Boolean.TRUE)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.timeoutMillis)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(0L, 0L, (long)NettyChannelPool.this.heartbeatTimeMillis, TimeUnit.MILLISECONDS)});
                pipeline.addLast(new ChannelHandler[]{new NettyClientHandler()});
            }
        });
        ChannelFuture channelFuture = bootstrap.connect(this.ip, this.port);
        Channel channel = channelFuture.sync().channel();
        Attribute attribute = channel.attr(ChannelUtils.DATA_MAP_ATTRIBUTEKEY);
        ConcurrentHashMap dataMap = new ConcurrentHashMap();
        attribute.set(dataMap);
        return channel;
    }
}

