/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.mmc.config;

import com.xdja.saps.mmc.client.MmcClient;
import com.xdja.saps.mmc.client.netty.NettyChannelPool;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MmcConfig {
    @Value(value="${mms.ip:127.0.0.1}")
    private String ip;
    @Value(value="${mms.port:5059}")
    private int port;
    @Value(value="${mms.maxChannel:1}")
    private int maxChannel;
    @Value(value="${mms.connectionTimeout:3}")
    private int connectionTimeout;
    @Value(value="${mms.heartbeatTime:120}")
    private int heartbeatTime;
    @Value(value="${mms.responseTimeout:5}")
    private long responseTimeout;

    @Bean
    public NettyChannelPool nettyChannelPool() {
        return new NettyChannelPool(this.ip, this.port, this.maxChannel, this.connectionTimeout * 1000, this.heartbeatTime * 1000);
    }

    @Bean
    public MmcClient mmcClient() {
        return new MmcClient(this.nettyChannelPool(), this.responseTimeout * 1000L);
    }
}

