/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.mmc.service.impl;

import com.xdja.saps.mmc.client.MmcClient;
import com.xdja.saps.mmc.client.exception.MmcClientException;
import com.xdja.saps.mmc.client.netty.util.MsgSeqUtil;
import com.xdja.saps.mmc.client.protobuf.DevSignReq;
import com.xdja.saps.mmc.client.protobuf.DevSignRes;
import com.xdja.saps.mmc.client.protobuf.DevVerifyReq;
import com.xdja.saps.mmc.client.protobuf.GenSipCheckReq;
import com.xdja.saps.mmc.client.protobuf.GenSipCheckRes;
import com.xdja.saps.mmc.client.protobuf.GetKeyVendorReq;
import com.xdja.saps.mmc.client.protobuf.GetSecCapacitySetReq;
import com.xdja.saps.mmc.client.protobuf.KeyVendorRes;
import com.xdja.saps.mmc.client.protobuf.PictureData;
import com.xdja.saps.mmc.client.protobuf.PictureDataDecReq;
import com.xdja.saps.mmc.client.protobuf.PictureDataEncReq;
import com.xdja.saps.mmc.client.protobuf.SetCapacityReq;
import com.xdja.saps.mmc.client.protobuf.SetKeyVendorReq;
import com.xdja.saps.mmc.client.protobuf.SetSecParamReq;
import com.xdja.saps.mmc.client.protobuf.SipCheckReq;
import com.xdja.saps.mmc.client.protobuf.request;
import com.xdja.saps.mmc.client.protobuf.response;
import com.xdja.saps.mmc.service.IMmcService;
import com.xdja.saps.mmc.service.bean.DeviceSignReq;
import com.xdja.saps.mmc.service.bean.DeviceSignResp;
import com.xdja.saps.mmc.service.bean.DeviceVerifyReq;
import com.xdja.saps.mmc.service.bean.EncViewDataReq;
import com.xdja.saps.mmc.service.bean.GenControlSipParamsReq;
import com.xdja.saps.mmc.service.bean.GenControlSipParamsResp;
import com.xdja.saps.mmc.service.bean.KeyVendorReq;
import com.xdja.saps.mmc.service.bean.VerifyControlSipReq;
import com.xdja.saps.mmc.service.bean.ViewData;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MmcServiceImpl
implements IMmcService {
    private static final Logger log = LoggerFactory.getLogger(MmcServiceImpl.class);
    private final MmcClient mmcClient;

    @Override
    public boolean setCapacity(String serverId, int level) {
        SetCapacityReq setCapacityReq = SetCapacityReq.newBuilder().setLevel(level).setServerId(serverId).build();
        request request2 = this.createRequestBuilder().setSetCapacityReq(setCapacityReq).build();
        response response2 = this.sendRequest(request2);
        return response2.getSesCapacityRes().getOk();
    }

    @Override
    public boolean setSecParams(String deviceId, String serverId) {
        SetSecParamReq setSecParamReq = SetSecParamReq.newBuilder().setServerId(serverId).setDevId(deviceId).build();
        request request2 = this.createRequestBuilder().setSetSecParamReq(setSecParamReq).build();
        response response2 = this.sendRequest(request2);
        return response2.getSetSecParamRes().getOk();
    }

    @Override
    public String getSecCapacity() {
        GetSecCapacitySetReq getSecCapacitySetReq = GetSecCapacitySetReq.newBuilder().build();
        request request2 = this.createRequestBuilder().setGetSecCapacitySetReq(getSecCapacitySetReq).build();
        response response2 = this.sendRequest(request2);
        return response2.getGetSecCapacitySetRes().getAlgorithms();
    }

    @Override
    public boolean setKeyVendor(KeyVendorReq keyVendor) {
        SetKeyVendorReq keyVendorReq = SetKeyVendorReq.newBuilder().setVendor(keyVendor.getVendor()).setIp(keyVendor.getIp()).setPort(keyVendor.getPort()).build();
        request request2 = this.createRequestBuilder().setSetKeyVendorReq(keyVendorReq).build();
        response response2 = this.sendRequest(request2);
        return response2.getSetKeyVendorRes().getOk();
    }

    @Override
    public KeyVendorReq getKeyVendor() {
        GetKeyVendorReq getKeyVendorReq = GetKeyVendorReq.newBuilder().build();
        request request2 = this.createRequestBuilder().setGetKeyVendorReq(getKeyVendorReq).build();
        response response2 = this.sendRequest(request2);
        KeyVendorRes keyVendorRes = response2.getKeyVendorRes();
        KeyVendorReq keyVendor = new KeyVendorReq();
        keyVendor.setVendor(keyVendorRes.getVendor());
        keyVendor.setIp(keyVendorRes.getIp());
        keyVendor.setPort(keyVendorRes.getPort());
        return keyVendor;
    }

    @Override
    public DeviceSignResp deviceSign(DeviceSignReq deviceSignReq) {
        DevSignReq devSignReq = DevSignReq.newBuilder().setRandom1(deviceSignReq.getRandom1()).setServerId(deviceSignReq.getServerId()).setAlgorithm(deviceSignReq.getAlgorithm()).build();
        request request2 = this.createRequestBuilder().setDevSignReq(devSignReq).build();
        response response2 = this.sendRequest(request2);
        DevSignRes devSignRes = response2.getDevSignRes();
        DeviceSignResp deviceSignResp = new DeviceSignResp();
        deviceSignResp.setSign(devSignRes.getSign());
        deviceSignResp.setRandom2(devSignRes.getRandom2());
        deviceSignResp.setAlgorithm(devSignRes.getAlgorithm());
        return deviceSignResp;
    }

    @Override
    public boolean deviceVerifySign(DeviceVerifyReq deviceVerifyReq) {
        DevVerifyReq devVerifyReq = DevVerifyReq.newBuilder().setRandom1(deviceVerifyReq.getRandom1()).setRandom2(deviceVerifyReq.getRandom2()).setDevId(deviceVerifyReq.getDeviceId()).setServerId(deviceVerifyReq.getServerId()).setCryptKey(deviceVerifyReq.getCryptKey()).setKeyVersion(deviceVerifyReq.getKeyVersion()).setSign2(deviceVerifyReq.getSign2()).build();
        request request2 = this.createRequestBuilder().setDevVerifyReq(devVerifyReq).build();
        response response2 = this.sendRequest(request2);
        return response2.getDevVerifyRes().getOk();
    }

    @Override
    public GenControlSipParamsResp genControlSipParams(GenControlSipParamsReq genControlSipReq) {
        GenSipCheckReq genSipCheckReq = GenSipCheckReq.newBuilder().setDate(genControlSipReq.getDate()).setMethod(genControlSipReq.getMethod()).setFrom(genControlSipReq.getFrom()).setTo(genControlSipReq.getTo()).setCallId(genControlSipReq.getCallId()).setMessageBody(genControlSipReq.getMessageBody()).setServerId(genControlSipReq.getServerId()).build();
        request request2 = this.createRequestBuilder().setGenSipCheckReq(genSipCheckReq).build();
        response response2 = this.sendRequest(request2);
        GenSipCheckRes genSipCheckRes = response2.getGenSipCheckRes();
        GenControlSipParamsResp genControlSipParamsResp = new GenControlSipParamsResp();
        genControlSipParamsResp.setNonce(genSipCheckRes.getNonce());
        genControlSipParamsResp.setAlgorithm(genSipCheckRes.getAlgorithm());
        return genControlSipParamsResp;
    }

    @Override
    public boolean verifyControlSip(VerifyControlSipReq verifyControlSipReq) {
        SipCheckReq sipCheckReq = SipCheckReq.newBuilder().setDate(verifyControlSipReq.getDate()).setMethod(verifyControlSipReq.getMethod()).setFrom(verifyControlSipReq.getFrom()).setTo(verifyControlSipReq.getTo()).setCallId(verifyControlSipReq.getCallId()).setMessageBody(verifyControlSipReq.getMessageBody()).setAlgorithm(verifyControlSipReq.getAlgorithm()).setNonce(verifyControlSipReq.getNonce()).setServerId(verifyControlSipReq.getServerId()).build();
        request request2 = this.createRequestBuilder().setSipCheckReq(sipCheckReq).build();
        response response2 = this.sendRequest(request2);
        return response2.getSipCheckRes().getOk();
    }

    @Override
    public String encryptViewData(EncViewDataReq viewDataReq) {
        PictureDataEncReq.Builder pictureDataEncReqBuilder = PictureDataEncReq.newBuilder();
        pictureDataEncReqBuilder.setGWDeviceId(viewDataReq.getGWDeviceId());
        viewDataReq.getViewDataList().forEach(item -> {
            PictureData pictureData = PictureData.newBuilder().setDeviceId(item.getDeviceId()).setOriginURI(item.getOriginURI()).setBody(item.getBody()).build();
            pictureDataEncReqBuilder.addPictureData(pictureData);
        });
        request request2 = this.createRequestBuilder().setPictureDataEncReq(pictureDataEncReqBuilder).build();
        response response2 = this.sendRequest(request2);
        return response2.getPictureDataEncRes().getEncData();
    }

    @Override
    public List<ViewData> decryptViewData(String encViewDataReq) {
        PictureDataDecReq pictureDataDecReq = PictureDataDecReq.newBuilder().setEncData(encViewDataReq).build();
        request request2 = this.createRequestBuilder().setPictureDataDecReq(pictureDataDecReq).build();
        response response2 = this.sendRequest(request2);
        ArrayList<ViewData> viewDatas = new ArrayList<ViewData>();
        response2.getPictureDataDecRes().getPictureDataList().forEach(item -> {
            ViewData viewData = new ViewData();
            viewData.setDeviceId(item.getDeviceId());
            viewData.setOriginURI(item.getOriginURI());
            viewData.setBody(item.getBody());
            viewDatas.add(viewData);
        });
        return viewDatas;
    }

    private request.Builder createRequestBuilder() {
        return request.newBuilder().setId(MsgSeqUtil.getMsgSeq());
    }

    private response sendRequest(request req) {
        response response2 = this.mmcClient.send(req);
        if (response.TypeCase.ERROR == response2.getTypeCase()) {
            log.error("\u591a\u5a92\u4f53\u5bc6\u7801\u670d\u52a1\u4e1a\u52a1\u6267\u884c\u5f02\u5e38\uff0c[errCode={},desc={}]", (Object)response2.getError().getCode(), (Object)response2.getError().getDescription());
            throw MmcClientException.create("\u591a\u5a92\u4f53\u5bc6\u7801\u670d\u52a1\u4e1a\u52a1\u6267\u884c\u5f02\u5e38", null);
        }
        return response2;
    }

    public MmcServiceImpl(MmcClient mmcClient) {
        this.mmcClient = mmcClient;
    }
}

