/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.mmc.client;

import com.xdja.saps.mmc.client.exception.MmcClientException;
import com.xdja.saps.mmc.client.exception.RemotingRequestException;
import com.xdja.saps.mmc.client.exception.RemotingResponseTimeoutException;
import com.xdja.saps.mmc.client.netty.MsgCallback;
import com.xdja.saps.mmc.client.netty.NettyChannelPool;
import com.xdja.saps.mmc.client.netty.util.ChannelUtils;
import com.xdja.saps.mmc.client.protobuf.request;
import com.xdja.saps.mmc.client.protobuf.response;
import com.xdja.saps.mmc.client.protocol.ProtocolData;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MmcClient {
    private static final Logger log = LoggerFactory.getLogger(MmcClient.class);
    private NettyChannelPool nettyChannelPools;
    private long timeoutMillis;

    public MmcClient(NettyChannelPool nettyChannelPools, long timeoutMillis) {
        this.nettyChannelPools = nettyChannelPools;
        this.timeoutMillis = timeoutMillis;
    }

    public response send(request request2) {
        try {
            long begin = System.currentTimeMillis();
            final MsgCallback callback = new MsgCallback();
            Channel channel = this.nettyChannelPools.getChannel();
            ProtocolData respData = null;
            InetSocketAddress socketAddress = null;
            try {
                ChannelUtils.putCallback2DataMap(channel, request2.getId(), callback);
                socketAddress = (InetSocketAddress)channel.remoteAddress();
                channel.writeAndFlush((Object)ProtocolData.build(request2.toByteArray())).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            callback.setSendRequestOk(true);
                            return;
                        }
                        callback.setSendRequestOk(false);
                        callback.setCause(future.cause());
                        callback.putResponse(null);
                        future.channel().closeFuture();
                    }
                });
                respData = callback.waitResponse(this.timeoutMillis);
            }
            finally {
                this.nettyChannelPools.releaseChannel(channel);
            }
            if (respData == null) {
                ChannelUtils.removeCallback(channel, request2.getId());
                if (callback.isSendRequestOk()) {
                    log.warn("\u7b49\u5f85\u8fdc\u7a0b\u670d\u52a1\u5668\u54cd\u5e94\u8d85\u65f6\uff0c\u6d88\u606fId [{}]\uff0c\u670d\u52a1\u5668\u5730\u5740 [{}:{}]\uff0c\u8d85\u65f6\u65f6\u95f4 [{}] ms", new Object[]{request2.getId(), socketAddress.getAddress().getHostAddress(), socketAddress.getPort(), this.timeoutMillis});
                    throw RemotingResponseTimeoutException.create(String.format("\u7b49\u5f85\u8fdc\u7a0b\u670d\u52a1\u5668\u54cd\u5e94\u8d85\u65f6\uff0c\u6d88\u606fId[%s]\uff0c\u670d\u52a1\u5668\u5730\u5740 [%s:%s], \u8d85\u65f6\u65f6\u95f4 %s ms ", request2.getId(), socketAddress.getAddress().getHostAddress(), socketAddress.getPort(), this.timeoutMillis));
                }
                log.warn("\u5411\u8fdc\u7a0b\u670d\u52a1\u5668\u53d1\u9001\u8bf7\u6c42\u5931\u8d25\uff0c\u6d88\u606fId [{}]\uff0c\u670d\u52a1\u5668\u5730\u5740 [{}:{}]", new Object[]{request2.getId(), socketAddress.getAddress().getHostAddress(), socketAddress.getPort()});
                throw RemotingRequestException.create(String.format("\u5411\u8fdc\u7a0b\u670d\u52a1\u5668\u53d1\u9001\u8bf7\u6c42\u5931\u8d25\uff0c\u6d88\u606fId [%s]\uff0c\u670d\u52a1\u5668\u5730\u5740 [%s:%s]", request2.getId(), socketAddress.getAddress().getHostAddress(), socketAddress.getPort()), callback.getCause());
            }
            response resp = (response)respData.getBusObject();
            if (response.TypeCase.SERVER_AUTH_INIT_RES == resp.getTypeCase()) {
                log.info("Netty\u5ba2\u6237\u7aef\uff0c\u7b2c1\u6b21\u4e1a\u52a1\u603b\u8017\u65f6\uff1a{}\u6beb\u79d2", (Object)(System.currentTimeMillis() - begin));
            }
            if (response.TypeCase.SERVER_AUTH_RES == resp.getTypeCase()) {
                log.info("Netty\u5ba2\u6237\u7aef\uff0c\u7b2c2\u6b21\u4e1a\u52a1\u603b\u8017\u65f6\uff1a{}\u6beb\u79d2", (Object)(System.currentTimeMillis() - begin));
            }
            return resp;
        }
        catch (Exception e) {
            throw MmcClientException.create("\u8c03\u7528\u591a\u5a92\u4f53\u5bc6\u7801\u670d\u52a1\u5931\u8d25", e);
        }
    }
}

