/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.mmc.client.netty;

import com.xdja.saps.mmc.client.netty.NettyClientHandler;
import com.xdja.saps.mmc.client.netty.util.ChannelUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.FixedChannelPool;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.Attribute;
import io.netty.util.concurrent.Future;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class NettyChannelPool {
    private Bootstrap bootstrap;
    private EventLoopGroup eventLoopGroup;
    private ChannelPool channelPool;

    public NettyChannelPool(String ip, int port, int maxChannel, int threadCount, int timeoutMillis, final int heartbeatTimeMillis) {
        this.eventLoopGroup = new NioEventLoopGroup(threadCount);
        this.bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)Boolean.FALSE)).option(ChannelOption.TCP_NODELAY, (Object)Boolean.TRUE)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)timeoutMillis)).remoteAddress((SocketAddress)InetSocketAddress.createUnresolved(ip, port)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO));
        this.channelPool = new FixedChannelPool(this.bootstrap, new ChannelPoolHandler(){

            public void channelReleased(Channel ch) throws Exception {
            }

            public void channelCreated(Channel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(0L, 0L, (long)heartbeatTimeMillis, TimeUnit.MILLISECONDS)});
                pipeline.addLast(new ChannelHandler[]{new NettyClientHandler()});
                Attribute attribute = ch.attr(ChannelUtils.DATA_MAP_ATTRIBUTEKEY);
                ConcurrentHashMap dataMap = new ConcurrentHashMap();
                attribute.set(dataMap);
            }

            public void channelAcquired(Channel ch) throws Exception {
            }
        }, maxChannel);
    }

    public Channel getChannel() throws InterruptedException, ExecutionException {
        Future future = this.channelPool.acquire();
        Channel channel = (Channel)future.get();
        return channel;
    }

    public void releaseChannel(Channel channel) {
        if (channel != null) {
            this.channelPool.release(channel);
        }
    }
}

