/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.mmc.client.netty;

import com.xdja.saps.mmc.client.netty.MsgCallback;
import com.xdja.saps.mmc.client.netty.util.ChannelUtils;
import com.xdja.saps.mmc.client.protobuf.response;
import com.xdja.saps.mmc.client.protocol.ProtocolData;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyClientHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(NettyClientHandler.class);
    private AtomicBoolean heartbeatFlag = new AtomicBoolean();
    private ProtocolData protocolData = null;

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        long begin = System.currentTimeMillis();
        Channel channel = ctx.channel();
        ByteBuf responseBuf = (ByteBuf)msg;
        InetSocketAddress remoteAddress = (InetSocketAddress)channel.remoteAddress();
        try {
            if (this.protocolData != null && this.protocolData.isReadOk()) {
                this.protocolData = null;
            }
            this.protocolData = ProtocolData.reslove(responseBuf, this.protocolData);
            if (!this.protocolData.isReadOk()) {
                return;
            }
        }
        catch (Exception e) {
            log.warn(String.format("\u8fdc\u7a0b\u670d\u52a1\u5668\u54cd\u5e94\u6570\u636e\u683c\u5f0f\u9519\u8bef [%s:%s]", remoteAddress.getAddress().getHostAddress(), remoteAddress.getPort()), (Throwable)e);
            throw e;
        }
        finally {
            responseBuf.release();
        }
        log.info("Netty\u54cd\u5e94\u5904\u7406\u5668-\u6570\u636e\u63a5\u6536\u8017\u65f6\uff1a{}\u6beb\u79d2", (Object)(System.currentTimeMillis() - begin));
        long busBegin = System.currentTimeMillis();
        if (this.protocolData.getLength() == 0) {
            if (!this.heartbeatFlag.get()) {
                log.warn("\u63a5\u6536\u8fdc\u7a0b\u670d\u52a1\u5668\u5fc3\u8df3\u54cd\u5e94\u6210\u529f\uff0c\u4f46\u8be5\u901a\u9053\u672a\u53d1\u9001\u5fc3\u8df3\u8bf7\u6c42\uff0c\u5df2\u5ffd\u7565\u8be5\u5fc3\u8df3\u54cd\u5e94 [{}:{}]", (Object)remoteAddress.getAddress().getHostAddress(), (Object)remoteAddress.getPort());
                return;
            }
            this.heartbeatFlag.set(false);
            if (log.isDebugEnabled()) {
                log.debug("\u63a5\u6536\u8fdc\u7a0b\u670d\u52a1\u5668\u5fc3\u8df3\u54cd\u5e94\u6210\u529f [{}:{}]", (Object)remoteAddress.getAddress().getHostAddress(), (Object)remoteAddress.getPort());
            }
            return;
        }
        response busObject = response.parseFrom(this.protocolData.getData());
        this.protocolData.setBusObject(busObject);
        MsgCallback msgCallback = (MsgCallback)ChannelUtils.removeCallback(channel, busObject.getId());
        if (msgCallback == null) {
            log.warn("\u8fdc\u7a0b\u670d\u52a1\u5668\u54cd\u5e94\u8bf7\u6c42\u5bf9\u5e94Callback\u5904\u7406\u5668\u4e0d\u5b58\u5728\uff0c\u539f\u56e0\uff1a\u6d88\u606f\u54cd\u5e94\u5df2\u8d85\u65f6\u6216\u6d88\u606fId\u4e0d\u5b58\u5728 [msgId={}]", (Object)busObject.getId());
            return;
        }
        msgCallback.putResponse(this.protocolData);
        if (response.TypeCase.SERVER_AUTH_INIT_RES == busObject.getTypeCase()) {
            log.info("Netty\u54cd\u5e94\u5904\u7406\u5668\uff0c\u7b2c1\u6b21\u4e1a\u52a1\u5904\u7406\u8017\u65f6\uff1a{}\u6beb\u79d2", (Object)(System.currentTimeMillis() - busBegin));
            log.info("Netty\u54cd\u5e94\u5904\u7406\u5668\uff0c\u7b2c1\u6b21\u4e1a\u52a1\u5904\u7406\u603b\u8017\u65f6\uff1a{}\u6beb\u79d2", (Object)(System.currentTimeMillis() - begin));
        }
        if (response.TypeCase.SERVER_AUTH_RES == busObject.getTypeCase()) {
            log.info("Netty\u54cd\u5e94\u5904\u7406\u5668\uff0c\u7b2c2\u6b21\u4e1a\u52a1\u5904\u7406\u8017\u65f6\uff1a{}\u6beb\u79d2", (Object)(System.currentTimeMillis() - busBegin));
            log.info("Netty\u54cd\u5e94\u5904\u7406\u5668\uff0c\u7b2c2\u6b21\u4e1a\u52a1\u5904\u7406\u603b\u8017\u65f6\uff1a{}\u6beb\u79d2", (Object)(System.currentTimeMillis() - begin));
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        IdleStateEvent event = (IdleStateEvent)evt;
        Channel channel = ctx.channel();
        if (event.state() == IdleState.ALL_IDLE) {
            InetSocketAddress remoteAddress = (InetSocketAddress)channel.remoteAddress();
            if (this.heartbeatFlag.get()) {
                log.warn("\u8fdc\u7a0b\u670d\u52a1\u5668\u5fc3\u8df3\u54cd\u5e94\u8d85\u65f6\uff0c\u5c06\u5173\u95ed\u8be5\u901a\u9053[{}:{}]", (Object)remoteAddress.getAddress().getHostAddress(), (Object)remoteAddress.getPort());
                channel.closeFuture();
                return;
            }
            channel.writeAndFlush((Object)ProtocolData.build(null));
            this.heartbeatFlag.set(true);
            if (log.isDebugEnabled()) {
                log.debug("\u5411\u8fdc\u7a0b\u670d\u52a1\u5668\u53d1\u9001\u5fc3\u8df3\u8bf7\u6c42\u6210\u529f [{}:{}]", (Object)remoteAddress.getAddress().getHostAddress(), (Object)remoteAddress.getPort());
            }
        }
    }
}

