/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.mmc.client.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import org.springframework.util.Base64Utils;

public class ProtocolData {
    private static final int PROTO_PREFIX_LENGTH = 6;
    private int version = 1;
    private int type = 1;
    private int length;
    private byte[] data;
    private Object busObject;
    private boolean readOk;

    public ProtocolData() {
        this.data = new byte[0];
    }

    public ProtocolData(byte[] data) {
        this.data = data == null ? new byte[0] : data;
        this.length = this.data.length;
    }

    public ProtocolData(int version, int type, byte[] data) {
        this.version = version;
        this.type = type;
        this.data = data == null ? new byte[0] : data;
        this.length = this.data.length;
    }

    public static ByteBuf build(byte[] busData) {
        ProtocolData protocolData = new ProtocolData(busData);
        UnpooledByteBufAllocator reqData = new UnpooledByteBufAllocator(false);
        ByteBuf buffer = reqData.buffer(6 + protocolData.getLength());
        buffer.writeByte(protocolData.getVersion());
        buffer.writeByte(protocolData.getType());
        buffer.writeInt(protocolData.getLength());
        buffer.writeBytes(protocolData.getData());
        return buffer;
    }

    public static ProtocolData reslove(ByteBuf buffer, ProtocolData protocolData) {
        if (protocolData == null) {
            protocolData = new ProtocolData();
            protocolData.setVersion(buffer.readByte());
            protocolData.setType(buffer.readByte());
            protocolData.setLength(buffer.readInt());
        }
        if (protocolData.getLength() > 0) {
            byte[] data = null;
            if (protocolData.getLength() > buffer.readableBytes()) {
                data = new byte[buffer.readableBytes()];
                buffer.readBytes(data);
                if (protocolData.getData().length > 0) {
                    byte[] temp = new byte[protocolData.getData().length + data.length];
                    System.arraycopy(protocolData.getData(), 0, temp, 0, protocolData.getData().length);
                    System.arraycopy(data, 0, temp, protocolData.getData().length, data.length);
                    protocolData.setData(temp);
                    if (protocolData.getLength() == temp.length) {
                        protocolData.setReadOk(true);
                    }
                } else {
                    protocolData.setData(data);
                }
            } else {
                data = new byte[protocolData.getLength()];
                buffer.readBytes(data);
                protocolData.setData(data);
                protocolData.setReadOk(true);
            }
        } else {
            protocolData.setReadOk(true);
        }
        return protocolData;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setData(byte[] data) {
        if (data != null) {
            this.data = data;
        }
    }

    public Object getBusObject() {
        return this.busObject;
    }

    public void setBusObject(Object busObject) {
        this.busObject = busObject;
    }

    public boolean isReadOk() {
        return this.readOk;
    }

    public void setReadOk(boolean readOk) {
        this.readOk = readOk;
    }

    public String toString() {
        return "ProtocolData [version=" + this.version + ", type=" + this.type + ", length=" + this.length + ", data=" + Base64Utils.encodeToString((byte[])this.data) + ", readOk=" + this.readOk + "]";
    }
}

