/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.mmc.config;

import com.xdja.saps.mmc.client.MmcClient;
import com.xdja.saps.mmc.client.netty.NettyChannelPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MmcConfig {
    private static final Logger log = LoggerFactory.getLogger(MmcConfig.class);
    @Value(value="${mms.ip:127.0.0.1}")
    private String ip;
    @Value(value="${mms.port:5059}")
    private int port;
    @Value(value="${mms.maxChannel:10}")
    private int maxChannel;
    @Value(value="${mms.threadCount:10}")
    private int threadCount;
    @Value(value="${mms.connectionTimeout:3}")
    private int connectionTimeout;
    @Value(value="${mms.heartbeatTime:120}")
    private int heartbeatTime;
    @Value(value="${mms.responseTimeout:5}")
    private long responseTimeout;

    @Bean
    public NettyChannelPool nettyChannelPool() {
        log.info("\u591a\u5a92\u4f53\u5bc6\u7801\u670d\u52a1\u5ba2\u6237\u7aef\u8fde\u63a5\u914d\u7f6e\u4e3a\uff1aip={},port={},maxChannel={},threadCount={},connectionTimeout={}\u79d2,heartbeatTime={}\u79d2", new Object[]{this.ip, this.port, this.maxChannel, this.threadCount, this.connectionTimeout, this.heartbeatTime});
        return new NettyChannelPool(this.ip, this.port, this.maxChannel, this.threadCount, this.connectionTimeout * 1000, this.heartbeatTime * 1000);
    }

    @Bean
    public MmcClient mmcClient() {
        log.info("\u591a\u5a92\u4f53\u5bc6\u7801\u670d\u52a1\u5ba2\u6237\u7aef\u8bf7\u6c42\u54cd\u5e94\u8d85\u65f6\u914d\u7f6e\u4e3a\uff1aresponseTimeout={}\u79d2", (Object)this.responseTimeout);
        return new MmcClient(this.nettyChannelPool(), this.responseTimeout * 1000L);
    }
}

