/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.common.web.handler;

import com.xdja.saps.view.common.core.bean.ErrorBean;
import com.xdja.saps.view.common.core.exception.ServiceException;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={ServiceException.class})
    @ResponseBody
    public Object serviceExceptionHandler(ServiceException exception, HttpServletResponse response) {
        if (null != exception.getErrorBean()) {
            log.error("ServiceException\uff1a{}", (Object)exception.getErrorBean());
            response.setStatus(exception.getErrorBean().getStatus());
            return exception.getErrorBean();
        }
        log.error("ServiceException\uff1a", (Throwable)exception);
        response.setStatus(HttpStatus.BAD_REQUEST.value());
        return this.buildErrorBean(HttpStatus.BAD_REQUEST.value(), exception.getMessage());
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseBody
    public Object handleHttpMessageNotReadableException(HttpMessageNotReadableException exception, HttpServletResponse response) {
        log.error("HttpMessageNotReadableException\uff1a", (Throwable)exception);
        response.setStatus(HttpStatus.BAD_REQUEST.value());
        return this.buildErrorBean(HttpStatus.BAD_REQUEST.value(), exception.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Object handleException(Exception exception, HttpServletResponse response) {
        log.error("Exception\uff1a", (Throwable)exception);
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        return this.buildErrorBean(HttpStatus.INTERNAL_SERVER_ERROR.value(), exception.getMessage());
    }

    private ErrorBean buildErrorBean(int errCode, String errMsg) {
        return new ErrorBean(errCode, errMsg);
    }
}

