/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.data.api.controller;

import com.xdja.saps.view.data.api.service.FilesService;
import com.xdja.saps.view.data.core.model.FileListObject;
import com.xdja.saps.view.data.core.model.ResponseStatusListModeObject;
import com.xdja.saps.view.data.core.model.ResponseStatusObject;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/VIID/Files"})
public class FilesController {
    private final FilesService filesService;

    @PostMapping(produces={"application/viid+json;charset=UTF-8"})
    public ResponseStatusListModeObject batchAddFace(@RequestBody FileListObject fileListObject, HttpServletRequest request) {
        String userIdentify = request.getHeader("User-Identify");
        return this.filesService.batchAddFiles(fileListObject, userIdentify);
    }

    @PostMapping(value={"/{ID}/Data"}, produces={"application/viid+json;charset=UTF-8"})
    public ResponseStatusObject addFiles(@PathVariable(name="ID") String id, @RequestBody String base64, HttpServletRequest request) {
        String userIdentify = request.getHeader("User-Identify");
        return this.filesService.addFiles(base64, userIdentify, id);
    }

    public FilesController(FilesService filesService) {
        this.filesService = filesService;
    }
}

