/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.data.api.controller;

import com.xdja.saps.view.data.api.service.ImagesService;
import com.xdja.saps.view.data.core.model.ImageListObject;
import com.xdja.saps.view.data.core.model.ResponseStatusListModeObject;
import com.xdja.saps.view.data.core.model.ResponseStatusObject;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/VIID/Images"})
public class ImagesController {
    private final ImagesService imagesService;

    @PostMapping(produces={"application/viid+json;charset=UTF-8"})
    public ResponseStatusListModeObject batchAddFace(@RequestBody ImageListObject imageListObject, HttpServletRequest request) {
        String userIdentify = request.getHeader("User-Identify");
        return this.imagesService.batchAddImages(imageListObject, userIdentify);
    }

    @PostMapping(value={"/{ID}/Data"}, produces={"application/viid+json;charset=UTF-8"})
    public ResponseStatusObject addImages(@PathVariable(name="ID") String id, @RequestBody String base64, HttpServletRequest request) {
        String userIdentify = request.getHeader("User-Identify");
        return this.imagesService.addImages(base64, userIdentify, id);
    }

    public ImagesController(ImagesService imagesService) {
        this.imagesService = imagesService;
    }
}

