/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.data.api.controller;

import cn.hutool.extra.servlet.ServletUtil;
import com.alibaba.fastjson2.JSONObject;
import com.xdja.saps.view.common.core.bean.Result;
import com.xdja.saps.view.data.api.service.ISystemService;
import com.xdja.saps.view.data.core.model.KeepaliveObject;
import com.xdja.saps.view.data.core.model.RegisterObject;
import com.xdja.saps.view.data.core.model.ResponseStatusObject;
import com.xdja.saps.view.data.core.model.SystemTimeObject;
import com.xdja.saps.view.data.core.model.UnRegisterObject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/VIID/System"})
public class SystemController {
    private static final Logger log = LoggerFactory.getLogger(SystemController.class);
    private final ISystemService registerService;

    @PostMapping(value={"/Register"}, produces={"application/viid+json;charset=UTF-8"})
    public ResponseStatusObject register(@RequestBody RegisterObject registerObject, HttpServletRequest request, HttpServletResponse response) {
        String authorization = request.getHeader("Authorization");
        Result<ResponseStatusObject> result = this.processUnauthorized(authorization, response);
        if (result.isError()) {
            return (ResponseStatusObject)result.getData();
        }
        JSONObject params = new JSONObject();
        params.put((Object)"authorization", (Object)authorization);
        params.put((Object)"ip", (Object)ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]));
        params.put((Object)"port", (Object)request.getRemotePort());
        return this.registerService.register(registerObject, params);
    }

    @PostMapping(value={"/UnRegister"}, produces={"application/viid+json;charset=UTF-8"})
    public ResponseStatusObject unRegister(@RequestBody UnRegisterObject unRegisterObject, HttpServletRequest request, HttpServletResponse response) {
        String authorization = request.getHeader("Authorization");
        Result<ResponseStatusObject> result = this.processUnauthorized(authorization, response);
        if (result.isError()) {
            return (ResponseStatusObject)result.getData();
        }
        return this.registerService.unRegister(unRegisterObject, authorization);
    }

    @PostMapping(value={"/Keepalive"}, produces={"application/viid+json;charset=UTF-8"})
    public ResponseStatusObject keepalive(@RequestBody KeepaliveObject keepaliveObject) {
        return this.registerService.keepalive(keepaliveObject);
    }

    @GetMapping(value={"/Time"}, produces={"application/viid+json;charset=UTF-8"})
    public SystemTimeObject time() {
        return this.registerService.time();
    }

    private Result<ResponseStatusObject> processUnauthorized(String authorization, HttpServletResponse response) {
        if (StringUtils.isNotBlank((CharSequence)authorization)) {
            return Result.success();
        }
        response.setHeader("WWW-Authenticate", this.registerService.generateAuthenticate());
        try {
            response.sendError(HttpStatus.UNAUTHORIZED.value());
        }
        catch (Exception e) {
            log.error("response send error", (Throwable)e);
        }
        return Result.fail((Object)new ResponseStatusObject());
    }

    public SystemController(ISystemService registerService) {
        this.registerService = registerService;
    }
}

